/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metric.testutils;

import java.util.Optional;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.testutils.MetricListener;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class MetricListenerTest {
    public static final String COUNTER_NAME = "testCounter";
    public static final String GAUGE_NAME = "testGauge";
    public static final String METER_NAME = "testMeter";
    public static final String HISTOGRAM_NAME = "testHistogram";
    public static final String GROUP_A = "groupA";
    public static final String GROUP_B = "groupB";
    public static final String GROUP_A_1 = "groupA_1";
    public static final String GROUP_B_1 = "groupB_1";
    public static final String GROUP_B_2 = "groupB_2";

    MetricListenerTest() {
    }

    @Test
    void testRegisterMetrics() {
        MetricListener metricListener = new MetricListener();
        MetricGroup metricGroup = metricListener.getMetricGroup();
        Counter counter = metricGroup.counter(COUNTER_NAME);
        counter.inc(15213L);
        Assertions.assertThat((Optional)metricListener.getCounter(new String[]{COUNTER_NAME})).hasValueSatisfying(registeredCounter -> Assertions.assertThat((long)registeredCounter.getCount()).isEqualTo(15213L));
        metricGroup.gauge(GAUGE_NAME, () -> 15213);
        Assertions.assertThat((Optional)metricListener.getGauge(new String[]{GAUGE_NAME})).hasValueSatisfying(registeredGauge -> Assertions.assertThat((Object)registeredGauge.getValue()).isEqualTo((Object)15213));
        metricGroup.meter(METER_NAME, new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 15213.0;
            }

            public long getCount() {
                return 18213L;
            }
        });
        Assertions.assertThat((Optional)metricListener.getMeter(new String[]{METER_NAME})).hasValueSatisfying(registeredMeter -> {
            Assertions.assertThat((long)registeredMeter.getCount()).isEqualTo(18213L);
            Assertions.assertThat((double)registeredMeter.getRate()).isCloseTo(15213.0, Offset.offset((Number)0.1));
        });
        metricGroup.histogram(HISTOGRAM_NAME, new Histogram(){

            public void update(long value) {
            }

            public long getCount() {
                return 15213L;
            }

            public HistogramStatistics getStatistics() {
                return null;
            }
        });
        Assertions.assertThat((Optional)metricListener.getHistogram(new String[]{HISTOGRAM_NAME})).hasValueSatisfying(registeredHistogram -> Assertions.assertThat((long)registeredHistogram.getCount()).isEqualTo(15213L));
    }

    @Test
    void testRegisterMetricGroup() {
        MetricListener metricListener = new MetricListener();
        MetricGroup rootGroup = metricListener.getMetricGroup();
        MetricGroup groupA1 = rootGroup.addGroup(GROUP_A).addGroup(GROUP_A_1);
        MetricGroup groupB = rootGroup.addGroup(GROUP_B);
        MetricGroup groupB1 = groupB.addGroup(GROUP_B_1);
        MetricGroup groupB2 = groupB.addGroup(GROUP_B_2);
        groupA1.counter(COUNTER_NAME).inc(18213L);
        groupB1.gauge(GAUGE_NAME, () -> 15213L);
        groupB2.counter(COUNTER_NAME).inc(15513L);
        Assertions.assertThat((Optional)metricListener.getCounter(new String[]{GROUP_A, GROUP_A_1, COUNTER_NAME})).hasValueSatisfying(counter -> Assertions.assertThat((long)counter.getCount()).isEqualTo(18213L));
        Assertions.assertThat((Optional)metricListener.getGauge(new String[]{GROUP_B, GROUP_B_1, GAUGE_NAME})).hasValueSatisfying(gauge -> Assertions.assertThat((Object)gauge.getValue()).isEqualTo((Object)15213L));
        Assertions.assertThat((Optional)metricListener.getCounter(new String[]{GROUP_B, GROUP_B_2, COUNTER_NAME})).hasValueSatisfying(counter -> Assertions.assertThat((long)counter.getCount()).isEqualTo(15513L));
    }
}

