/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.unslicing;

import java.io.IOException;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.operators.window.MergeCallback;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.SessionWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.internal.MergingWindowProcessFunction;
import org.apache.flink.table.runtime.operators.window.tvf.common.ClockService;
import org.apache.flink.table.runtime.operators.window.tvf.unslicing.UnsliceAssigner;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class UnsliceAssigners {
    public static SessionUnsliceAssigner session(int rowtimeIndex, ZoneId shiftTimeZone, Duration gap) {
        return new SessionUnsliceAssigner(rowtimeIndex, shiftTimeZone, gap.toMillis());
    }

    public static WindowedUnsliceAssigner windowed(int windowStartIndex, int windowEndIndex, UnsliceAssigner<TimeWindow> innerAssigner) {
        return new WindowedUnsliceAssigner(windowStartIndex, windowEndIndex, innerAssigner);
    }

    public static class SessionUnsliceAssigner
    implements UnsliceAssigner<TimeWindow> {
        private static final long serialVersionUID = 1L;
        private final int rowtimeIndex;
        private final long sessionGap;
        private final boolean isEventTime;
        private final ZoneId shiftTimeZone;
        private final SessionWindowAssigner innerSessionWindowAssigner;

        public SessionUnsliceAssigner(int rowtimeIndex, ZoneId shiftTimeZone, long sessionGap) {
            this.rowtimeIndex = rowtimeIndex;
            this.shiftTimeZone = shiftTimeZone;
            this.sessionGap = sessionGap;
            this.isEventTime = rowtimeIndex >= 0;
            this.innerSessionWindowAssigner = SessionWindowAssigner.withGap(Duration.ofMillis(sessionGap));
            if (this.isEventTime()) {
                this.innerSessionWindowAssigner.withEventTime();
            } else {
                this.innerSessionWindowAssigner.withProcessingTime();
            }
        }

        @Override
        public MergingWindowAssigner<TimeWindow> getMergingWindowAssigner() {
            return this.innerSessionWindowAssigner;
        }

        @Override
        public Optional<TimeWindow> assignActualWindow(RowData element, ClockService clock, MergingWindowProcessFunction<?, TimeWindow> windowFunction) throws Exception {
            Collection<TimeWindow> windows = windowFunction.assignActualWindows(element, this.getUtcTimestamp(element, clock));
            Preconditions.checkState((windows.size() <= 1 ? 1 : 0) != 0);
            if (windows.size() == 1) {
                return Optional.of(windows.iterator().next());
            }
            return Optional.empty();
        }

        @Override
        public Optional<TimeWindow> assignStateNamespace(RowData element, ClockService clock, MergingWindowProcessFunction<?, TimeWindow> windowFunction) throws Exception {
            Collection<TimeWindow> windows = windowFunction.assignStateNamespace(element, this.getUtcTimestamp(element, clock));
            Preconditions.checkState((windows.size() <= 1 ? 1 : 0) != 0);
            if (windows.size() == 1) {
                return Optional.of(windows.iterator().next());
            }
            return Optional.empty();
        }

        protected long getUtcTimestamp(RowData element, ClockService clock) {
            long timestamp;
            if (this.rowtimeIndex >= 0) {
                if (element.isNullAt(this.rowtimeIndex)) {
                    throw new RuntimeException("rowtimeIndex should not be null, please convert it to a non-null long value.");
                }
                TimestampData rowTime = element.getTimestamp(this.rowtimeIndex, 3);
                timestamp = TimeWindowUtil.toUtcTimestampMills(rowTime.getMillisecond(), this.shiftTimeZone);
            } else {
                timestamp = TimeWindowUtil.toUtcTimestampMills(clock.currentProcessingTime(), this.shiftTimeZone);
            }
            return timestamp;
        }

        @Override
        public boolean isEventTime() {
            return this.isEventTime;
        }

        @Override
        public String getDescription() {
            return String.format("SessionWindow(gap=%dms)", this.sessionGap);
        }
    }

    public static class WindowedUnsliceAssigner
    extends MergingWindowAssigner<TimeWindow>
    implements UnsliceAssigner<TimeWindow>,
    InternalTimeWindowAssigner {
        private static final long serialVersionUID = 1L;
        private final int windowStartIndex;
        private final int windowEndIndex;
        private final UnsliceAssigner<TimeWindow> innerAssigner;

        public WindowedUnsliceAssigner(int windowStartIndex, int windowEndIndex, UnsliceAssigner<TimeWindow> innerAssigner) {
            this.windowStartIndex = windowStartIndex;
            this.windowEndIndex = windowEndIndex;
            this.innerAssigner = innerAssigner;
        }

        @Override
        public Optional<TimeWindow> assignActualWindow(RowData element, ClockService clock, MergingWindowProcessFunction<?, TimeWindow> windowFunction) throws Exception {
            return this.innerAssigner.assignActualWindow(element, clock, windowFunction);
        }

        @Override
        public Optional<TimeWindow> assignStateNamespace(RowData element, ClockService clock, MergingWindowProcessFunction<?, TimeWindow> windowFunction) throws Exception {
            return this.innerAssigner.assignStateNamespace(element, clock, windowFunction);
        }

        @Override
        public MergingWindowAssigner<TimeWindow> getMergingWindowAssigner() {
            return this;
        }

        @Override
        public boolean isEventTime() {
            return true;
        }

        @Override
        public Collection<TimeWindow> assignWindows(RowData element, long timestamp) throws IOException {
            return Collections.singletonList(this.createWindow(element));
        }

        private TimeWindow createWindow(RowData element) {
            if (element.isNullAt(this.windowStartIndex) || element.isNullAt(this.windowEndIndex)) {
                throw new RuntimeException("RowTime field should not be null.");
            }
            long windowStartTime = element.getTimestamp(this.windowStartIndex, 3).getMillisecond();
            long windowEndTime = element.getTimestamp(this.windowEndIndex, 3).getMillisecond();
            return new TimeWindow(windowStartTime, windowEndTime);
        }

        @Override
        public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
            return new TimeWindow.Serializer();
        }

        @Override
        public String toString() {
            return this.getDescription();
        }

        @Override
        public String getDescription() {
            return String.format("WindowedUnsliceWindow(innerAssigner=%s, StartIndex=%d, windowEndIndex=%d)", this.innerAssigner.getDescription(), this.windowStartIndex, this.windowEndIndex);
        }

        @Override
        public InternalTimeWindowAssigner withEventTime() {
            throw new IllegalStateException("Should not call this function on WindowedUnsliceAssigner.");
        }

        @Override
        public InternalTimeWindowAssigner withProcessingTime() {
            throw new IllegalStateException("Should not call this function on WindowedUnsliceAssigner.");
        }

        @Override
        public void mergeWindows(TimeWindow newWindow, NavigableSet<TimeWindow> sortedWindows, MergeCallback<TimeWindow, Collection<TimeWindow>> callback) {
        }
    }
}

