/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.triggers;

import java.time.Duration;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.Trigger;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.WindowTrigger;
import org.apache.flink.util.Preconditions;

public class ProcessingTimeTriggers {
    private static final String TO_STRING = "ProcessingTime.afterEndOfWindow()";

    private ProcessingTimeTriggers() {
    }

    public static <W extends Window> AfterEndOfWindow<W> afterEndOfWindow() {
        return new AfterEndOfWindow();
    }

    public static <W extends Window> AfterFirstElementPeriodic<W> every(Duration time) {
        return new AfterFirstElementPeriodic(time.toMillis());
    }

    public static final class AfterEndOfWindow<W extends Window>
    extends WindowTrigger<W> {
        private static final long serialVersionUID = 2369815941792574642L;

        public AfterEndOfWindowNoLate<W> withEarlyFirings(Trigger<W> earlyFirings) {
            Preconditions.checkNotNull(earlyFirings);
            return new AfterEndOfWindowNoLate<W>(earlyFirings);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            this.ctx.registerProcessingTimeTimer(this.triggerTime(window));
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return time == this.triggerTime(window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteProcessingTimeTimer(this.triggerTime(window));
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerProcessingTimeTimer(this.triggerTime(window));
        }

        public String toString() {
            return ProcessingTimeTriggers.TO_STRING;
        }
    }

    public static final class AfterFirstElementPeriodic<W extends Window>
    extends WindowTrigger<W> {
        private static final long serialVersionUID = -4710472821577125673L;
        private final long interval;
        private final ReducingStateDescriptor<Long> nextFiringStateDesc;

        AfterFirstElementPeriodic(long interval) {
            Preconditions.checkArgument((interval > 0L ? 1 : 0) != 0);
            this.interval = interval;
            this.nextFiringStateDesc = new ReducingStateDescriptor("processingTime-every-" + interval, (ReduceFunction)new Min(), (TypeSerializer)LongSerializer.INSTANCE);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            ReducingState nextFiring = (ReducingState)this.ctx.getPartitionedState(this.nextFiringStateDesc);
            if (nextFiring.get() == null) {
                long nextTimer = this.ctx.getCurrentProcessingTime() + this.interval;
                this.ctx.registerProcessingTimeTimer(nextTimer);
                nextFiring.add((Object)nextTimer);
            }
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            ReducingState nextFiring = (ReducingState)this.ctx.getPartitionedState(this.nextFiringStateDesc);
            Long timer = (Long)nextFiring.get();
            if (timer != null && timer == time) {
                long newTimer = time + this.interval;
                this.ctx.registerProcessingTimeTimer(newTimer);
                nextFiring.clear();
                nextFiring.add((Object)newTimer);
                return true;
            }
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            mergeContext.mergePartitionedState(this.nextFiringStateDesc);
            Long nextTimer = (Long)((ReducingState)this.ctx.getPartitionedState(this.nextFiringStateDesc)).get();
            if (nextTimer != null) {
                this.ctx.registerProcessingTimeTimer(nextTimer);
            }
        }

        @Override
        public void clear(W window) throws Exception {
            ReducingState nextFiring = (ReducingState)this.ctx.getPartitionedState(this.nextFiringStateDesc);
            Long timer = (Long)nextFiring.get();
            if (timer != null) {
                this.ctx.deleteProcessingTimeTimer(timer);
                nextFiring.clear();
            }
        }

        public String toString() {
            return "ProcessingTime.every(" + this.interval + ")";
        }

        private static class Min
        implements ReduceFunction<Long> {
            private static final long serialVersionUID = 1L;

            private Min() {
            }

            public Long reduce(Long value1, Long value2) throws Exception {
                return Math.min(value1, value2);
            }
        }
    }

    public static final class AfterEndOfWindowNoLate<W extends Window>
    extends WindowTrigger<W> {
        private static final long serialVersionUID = 2310050856564792734L;
        private final Trigger<W> earlyTrigger;

        AfterEndOfWindowNoLate(Trigger<W> earlyTrigger) {
            Preconditions.checkNotNull(earlyTrigger);
            this.earlyTrigger = earlyTrigger;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            this.earlyTrigger.open(ctx);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            this.ctx.registerProcessingTimeTimer(this.triggerTime(window));
            return this.earlyTrigger.onElement(element, timestamp, window);
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return time == this.triggerTime(window) || this.earlyTrigger.onProcessingTime(time, window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return this.earlyTrigger.onEventTime(time, window);
        }

        @Override
        public boolean canMerge() {
            return this.earlyTrigger.canMerge();
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerProcessingTimeTimer(this.triggerTime(window));
            this.earlyTrigger.onMerge(window, mergeContext);
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteProcessingTimeTimer(this.triggerTime(window));
            this.earlyTrigger.clear(window);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(ProcessingTimeTriggers.TO_STRING);
            if (this.earlyTrigger != null) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            return builder.toString();
        }
    }
}

