/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.Pair;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public abstract class PercentileAggFunction<T>
extends BuiltInAggregateFunction<T, PercentileAccumulator> {
    protected final transient DataType valueType;
    protected final transient DataType frequencyType;

    public PercentileAggFunction(LogicalType inputType, LogicalType frequencyType) {
        this.valueType = DataTypeUtils.toInternalDataType((LogicalType)inputType);
        this.frequencyType = frequencyType == null ? null : DataTypeUtils.toInternalDataType((LogicalType)frequencyType);
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(PercentileAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"percentages", (DataType)((DataType)DataTypes.ARRAY((DataType)DataTypes.DOUBLE()).bridgedTo(double[].class))), DataTypes.FIELD((String)"valueCount", (DataType)MapView.newMapViewDataType((DataType)DataTypes.DOUBLE(), (DataType)DataTypes.BIGINT()))});
    }

    public PercentileAccumulator createAccumulator() {
        PercentileAccumulator acc = new PercentileAccumulator();
        acc.percentages = null;
        acc.valueCount = new MapView();
        return acc;
    }

    public void accumulate(PercentileAccumulator acc, @Nullable Object value, Double percentage) throws Exception {
        if (acc.percentages == null) {
            acc.setPercentages(percentage);
        }
        this.update(acc, value, 1L);
    }

    public void accumulate(PercentileAccumulator acc, @Nullable Object value, Double percentage, @Nullable Number frequency) throws Exception {
        if (acc.percentages == null) {
            acc.setPercentages(percentage);
        }
        if (frequency == null || frequency.longValue() <= 0L) {
            return;
        }
        this.update(acc, value, frequency.longValue());
    }

    public void accumulate(PercentileAccumulator acc, @Nullable Object value, Double[] percentage) throws Exception {
        if (acc.percentages == null) {
            acc.setPercentages(percentage);
        }
        this.update(acc, value, 1L);
    }

    public void accumulate(PercentileAccumulator acc, @Nullable Object value, Double[] percentage, @Nullable Number frequency) throws Exception {
        if (acc.percentages == null) {
            acc.setPercentages(percentage);
        }
        if (frequency == null || frequency.longValue() <= 0L) {
            return;
        }
        this.update(acc, value, frequency.longValue());
    }

    private void update(PercentileAccumulator acc, @Nullable Object value, long frequency) throws Exception {
        if (value == null) {
            return;
        }
        double val = value instanceof Number ? ((Number)value).doubleValue() : DecimalDataUtils.doubleValue((DecimalData)value);
        long cnt = Optional.ofNullable((Long)acc.valueCount.get((Object)val)).orElse(0L) + frequency;
        if (cnt != 0L) {
            acc.valueCount.put((Object)val, (Object)cnt);
        } else {
            acc.valueCount.remove((Object)val);
        }
    }

    public void retract(PercentileAccumulator acc, @Nullable Object value, Double percentage) throws Exception {
        this.update(acc, value, -1L);
    }

    public void retract(PercentileAccumulator acc, @Nullable Object value, Double percentage, @Nullable Number frequency) throws Exception {
        if (frequency == null || frequency.longValue() <= 0L) {
            return;
        }
        this.update(acc, value, -frequency.longValue());
    }

    public void retract(PercentileAccumulator acc, @Nullable Object value, Double[] percentage) throws Exception {
        this.update(acc, value, -1L);
    }

    public void retract(PercentileAccumulator acc, @Nullable Object value, Double[] percentage, @Nullable Number frequency) throws Exception {
        if (frequency == null || frequency.longValue() <= 0L) {
            return;
        }
        this.update(acc, value, -frequency.longValue());
    }

    public void merge(PercentileAccumulator acc, Iterable<PercentileAccumulator> its) throws Exception {
        for (PercentileAccumulator mergedAcc : its) {
            if (acc.percentages == null && mergedAcc.percentages != null) {
                acc.percentages = (double[])mergedAcc.percentages.clone();
            }
            for (Map.Entry entry : mergedAcc.valueCount.entries()) {
                long cnt = Optional.ofNullable((Long)acc.valueCount.get((Object)((Double)entry.getKey()))).orElse(0L) + (Long)entry.getValue();
                if (cnt != 0L) {
                    acc.valueCount.put((Object)((Double)entry.getKey()), (Object)cnt);
                    continue;
                }
                acc.valueCount.remove((Object)((Double)entry.getKey()));
            }
        }
    }

    public static class PercentileAccumulator {
        public double[] percentages;
        public MapView<Double, Long> valueCount;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PercentileAccumulator that = (PercentileAccumulator)o;
            return Arrays.equals(this.percentages, that.percentages) && Objects.equals(this.valueCount, that.valueCount);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.percentages), this.valueCount.hashCode());
        }

        public Double[] getValue() {
            long totalCount = 0L;
            ArrayList sortedList = new ArrayList();
            try {
                for (Map.Entry entry : this.valueCount.entries()) {
                    sortedList.add(entry);
                    totalCount += ((Long)entry.getValue()).longValue();
                }
            }
            catch (Exception e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
            if (totalCount <= 0L) {
                return null;
            }
            sortedList.sort(Map.Entry.comparingByKey());
            ArrayList<Pair> sortedPercentages = new ArrayList<Pair>();
            for (int index = 0; index < this.percentages.length; ++index) {
                sortedPercentages.add(new Pair((Object)(this.percentages[index] * (double)(totalCount - 1L) + 1.0), (Object)index));
            }
            sortedPercentages.sort(Comparator.comparing(Pair::getKey));
            Double[] percentiles = new Double[this.percentages.length];
            long preCnt = (Long)((Map.Entry)sortedList.get(0)).getValue();
            int j = 0;
            for (int i = 0; i < sortedPercentages.size(); ++i) {
                Pair entry = (Pair)sortedPercentages.get(i);
                double position = (Double)entry.getKey();
                long lower = (long)Math.floor(position);
                long higher = (long)Math.ceil(position);
                while (preCnt < lower) {
                    preCnt += ((Long)((Map.Entry)sortedList.get(++j)).getValue()).longValue();
                }
                percentiles[((Integer)entry.getValue()).intValue()] = preCnt >= higher ? (Double)((Map.Entry)sortedList.get(j)).getKey() : ((double)higher - position) * (Double)((Map.Entry)sortedList.get(j)).getKey() + (position - (double)lower) * (Double)((Map.Entry)sortedList.get(j + 1)).getKey();
            }
            return percentiles;
        }

        public void setPercentages(Double percentage) {
            if (percentage < 0.0 || percentage > 1.0) {
                throw new IllegalArgumentException(String.format("Percentage of PERCENTILE should be between [0.0, 1.0], but was '%s'.", percentage));
            }
            this.percentages = new double[]{percentage};
        }

        public void setPercentages(Double[] percentage) {
            this.percentages = new double[percentage.length];
            for (int i = 0; i < this.percentages.length; ++i) {
                if (percentage[i] < 0.0 || percentage[i] > 1.0) {
                    throw new IllegalArgumentException(String.format("Percentage of PERCENTILE should be between [0.0, 1.0], but was '%s'.", percentage[i]));
                }
                this.percentages[i] = percentage[i];
            }
        }
    }

    public static class MultiPercentileAggFunction
    extends PercentileAggFunction<Double[]> {
        public MultiPercentileAggFunction(LogicalType valueType, LogicalType frequencyType) {
            super(valueType, frequencyType);
        }

        @Override
        public List<DataType> getArgumentDataTypes() {
            return this.frequencyType == null ? Arrays.asList(this.valueType, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.DOUBLE().notNull())).notNull()) : Arrays.asList(this.valueType, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.DOUBLE().notNull())).notNull(), this.frequencyType);
        }

        @Override
        public DataType getOutputDataType() {
            return DataTypes.ARRAY((DataType)DataTypes.DOUBLE());
        }

        public Double[] getValue(PercentileAccumulator acc) {
            if (acc.percentages == null || acc.percentages.length == 0) {
                return null;
            }
            return acc.getValue();
        }
    }

    public static class SinglePercentileAggFunction
    extends PercentileAggFunction<Double> {
        public SinglePercentileAggFunction(LogicalType valueType, LogicalType frequencyType) {
            super(valueType, frequencyType);
        }

        @Override
        public List<DataType> getArgumentDataTypes() {
            return this.frequencyType == null ? Arrays.asList(this.valueType, (DataType)DataTypes.DOUBLE().notNull()) : Arrays.asList(this.valueType, (DataType)DataTypes.DOUBLE().notNull(), this.frequencyType);
        }

        @Override
        public DataType getOutputDataType() {
            return DataTypes.DOUBLE();
        }

        public Double getValue(PercentileAccumulator acc) {
            if (acc.percentages == null) {
                return null;
            }
            Double[] result = acc.getValue();
            return result == null ? null : result[0];
        }
    }
}

