/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.raw;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.util.Preconditions;

@Internal
public class RawFormatDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final LogicalType deserializedType;
    private final TypeInformation<RowData> producedTypeInfo;
    private final String charsetName;
    private final boolean isBigEndian;
    private final DeserializationRuntimeConverter converter;
    private final DataLengthValidator validator;

    public RawFormatDeserializationSchema(LogicalType deserializedType, TypeInformation<RowData> producedTypeInfo, String charsetName, boolean isBigEndian) {
        this.deserializedType = (LogicalType)Preconditions.checkNotNull((Object)deserializedType);
        this.producedTypeInfo = (TypeInformation)Preconditions.checkNotNull(producedTypeInfo);
        this.converter = RawFormatDeserializationSchema.createConverter(deserializedType, charsetName, isBigEndian);
        this.validator = RawFormatDeserializationSchema.createDataLengthValidator(deserializedType);
        this.charsetName = charsetName;
        this.isBigEndian = isBigEndian;
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.converter.open();
    }

    public RowData deserialize(byte[] message) throws IOException {
        Object field;
        if (message == null) {
            field = null;
        } else {
            this.validator.validate(message);
            field = this.converter.convert(message);
        }
        GenericRowData rowData = new GenericRowData(1);
        rowData.setField(0, field);
        return rowData;
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawFormatDeserializationSchema that = (RawFormatDeserializationSchema)o;
        return this.producedTypeInfo.equals(that.producedTypeInfo) && this.deserializedType.equals((Object)that.deserializedType) && this.charsetName.equals(that.charsetName) && this.isBigEndian == that.isBigEndian;
    }

    public int hashCode() {
        return Objects.hash(this.producedTypeInfo, this.deserializedType, this.charsetName, this.isBigEndian);
    }

    private static DeserializationRuntimeConverter createConverter(LogicalType type, String charsetName, boolean isBigEndian) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return RawFormatDeserializationSchema.createStringConverter(charsetName);
            }
            case VARBINARY: 
            case BINARY: {
                return data -> data;
            }
            case RAW: {
                return RawValueData::fromBytes;
            }
            case BOOLEAN: {
                return data -> data[0] != 0;
            }
            case TINYINT: {
                return data -> data[0];
            }
            case SMALLINT: {
                return RawFormatDeserializationSchema.createEndiannessAwareConverter(isBigEndian, segment -> segment.getShortBigEndian(0), segment -> segment.getShortLittleEndian(0));
            }
            case INTEGER: {
                return RawFormatDeserializationSchema.createEndiannessAwareConverter(isBigEndian, segment -> segment.getIntBigEndian(0), segment -> segment.getIntLittleEndian(0));
            }
            case BIGINT: {
                return RawFormatDeserializationSchema.createEndiannessAwareConverter(isBigEndian, segment -> segment.getLongBigEndian(0), segment -> segment.getLongLittleEndian(0));
            }
            case FLOAT: {
                return RawFormatDeserializationSchema.createEndiannessAwareConverter(isBigEndian, segment -> Float.valueOf(segment.getFloatBigEndian(0)), segment -> Float.valueOf(segment.getFloatLittleEndian(0)));
            }
            case DOUBLE: {
                return RawFormatDeserializationSchema.createEndiannessAwareConverter(isBigEndian, segment -> segment.getDoubleBigEndian(0), segment -> segment.getDoubleLittleEndian(0));
            }
        }
        throw new UnsupportedOperationException("'raw' format currently doesn't support type: " + type);
    }

    private static DeserializationRuntimeConverter createStringConverter(final String charsetName) {
        Charset charset = Charset.forName(charsetName);
        if (charset == StandardCharsets.UTF_8) {
            return StringData::fromBytes;
        }
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;
            private transient Charset charset;

            @Override
            public void open() {
                this.charset = Charset.forName(charsetName);
            }

            @Override
            public Object convert(byte[] data) {
                String str = new String(data, this.charset);
                return StringData.fromString((String)str);
            }
        };
    }

    private static DeserializationRuntimeConverter createEndiannessAwareConverter(boolean isBigEndian, MemorySegmentConverter bigEndianConverter, MemorySegmentConverter littleEndianConverter) {
        if (isBigEndian) {
            return new EndiannessAwareDeserializationConverter(bigEndianConverter);
        }
        return new EndiannessAwareDeserializationConverter(littleEndianConverter);
    }

    private static DataLengthValidator createDataLengthValidator(LogicalType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case VARBINARY: 
            case BINARY: 
            case RAW: {
                return data -> {};
            }
            case BOOLEAN: {
                return RawFormatDeserializationSchema.createDataLengthValidator(1, "BOOLEAN");
            }
            case TINYINT: {
                return RawFormatDeserializationSchema.createDataLengthValidator(1, "TINYINT");
            }
            case SMALLINT: {
                return RawFormatDeserializationSchema.createDataLengthValidator(2, "SMALLINT");
            }
            case INTEGER: {
                return RawFormatDeserializationSchema.createDataLengthValidator(4, "INT");
            }
            case BIGINT: {
                return RawFormatDeserializationSchema.createDataLengthValidator(8, "BIGINT");
            }
            case FLOAT: {
                return RawFormatDeserializationSchema.createDataLengthValidator(4, "FLOAT");
            }
            case DOUBLE: {
                return RawFormatDeserializationSchema.createDataLengthValidator(8, "DOUBLE");
            }
        }
        throw new UnsupportedOperationException("'raw' format currently doesn't support type: " + type);
    }

    private static DataLengthValidator createDataLengthValidator(int expectedLength, String typeName) {
        return data -> {
            if (data.length != expectedLength) {
                throw new DeserializationException(String.format("Size of data received for deserializing %s type is not %s.", typeName, expectedLength));
            }
        };
    }

    @FunctionalInterface
    private static interface DeserializationRuntimeConverter
    extends Serializable {
        default public void open() {
        }

        public Object convert(byte[] var1) throws IOException;
    }

    private static interface DataLengthValidator
    extends Serializable {
        public void validate(byte[] var1);
    }

    private static interface MemorySegmentConverter
    extends Serializable {
        public Object convert(MemorySegment var1);
    }

    private static final class EndiannessAwareDeserializationConverter
    implements DeserializationRuntimeConverter {
        private static final long serialVersionUID = 1L;
        private final MemorySegmentConverter innerConverter;

        private EndiannessAwareDeserializationConverter(MemorySegmentConverter innerConverter) {
            this.innerConverter = innerConverter;
        }

        @Override
        public Object convert(byte[] data) {
            MemorySegment segment = MemorySegmentFactory.wrap((byte[])data);
            return this.innerConverter.convert(segment);
        }
    }
}

