/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Arrays;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.binary.BinaryRawValueData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class RawValueDataAsserter
extends TypeSafeMatcher<RawValueData> {
    private final BinaryRawValueData expected;
    private final RawValueDataSerializer serializer;

    private RawValueDataAsserter(BinaryRawValueData expected, RawValueDataSerializer serializer) {
        this.expected = expected;
        this.serializer = serializer;
    }

    public static RawValueDataAsserter equivalent(RawValueData<?> expected, RawValueDataSerializer<?> serializer) {
        BinaryRawValueData binaryExpected = (BinaryRawValueData)expected;
        binaryExpected.ensureMaterialized(serializer.getInnerSerializer());
        return new RawValueDataAsserter(binaryExpected, serializer);
    }

    protected boolean matchesSafely(RawValueData item) {
        BinaryRawValueData binaryItem = (BinaryRawValueData)item;
        binaryItem.ensureMaterialized(this.serializer.getInnerSerializer());
        this.expected.ensureMaterialized(this.serializer.getInnerSerializer());
        return binaryItem.getSizeInBytes() == this.expected.getSizeInBytes() && BinarySegmentUtils.equals((MemorySegment[])binaryItem.getSegments(), (int)binaryItem.getOffset(), (MemorySegment[])this.expected.getSegments(), (int)this.expected.getOffset(), (int)binaryItem.getSizeInBytes());
    }

    public void describeTo(Description description) {
        byte[] bytes = BinarySegmentUtils.getBytes((MemorySegment[])this.expected.getSegments(), (int)this.expected.getOffset(), (int)this.expected.getSizeInBytes());
        description.appendText(Arrays.toString(bytes));
    }
}

