/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

abstract class RowDataSerializerTest
extends SerializerTestInstance<RowData> {
    private final RowDataSerializer serializer;
    private final RowData[] testData;

    RowDataSerializerTest(RowDataSerializer serializer, RowData[] testData) {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof RowData && o2 instanceof RowData, (o1, o2, checker) -> RowDataSerializerTest.deepEqualsRowData((RowData)o1, (RowData)o2, (RowDataSerializer)serializer.duplicate(), (RowDataSerializer)serializer.duplicate())), (TypeSerializer)serializer, RowData.class, -1, (Object[])testData);
        this.serializer = serializer;
        this.testData = testData;
    }

    private static BinaryArrayData createArray(int ... ints) {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, ints.length, 4);
        for (int i = 0; i < ints.length; ++i) {
            writer.writeInt(i, ints[i]);
        }
        writer.complete();
        return array;
    }

    private static BinaryMapData createMap(int[] keys, int[] values) {
        return BinaryMapData.valueOf((BinaryArrayData)RowDataSerializerTest.createArray(keys), (BinaryArrayData)RowDataSerializerTest.createArray(values));
    }

    private static GenericRowData createRow(Object f0, Object f1, Object f2, Object f3, Object f4) {
        GenericRowData row = new GenericRowData(5);
        row.setField(0, f0);
        row.setField(1, f1);
        row.setField(2, f2);
        row.setField(3, f3);
        row.setField(4, f4);
        return row;
    }

    private static boolean deepEqualsRowData(RowData should, RowData is, RowDataSerializer serializer1, RowDataSerializer serializer2) {
        return RowDataSerializerTest.deepEqualsRowData(should, is, serializer1, serializer2, false);
    }

    private static boolean deepEqualsRowData(RowData should, RowData is, RowDataSerializer serializer1, RowDataSerializer serializer2, boolean checkClass) {
        if (should.getArity() != is.getArity()) {
            return false;
        }
        if (checkClass && (should.getClass() != is.getClass() || !should.equals(is))) {
            return false;
        }
        BinaryRowData row1 = serializer1.toBinaryRow(should);
        BinaryRowData row2 = serializer2.toBinaryRow(is);
        return Objects.equals(row1, row2);
    }

    private void checkDeepEquals(RowData should, RowData is, boolean checkClass) {
        boolean equals = RowDataSerializerTest.deepEqualsRowData(should, is, (RowDataSerializer)this.serializer.duplicate(), (RowDataSerializer)this.serializer.duplicate(), checkClass);
        Assertions.assertThat((boolean)equals).isTrue();
    }

    @Test
    protected void testCopy() {
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row), true);
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row, (RowData)new GenericRowData(row.getArity())), true);
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((RowData)this.serializer.toBinaryRow(row), (RowData)new GenericRowData(row.getArity())), false);
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((RowData)this.serializer.toBinaryRow(row)), false);
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((RowData)this.serializer.toBinaryRow(row), (RowData)new BinaryRowData(row.getArity())), false);
        }
    }

    @Test
    void testWrongCopy() {
        Assertions.assertThatThrownBy(() -> this.serializer.copy((RowData)new GenericRowData(this.serializer.getArity() + 1))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testWrongCopyReuse() {
        for (RowData row : this.testData) {
            Assertions.assertThatThrownBy(() -> this.checkDeepEquals(row, this.serializer.copy(row, (RowData)new GenericRowData(row.getArity() + 1)), false)).isInstanceOf(IllegalArgumentException.class);
        }
    }

    static final class RowDataSerializerWithNestedRowTest
    extends RowDataSerializerTest {
        private static final DataType NESTED_DATA_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"ri", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"rs", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"rb", (DataType)DataTypes.BIGINT())});

        public RowDataSerializerWithNestedRowTest() {
            super(RowDataSerializerWithNestedRowTest.getRowSerializer(), RowDataSerializerWithNestedRowTest.getData());
        }

        private static RowData[] getData() {
            DataType outerDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"r", (DataType)NESTED_DATA_TYPE), DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING())});
            RowDataSerializer outerSerializer = (RowDataSerializer)InternalSerializers.create((LogicalType)outerDataType.getLogicalType());
            GenericRowData outerRow1 = GenericRowData.of((Object[])new Object[]{12, GenericRowData.of((Object[])new Object[]{34, StringData.fromString((String)"56"), 78L}), StringData.fromString((String)"910")});
            RowData nestedRow1 = outerSerializer.toBinaryRow((RowData)outerRow1).getRow(1, 3);
            GenericRowData outerRow2 = GenericRowData.of((Object[])new Object[]{12, GenericRowData.of((Object[])new Object[]{null, StringData.fromString((String)"56"), 78L}), null});
            RowData nestedRow2 = outerSerializer.toBinaryRow((RowData)outerRow2).getRow(1, 3);
            return new RowData[]{nestedRow1, nestedRow2};
        }

        private static RowDataSerializer getRowSerializer() {
            return (RowDataSerializer)InternalSerializers.create((LogicalType)NESTED_DATA_TYPE.getLogicalType());
        }
    }

    static final class RowDataSerializerWithKryoTest
    extends RowDataSerializerTest {
        public RowDataSerializerWithKryoTest() {
            super(RowDataSerializerWithKryoTest.getRowSerializer(), RowDataSerializerWithKryoTest.getData());
        }

        private static RowData[] getData() {
            GenericRowData row = new GenericRowData(1);
            row.setField(0, (Object)RawValueData.fromObject((Object)new WrappedString("a")));
            return new RowData[]{row};
        }

        private static RowDataSerializer getRowSerializer() {
            RawValueDataSerializer rawValueSerializer = new RawValueDataSerializer((TypeSerializer)new KryoSerializer(WrappedString.class, (SerializerConfig)new SerializerConfigImpl()));
            return new RowDataSerializer(new LogicalType[]{new RawType(RawValueData.class, (TypeSerializer)rawValueSerializer)}, new TypeSerializer[]{rawValueSerializer});
        }
    }

    static final class RowDataSerializerWithComplexTypesTest
    extends RowDataSerializerTest {
        public RowDataSerializerWithComplexTypesTest() {
            super(RowDataSerializerWithComplexTypesTest.getRowSerializer(), RowDataSerializerWithComplexTypesTest.getData());
        }

        private static RowData[] getData() {
            return new GenericRowData[]{RowDataSerializerTest.createRow(null, null, null, null, null), RowDataSerializerTest.createRow(0, null, null, null, null), RowDataSerializerTest.createRow(0, 0.0, null, null, null), RowDataSerializerTest.createRow(0, 0.0, StringData.fromString((String)"a"), null, null), RowDataSerializerTest.createRow(1, 0.0, StringData.fromString((String)"a"), null, null), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"a"), null, null), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), null, null), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1), RowDataSerializerTest.createMap(new int[]{1}, new int[]{1})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2), RowDataSerializerTest.createMap(new int[]{1, 4}, new int[]{1, 2})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3), RowDataSerializerTest.createMap(new int[]{1, 5}, new int[]{1, 3})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3, 4), RowDataSerializerTest.createMap(new int[]{1, 6}, new int[]{1, 4})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3, 4, 5), RowDataSerializerTest.createMap(new int[]{1, 7}, new int[]{1, 5})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3, 4, 5, 6), RowDataSerializerTest.createMap(new int[]{1, 8}, new int[]{1, 6}))};
        }

        private static RowDataSerializer getRowSerializer() {
            InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new DoubleType(), VarCharType.STRING_TYPE, new ArrayType((LogicalType)new IntType()), new MapType((LogicalType)new IntType(), (LogicalType)new IntType())});
            return typeInfo.toRowSerializer();
        }
    }

    static final class LargeRowDataSerializerTest
    extends RowDataSerializerTest {
        public LargeRowDataSerializerTest() {
            super(LargeRowDataSerializerTest.getRowSerializer(), LargeRowDataSerializerTest.getData());
        }

        private static RowData[] getData() {
            GenericRowData row = new GenericRowData(13);
            row.setField(0, (Object)2);
            row.setField(1, null);
            row.setField(3, null);
            row.setField(4, null);
            row.setField(5, null);
            row.setField(6, null);
            row.setField(7, null);
            row.setField(8, null);
            row.setField(9, null);
            row.setField(10, null);
            row.setField(11, null);
            row.setField(12, (Object)StringData.fromString((String)"Test"));
            return new RowData[]{row};
        }

        private static RowDataSerializer getRowSerializer() {
            InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), VarCharType.STRING_TYPE});
            return typeInfo.toRowSerializer();
        }
    }

    static final class SimpleRowDataSerializerTest
    extends RowDataSerializerTest {
        public SimpleRowDataSerializerTest() {
            super(SimpleRowDataSerializerTest.getRowSerializer(), SimpleRowDataSerializerTest.getData());
        }

        private static RowData[] getData() {
            GenericRowData row1 = new GenericRowData(2);
            row1.setField(0, (Object)1);
            row1.setField(1, (Object)StringData.fromString((String)"a"));
            GenericRowData row2 = new GenericRowData(2);
            row2.setField(0, (Object)2);
            row2.setField(1, null);
            return new RowData[]{row1, row2};
        }

        private static RowDataSerializer getRowSerializer() {
            InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), VarCharType.STRING_TYPE});
            return typeInfo.toRowSerializer();
        }
    }

    private static class WrappedString {
        private final String content;

        WrappedString(String content) {
            this.content = content;
        }
    }
}

