/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.slicing;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.operators.window.MergeCallback;
import org.apache.flink.table.runtime.operators.window.tvf.common.ClockService;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;
import org.assertj.core.api.Assertions;

abstract class SliceAssignerTestBase {
    private static final ClockService CLOCK_SERVICE = System::currentTimeMillis;
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");

    SliceAssignerTestBase() {
    }

    static Collection<ZoneId> zoneIds() {
        return Arrays.asList(ZoneId.of("America/Los_Angeles"), ZoneId.of("Asia/Shanghai"));
    }

    protected static void assertErrorMessage(Runnable runnable, String errorMessage) {
        Assertions.assertThatThrownBy(runnable::run).hasMessageContaining(errorMessage);
    }

    protected static long assignSliceEnd(SliceAssigner assigner, long timestamp) {
        return assigner.assignSliceEnd(SliceAssignerTestBase.row(timestamp), CLOCK_SERVICE);
    }

    protected static List<Long> expiredSlices(SliceAssigner assigner, long sliceEnd) {
        return Lists.newArrayList((Iterable)assigner.expiredSlices(sliceEnd));
    }

    protected static Long mergeResultSlice(SliceSharedAssigner assigner, long sliceEnd) throws Exception {
        TestingMergingCallBack callBack = new TestingMergingCallBack();
        assigner.mergeSlices(sliceEnd, (MergeCallback)callBack);
        return callBack.mergeResult;
    }

    protected static List<Long> toBeMergedSlices(SliceSharedAssigner assigner, long sliceEnd) throws Exception {
        TestingMergingCallBack callBack = new TestingMergingCallBack();
        assigner.mergeSlices(sliceEnd, (MergeCallback)callBack);
        return callBack.toBeMerged;
    }

    protected static RowData row(long timestamp) {
        BinaryRowData binaryRowData = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(binaryRowData);
        writer.writeTimestamp(0, TimestampData.fromEpochMillis((long)timestamp), 3);
        writer.complete();
        return binaryRowData;
    }

    protected static void assertSliceStartEnd(String start, String end, long epochMills, SliceAssigner assigner) {
        Assertions.assertThat((String)SliceAssignerTestBase.localTimestampStr(assigner.getWindowStart(SliceAssignerTestBase.assignSliceEnd(assigner, epochMills)))).isEqualTo(start);
        Assertions.assertThat((String)SliceAssignerTestBase.localTimestampStr(SliceAssignerTestBase.assignSliceEnd(assigner, epochMills))).isEqualTo(end);
    }

    public static String localTimestampStr(long epochMills) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMills), UTC_ZONE_ID).toString();
    }

    protected long utcMills(String timestampStr) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampStr);
        return localDateTime.atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
    }

    protected long localMills(String timestampStr, ZoneId shiftTimeZone) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampStr);
        return localDateTime.atZone(shiftTimeZone).toInstant().toEpochMilli();
    }

    private static final class TestingMergingCallBack
    implements MergeCallback<Long, Iterable<Long>> {
        private Long mergeResult;
        private List<Long> toBeMerged;

        private TestingMergingCallBack() {
        }

        public void merge(Long mergeResult, Iterable<Long> toBeMerged) throws Exception {
            this.mergeResult = mergeResult;
            this.toBeMerged = Lists.newArrayList(toBeMerged);
        }
    }
}

