/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.AppendOnlyTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNFunctionTestBase;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.operators.rank.async.AsyncStateAppendOnlyTopNFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.jupiter.api.TestTemplate;

class AppendOnlyTopNFunctionTest
extends TopNFunctionTestBase {
    AppendOnlyTopNFunctionTest() {
    }

    @Override
    protected AbstractTopNFunction createFunction(RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, boolean enableAsyncState) {
        if (enableAsyncState) {
            return new AsyncStateAppendOnlyTopNFunction(this.ttlConfig, this.inputRowType, generatedSortKeyComparator, this.sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber, this.cacheSize);
        }
        return new AppendOnlyTopNFunction(this.ttlConfig, this.inputRowType, generatedSortKeyComparator, this.sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber, this.cacheSize);
    }

    @Override
    boolean supportedAsyncState() {
        return true;
    }

    @TestTemplate
    void testVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

