/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.UniformBinaryRowGenerator;
import org.junit.jupiter.api.Test;

public class Int2HashJoinOperatorTest
extends Int2HashJoinOperatorTestBase {
    @Test
    protected void testBuildFirstHashInnerJoin() throws Exception {
        int numKeys = 100;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys, buildValsPerKey, false);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, false, true, numKeys * buildValsPerKey * probeValsPerKey, numKeys, 165);
    }

    @Test
    protected void testBuildFirstHashLeftOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, false, true, numKeys1 * buildValsPerKey * probeValsPerKey, numKeys1, 165);
    }

    @Test
    protected void testBuildFirstHashRightOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, true, true, 280, numKeys2, -1);
    }

    @Test
    protected void testBuildFirstHashFullOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, true, true, 280, numKeys2, -1);
    }

    @Test
    protected void testBuildSecondHashInnerJoin() throws Exception {
        int numKeys = 100;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys, buildValsPerKey, false);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, false, false, numKeys * buildValsPerKey * probeValsPerKey, numKeys, 165);
    }

    @Test
    protected void testBuildSecondHashLeftOutJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, false, false, numKeys2 * buildValsPerKey * probeValsPerKey, numKeys2, 165);
    }

    @Test
    protected void testBuildSecondHashRightOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, true, false, numKeys1 * buildValsPerKey * probeValsPerKey, numKeys2, -1);
    }

    @Test
    protected void testBuildSecondHashFullOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, true, false, 280, numKeys2, -1);
    }

    @Test
    protected void testSemiJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.SEMI, HashJoinType.SEMI, false, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 90, 9, 45, true);
    }

    @Test
    protected void testAntiJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.ANTI, HashJoinType.ANTI, false, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 10, 1, 45, true);
    }

    @Test
    protected void testBuildLeftSemiJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 10;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.SEMI, HashJoinType.BUILD_LEFT_SEMI, true, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 90, 9, 45, true);
    }

    @Test
    protected void testBuildLeftAntiJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 10;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        Object operator = this.newOperator(0x108000L, FlinkJoinType.ANTI, HashJoinType.BUILD_LEFT_ANTI, true, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 10, 1, 45, true);
    }
}

