/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.BoxedWrapperRowData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.RawValueDataAsserter;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RowDataTest {
    private StringData str;
    private RawValueData<String> generic;
    private DecimalData decimal1;
    private DecimalData decimal2;
    private BinaryArrayData array;
    private BinaryMapData map;
    private BinaryRowData underRow;
    private byte[] bytes;
    private RawValueDataSerializer<String> genericSerializer;
    private TimestampData timestamp1;
    private TimestampData timestamp2;

    RowDataTest() {
    }

    @BeforeEach
    void before() {
        this.str = StringData.fromString((String)"haha");
        this.generic = RawValueData.fromObject((Object)"haha");
        this.genericSerializer = new RawValueDataSerializer((TypeSerializer)StringSerializer.INSTANCE);
        this.decimal1 = DecimalData.fromUnscaledLong((long)10L, (int)5, (int)0);
        this.decimal2 = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(11), (int)20, (int)0);
        this.array = new BinaryArrayData();
        BinaryArrayWriter arrayWriter = new BinaryArrayWriter(this.array, 2, 4);
        arrayWriter.writeInt(0, 15);
        arrayWriter.writeInt(1, 16);
        arrayWriter.complete();
        this.map = BinaryMapData.valueOf((BinaryArrayData)this.array, (BinaryArrayData)this.array);
        this.underRow = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(this.underRow);
        writer.writeInt(0, 15);
        writer.writeInt(1, 16);
        writer.complete();
        this.bytes = new byte[]{1, 5, 6};
        this.timestamp1 = TimestampData.fromEpochMillis((long)123L);
        this.timestamp2 = TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(1969, 1, 1, 0, 0, 0, 123456789));
    }

    @Test
    void testBinaryRow() {
        BinaryRowData binaryRow = this.getBinaryRow();
        this.testGetters((RowData)binaryRow);
        this.testSetters((RowData)binaryRow);
    }

    @Test
    void testNestedRow() {
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeRow(0, (RowData)this.getBinaryRow(), null);
        writer.complete();
        RowData nestedRow = row.getRow(0, 18);
        this.testGetters(nestedRow);
        this.testSetters(nestedRow);
    }

    private BinaryRowData getBinaryRow() {
        BinaryRowData row = new BinaryRowData(18);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeBoolean(0, true);
        writer.writeByte(1, (byte)1);
        writer.writeShort(2, (short)2);
        writer.writeInt(3, 3);
        writer.writeLong(4, 4L);
        writer.writeFloat(5, 5.0f);
        writer.writeDouble(6, 6.0);
        writer.writeString(8, this.str);
        writer.writeRawValue(9, this.generic, this.genericSerializer);
        writer.writeDecimal(10, this.decimal1, 5);
        writer.writeDecimal(11, this.decimal2, 20);
        writer.writeArray(12, (ArrayData)this.array, new ArrayDataSerializer(DataTypes.INT().getLogicalType()));
        writer.writeMap(13, (MapData)this.map, new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType()));
        writer.writeRow(14, (RowData)this.underRow, new RowDataSerializer(RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType()})));
        writer.writeBinary(15, this.bytes);
        writer.writeTimestamp(16, this.timestamp1, 3);
        writer.writeTimestamp(17, this.timestamp2, 9);
        return row;
    }

    @Test
    void testGenericRow() {
        GenericRowData row = new GenericRowData(18);
        row.setField(0, (Object)true);
        row.setField(1, (Object)1);
        row.setField(2, (Object)2);
        row.setField(3, (Object)3);
        row.setField(4, (Object)4L);
        row.setField(5, (Object)Float.valueOf(5.0f));
        row.setField(6, (Object)6.0);
        row.setField(7, (Object)Character.valueOf('\u0007'));
        row.setField(8, (Object)this.str);
        row.setField(9, this.generic);
        row.setField(10, (Object)this.decimal1);
        row.setField(11, (Object)this.decimal2);
        row.setField(12, (Object)this.array);
        row.setField(13, (Object)this.map);
        row.setField(14, (Object)this.underRow);
        row.setField(15, (Object)this.bytes);
        row.setField(16, (Object)this.timestamp1);
        row.setField(17, (Object)this.timestamp2);
        this.testGetters((RowData)row);
    }

    @Test
    void testBoxedWrapperRow() {
        BoxedWrapperRowData row = new BoxedWrapperRowData(18);
        row.setBoolean(0, true);
        row.setByte(1, (byte)1);
        row.setShort(2, (short)2);
        row.setInt(3, 3);
        row.setLong(4, 4L);
        row.setFloat(5, 5.0f);
        row.setDouble(6, 6.0);
        row.setNonPrimitiveValue(8, (Object)this.str);
        row.setNonPrimitiveValue(9, this.generic);
        row.setNonPrimitiveValue(10, (Object)this.decimal1);
        row.setNonPrimitiveValue(11, (Object)this.decimal2);
        row.setNonPrimitiveValue(12, (Object)this.array);
        row.setNonPrimitiveValue(13, (Object)this.map);
        row.setNonPrimitiveValue(14, (Object)this.underRow);
        row.setNonPrimitiveValue(15, (Object)this.bytes);
        row.setNonPrimitiveValue(16, (Object)this.timestamp1);
        row.setNonPrimitiveValue(17, (Object)this.timestamp2);
        this.testGetters((RowData)row);
        this.testSetters((RowData)row);
    }

    @Test
    void testJoinedRow() {
        GenericRowData row1 = new GenericRowData(5);
        row1.setField(0, (Object)true);
        row1.setField(1, (Object)1);
        row1.setField(2, (Object)2);
        row1.setField(3, (Object)3);
        row1.setField(4, (Object)4L);
        GenericRowData row2 = new GenericRowData(13);
        row2.setField(0, (Object)Float.valueOf(5.0f));
        row2.setField(1, (Object)6.0);
        row2.setField(2, (Object)Character.valueOf('\u0007'));
        row2.setField(3, (Object)this.str);
        row2.setField(4, this.generic);
        row2.setField(5, (Object)this.decimal1);
        row2.setField(6, (Object)this.decimal2);
        row2.setField(7, (Object)this.array);
        row2.setField(8, (Object)this.map);
        row2.setField(9, (Object)this.underRow);
        row2.setField(10, (Object)this.bytes);
        row2.setField(11, (Object)this.timestamp1);
        row2.setField(12, (Object)this.timestamp2);
        this.testGetters((RowData)new JoinedRowData((RowData)row1, (RowData)row2));
    }

    private void testGetters(RowData row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(18);
        Assertions.assertThat((Comparable)row.getRowKind()).isEqualTo((Object)RowKind.INSERT);
        row.setRowKind(RowKind.DELETE);
        Assertions.assertThat((Comparable)row.getRowKind()).isEqualTo((Object)RowKind.DELETE);
        Assertions.assertThat((boolean)row.getBoolean(0)).isTrue();
        Assertions.assertThat((byte)row.getByte(1)).isEqualTo((byte)1);
        Assertions.assertThat((short)row.getShort(2)).isEqualTo((short)2);
        Assertions.assertThat((int)row.getInt(3)).isEqualTo(3);
        Assertions.assertThat((long)row.getLong(4)).isEqualTo(4L);
        Assertions.assertThat((float)row.getFloat(5)).isEqualTo(5.0f);
        Assertions.assertThat((double)row.getDouble(6)).isEqualTo(6.0);
        Assertions.assertThat((Comparable)row.getString(8)).isEqualTo((Object)this.str);
        Assertions.assertThat((Object)row.getRawValue(9)).satisfies((Condition)HamcrestCondition.matching((Matcher)RawValueDataAsserter.equivalent(this.generic, this.genericSerializer)));
        Assertions.assertThat((Comparable)row.getDecimal(10, 5, 0)).isEqualTo((Object)this.decimal1);
        Assertions.assertThat((Comparable)row.getDecimal(11, 20, 0)).isEqualTo((Object)this.decimal2);
        Assertions.assertThat((Object)row.getArray(12)).isEqualTo((Object)this.array);
        Assertions.assertThat((Object)row.getMap(13)).isEqualTo((Object)this.map);
        Assertions.assertThat((int)row.getRow(14, 2).getInt(0)).isEqualTo(15);
        Assertions.assertThat((int)row.getRow(14, 2).getInt(1)).isEqualTo(16);
        Assertions.assertThat((byte[])row.getBinary(15)).isEqualTo((Object)this.bytes);
        Assertions.assertThat((Comparable)row.getTimestamp(16, 3)).isEqualTo((Object)this.timestamp1);
        Assertions.assertThat((Comparable)row.getTimestamp(17, 9)).isEqualTo((Object)this.timestamp2);
    }

    private void testSetters(RowData row) {
        if (!(row instanceof TypedSetters)) {
            throw new RuntimeException("testSetters only tests RowData which implements TypedSetters. However " + row.getClass().getSimpleName() + " doesn't implements TypedSetters interface.");
        }
        TypedSetters setter = (TypedSetters)row;
        setter.setBoolean(0, false);
        Assertions.assertThat((boolean)row.getBoolean(0)).isFalse();
        setter.setByte(1, (byte)2);
        Assertions.assertThat((byte)row.getByte(1)).isEqualTo((byte)2);
        setter.setShort(2, (short)3);
        Assertions.assertThat((short)row.getShort(2)).isEqualTo((short)3);
        setter.setInt(3, 4);
        Assertions.assertThat((int)row.getInt(3)).isEqualTo(4);
        setter.setLong(4, 5L);
        Assertions.assertThat((long)row.getLong(4)).isEqualTo(5L);
        setter.setFloat(5, 6.0f);
        Assertions.assertThat((float)row.getFloat(5)).isEqualTo(6.0f);
        setter.setDouble(6, 7.0);
        Assertions.assertThat((double)row.getDouble(6)).isEqualTo(7.0);
        setter.setDecimal(10, DecimalData.fromUnscaledLong((long)11L, (int)5, (int)0), 5);
        Assertions.assertThat((Comparable)row.getDecimal(10, 5, 0)).isEqualTo((Object)DecimalData.fromUnscaledLong((long)11L, (int)5, (int)0));
        setter.setDecimal(11, DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(12), (int)20, (int)0), 20);
        Assertions.assertThat((Comparable)row.getDecimal(11, 20, 0)).isEqualTo((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(12), (int)20, (int)0));
        setter.setTimestamp(16, TimestampData.fromEpochMillis((long)456L), 3);
        Assertions.assertThat((Comparable)row.getTimestamp(16, 3)).isEqualTo((Object)TimestampData.fromEpochMillis((long)456L));
        setter.setTimestamp(17, TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("1970-01-01 00:00:00.123456789")), 9);
        Assertions.assertThat((Comparable)row.getTimestamp(17, 9)).isEqualTo((Object)TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("1970-01-01 00:00:00.123456789")));
        Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
        setter.setNullAt(0);
        Assertions.assertThat((boolean)row.isNullAt(0)).isTrue();
    }
}

