/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableScan;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalChangelogNormalize;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.ScanUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4AAC\u0006\u0001=!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u0003?\u0001\u0011\u0005q\bC\u0003D\u0001\u0011\u0005C\tC\u0003#\u0001\u0011\u0005!kB\u0003Y\u0017!\u0005\u0011LB\u0003\u000b\u0017!\u0005!\fC\u0003?\r\u0011\u0005a\fC\u0004`\r\t\u0007I\u0011\u00011\t\r\u00054\u0001\u0015!\u0003A\u0005\u0005\u001aFO]3b[BC\u0017p]5dC2$\u0016M\u00197f'>,(oY3TG\u0006t'+\u001e7f\u0015\taQ\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u001d=\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003!E\tQA];mKNT!AE\n\u0002\tAd\u0017M\u001c\u0006\u0003)U\tq\u0001\u001d7b]:,'O\u0003\u0002\u0017/\u0005)A/\u00192mK*\u0011\u0001$G\u0001\u0006M2Lgn\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011(\u001b\u0005\t#B\u0001\u0012$\u0003\u001d\u0019wN\u001c<feRT!\u0001J\u0013\u0002\u0007I,GN\u0003\u0002'3\u000591-\u00197dSR,\u0017B\u0001\u0015\"\u00055\u0019uN\u001c<feR,'OU;mK\u000611m\u001c8gS\u001e\u0004\"aK\u001e\u000f\u00051JdBA\u00179\u001d\tqsG\u0004\u00020m9\u0011\u0001'\u000e\b\u0003cQj\u0011A\r\u0006\u0003gu\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\u0014\u001a\u0013\t!S%\u0003\u0002#G%\u0011!(I\u0001\u000e\u0007>tg/\u001a:uKJ\u0014V\u000f\\3\n\u0005qj$AB\"p]\u001aLwM\u0003\u0002;C\u00051A(\u001b8jiz\"\"\u0001\u0011\"\u0011\u0005\u0005\u0003Q\"A\u0006\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\u000f5\fGo\u00195fgR\u0011Qi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015a5\u00011\u0001N\u0003\u0011\u0019\u0017\r\u001c7\u0011\u00059\u0003V\"A(\u000b\u0005I)\u0013BA)P\u00059\u0011V\r\\(qiJ+H.Z\"bY2$\"aU,\u0011\u0005Q+V\"A\u0012\n\u0005Y\u001b#a\u0002*fY:{G-\u001a\u0005\u0006I\u0011\u0001\raU\u0001\"'R\u0014X-Y7QQf\u001c\u0018nY1m)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\t\u0003\u0003\u001a\u0019\"AB.\u0011\u0005\u0019c\u0016BA/H\u0005\u0019\te.\u001f*fMR\t\u0011,\u0001\u0005J\u001dN#\u0016IT\"F+\u0005\u0001\u0015!C%O'R\u000bejQ#!\u0001")
public class StreamPhysicalTableSourceScanRule
extends ConverterRule {
    public static StreamPhysicalTableSourceScanRule INSTANCE() {
        return StreamPhysicalTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        TableScan scan = (TableScan)call.rel(0);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        TableSourceTable tableSourceTable2 = tableSourceTable;
        if (tableSourceTable2 != null) {
            TableSourceTable tableSourceTable3 = tableSourceTable2;
            DynamicTableSource dynamicTableSource = tableSourceTable3.tableSource();
            return dynamicTableSource instanceof ScanTableSource;
        }
        return false;
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        TableConfig tableConfig = ShortcutUtils.unwrapContext(rel.getCluster()).getTableConfig();
        TableSourceTable table = (TableSourceTable)scan.getTable();
        StreamPhysicalTableSourceScan newScan = new StreamPhysicalTableSourceScan(rel.getCluster(), traitSet, scan.getHints(), table, scan.eventTimeSnapshotRequired());
        ResolvedSchema resolvedSchema = table.contextResolvedTable().getResolvedSchema();
        if (DynamicSourceUtils.changelogNormalizeEnabled(scan.eventTimeSnapshotRequired(), resolvedSchema, table.tableSource(), tableConfig)) {
            UniqueConstraint primaryKey = (UniqueConstraint)resolvedSchema.getPrimaryKey().get();
            List keyFields = primaryKey.getColumns();
            List<String> inputFieldNames = newScan.getRowType().getFieldNames();
            int[] primaryKeyIndices = ScanUtil$.MODULE$.getPrimaryKeyIndices(inputFieldNames, keyFields);
            FlinkRelDistribution requiredDistribution = FlinkRelDistribution$.MODULE$.hash(primaryKeyIndices, true);
            RelTraitSet requiredTraitSet = rel.getCluster().getPlanner().emptyTraitSet().replace(requiredDistribution).replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
            RelNode newInput = RelOptRule.convert((RelNode)newScan, requiredTraitSet);
            return new StreamPhysicalChangelogNormalize(scan.getCluster(), traitSet, newInput, primaryKeyIndices);
        }
        return newScan;
    }

    public StreamPhysicalTableSourceScanRule(ConverterRule.Config config) {
        super(config);
    }
}

