/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
@Internal
public class InputProperty {
    public static final RequiredDistribution ANY_DISTRIBUTION = new RequiredDistribution(DistributionType.ANY){};
    public static final RequiredDistribution BROADCAST_DISTRIBUTION = new RequiredDistribution(DistributionType.BROADCAST){};
    public static final RequiredDistribution SINGLETON_DISTRIBUTION = new RequiredDistribution(DistributionType.SINGLETON){};
    public static final RequiredDistribution UNKNOWN_DISTRIBUTION = new RequiredDistribution(DistributionType.UNKNOWN){};
    public static final InputProperty DEFAULT = InputProperty.builder().build();
    public static final String FIELD_NAME_REQUIRED_DISTRIBUTION = "requiredDistribution";
    public static final String FIELD_NAME_DAM_BEHAVIOR = "damBehavior";
    public static final String FIELD_NAME_PRIORITY = "priority";
    @JsonProperty(value="requiredDistribution")
    private final RequiredDistribution requiredDistribution;
    @JsonProperty(value="damBehavior")
    private final DamBehavior damBehavior;
    @JsonProperty(value="priority")
    private final int priority;

    @JsonCreator
    public InputProperty(@JsonProperty(value="requiredDistribution") RequiredDistribution requiredDistribution, @JsonProperty(value="damBehavior") DamBehavior damBehavior, @JsonProperty(value="priority") int priority) {
        this.requiredDistribution = (RequiredDistribution)Preconditions.checkNotNull((Object)requiredDistribution);
        this.damBehavior = (DamBehavior)((Object)Preconditions.checkNotNull((Object)((Object)damBehavior)));
        this.priority = priority;
    }

    public RequiredDistribution getRequiredDistribution() {
        return this.requiredDistribution;
    }

    public DamBehavior getDamBehavior() {
        return this.damBehavior;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputProperty inputProperty = (InputProperty)o;
        return this.priority == inputProperty.priority && this.requiredDistribution.equals(inputProperty.requiredDistribution) && this.damBehavior == inputProperty.damBehavior;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requiredDistribution, this.damBehavior, this.priority});
    }

    public String toString() {
        return "InputProperty{requiredDistribution=" + this.requiredDistribution + ", damBehavior=" + this.damBehavior + ", priority=" + this.priority + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HashDistribution hashDistribution(int[] keys) {
        return new HashDistribution(keys);
    }

    public static KeepInputAsIsDistribution keepInputAsIsDistribution(RequiredDistribution inputDistribution, boolean strict) {
        return new KeepInputAsIsDistribution(inputDistribution, strict);
    }

    public static abstract class RequiredDistribution {
        private final DistributionType type;

        protected RequiredDistribution(DistributionType type) {
            this.type = (DistributionType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        public DistributionType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequiredDistribution that = (RequiredDistribution)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        public String toString() {
            return this.type.name();
        }
    }

    public static enum DamBehavior {
        PIPELINED,
        END_INPUT,
        BLOCKING;


        public boolean stricterOrEqual(DamBehavior o) {
            return this.ordinal() >= o.ordinal();
        }
    }

    public static class Builder {
        private RequiredDistribution requiredDistribution = UNKNOWN_DISTRIBUTION;
        private DamBehavior damBehavior = DamBehavior.PIPELINED;
        private int priority = 0;

        private Builder() {
        }

        public Builder requiredDistribution(RequiredDistribution requiredDistribution) {
            this.requiredDistribution = requiredDistribution;
            return this;
        }

        public Builder damBehavior(DamBehavior damBehavior) {
            this.damBehavior = damBehavior;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public InputProperty build() {
            return new InputProperty(this.requiredDistribution, this.damBehavior, this.priority);
        }
    }

    public static class HashDistribution
    extends RequiredDistribution {
        private final int[] keys;

        private HashDistribution(int[] keys) {
            super(DistributionType.HASH);
            this.keys = (int[])Preconditions.checkNotNull((Object)keys);
            Preconditions.checkArgument((keys.length > 0 ? 1 : 0) != 0, (Object)"Hash keys must no be empty.");
        }

        public int[] getKeys() {
            return this.keys;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HashDistribution that = (HashDistribution)o;
            return Arrays.equals(this.keys, that.keys);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.keys);
            return result;
        }

        @Override
        public String toString() {
            return "HASH" + Arrays.toString(this.keys);
        }
    }

    public static class KeepInputAsIsDistribution
    extends RequiredDistribution {
        private final RequiredDistribution inputDistribution;
        private final boolean strict;

        private KeepInputAsIsDistribution(RequiredDistribution inputDistribution, boolean strict) {
            super(DistributionType.KEEP_INPUT_AS_IS);
            this.inputDistribution = (RequiredDistribution)Preconditions.checkNotNull((Object)inputDistribution);
            this.strict = strict;
        }

        public RequiredDistribution getInputDistribution() {
            return this.inputDistribution;
        }

        public boolean isStrict() {
            return this.strict;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KeepInputAsIsDistribution that = (KeepInputAsIsDistribution)o;
            return this.strict == that.strict && this.inputDistribution.equals(that.inputDistribution);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.strict, this.inputDistribution);
        }

        @Override
        public String toString() {
            if (this.strict) {
                return "KEEP_INPUT_AS_IS(strict, " + this.inputDistribution + ")";
            }
            return "KEEP_INPUT_AS_IS(" + this.inputDistribution + ")";
        }
    }

    public static enum DistributionType {
        ANY,
        HASH,
        BROADCAST,
        SINGLETON,
        KEEP_INPUT_AS_IS,
        UNKNOWN;

    }
}

