/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.lineage;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.lineage.LineageDataset;
import org.apache.flink.streaming.api.lineage.LineageDatasetFacet;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.listener.CatalogContext;
import org.apache.flink.table.planner.lineage.TableLineageDataset;

public class TableLineageDatasetImpl
implements TableLineageDataset {
    @JsonProperty
    private String name;
    @JsonProperty
    private String namespace;
    private CatalogContext catalogContext;
    private CatalogBaseTable catalogBaseTable;
    @JsonProperty
    private ObjectPath objectPath;
    @JsonProperty
    private Map<String, LineageDatasetFacet> facets;

    public TableLineageDatasetImpl(ContextResolvedTable contextResolvedTable, Optional<LineageDataset> lineageDatasetOpt) {
        this.name = contextResolvedTable.getIdentifier().asSummaryString();
        this.namespace = lineageDatasetOpt.map(lineageDataset -> lineageDataset.namespace()).orElse("");
        this.catalogContext = CatalogContext.createContext((String)(contextResolvedTable.getCatalog().isPresent() ? ((AbstractCatalog)contextResolvedTable.getCatalog().get()).getName() : ""), (Catalog)contextResolvedTable.getCatalog().orElse(null));
        this.catalogBaseTable = contextResolvedTable.getTable();
        this.objectPath = contextResolvedTable.isAnonymous() ? null : contextResolvedTable.getIdentifier().toObjectPath();
        this.facets = new HashMap<String, LineageDatasetFacet>();
        if (lineageDatasetOpt.isPresent()) {
            this.facets.putAll(lineageDatasetOpt.get().facets());
        }
    }

    public void addLineageDatasetFacet(LineageDatasetFacet facet) {
        this.facets.put(facet.name(), facet);
    }

    public String name() {
        return this.name;
    }

    public String namespace() {
        return this.namespace;
    }

    public Map<String, LineageDatasetFacet> facets() {
        return this.facets;
    }

    @Override
    public CatalogContext catalogContext() {
        return this.catalogContext;
    }

    @Override
    public CatalogBaseTable table() {
        return this.catalogBaseTable;
    }

    @Override
    public ObjectPath objectPath() {
        return this.objectPath;
    }
}

