/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class CallBindingCallContext
extends AbstractSqlCallContext {
    private final List<SqlNode> adaptedArguments;
    private final List<DataType> argumentDataTypes;
    @Nullable
    private final DataType outputType;
    @Nullable
    private final List<StaticArgument> staticArguments;

    public CallBindingCallContext(DataTypeFactory dataTypeFactory, FunctionDefinition definition, final SqlCallBinding binding, @Nullable RelDataType outputType, @Nullable List<StaticArgument> staticArguments) {
        super(dataTypeFactory, definition, binding.getOperator().getNameAsId().toString(), binding.getGroupCount() > 0);
        this.adaptedArguments = binding.operands();
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int pos) {
                LogicalType logicalType = FlinkTypeFactory.toLogicalType(binding.getOperandType(pos));
                return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
            }

            @Override
            public int size() {
                return binding.getOperandCount();
            }
        };
        this.outputType = CallBindingCallContext.convertOutputType(binding, outputType);
        this.staticArguments = staticArguments;
    }

    public boolean isArgumentLiteral(int pos) {
        return SqlUtil.isLiteral(this.adaptedArguments.get(pos), false);
    }

    public boolean isArgumentNull(int pos) {
        return SqlUtil.isNullLiteral(this.adaptedArguments.get(pos), false) || this.adaptedArguments.get(pos).getKind() == SqlKind.DEFAULT;
    }

    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        try {
            SqlLiteral literal = SqlLiteral.unchain(this.adaptedArguments.get(pos));
            return Optional.ofNullable(CallBindingCallContext.getLiteralValueAs(literal::getValueAs, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public Optional<TableSemantics> getTableSemantics(int pos) {
        StaticArgument staticArg = Optional.ofNullable(this.staticArguments).map(args -> (StaticArgument)args.get(pos)).orElse(null);
        if (staticArg == null || !staticArg.is(StaticArgumentTrait.TABLE)) {
            return Optional.empty();
        }
        SqlNode sqlNode = this.adaptedArguments.get(pos);
        if (!sqlNode.isA(SqlKind.QUERY) && CallBindingCallContext.noSetSemantics(sqlNode)) {
            return Optional.empty();
        }
        return Optional.of(CallBindingTableSemantics.create(this.argumentDataTypes.get(pos), this.staticArguments.get(pos), sqlNode));
    }

    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    public Optional<DataType> getOutputDataType() {
        return Optional.ofNullable(this.outputType);
    }

    @Nullable
    private static DataType convertOutputType(SqlCallBinding binding, @Nullable RelDataType returnType) {
        if (returnType == null || returnType.equals(binding.getValidator().getUnknownType()) || returnType.getSqlTypeName() == SqlTypeName.ANY) {
            return null;
        }
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(returnType);
        return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
    }

    private static boolean noSetSemantics(SqlNode sqlNode) {
        return sqlNode.getKind() != SqlKind.SET_SEMANTICS_TABLE;
    }

    private static class CallBindingTableSemantics
    implements TableSemantics {
        private final DataType dataType;
        private final int[] partitionByColumns;

        public static CallBindingTableSemantics create(DataType tableDataType, StaticArgument staticArg, SqlNode sqlNode) {
            CallBindingTableSemantics.checkNoOrderBy(sqlNode);
            return new CallBindingTableSemantics(CallBindingTableSemantics.createDataType(tableDataType, staticArg), CallBindingTableSemantics.createPartitionByColumns(tableDataType, sqlNode));
        }

        private static void checkNoOrderBy(SqlNode sqlNode) {
            SqlNodeList orderByList = CallBindingTableSemantics.getSemanticsComponent(sqlNode, 2);
            if (orderByList == null) {
                return;
            }
            if (!orderByList.isEmpty()) {
                throw new ValidationException("ORDER BY clause is currently not supported.");
            }
        }

        @Nullable
        private static SqlNodeList getSemanticsComponent(SqlNode sqlNode, int pos) {
            if (CallBindingCallContext.noSetSemantics(sqlNode)) {
                return null;
            }
            List<SqlNode> setSemantics = ((SqlCall)sqlNode).getOperandList();
            return (SqlNodeList)setSemantics.get(pos);
        }

        private static DataType createDataType(DataType tableDataType, StaticArgument staticArg) {
            DataType dataType = staticArg.getDataType().orElse(null);
            if (dataType != null) {
                return dataType;
            }
            return tableDataType;
        }

        private static int[] createPartitionByColumns(DataType tableDataType, SqlNode sqlNode) {
            SqlNodeList partitionByList = CallBindingTableSemantics.getSemanticsComponent(sqlNode, 1);
            if (partitionByList == null) {
                return new int[0];
            }
            List tableColumns = DataType.getFieldNames((DataType)tableDataType);
            return partitionByList.stream().map(n -> ((SqlIdentifier)n).getSimple()).map(c -> {
                int pos = tableColumns.indexOf(c);
                if (pos < 0) {
                    throw new ValidationException(String.format("Invalid column '%s' for PARTITION BY clause. Available columns are: %s", c, tableColumns));
                }
                return pos;
            }).mapToInt(Integer::intValue).toArray();
        }

        private CallBindingTableSemantics(DataType dataType, int[] partitionByColumns) {
            this.dataType = dataType;
            this.partitionByColumns = partitionByColumns;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public int[] partitionByColumns() {
            return this.partitionByColumns;
        }

        public int[] orderByColumns() {
            return new int[0];
        }

        public int timeColumn() {
            return -1;
        }

        public List<String> coPartitionArgs() {
            return List.of();
        }

        public Optional<ChangelogMode> changelogMode() {
            return Optional.empty();
        }
    }
}

