/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.planner.utils.Top3Accum;
import org.apache.flink.util.Collector;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0003\u0006\u0001/!)1\u0007\u0001C\u0001i!)a\u0007\u0001C!o!)\u0001\b\u0001C\u0001s!)A\t\u0001C\u0001\u000b\")\u0001\n\u0001C\u0001\u0013\")1\n\u0001C\u0001\u0019\")q\n\u0001C\u0001!\")q\u000b\u0001C\u00011\n!Ak\u001c94\u0015\tYA\"A\u0003vi&d7O\u0003\u0002\u000e\u001d\u00059\u0001\u000f\\1o]\u0016\u0014(BA\b\u0011\u0003\u0015!\u0018M\u00197f\u0015\t\t\"#A\u0003gY&t7N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001B!\u0007\u000f\u001f_5\t!D\u0003\u0002\u001c\u001d\u0005Ia-\u001e8di&|gn]\u0005\u0003;i\u0011a\u0003V1cY\u0016\fum\u001a:fO\u0006$XMR;oGRLwN\u001c\t\u0005?\u0019B\u0003&D\u0001!\u0015\t\t#%A\u0003ukBdWM\u0003\u0002$I\u0005!!.\u0019<b\u0015\t)\u0003#A\u0002ba&L!a\n\u0011\u0003\rQ+\b\u000f\\33!\tIS&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0012\n\u00059R#aB%oi\u0016<WM\u001d\t\u0003aEj\u0011AC\u0005\u0003e)\u0011\u0011\u0002V8qg\u0005\u001b7-^7\u0002\rqJg.\u001b;?)\u0005)\u0004C\u0001\u0019\u0001\u0003E\u0019'/Z1uK\u0006\u001b7-^7vY\u0006$xN\u001d\u000b\u0002_\u0005\u0019\u0011\r\u001a3\u0015\u0007i\u0002%\t\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0003V]&$\b\"B!\u0004\u0001\u0004y\u0013aA1dG\")1i\u0001a\u0001Q\u0005\ta/\u0001\u0004eK2,G/\u001a\u000b\u0004u\u0019;\u0005\"B!\u0005\u0001\u0004y\u0003\"B\"\u0005\u0001\u0004A\u0013AD;qI\u0006$XmU7bY2,7\u000f\u001e\u000b\u0003u)CQ!Q\u0003A\u0002=\n!\"Y2dk6,H.\u0019;f)\rQTJ\u0014\u0005\u0006\u0003\u001a\u0001\ra\f\u0005\u0006\u0007\u001a\u0001\r\u0001K\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004uE\u0013\u0006\"B!\b\u0001\u0004y\u0003\"B*\b\u0001\u0004!\u0016aA5ugB\u0019\u0011&V\u0018\n\u0005YS#\u0001C%uKJ\f'\r\\3\u0002\u0013\u0015l\u0017\u000e\u001e,bYV,Gc\u0001\u001eZ5\")\u0011\t\u0003a\u0001_!)1\f\u0003a\u00019\u0006\u0019q.\u001e;\u0011\u0007u\u0003g$D\u0001_\u0015\ty\u0006#\u0001\u0003vi&d\u0017BA1_\u0005%\u0019u\u000e\u001c7fGR|'\u000f")
public class Top3
extends TableAggregateFunction<Tuple2<Integer, Integer>, Top3Accum> {
    public Top3Accum createAccumulator() {
        Top3Accum acc = new Top3Accum();
        acc.data_$eq(new HashMap<Integer, Integer>());
        acc.size_$eq(Predef$.MODULE$.int2Integer(0));
        acc.smallest_$eq(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        return acc;
    }

    public void add(Top3Accum acc, Integer v) {
        Integer cnt = acc.data().get(v);
        acc.size_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(acc.size()) + 1));
        if (cnt == null) {
            cnt = Predef$.MODULE$.int2Integer(0);
        }
        acc.data().put(v, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(cnt) + 1));
    }

    public void delete(Top3Accum acc, Integer v) {
        if (acc.data().containsKey(v)) {
            acc.size_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(acc.size()) - 1));
            int cnt = Predef$.MODULE$.Integer2int(acc.data().get(v)) - 1;
            if (cnt == 0) {
                acc.data().remove(v);
                return;
            }
            acc.data().put(v, Predef$.MODULE$.int2Integer(cnt));
            return;
        }
    }

    public void updateSmallest(Top3Accum acc) {
        acc.smallest_$eq(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        for (Integer key : acc.data().keySet()) {
            if (Predef$.MODULE$.Integer2int(key) >= Predef$.MODULE$.Integer2int(acc.smallest())) continue;
            acc.smallest_$eq(key);
        }
    }

    public void accumulate(Top3Accum acc, Integer v) {
        if (BoxesRunTime.equalsNumObject((Number)acc.size(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            acc.size_$eq(Predef$.MODULE$.int2Integer(1));
            acc.smallest_$eq(v);
            acc.data().put(v, Predef$.MODULE$.int2Integer(1));
            return;
        }
        if (Predef$.MODULE$.Integer2int(acc.size()) < 3) {
            this.add(acc, v);
            if (Predef$.MODULE$.Integer2int(v) < Predef$.MODULE$.Integer2int(acc.smallest())) {
                acc.smallest_$eq(v);
                return;
            }
            return;
        }
        if (Predef$.MODULE$.Integer2int(v) > Predef$.MODULE$.Integer2int(acc.smallest())) {
            this.delete(acc, acc.smallest());
            this.add(acc, v);
            this.updateSmallest(acc);
            return;
        }
    }

    public void merge(Top3Accum acc, Iterable<Top3Accum> its) {
        Iterator<Top3Accum> iter = its.iterator();
        while (iter.hasNext()) {
            Map<Integer, Integer> map = iter.next().data();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(entry.getValue())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)_ -> this.accumulate(acc, (Integer)entry.getKey()));
            }
        }
    }

    public void emitValue(Top3Accum acc, Collector<Tuple2<Integer, Integer>> out) {
        for (Map.Entry<Integer, Integer> pair : acc.data().entrySet()) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(pair.getValue())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)_ -> out.collect((Object)Tuple2.of(pair.getKey(), pair.getKey())));
        }
    }
}

