/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TestTableSourceSinks$ {
    public static TestTableSourceSinks$ MODULE$;
    private String getPersonCsvPath;
    private String getOrdersCsvPath;
    private String getRatesCsvPath;
    private volatile byte bitmap$0;

    static {
        new TestTableSourceSinks$();
    }

    public void createPersonCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(677).append("\n                       |CREATE TEMPORARY TABLE ").append(tableName).append(" (\n                       |  first STRING,\n                       |  id INT,\n                       |  score DOUBLE,\n                       |  last STRING\n                       |) WITH (\n                       |  'connector.type' = 'filesystem',\n                       |  'connector.path' = '").append(this.getPersonCsvPath()).append("',\n                       |  'format.type' = 'csv',\n                       |  'format.field-delimiter' = '#',\n                       |  'format.line-delimiter' = '$',\n                       |  'format.ignore-first-line' = 'true',\n                       |  'format.comment-prefix' = '%'\n                       |)\n                       |").toString())).stripMargin());
    }

    public void createOrdersCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(525).append("\n                       |CREATE TEMPORARY TABLE ").append(tableName).append(" (\n                       |  amount BIGINT,\n                       |  currency STRING,\n                       |  ts BIGINT\n                       |) WITH (\n                       |  'connector.type' = 'filesystem',\n                       |  'connector.path' = '").append(this.getOrdersCsvPath()).append("',\n                       |  'format.type' = 'csv',\n                       |  'format.field-delimiter' = ',',\n                       |  'format.line-delimiter' = '$'\n                       |)\n                       |").toString())).stripMargin());
    }

    public void createRatesCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(486).append("\n                       |CREATE TEMPORARY TABLE ").append(tableName).append(" (\n                       |  currency STRING,\n                       |  rate BIGINT\n                       |) WITH (\n                       |  'connector.type' = 'filesystem',\n                       |  'connector.path' = '").append(this.getRatesCsvPath()).append("',\n                       |  'format.type' = 'csv',\n                       |  'format.field-delimiter' = ',',\n                       |  'format.line-delimiter' = '$'\n                       |)\n                       |").toString())).stripMargin());
    }

    public String createCsvTemporarySinkTable(TableEnvironment tEnv, TableSchema tableSchema, String tableName, int numFiles) {
        File tempDir = Files.createTempDirectory("csv-test", new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        String tempDirPath = tempDir.getAbsolutePath();
        Schema schema = tableSchema.toSchema();
        TableDescriptor tableDescriptor = TableDescriptor.forConnector((String)"filesystem").schema(schema).option("path", tempDirPath).option(FactoryUtil.SINK_PARALLELISM, (Object)numFiles).format("testcsv").build();
        tEnv.createTable(tableName, tableDescriptor);
        return tempDirPath;
    }

    public int createCsvTemporarySinkTable$default$4() {
        return 1;
    }

    public void createWithoutTimeAttributesTableSource(TableEnvironment tEnv, String tableName) {
        Seq data = (Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"Mary", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Bob", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)3)}), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(381).append("\n                       | create table ").append(tableName).append(" (\n                       |  `name` string,\n                       |  `id` bigint,\n                       |  `value` int\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       | )\n                       |").toString())).stripMargin());
    }

    private String getPersonCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First#Id#Score#Last", "Mike#1#12.3#Smith", "Bob#2#45.6#Taylor", "Sam#3#7.89#Miller", "Peter#4#0.12#Smith", "% Just a comment", "Liz#5#34.5#Williams", "Sally#6#6.78#Miller", "Alice#7#90.1#Smith", "Kelly#8#2.34#Williams"}));
                this.getPersonCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.getPersonCsvPath;
    }

    public String getPersonCsvPath() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.getPersonCsvPath$lzycompute();
        }
        return this.getPersonCsvPath;
    }

    private String getOrdersCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Seq csvRecords = (Seq)new .colon.colon((Object)"2,Euro,2", (List)new .colon.colon((Object)"1,US Dollar,3", (List)new .colon.colon((Object)"50,Yen,4", (List)new .colon.colon((Object)"3,Euro,5", (List)new .colon.colon((Object)"5,US Dollar,6", (List)Nil$.MODULE$)))));
                this.getOrdersCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-order-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.getOrdersCsvPath;
    }

    public String getOrdersCsvPath() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.getOrdersCsvPath$lzycompute();
        }
        return this.getOrdersCsvPath;
    }

    private String getRatesCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Seq csvRecords = (Seq)new .colon.colon((Object)"US Dollar,102", (List)new .colon.colon((Object)"Yen,1", (List)new .colon.colon((Object)"Euro,119", (List)new .colon.colon((Object)"RMB,702", (List)Nil$.MODULE$))));
                this.getRatesCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-rate-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.getRatesCsvPath;
    }

    public String getRatesCsvPath() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.getRatesCsvPath$lzycompute();
        }
        return this.getRatesCsvPath;
    }

    private String writeToTempFile(String contents, String filePrefix, String fileSuffix, String charset) {
        File tempFile = File.createTempFile(filePrefix, fileSuffix);
        tempFile.deleteOnExit();
        OutputStreamWriter tmpWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset);
        tmpWriter.write(contents);
        tmpWriter.close();
        return tempFile.getAbsolutePath();
    }

    private String writeToTempFile$default$4() {
        return "UTF-8";
    }

    private TestTableSourceSinks$() {
        MODULE$ = this;
    }
}

