/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.TableScan;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class StatisticsReportTestBase
extends TestLogger {
    private static final int DEFAULT_PARALLELISM = 4;
    protected TableEnvironment tEnv;
    protected File folder;

    @BeforeEach
    public void setup(@TempDir File file) throws Exception {
        this.folder = file;
        this.tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inBatchMode());
        this.tEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)4);
    }

    @AfterEach
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    protected void createFileSystemSource() {
        String ddl1 = String.format("CREATE TABLE sourceTable (\n%s) with (\n 'connector' = 'filesystem', 'path' = '%s',%s )", String.join((CharSequence)",\n", StatisticsReportTestBase.ddlTypesMapToStringList(this.ddlTypesMap())), this.folder, String.join((CharSequence)",\n", this.properties()));
        this.tEnv.executeSql(ddl1);
    }

    protected abstract String[] properties();

    protected Map<String, String> ddlTypesMap() {
        LinkedHashMap<String, String> ddlTypesMap = new LinkedHashMap<String, String>();
        ddlTypesMap.put("boolean", "f_boolean");
        ddlTypesMap.put("tinyint", "f_tinyint");
        ddlTypesMap.put("smallint", "f_smallint");
        ddlTypesMap.put("int", "f_int");
        ddlTypesMap.put("bigint", "f_bigint");
        ddlTypesMap.put("float", "f_float");
        ddlTypesMap.put("double", "f_double");
        ddlTypesMap.put("string", "f_string");
        ddlTypesMap.put("decimal(5,2)", "f_decimal5");
        ddlTypesMap.put("decimal(14,2)", "f_decimal14");
        ddlTypesMap.put("decimal(38,2)", "f_decimal38");
        ddlTypesMap.put("date", "f_date");
        ddlTypesMap.put("timestamp(3)", "f_timestamp3");
        ddlTypesMap.put("timestamp(9)", "f_timestamp9");
        ddlTypesMap.put("timestamp without time zone", "f_timestamp_wtz");
        ddlTypesMap.put("timestamp with local time zone", "f_timestamp_ltz");
        ddlTypesMap.put("binary(1)", "f_binary");
        ddlTypesMap.put("varbinary(1)", "f_varbinary");
        ddlTypesMap.put("time", "f_time");
        ddlTypesMap.put("row<col1 string, col2 int>", "f_row");
        ddlTypesMap.put("array<int>", "f_array");
        ddlTypesMap.put("map<string, int>", "f_map");
        return ddlTypesMap;
    }

    protected Map<String, List<Object>> getDataMap() {
        LinkedHashMap<String, List<Object>> dataMap = new LinkedHashMap<String, List<Object>>();
        dataMap.put("boolean", Stream.of(null, true, false).collect(Collectors.toList()));
        dataMap.put("tinyint", Stream.of((byte)1, (byte)2, (byte)3).collect(Collectors.toList()));
        dataMap.put("smallint", Stream.of(128, 111, 100).collect(Collectors.toList()));
        dataMap.put("int", Stream.of(45536, null, 31000).collect(Collectors.toList()));
        dataMap.put("bigint", Stream.of(1238123899121L, 1238123899100L, 1238123899000L).collect(Collectors.toList()));
        dataMap.put("float", Stream.of(Float.valueOf(33.333f), Float.valueOf(33.311f), null).collect(Collectors.toList()));
        dataMap.put("double", Stream.of(1.1, 1.5, 10.1).collect(Collectors.toList()));
        dataMap.put("string", Stream.of("abcd", "abcd", "def").collect(Collectors.toList()));
        dataMap.put("decimal(5,2)", Stream.of(new BigDecimal("123.45"), new BigDecimal("223.45"), new BigDecimal("127.45")).collect(Collectors.toList()));
        dataMap.put("decimal(14,2)", Stream.of(new BigDecimal("123333333333.33"), new BigDecimal("123333333355.33"), new BigDecimal("123333333344.33")).collect(Collectors.toList()));
        dataMap.put("decimal(38,2)", Stream.of(new BigDecimal("123433343334333433343334333433343334.34"), new BigDecimal("123433343334333433343334333433343334.33"), null).collect(Collectors.toList()));
        dataMap.put("date", Stream.of(LocalDate.parse("1990-10-14"), LocalDate.parse("1990-10-15"), LocalDate.parse("1990-10-16")).collect(Collectors.toList()));
        dataMap.put("timestamp(3)", Stream.of(this.localDateTime("1990-10-14 12:12:43.123", 3), this.localDateTime("1990-10-15 12:12:43.123", 3), this.localDateTime("1990-10-16 12:12:43.123", 3)).collect(Collectors.toList()));
        dataMap.put("timestamp(9)", Stream.of(this.localDateTime("1990-10-14 12:12:43.123456789", 9), this.localDateTime("1990-10-15 12:12:43.123456789", 9), this.localDateTime("1990-10-16 12:12:43.123456789", 9)).collect(Collectors.toList()));
        dataMap.put("timestamp without time zone", Stream.of(this.localDateTime("1990-10-14 12:12:43.123", 3), this.localDateTime("1990-10-15 12:12:43.123", 3), this.localDateTime("1990-10-16 12:12:43.123", 3)).collect(Collectors.toList()));
        dataMap.put("timestamp with local time zone", Stream.of(this.localDateTime("1990-10-14 12:12:43.123", 3), null, this.localDateTime("1990-10-16 12:12:43.123", 3)).collect(Collectors.toList()));
        dataMap.put("binary(1)", Stream.of({1}, {2}, {3}).collect(Collectors.toList()));
        dataMap.put("varbinary(1)", Stream.of({1}, null, {3}).collect(Collectors.toList()));
        dataMap.put("time", Stream.of(LocalTime.parse("12:12:43"), LocalTime.parse("12:12:44"), LocalTime.parse("12:12:45")).collect(Collectors.toList()));
        dataMap.put("row<col1 string, col2 int>", Stream.of({"abc", 10}, {"ef", 11}, {"gh", 12}).collect(Collectors.toList()));
        dataMap.put("array<int>", Stream.of({1, 2, 3}, {2, 3, 4}, {3, 4, 5}).collect(Collectors.toList()));
        dataMap.put("map<string, int>", Stream.of({"abc", 10}, {"ef", 11}, {"gh", 12}).collect(Collectors.toList()));
        return dataMap;
    }

    protected List<Row> getData() {
        Map<String, List<Object>> dataMap = this.getDataMap();
        Row row1 = new Row(dataMap.size());
        Row row2 = new Row(dataMap.size());
        Row row3 = new Row(dataMap.size());
        int i = 0;
        block10: for (Map.Entry<String, List<Object>> entry : dataMap.entrySet()) {
            List<Object> value = entry.getValue();
            switch (entry.getKey()) {
                case "row<col1 string, col2 int>": {
                    row1.setField(i, (Object)this.getTypeRowData(value.get(0)));
                    row2.setField(i, (Object)this.getTypeRowData(value.get(1)));
                    row2.setField(i++, (Object)this.getTypeRowData(value.get(2)));
                    continue block10;
                }
                case "array<int>": {
                    row1.setField(i, this.getTypeArrayData(value.get(0)));
                    row2.setField(i, this.getTypeArrayData(value.get(1)));
                    row2.setField(i++, this.getTypeArrayData(value.get(2)));
                    continue block10;
                }
                case "map<string, int>": {
                    row1.setField(i, this.getTypeMapData(value.get(0)));
                    row2.setField(i, this.getTypeMapData(value.get(1)));
                    row2.setField(i++, this.getTypeMapData(value.get(2)));
                    continue block10;
                }
            }
            row1.setField(i, value.get(0));
            row2.setField(i, value.get(1));
            row3.setField(i++, value.get(2));
        }
        return Stream.of(row1, row2, row3).collect(Collectors.toList());
    }

    private Row getTypeRowData(Object object) {
        Object[] objectList = (Object[])object;
        Row row = new Row(objectList.length);
        row.setField(0, objectList[0]);
        row.setField(1, objectList[1]);
        return row;
    }

    private Map<String, Integer> getTypeMapData(Object object) {
        Object[] objectList = (Object[])object;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put((String)objectList[0], (Integer)objectList[1]);
        return map;
    }

    private List<Integer> getTypeArrayData(Object object) {
        Object[] objectList = (Object[])object;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object obj : objectList) {
            list.add((int)((Integer)obj));
        }
        return list;
    }

    protected FlinkStatistic getStatisticsFromOptimizedPlan(String sql) {
        RelNode relNode = TableTestUtil.toRelNode(this.tEnv.sqlQuery(sql));
        RelNode optimized = StatisticsReportTestBase.getPlanner(this.tEnv).optimize(relNode);
        FlinkStatisticVisitor visitor = new FlinkStatisticVisitor();
        visitor.go(optimized);
        return visitor.result;
    }

    protected static String[] ddlTypesMapToStringList(Map<String, String> ddlTypesMap) {
        String[] types = new String[ddlTypesMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : ddlTypesMap.entrySet()) {
            String str = entry.getValue() + " " + entry.getKey();
            types[i++] = str;
        }
        return types;
    }

    private static PlannerBase getPlanner(TableEnvironment tEnv) {
        TableEnvironmentImpl tEnvImpl = (TableEnvironmentImpl)tEnv;
        return (PlannerBase)tEnvImpl.getPlanner();
    }

    protected LocalDateTime localDateTime(String dateTime, int precision) {
        return DateTimeUtils.parseTimestampData((String)dateTime, (int)precision).toLocalDateTime();
    }

    private static class FlinkStatisticVisitor
    extends RelVisitor {
        private FlinkStatistic result = null;

        private FlinkStatisticVisitor() {
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof TableScan) {
                Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
                TableSourceTable table = (TableSourceTable)node.getTable();
                this.result = table.getStatistic();
            }
            super.visit(node, ordinal, parent);
        }
    }
}

