/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.utils.IntegralAvgAccumulator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4QAC\u0006\u0002\u0002aAQA\r\u0001\u0005\u0002MBQ!\u000e\u0001\u0005BYBQa\u000e\u0001\u0005\u0002aBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u0012\u0001\u0005B\u0015CQa\u0012\u0001\u0005\u0002!CQ\u0001\u0016\u0001\u0005BUCQA\u001a\u0001\u0007\u0002\u001dDQ\u0001\u001c\u0001\u0007\u00025\u0014a#\u00138uK\u001e\u0014\u0018\r\\!wO\u0006;wMR;oGRLwN\u001c\u0006\u0003\u00195\tQ!\u001e;jYNT!AD\b\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0001#E\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003%M\tQA\u001a7j].T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u0001QCA\r#'\t\u0001!\u0004\u0005\u0003\u001c=\u0001rS\"\u0001\u000f\u000b\u0005uy\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\tyBDA\tBO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u0004\"!\t\u0012\r\u0001\u0011)1\u0005\u0001b\u0001I\t\tA+\u0005\u0002&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t9aj\u001c;iS:<\u0007C\u0001\u0014-\u0013\tisEA\u0002B]f\u0004\"a\f\u0019\u000e\u0003-I!!M\u0006\u0003-%sG/Z4sC2\feoZ!dGVlW\u000f\\1u_J\fa\u0001P5oSRtD#\u0001\u001b\u0011\u0007=\u0002\u0001%A\tde\u0016\fG/Z!dGVlW\u000f\\1u_J$\u0012AL\u0001\u000bC\u000e\u001cW/\\;mCR,GcA\u001d=}A\u0011aEO\u0005\u0003w\u001d\u0012A!\u00168ji\")Qh\u0001a\u0001]\u0005\u0019\u0011mY2\t\u000b}\u001a\u0001\u0019A\u0016\u0002\u000bY\fG.^3\u0002\u000fI,GO]1diR\u0019\u0011HQ\"\t\u000bu\"\u0001\u0019\u0001\u0018\t\u000b}\"\u0001\u0019A\u0016\u0002\u0011\u001d,GOV1mk\u0016$\"\u0001\t$\t\u000bu*\u0001\u0019\u0001\u0018\u0002\u000b5,'oZ3\u0015\u0007eJ%\nC\u0003>\r\u0001\u0007a\u0006C\u0003L\r\u0001\u0007A*A\u0002jiN\u00042!\u0014*/\u001b\u0005q%BA(Q\u0003\u0011a\u0017M\\4\u000b\u0003E\u000bAA[1wC&\u00111K\u0014\u0002\t\u0013R,'/\u00192mK\u0006\u0001r-\u001a;UsB,\u0017J\u001c4fe\u0016t7-\u001a\u000b\u0003-z\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0013%tg-\u001a:f]\u000e,'BA.\u0010\u0003\u0015!\u0018\u0010]3t\u0013\ti\u0006LA\u0007UsB,\u0017J\u001c4fe\u0016t7-\u001a\u0005\u0006?\u001e\u0001\r\u0001Y\u0001\fif\u0004XMR1di>\u0014\u0018\u0010\u0005\u0002bI6\t!M\u0003\u0002d\u001f\u000591-\u0019;bY><\u0017BA3c\u0005=!\u0015\r^1UsB,g)Y2u_JL\u0018\u0001E4fiZ\u000bG.^3ECR\fG+\u001f9f+\u0005A\u0007CA5k\u001b\u0005Q\u0016BA6[\u0005!!\u0015\r^1UsB,\u0017!\u0005:fgVdG\u000fV=qK\u000e{gN^3siR\u0011\u0001E\u001c\u0005\u0006\u007f%\u0001\ra\u001c\t\u0003MAL!!]\u0014\u0003\t1{gn\u001a")
public abstract class IntegralAvgAggFunction<T>
extends AggregateFunction<T, IntegralAvgAccumulator> {
    public IntegralAvgAccumulator createAccumulator() {
        return new IntegralAvgAccumulator();
    }

    public void accumulate(IntegralAvgAccumulator acc, Object value) {
        if (value != null) {
            long v = ((Number)value).longValue();
            acc.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f0) + v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
            return;
        }
    }

    public void retract(IntegralAvgAccumulator acc, Object value) {
        if (value != null) {
            long v = ((Number)value).longValue();
            acc.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f0) - v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
            return;
        }
    }

    public T getValue(IntegralAvgAccumulator acc) {
        if (BoxesRunTime.unboxToLong((Object)acc.f1) == 0L) {
            return null;
        }
        return this.resultTypeConvert(BoxesRunTime.unboxToLong((Object)acc.f0) / BoxesRunTime.unboxToLong((Object)acc.f1));
    }

    public void merge(IntegralAvgAccumulator acc, Iterable<IntegralAvgAccumulator> its) {
        for (IntegralAvgAccumulator a : its) {
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
            acc.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f0) + BoxesRunTime.unboxToLong((Object)a.f0)));
        }
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().typedArguments(new DataType[]{this.getValueDataType()}).accumulatorTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRUCTURED(IntegralAvgAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}))).outputTypeStrategy(TypeStrategies.explicit((DataType)this.getValueDataType())).build();
    }

    public abstract DataType getValueDataType();

    public abstract T resultTypeConvert(long var1);
}

