/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.core.execution.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.source.legacy.FromElementsFunction;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.runtime.utils.FailingCollectionSource;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001\u0002\u0015*\u0001aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u00075\u0002!\t!a3\t\u0013\u0005E\u0007A1A\u0005\n\u0005M\u0007\u0002CAn\u0001\u0001\u0006I!!6\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\"9\u00111 \u0001\u0005B\u0005}\u0007b\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fBqA!#\u0001\t\u0003\u0011YiB\u0003RS!\u0005!KB\u0003)S!\u00051\u000bC\u0003[\u0019\u0011\u00051L\u0002\u0003]\u0019\u0001k\u0006\u0002\u00033\u000f\u0005+\u0007I\u0011A3\t\u00119t!\u0011#Q\u0001\n\u0019DQA\u0017\b\u0005\u0002=DQa\u001d\b\u0005BQDq!\u001e\b\u0002\u0002\u0013\u0005a\u000fC\u0004y\u001dE\u0005I\u0011A=\t\u0013\u0005%a\"!A\u0005B\u0005-\u0001\"CA\u000e\u001d\u0005\u0005I\u0011AA\u000f\u0011%\t)CDA\u0001\n\u0003\t9\u0003C\u0005\u000249\t\t\u0011\"\u0011\u00026!I\u00111\t\b\u0002\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003\u001fr\u0011\u0011!C!\u0003#B\u0011\"a\u0015\u000f\u0003\u0003%\t%!\u0016\b\u0013\u0005eC\"!A\t\u0002\u0005mc\u0001\u0003/\r\u0003\u0003E\t!!\u0018\t\rikB\u0011AA5\u0011!\u0019X$!A\u0005F\u0005-\u0004\"CA7;\u0005\u0005I\u0011QA8\u0011%\t\u0019(HA\u0001\n\u0003\u000b)\bC\u0005\u0002\u0002v\t\t\u0011\"\u0003\u0002\u0004\"I\u00111\u0012\u0007C\u0002\u0013\u0005\u0011Q\u0012\u0005\b\u0003\u001fc\u0001\u0015!\u0003q\u0011%\t\t\n\u0004b\u0001\n\u0003\ti\tC\u0004\u0002\u00142\u0001\u000b\u0011\u00029\t\u000f\u0005UE\u0002\"\u0001\u0002\u0018\nQ2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK*\u0011!fK\u0001\u0006kRLGn\u001d\u0006\u0003Y5\nqA];oi&lWM\u0003\u0002/_\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u00192\u0003\u0015!\u0018M\u00197f\u0015\t\u00114'A\u0003gY&t7N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0003\u0001e\u0002\"AO\u001e\u000e\u0003%J!\u0001P\u0015\u0003#M#(/Z1nS:<G+Z:u\u0005\u0006\u001cX-A\u0003ti\u0006$X\r\u0005\u0002@\u001d9\u0011\u0001i\u0003\b\u0003\u0003Bs!AQ(\u000f\u0005\rseB\u0001#N\u001d\t)EJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011jN\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!\u0001N\u001b\n\u0005I\u001a\u0014B\u0001\u00192\u0013\tqs&\u0003\u0002-[%\u0011!fK\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\t\u0003u1\u0019\"\u0001\u0004+\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!K\u0001\tTi\u0006$XMQ1dW\u0016tG-T8eKN!a\u0002\u00160b!\t)v,\u0003\u0002a-\n9\u0001K]8ek\u000e$\bCA+c\u0013\t\u0019gK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004cC\u000e\\WM\u001c3\u0016\u0003\u0019\u0004\"aZ6\u000f\u0005!L\u0007CA$W\u0013\tQg+\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016W\u0003!\u0011\u0017mY6f]\u0012\u0004CC\u00019s!\t\th\"D\u0001\r\u0011\u0015!\u0017\u00031\u0001g\u0003!!xn\u0015;sS:<G#\u00014\u0002\t\r|\u0007/\u001f\u000b\u0003a^Dq\u0001Z\n\u0011\u0002\u0003\u0007a-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#AZ>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00071\u0016AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0003mC:<'BAA\f\u0003\u0011Q\u0017M^1\n\u00071\f\t\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002 A\u0019Q+!\t\n\u0007\u0005\rbKA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002*\u0005=\u0002cA+\u0002,%\u0019\u0011Q\u0006,\u0003\u0007\u0005s\u0017\u0010C\u0005\u00022]\t\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u000e\u0011\r\u0005e\u0012qHA\u0015\u001b\t\tYDC\u0002\u0002>Y\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\ni\u0005E\u0002V\u0003\u0013J1!a\u0013W\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\r\u001a\u0003\u0003\u0005\r!!\u000b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\b\u0002\r\u0015\fX/\u00197t)\u0011\t9%a\u0016\t\u0013\u0005E2$!AA\u0002\u0005%\u0012\u0001E*uCR,')Y2lK:$Wj\u001c3f!\t\tXd\u0005\u0003\u001e\u0003?\n\u0007CBA1\u0003K2\u0007/\u0004\u0002\u0002d)\u0011AFV\u0005\u0005\u0003O\n\u0019GA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!a\u0017\u0015\u0005\u00055\u0011!B1qa2LHc\u00019\u0002r!)A\r\ta\u0001M\u00069QO\\1qa2LH\u0003BA<\u0003{\u0002B!VA=M&\u0019\u00111\u0010,\u0003\r=\u0003H/[8o\u0011!\ty(IA\u0001\u0002\u0004\u0001\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\t\u0005\u0003\u0002\u0010\u0005\u001d\u0015\u0002BAE\u0003#\u0011aa\u00142kK\u000e$\u0018\u0001\u0004%F\u0003B{&)Q\"L\u000b:#U#\u00019\u0002\u001b!+\u0015\tU0C\u0003\u000e[UI\u0014#!\u0003=\u0011vjQ&T\t\n{&)Q\"L\u000b:#\u0015\u0001\u0005*P\u0007.\u001bFIQ0C\u0003\u000e[UI\u0014#!\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u00033\u0003b!a'\u0002\"\u0006\u0015VBAAO\u0015\u0011\ty*!\u0006\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\u000biJ\u0001\u0006D_2dWm\u0019;j_:\u0004R!VAT\u0003\u000bK1!!+W\u0005\u0015\t%O]1zQ\u001d9\u0013QVAc\u0003\u000f\u0004B!a,\u0002B6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u0003o\u000bI,\u0001\u0006fqR,gn]5p]NTA!a/\u0002>\u0006)!.\u001e8ji*\u0019\u0011qX\u0019\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002BAb\u0003c\u0013!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005%\u0017\u0001E*uCR,')Y2lK:$Wh\u001f\u0019~)\u0011\ti-a4\u0011\u0005i\u0002\u0001\"B\u001f\u0003\u0001\u0004q\u0014aC2mCN\u001cHj\\1eKJ,\"!!6\u0011\t\u0005=\u0011q[\u0005\u0005\u00033\f\tBA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018\u0001D2mCN\u001cHj\\1eKJ\u0004\u0013A\u00022fM>\u0014X\r\u0006\u0002\u0002bB\u0019Q+a9\n\u0007\u0005\u0015hK\u0001\u0003V]&$\bfA\u0003\u0002jB!\u00111^A|\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018aA1qS*!\u00111_A{\u0003\u001dQW\u000f]5uKJT1!a/6\u0013\u0011\tI0!<\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0003bMR,'\u000fK\u0002\u0007\u0003\u007f\u0004B!a;\u0003\u0002%!!1AAw\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\fgC&d\u0017N\\4CS:\f'/\u001f*poN{WO]2f+\u0011\u0011IA!\u0012\u0015\t\t-!\u0011\u000b\u000b\u0005\u0005\u001b\u0011Y\u0003\u0005\u0004\u0003\u0010\tm!qD\u0007\u0003\u0005#QAAa\u0005\u0003\u0016\u0005QA-\u0019;bgR\u0014X-Y7\u000b\t\u0005=(q\u0003\u0006\u0004\u00053\t\u0014!C:ue\u0016\fW.\u001b8h\u0013\u0011\u0011iB!\u0005\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)cL\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0003*\t\r\"a\u0002*po\u0012\u000bG/\u0019\u0005\n\u0005[9\u0011\u0011!a\u0002\u0005_\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\u0011\tD!\u0010\u0003B5\u0011!1\u0007\u0006\u0005\u0005k\u00119$\u0001\u0005usB,\u0017N\u001c4p\u0015\u0011\u0011IDa\u000f\u0002\r\r|W.\\8o\u0015\r\ty/M\u0005\u0005\u0005\u007f\u0011\u0019DA\bUsB,\u0017J\u001c4pe6\fG/[8o!\u0011\u0011\u0019E!\u0012\r\u0001\u00119!qI\u0004C\u0002\t%#!\u0001+\u0012\t\t-\u0013\u0011\u0006\t\u0004+\n5\u0013b\u0001B(-\n9aj\u001c;iS:<\u0007b\u0002B\u0013\u000f\u0001\u0007!1\u000b\t\u0007\u0005+\u0012yF!\u0011\u000f\t\t]#1\f\b\u0004\u000f\ne\u0013\"A,\n\u0007\tuc+A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0005$1\r\u0002\u0004'\u0016\f(b\u0001B/-\u0006\tb-Y5mS:<G)\u0019;b'>,(oY3\u0016\t\t%$\u0011\u000f\u000b\u0005\u0005W\u0012I\b\u0006\u0003\u0003n\tM\u0004C\u0002B\b\u00057\u0011y\u0007\u0005\u0003\u0003D\tEDa\u0002B$\u0011\t\u0007!\u0011\n\u0005\n\u0005kB\u0011\u0011!a\u0002\u0005o\n!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\u0011\tD!\u0010\u0003p!9!Q\u0005\u0005A\u0002\tm\u0004C\u0002B+\u0005?\u0012y'\u0001\u0007nCB\u001cFO]#rk\u0006d7\u000f\u0006\u0004\u0002H\t\u0005%Q\u0011\u0005\u0007\u0005\u0007K\u0001\u0019\u00014\u0002\tM$(/\r\u0005\u0007\u0005\u000fK\u0001\u0019\u00014\u0002\tM$(OM\u0001\u0013CN\u001cXM\u001d;NCB\u001cFO]#rk\u0006d7\u000f\u0006\u0004\u0002b\n5%q\u0012\u0005\u0007\u0005\u0007S\u0001\u0019\u00014\t\r\t\u001d%\u00021\u0001g\u0001")
public class StreamingWithStateTestBase
extends StreamingTestBase {
    private final StateBackendMode state;
    private final ClassLoader classLoader;

    @Parameters(name="StateBackend={0}")
    public static Collection<Object[]> parameters() {
        return StreamingWithStateTestBase$.MODULE$.parameters();
    }

    public static StateBackendMode ROCKSDB_BACKEND() {
        return StreamingWithStateTestBase$.MODULE$.ROCKSDB_BACKEND();
    }

    public static StateBackendMode HEAP_BACKEND() {
        return StreamingWithStateTestBase$.MODULE$.HEAP_BACKEND();
    }

    private ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        Path baseCheckpointPath = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        baseCheckpointPath.toFile().deleteOnExit();
        StateBackendMode stateBackendMode = this.state;
        StateBackendMode stateBackendMode2 = StreamingWithStateTestBase$.MODULE$.HEAP_BACKEND();
        StateBackendMode stateBackendMode3 = stateBackendMode;
        if (!(stateBackendMode2 != null ? !((Object)stateBackendMode2).equals(stateBackendMode3) : stateBackendMode3 != null)) {
            Configuration conf = new Configuration();
            conf.set(StateBackendOptions.STATE_BACKEND, (Object)"hashmap");
            conf.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)new StringBuilder(7).append("file://").append(baseCheckpointPath).toString());
            this.env().configure((ReadableConfig)conf, this.classLoader());
        } else {
            StateBackendMode stateBackendMode4 = StreamingWithStateTestBase$.MODULE$.ROCKSDB_BACKEND();
            StateBackendMode stateBackendMode5 = stateBackendMode;
            if (!(stateBackendMode4 != null ? !((Object)stateBackendMode4).equals(stateBackendMode5) : stateBackendMode5 != null)) {
                Configuration conf = new Configuration();
                conf.set(CheckpointingOptions.INCREMENTAL_CHECKPOINTS, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                conf.set(StateBackendOptions.STATE_BACKEND, (Object)"rocksdb");
                conf.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)new StringBuilder(7).append("file://").append(baseCheckpointPath).toString());
                this.env().configure((ReadableConfig)conf, this.classLoader());
            } else {
                throw new MatchError((Object)stateBackendMode);
            }
        }
        this.tEnv_$eq(StreamTableEnvironment$.MODULE$.create(this.env(), TableTestUtil$.MODULE$.STREAM_SETTING()));
        FailingCollectionSource.failedBefore = true;
    }

    @Override
    @AfterEach
    public void after() {
        super.after();
        Assertions.assertThat((boolean)FailingCollectionSource.failedBefore).isTrue();
    }

    public <T> DataStream<RowData> failingBinaryRowSource(Seq<T> data, TypeInformation<T> evidence$1) {
        CompositeType typeInfo = (CompositeType)Predef$.MODULE$.implicitly(evidence$1);
        MutableList result = new MutableList();
        BinaryRowData reuse = new BinaryRowData(typeInfo.getArity());
        BinaryRowWriter writer = new BinaryRowWriter(reuse);
        data.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Product) {
                Object object2 = object;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), typeInfo.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    TypeInformation fieldType;
                    TypeInformation typeInformation = fieldType = typeInfo.getTypeAt(i);
                    TypeInformation typeInformation2 = Types.INT;
                    TypeInformation typeInformation3 = typeInformation;
                    if (!(typeInformation2 != null ? !typeInformation2.equals(typeInformation3) : typeInformation3 != null)) {
                        writer.writeInt(i, BoxesRunTime.unboxToInt((Object)((Product)object2).productElement(i)));
                        return;
                    }
                    TypeInformation typeInformation4 = Types.LONG;
                    TypeInformation typeInformation5 = typeInformation;
                    if (!(typeInformation4 != null ? !typeInformation4.equals(typeInformation5) : typeInformation5 != null)) {
                        writer.writeLong(i, BoxesRunTime.unboxToLong((Object)((Product)object2).productElement(i)));
                        return;
                    }
                    TypeInformation typeInformation6 = Types.STRING;
                    TypeInformation typeInformation7 = typeInformation;
                    if (!(typeInformation6 != null ? !typeInformation6.equals(typeInformation7) : typeInformation7 != null)) {
                        writer.writeString(i, StringData.fromString((String)((String)((Product)object2).productElement(i))));
                        return;
                    }
                    TypeInformation typeInformation8 = Types.BOOLEAN;
                    TypeInformation typeInformation9 = typeInformation;
                    if (!(typeInformation8 != null ? !typeInformation8.equals(typeInformation9) : typeInformation9 != null)) {
                        writer.writeBoolean(i, BoxesRunTime.unboxToBoolean((Object)((Product)object2).productElement(i)));
                        return;
                    }
                    throw new MatchError((Object)typeInformation);
                });
                writer.complete();
                return result.$plus$eq((Object)reuse.copy());
            }
            throw new UnsupportedOperationException();
        });
        InternalTypeInfo newTypeInfo = InternalTypeInfo.of((RowType)((RowType)TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)typeInfo)));
        return this.failingDataSource((Seq<T>)result, (TypeInformation<T>)newTypeInfo);
    }

    public <T> DataStream<T> failingDataSource(Seq<T> data, TypeInformation<T> evidence$2) {
        this.env().enableCheckpointing(100L, CheckpointingMode.EXACTLY_ONCE);
        Configuration configuration = new Configuration();
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixeddelay");
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)BoxesRunTime.boxToInteger((int)1));
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofMillis(0L));
        this.env().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        FailingCollectionSource.reset();
        Predef$.MODULE$.require(data != null, (Function0 & Serializable & scala.Serializable)() -> "Data must not be null.");
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$2);
        Collection collection = JavaConversions$.MODULE$.asJavaCollection(data);
        FromElementsFunction.checkCollection((Collection)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(data), (Class)typeInfo.getTypeClass());
        FailingCollectionSource function = new FailingCollectionSource(typeInfo.createSerializer(this.env().getConfig().getSerializerConfig()), collection, data.length() / 2);
        return this.env().addSource(function, typeInfo).setMaxParallelism(1);
    }

    private boolean mapStrEquals(String str1, String str2) {
        if (str1.length() != str2.length()) {
            return false;
        }
        int l = str1.length();
        char leftBrace = "{".charAt(0);
        char rightBrace = "}".charAt(0);
        char equalsChar = "=".charAt(0);
        char lParenthesis = "(".charAt(0);
        char rParenthesis = ")".charAt(0);
        char dot = ",".charAt(0);
        char whiteSpace = " ".charAt(0);
        Map map1 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        int idx = 0;
        while (idx < l) {
            char char2;
            char char1 = str1.charAt(idx);
            if (char1 != (char2 = str2.charAt(idx))) {
                return false;
            }
            if (char1 == leftBrace) {
                int rightBraceIdx = str1.substring(idx + 1, l).indexOf(rightBrace);
                StreamingWithStateTestBase.appendStrToMap$1(str1.substring(idx + 1, rightBraceIdx + idx + 2), map1, equalsChar, lParenthesis, rParenthesis, dot, rightBrace, whiteSpace, leftBrace);
                idx += rightBraceIdx;
                continue;
            }
            ++idx;
        }
        return map1.equals((Object)map2);
    }

    public void assertMapStrEquals(String str1, String str2) {
        if (!this.mapStrEquals(str1, str2)) {
            throw new AssertionError((Object)new StringBuilder(21).append("Expected: ").append(str1).append(" \n Actual: ").append(str2).toString());
        }
    }

    public static final /* synthetic */ Object $anonfun$mapStrEquals$1(CharSequence ss$1, char equalsChar$1, ArrayBuffer ret$1, int idx) {
        if (ss$1.charAt(idx) == equalsChar$1) {
            return ret$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
        }
        return BoxedUnit.UNIT;
    }

    private static final int[] findEquals$1(CharSequence ss, char equalsChar$1) {
        ArrayBuffer ret = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ss.length()).foreach((Function1 & Serializable & scala.Serializable)idx -> StreamingWithStateTestBase.$anonfun$mapStrEquals$1(ss, equalsChar$1, ret, BoxesRunTime.unboxToInt((Object)idx)));
        return (int[])ret.toArray(ClassTag$.MODULE$.Int());
    }

    private static final Tuple2 splitKV$1(CharSequence ss, int equalsIdx, char lParenthesis$1, char rParenthesis$1, char dot$1, char rightBrace$1, char whiteSpace$1, char leftBrace$1) {
        boolean endFlag = false;
        int curIdx = equalsIdx + 1;
        char endChar = ss.charAt(curIdx) == lParenthesis$1 ? rParenthesis$1 : dot$1;
        CharSequence valueStr = null;
        CharSequence keyStr = null;
        while (curIdx < ss.length() && !endFlag) {
            char curChar = ss.charAt(curIdx);
            if (curChar != endChar && curChar != rightBrace$1) {
                if (++curIdx != ss.length()) continue;
                valueStr = ss.subSequence(equalsIdx + 1, curIdx);
                continue;
            }
            valueStr = ss.subSequence(equalsIdx + 1, curIdx);
            endFlag = true;
        }
        endFlag = false;
        curIdx = equalsIdx - 1;
        char c = endChar = ss.charAt(curIdx) == rParenthesis$1 ? lParenthesis$1 : whiteSpace$1;
        while (curIdx >= 0 && !endFlag) {
            char curChar = ss.charAt(curIdx);
            if (curChar != endChar && curChar != leftBrace$1) {
                if (--curIdx != -1) continue;
                keyStr = ss.subSequence(0, equalsIdx);
                continue;
            }
            keyStr = ss.subSequence(curIdx, equalsIdx);
            endFlag = true;
        }
        Predef$.MODULE$.require(keyStr != null);
        Predef$.MODULE$.require(valueStr != null);
        return new Tuple2((Object)((Object)keyStr).toString(), (Object)((Object)valueStr).toString());
    }

    private static final void appendStrToMap$1(CharSequence ss, Map m, char equalsChar$1, char lParenthesis$1, char rParenthesis$1, char dot$1, char rightBrace$1, char whiteSpace$1, char leftBrace$1) {
        int[] equalsIdxs = StreamingWithStateTestBase.findEquals$1(ss, equalsChar$1);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(equalsIdxs)).foreach((Function1 & Serializable & scala.Serializable)idx -> m.$plus(StreamingWithStateTestBase.splitKV$1(ss, BoxesRunTime.unboxToInt((Object)idx), lParenthesis$1, rParenthesis$1, dot$1, rightBrace$1, whiteSpace$1, leftBrace$1)));
    }

    public StreamingWithStateTestBase(StateBackendMode state) {
        boolean bl;
        this.state = state;
        StateBackendMode stateBackendMode = state;
        StateBackendMode stateBackendMode2 = StreamingWithStateTestBase$.MODULE$.HEAP_BACKEND();
        StateBackendMode stateBackendMode3 = stateBackendMode;
        if (!(stateBackendMode2 != null ? !((Object)stateBackendMode2).equals(stateBackendMode3) : stateBackendMode3 != null)) {
            bl = false;
        } else {
            StateBackendMode stateBackendMode4 = StreamingWithStateTestBase$.MODULE$.ROCKSDB_BACKEND();
            StateBackendMode stateBackendMode5 = stateBackendMode;
            if (!(stateBackendMode4 != null ? !((Object)stateBackendMode4).equals(stateBackendMode5) : stateBackendMode5 != null)) {
                bl = true;
            } else {
                throw new MatchError((Object)stateBackendMode);
            }
        }
        this.enableObjectReuse_$eq(bl);
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public static class StateBackendMode
    implements Product,
    scala.Serializable {
        private final String backend;

        public String backend() {
            return this.backend;
        }

        public String toString() {
            return this.backend().toString();
        }

        public StateBackendMode copy(String backend) {
            return new StateBackendMode(backend);
        }

        public String copy$default$1() {
            return this.backend();
        }

        public String productPrefix() {
            return "StateBackendMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.backend();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StateBackendMode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StateBackendMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            StateBackendMode stateBackendMode = (StateBackendMode)x$1;
            String string = this.backend();
            String string2 = stateBackendMode.backend();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stateBackendMode.canEqual(this)) return false;
            return true;
        }

        public StateBackendMode(String backend) {
            this.backend = backend;
            Product.$init$((Product)this);
        }
    }
}

