/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.util.Collector;

public class JavaUserDefinedTableAggFunctions {

    public static class IncrementalTop2
    extends Top2 {
        @Override
        public Top2Accumulator createAccumulator() {
            Top2Accumulator acc = super.createAccumulator();
            acc.previousFirst = Integer.MIN_VALUE;
            acc.previousSecond = Integer.MIN_VALUE;
            return acc;
        }

        @Override
        public void accumulate(Top2Accumulator acc, Integer value) {
            acc.previousFirst = acc.first;
            acc.previousSecond = acc.second;
            super.accumulate(acc, value);
        }

        public void emitUpdateWithRetract(Top2Accumulator acc, TableAggregateFunction.RetractableCollector<Tuple2<Integer, Integer>> out) {
            if (!acc.first.equals(acc.previousFirst)) {
                if (!acc.previousFirst.equals(Integer.MIN_VALUE)) {
                    out.retract((Object)Tuple2.of((Object)acc.previousFirst, (Object)1));
                }
                out.collect((Object)Tuple2.of((Object)acc.first, (Object)1));
            }
            if (!acc.second.equals(acc.previousSecond)) {
                if (!acc.previousSecond.equals(Integer.MIN_VALUE)) {
                    out.retract((Object)Tuple2.of((Object)acc.previousSecond, (Object)2));
                }
                out.collect((Object)Tuple2.of((Object)acc.second, (Object)2));
            }
        }
    }

    public static class Top2
    extends TableAggregateFunction<Tuple2<Integer, Integer>, Top2Accumulator> {
        public Top2Accumulator createAccumulator() {
            Top2Accumulator acc = new Top2Accumulator();
            acc.first = Integer.MIN_VALUE;
            acc.second = Integer.MIN_VALUE;
            return acc;
        }

        public void accumulate(Top2Accumulator acc, Integer value) {
            if (value > acc.first) {
                acc.second = acc.first;
                acc.first = value;
            } else if (value > acc.second) {
                acc.second = value;
            }
        }

        public void merge(Top2Accumulator acc, Iterable<Top2Accumulator> it) {
            for (Top2Accumulator otherAcc : it) {
                this.accumulate(acc, otherAcc.first);
                this.accumulate(acc, otherAcc.second);
            }
        }

        public void emitValue(Top2Accumulator acc, Collector<Tuple2<Integer, Integer>> out) {
            if (acc.first != Integer.MIN_VALUE) {
                out.collect((Object)Tuple2.of((Object)acc.first, (Object)1));
            }
            if (acc.second != Integer.MIN_VALUE) {
                out.collect((Object)Tuple2.of((Object)acc.second, (Object)2));
            }
        }
    }

    public static class Top2Accumulator {
        public Integer first;
        public Integer second;
        public Integer previousFirst;
        public Integer previousSecond;
    }
}

