/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public class BatchAbstractTestBase {
    protected static final int DEFAULT_PARALLELISM = 3;
    @RegisterExtension
    private static final MiniClusterExtension MINI_CLUSTER_EXTENSION = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setConfiguration(BatchAbstractTestBase.getConfiguration()).setNumberTaskManagers(1).setNumberSlotsPerTaskManager(3).build());
    @TempDir
    protected static Path tmpDir;

    private static Configuration getConfiguration() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"100m"));
        return config;
    }

    protected static File createTempFolder() throws IOException {
        return TempDirUtils.newFolder((Path)tmpDir);
    }

    protected static File createTempFile() throws IOException {
        Path tmpDirPath = BatchAbstractTestBase.createTempFolder().toPath();
        return TempDirUtils.newFile((Path)tmpDirPath);
    }

    protected static File createFileInTempFolder(String fileName) throws IOException {
        Path tmpDirPath = BatchAbstractTestBase.createTempFolder().toPath();
        return TempDirUtils.newFile((Path)tmpDirPath, (String)fileName);
    }
}

