/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0003\u0006\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C!O!)\u0011\b\u0001C\u0001O!)a\b\u0001C\u0001O!)\u0001\t\u0001C\u0001O!)!\t\u0001C\u0001O!)A\t\u0001C\u0001O!)a\t\u0001C\u0001O\tyA+[7fgR\fW\u000e]%U\u0007\u0006\u001cXM\u0003\u0002\f\u0019\u0005\u00191/\u001d7\u000b\u00055q\u0011AB:ue\u0016\fWN\u0003\u0002\u0010!\u00059!/\u001e8uS6,'BA\t\u0013\u0003\u001d\u0001H.\u00198oKJT!a\u0005\u000b\u0002\u000bQ\f'\r\\3\u000b\u0005U1\u0012!\u00024mS:\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\u0011qDD\u0001\u0006kRLGn]\u0005\u0003Cy\u0011\u0011c\u0015;sK\u0006l\u0017N\\4UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t!\"\u0001\u0004cK\u001a|'/\u001a\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5uQ\t\u0011q\u0006\u0005\u00021o5\t\u0011G\u0003\u00023g\u0005\u0019\u0011\r]5\u000b\u0005Q*\u0014a\u00026va&$XM\u001d\u0006\u0003ma\tQA[;oSRL!\u0001O\u0019\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u000buKN$xI]8va\nKH+[7fgR\fW\u000e\u001d\u0015\u0003\u0007m\u0002\"\u0001\r\u001f\n\u0005u\n$\u0001\u0002+fgR\fa\u0004^3ti\u001e\u0013x.\u001e9Cs2{7-\u00197[_:,G\rV5nKN$\u0018-\u001c9)\u0005\u0011Y\u0014\u0001\b;fgR\u001cu.\u001e8u\t&\u001cH/\u001b8di>sG+[7fgR\fW\u000e\u001d\u0015\u0003\u000bm\na\u0005^3ti\u000e{WO\u001c;ESN$\u0018N\\2u\u001f:dunY1m5>tW\r\u001a+j[\u0016\u001cH/Y7qQ\t11(A\u000buKN$X*\u0019=NS:|e\u000eV5nKN$\u0018-\u001c9)\u0005\u001dY\u0014\u0001\t;fgRl\u0015\r_'j]^KG\u000f\u001b*fiJ\f7\r^(o)&lWm\u001d;b[BD#\u0001C\u001e")
public class TimestampITCase
extends StreamingTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        List ints = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), null}));
        List longs = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), null}));
        .colon.colon datetimes = new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1969-01-01 00:00:00.123456789"), (List)new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456"), (List)new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456"), (List)new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123"), (List)new .colon.colon(null, (List)Nil$.MODULE$)))));
        .colon.colon timestamps = new .colon.colon((Object)Timestamp.valueOf("1969-01-01 00:00:00.123456789").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1970-01-01 00:00:00.123456").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1970-01-01 00:00:00.123").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1972-01-01 00:00:00").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1973-01-01 00:00:00").toLocalDateTime(), (List)Nil$.MODULE$)))));
        MutableList instants = new MutableList();
        datetimes.indices().foreach(arg_0 -> TimestampITCase.$anonfun$before$1$adapted((List)datetimes, instants, arg_0));
        MutableList data = new MutableList();
        ints.indices().foreach(arg_0 -> TimestampITCase.$anonfun$before$2$adapted(data, ints, longs, (List)datetimes, (List)timestamps, instants, arg_0));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data.seq());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(508).append("\n                       |create table T (\n                       |  a int,\n                       |  b bigint,\n                       |  c timestamp(9),\n                       |  d timestamp(3),\n                       |  e timestamp_ltz(9),\n                       |  watermark for d as d\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testGroupByTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(a), c FROM T GROUP BY c")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"0,null", (List)new .colon.colon((Object)"1,1969-01-01T00:00:00.123456789", (List)new .colon.colon((Object)"1,1970-01-01T00:00:00.123", (List)new .colon.colon((Object)"2,1970-01-01T00:00:00.123456", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGroupByLocalZonedTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(a), e FROM T GROUP BY e")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"0,null", (List)new .colon.colon((Object)"1,1969-01-01T00:00:00.123456789Z", (List)new .colon.colon((Object)"1,1970-01-01T00:00:00.123Z", (List)new .colon.colon((Object)"2,1970-01-01T00:00:00.123456Z", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCountDistinctOnTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(DISTINCT c), b FROM T GROUP BY b")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"0,null", (List)new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"1,2", (List)new .colon.colon((Object)"1,4", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCountDistinctOnLocalZonedTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(DISTINCT e), b FROM T GROUP BY b")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"0,null", (List)new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"1,2", (List)new .colon.colon((Object)"1,4", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMaxMinOnTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT MAX(c), MIN(c), b FROM T GROUP BY b")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1969-01-01T00:00:00.123456789,1969-01-01T00:00:00.123456789,1", (List)new .colon.colon((Object)"null,null,null", (List)new .colon.colon((Object)"1970-01-01T00:00:00.123456,1970-01-01T00:00:00.123456,2", (List)new .colon.colon((Object)"1970-01-01T00:00:00.123,1970-01-01T00:00:00.123,4", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMaxMinWithRetractOnTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                   |SELECT MAX(y), MIN(x)\n                   |FROM\n                   |  (SELECT b, MAX(c) AS x, MIN(c) AS y FROM T GROUP BY b, c)\n                   |GROUP BY b\n       ")).stripMargin())).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1969-01-01T00:00:00.123456789,1969-01-01T00:00:00.123456789", (List)new .colon.colon((Object)"1970-01-01T00:00:00.123,1970-01-01T00:00:00.123", (List)new .colon.colon((Object)"1970-01-01T00:00:00.123456,1970-01-01T00:00:00.123456", (List)new .colon.colon((Object)"null,null", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ MutableList $anonfun$before$1(List datetimes$1, MutableList instants$1, int i) {
        if (datetimes$1.apply(i) == null) {
            return instants$1.$plus$eq(null);
        }
        return instants$1.$plus$eq((Object)((ChronoLocalDateTime)datetimes$1.apply(i)).toInstant(ZoneId.of("UTC").getRules().getOffset((LocalDateTime)datetimes$1.apply(i))));
    }

    public static final /* synthetic */ MutableList $anonfun$before$1$adapted(List datetimes$1, MutableList instants$1, Object i) {
        return TimestampITCase.$anonfun$before$1(datetimes$1, instants$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ MutableList $anonfun$before$2$adapted(MutableList data$1, List ints$1, List longs$1, List datetimes$1, List timestamps$1, MutableList instants$1, Object i) {
        return data$1.$plus$eq((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ints$1.apply(BoxesRunTime.unboxToInt((Object)i)), longs$1.apply(BoxesRunTime.unboxToInt((Object)i)), datetimes$1.apply(BoxesRunTime.unboxToInt((Object)i)), timestamps$1.apply(BoxesRunTime.unboxToInt((Object)i)), instants$1.apply(BoxesRunTime.unboxToInt((Object)i))})));
    }
}

