/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0004\t\u0001C!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0003i\u0003B\u0002 \u0001A\u0003%a\u0006C\u0004@\u0001\t\u0007I\u0011\u0001!\t\r1\u0003\u0001\u0015!\u0003B\u0011\u001di\u0005A1A\u0005\u00025BaA\u0014\u0001!\u0002\u0013q\u0003bB(\u0001\u0005\u0004%\t\u0001\u0011\u0005\u0007!\u0002\u0001\u000b\u0011B!\t\u000bE\u0003A\u0011\u0001*\t\u000b\t\u0004A\u0011\u0001*\t\u000b\u0011\u0004A\u0011\u0001*\t\u000b\u0019\u0004A\u0011\u0001*\t\u000b!\u0004A\u0011B5\u0003'QKW.Z!uiJL'-\u001e;f\u0013R\u001b\u0015m]3\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0007gR\u0014X-Y7\u000b\u0005U1\u0012a\u0002:v]RLW.\u001a\u0006\u0003/a\tq\u0001\u001d7b]:,'O\u0003\u0002\u001a5\u0005)A/\u00192mK*\u00111\u0004H\u0001\u0006M2Lgn\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0015\u0003\u0015)H/\u001b7t\u0013\t9CEA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\t\u0002\t\u0011\fG/Y\u000b\u0002]A\u0019qF\u000e\u001d\u000e\u0003AR!!\r\u001a\u0002\u0013%lW.\u001e;bE2,'BA\u001a5\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\r\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002:y5\t!H\u0003\u0002<5\u0005)A/\u001f9fg&\u0011QH\u000f\u0002\u0004%><\u0018!\u00023bi\u0006\u0004\u0013A\u00023bi\u0006LE-F\u0001B!\t\u0011\u0015J\u0004\u0002D\u000fB\u0011A\tN\u0007\u0002\u000b*\u0011a\tI\u0001\u0007yI|w\u000e\u001e \n\u0005!#\u0014A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001\u0013\u001b\u0002\u000f\u0011\fG/Y%eA\u00059A\u000e\u001e>ECR\f\u0017\u0001\u00037uu\u0012\u000bG/\u0019\u0011\u0002\u00131$(\u0010R1uC&#\u0017A\u00037uu\u0012\u000bG/Y%eA\u0005qB/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK>sw+\u0019;fe6\f'o\u001b\u000b\u0002'B\u0011A+V\u0007\u0002i%\u0011a\u000b\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u000b1B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u0004CBL'BA/_\u0003\u001dQW\u000f]5uKJT!a\u0018\u0010\u0002\u000b),h.\u001b;\n\u0005\u0005T&\u0001\u0002+fgR\f!\u0006^3ti^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016|e\u000eV5nKN$\u0018-\u001c9Mij<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0002\f1\u0006AC/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK>s7)^:u_6L'0\u001a3XCR,'/\\1sW\"\u0012A\u0002W\u0001%i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o\u0007>l\u0007/\u001e;fIJ{w\u000f^5nK\"\u0012Q\u0002W\u0001\u000eY>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\u0015\u0005)\u0014\bCA6q\u001b\u0005a'BA7o\u0003\u0011!\u0018.\\3\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000bMt\u0001\u0019\u0001;\u0002\u0005Q\u001c\bC\u0001+v\u0013\t1HG\u0001\u0003M_:<\u0007")
public class TimeAttributeITCase
extends StreamingTestBase {
    private final List<Row> data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.001", this.localDateTime(1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.002", this.localDateTime(2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.003", this.localDateTime(3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.004", this.localDateTime(4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.007", this.localDateTime(7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.008", this.localDateTime(8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.016", this.localDateTime(16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)})), (List)Nil$.MODULE$)))))));
    private final String dataId = TestValuesTableFactory.registerData(this.data());
    private final List<Row> ltzData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.001", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.002", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.003", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.004", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.007", BoxesRunTime.boxToLong((long)7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.008", BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.016", BoxesRunTime.boxToLong((long)16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)})), (List)Nil$.MODULE$)))))));
    private final String ltzDataId = TestValuesTableFactory.registerData(this.ltzData());

    public List<Row> data() {
        return this.data;
    }

    public String dataId() {
        return this.dataId;
    }

    public List<Row> ltzData() {
        return this.ltzData;
    }

    public String ltzDataId() {
        return this.ltzDataId;
    }

    @Test
    public void testWindowAggregateOnWatermark() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(288).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.dataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01T00:00:00.003,2,3.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.006,2,7.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.009,2,6.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.018,1,4.0", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWindowAggregateOnTimestampLtzWatermark() {
        String zoneId = "Asia/Shanghai";
        this.tEnv().getConfig().setLocalTimeZone(ZoneId.of(zoneId));
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n         |CREATE TABLE src1 (\n         |  log_ts STRING,\n         |  ts BIGINT,\n         |  a INT,\n         |  b DOUBLE,\n         |  ltz_ts AS TO_TIMESTAMP_LTZ(ts, 3),\n         |  WATERMARK FOR ltz_ts AS ltz_ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.ltzDataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ltz_ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src1\n        |GROUP BY TUMBLE(ltz_ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink(TimeZone.getTimeZone(zoneId));
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01T08:00:00.003,2,3.0", (List)new .colon.colon((Object)"1970-01-01T08:00:00.006,2,7.0", (List)new .colon.colon((Object)"1970-01-01T08:00:00.009,2,6.0", (List)new .colon.colon((Object)"1970-01-01T08:00:00.018,1,4.0", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWindowAggregateOnCustomizedWatermark() {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        this.tEnv().createTemporaryFunction("myFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(273).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  WATERMARK FOR ts AS myFunc(ts, a)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.dataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01T00:00:00.003,2,3.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.006,2,7.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.009,2,6.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.018,1,4.0", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled).isTrue();
        Assertions.assertThat((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled).isTrue();
    }

    @Test
    public void testWindowAggregateOnComputedRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  rowtime AS CAST(log_ts AS TIMESTAMP(3)),\n         |  WATERMARK FOR rowtime AS rowtime - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.dataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(rowtime, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01T00:00:00.003,2,3.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.006,2,7.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.009,2,6.0", (List)new .colon.colon((Object)"1970-01-01T00:00:00.018,1,4.0", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private LocalDateTime localDateTime(long ts) {
        return new Timestamp(ts - (long)TimeZone.getDefault().getOffset(ts)).toLocalDateTime();
    }
}

