/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$;
import org.apache.flink.table.planner.runtime.stream.sql.TimestampExtractor;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001=4A\u0001C\u0005\u00015!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003;\u0001\u0011\u00051\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003S\u0001\u0011\u0005\u0001\tC\u0003U\u0001\u0011\u0005\u0001\tC\u0003W\u0001\u0011\u0005\u0001\tC\u0003Y\u0001\u0011\u0005\u0001IA\u0010UK6\u0004xN]1m)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8K_&t\u0017\nV\"bg\u0016T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u000511\u000f\u001e:fC6T!AD\b\u0002\u000fI,h\u000e^5nK*\u0011\u0001#E\u0001\ba2\fgN\\3s\u0015\t\u00112#A\u0003uC\ndWM\u0003\u0002\u0015+\u0005)a\r\\5oW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0005yi\u0011!B;uS2\u001c\u0018B\u0001\u0011\u001e\u0005i\u0019FO]3b[&twmV5uQN#\u0018\r^3UKN$()Y:f\u0003\u0015\u0019H/\u0019;f!\t\u0019sG\u0004\u0002%k9\u0011Q\u0005\u000e\b\u0003MMr!a\n\u001a\u000f\u0005!\ndBA\u00151\u001d\tQsF\u0004\u0002,]5\tAF\u0003\u0002.3\u00051AH]8pizJ\u0011\u0001G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002\u001f\u001b%\u0011a'H\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/Z\u0005\u0003qe\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u0005Yj\u0012A\u0002\u001fj]&$h\b\u0006\u0002=}A\u0011Q\bA\u0007\u0002\u0013!)\u0011E\u0001a\u0001E\u0005AB/Z:u!J|7-Z:t)&lW-\u00138oKJTu.\u001b8\u0015\u0003\u0005\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013A!\u00168ji\"\u00121\u0001\u0013\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000b1!\u00199j\u0015\tie*A\u0004kkBLG/\u001a:\u000b\u0005=;\u0012!\u00026v]&$\u0018BA)K\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003%\"Xm\u001d;Qe>\u001cWm]:US6,\u0017J\u001c8fe*{\u0017N\\,ji\"\u001cuN\\:uC:$H+\u00192mK\"\u0012A\u0001S\u0001!i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8\u000fV5nK&sg.\u001a:K_&tWK\\5p]\u0006cG\u000e\u000b\u0002\u0006\u0011\u00061B/Z:u\u000bZ,g\u000e\u001e+j[\u0016LeN\\3s\u0015>Lg\u000e\u000b\u0002\u0007\u0011\u00061B/Z:u\u001d\u0016\u001cH/\u001a3UK6\u0004xN]1m\u0015>Lg\u000e\u000b\u0002\b\u0011\"\"\u0001aW1c!\tav,D\u0001^\u0015\tq&*A\u0005fqR,gn]5p]&\u0011\u0001-\u0018\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,G&A2$\u0003\u0011\u0004\"!Z7\u000e\u0003\u0019T!a\u001a5\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\tI'.\u0001\u0006fqR,gn]5p]NT!aT6\u000b\u00051\u001c\u0012!\u0003;fgR,H/\u001b7t\u0013\tqgM\u0001\u000eQCJ\fW.\u001a;fe&TX\r\u001a+fgR,\u0005\u0010^3og&|g\u000e")
public class TemporalTableFunctionJoinITCase
extends StreamingWithStateTestBase {
    @TestTemplate
    public void testProcessTimeInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.proctime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"US Dollar"));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L)));
        Table orders = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, ordersData, new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, ratesHistoryData, new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("Orders", orders);
        tEnv.createTemporaryView("RatesHistory", ratesHistory);
        tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)ratesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proctime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)new TestingAppendSink());
        env.execute();
    }

    @TestTemplate
    public void testProcessTimeInnerJoinWithConstantTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(1);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery("SELECT amount, currency, proctime() as proctime FROM (VALUES (1, 2.0)) AS T(amount, currency)")).toDataStream();
        result.addSink((SinkFunction)new TestingAppendSink());
        env.execute();
    }

    @TestTemplate
    public void testProcessTimeInnerJoinUnionAll() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.proctime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"US Dollar"));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L)));
        Table orders1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, ordersData, new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        Table orders2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, ordersData, new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, ratesHistoryData, new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("Orders1", orders1);
        tEnv.createTemporaryView("Orders2", orders2);
        tEnv.createTemporaryView("RatesHistory", ratesHistory);
        tEnv.createTemporaryFunction("Rates", (UserDefinedFunction)ratesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proctime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        tEnv.createTemporaryView("Orders", tEnv.sqlQuery("SELECT * FROM Orders1 UNION ALL SELECT * FROM Orders2"));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)new TestingAppendSink());
        env.execute();
    }

    @TestTemplate
    public void testEventTimeInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.rowtime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro", (Object)new Timestamp(2L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar", (Object)new Timestamp(3L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen", (Object)new Timestamp(4L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro", (Object)new Timestamp(5L)));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L), (Object)new Timestamp(5L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L), (Object)new Timestamp(7L)));
        HashSet expectedOutput = new HashSet();
        expectedOutput.$plus$eq((Object)Integer.toString(228));
        expectedOutput.$plus$eq((Object)Integer.toString(348));
        Table orders = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, ordersData, new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$11 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, ratesHistoryData, new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.createTemporaryView("Orders", orders);
        tEnv.createTemporaryView("RatesHistory", ratesHistory);
        tEnv.createTemporaryView("FilteredRatesHistory", tEnv.sqlQuery("SELECT * FROM RatesHistory WHERE rate > 110"));
        tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)tEnv.from("FilteredRatesHistory").createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        tEnv.createTemporaryView("TemporalJoinResult", tEnv.sqlQuery(sqlQuery));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.from("TemporalJoinResult")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        env.execute();
        Assertions.assertThat((Object)sink.getAppendResults().toSet()).isEqualTo((Object)expectedOutput);
    }

    @TestTemplate
    public void testNestedTemporalJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.orderId,\n        |  (o.amount * p.price * r.rate) as total_price\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Prices(o.rowtime)) AS p,\n        |  LATERAL TABLE (Rates(o.rowtime)) AS r\n        |WHERE\n        |  o.productId = p.productId AND\n        |  r.currency = p.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)1L), (Object)"A1", (Object)BoxesRunTime.boxToLong((long)2L), (Object)new Timestamp(2L)));
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)2L), (Object)"A2", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(3L)));
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)3L), (Object)"A4", (Object)BoxesRunTime.boxToLong((long)50L), (Object)new Timestamp(4L)));
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)4L), (Object)"A1", (Object)BoxesRunTime.boxToLong((long)3L), (Object)new Timestamp(5L)));
        Table orders = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, ordersData, new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$15 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "productId")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L), (Object)new Timestamp(5L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L), (Object)new Timestamp(7L)));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, ratesHistoryData, new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$17 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        MutableList pricesHistoryData = new MutableList();
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A2", (Object)"US Dollar", (Object)BoxesRunTime.boxToDouble((double)10.2), (Object)new Timestamp(1L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A1", (Object)"Euro", (Object)BoxesRunTime.boxToDouble((double)11.4), (Object)new Timestamp(1L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A4", (Object)"Yen", (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)new Timestamp(1L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A1", (Object)"Euro", (Object)BoxesRunTime.boxToDouble((double)11.6), (Object)new Timestamp(5L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A1", (Object)"Euro", (Object)BoxesRunTime.boxToDouble((double)11.9), (Object)new Timestamp(7L)));
        Table pricesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, pricesHistoryData, new CaseClassTypeInfo<Tuple4<String, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<String, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<String, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$$anon$19 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "productId")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.createTemporaryView("Orders", orders);
        tEnv.createTemporaryView("RatesHistory", ratesHistory);
        tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)ratesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        tEnv.createTemporarySystemFunction("Prices", (UserDefinedFunction)pricesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"productId"}))).$((Seq)Nil$.MODULE$)));
        tEnv.createTemporaryView("TemporalJoinResult", tEnv.sqlQuery(sqlQuery));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.from("TemporalJoinResult")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)new StringBuilder(2).append("1,").append(2599.2000000000003).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("2,").append(1040.3999999999999).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("3,").append(50.0).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("4,").append(4036.7999999999997).toString(), (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TemporalTableFunctionJoinITCase(StreamingWithStateTestBase.StateBackendMode state) {
        super(state);
    }
}

