/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\u00180\u0001\u0001C\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019!\b\u0001)A\u0005O\"I\u0011Q\u0001\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\n!I\u00111\u0006\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\n!I\u0011q\u0006\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\n!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\n!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002\n!I\u00111\b\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002\n!I\u0011q\b\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002\n!I\u00111\t\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002\n!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA/\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003O\u0002A\u0011AA%\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u0013Bq!a\u001c\u0001\t\u0003\tI\u0005C\u0004\u0002t\u0001!\t!!\u0013\t\u000f\u0005]\u0004\u0001\"\u0001\u0002J!9\u00111\u0010\u0001\u0005\u0002\u0005%\u0003bBA@\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u0007\u0003A\u0011AA%\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Bq!a#\u0001\t\u0003\tI\u0005C\u0004\u0002\u0010\u0002!\t!!\u0013\t\u000f\u0005M\u0005\u0001\"\u0001\u0002J!9\u0011q\u0013\u0001\u0005\u0002\u0005%\u0003bBAN\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003?\u0003A\u0011AA%\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u0013Bq!a*\u0001\t\u0003\tI\u0005C\u0004\u0002,\u0002!\t!!\u0013\t\u000f\u0005=\u0006\u0001\"\u0001\u0002J!9\u00111\u0017\u0001\u0005\u0002\u0005%\u0003bBA\\\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\ti\u000e\u0001C\u0005\u0003?\u0014!\u0003V3na>\u0014\u0018\r\u001c&pS:LEkQ1tK*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0019\u0019HO]3b[*\u0011A'N\u0001\beVtG/[7f\u0015\t1t'A\u0004qY\u0006tg.\u001a:\u000b\u0005aJ\u0014!\u0002;bE2,'B\u0001\u001e<\u0003\u00151G.\u001b8l\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tN\nQ!\u001e;jYNL!AR\"\u00035M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\u0002\u000bM$\u0018\r^3\u0011\u0005%kfB\u0001&\\\u001d\tY%L\u0004\u0002M3:\u0011Q\n\u0017\b\u0003\u001d^s!a\u0014,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*@\u0003\u0019a$o\\8u}%\ta(\u0003\u0002={%\u0011!hO\u0005\u0003qeJ!AN\u001c\n\u0005Q*\u0014B\u0001#4\u0013\ta6)\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-\u0003\u0002_?\n\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u00039\u000e\u000ba\u0001P5oSRtDC\u00012e!\t\u0019\u0007!D\u00010\u0011\u00159%\u00011\u0001I\u0003\u0005yV#A4\u0011\u0007!lw.D\u0001j\u0015\tQ7.A\u0005uKN$X\u000f^5mg*\u0011A.O\u0001\u0005G>\u0014X-\u0003\u0002oS\n\u0019R)Y2i\u0007\u0006dGNY1dW^\u0013\u0018\r\u001d9feB\u0011\u0001O]\u0007\u0002c*\u0011AiN\u0005\u0003gF\u0014!\u0003T3hC\u000eL(k\\<FqR,gn]5p]\u0006\u0011q\f\t\u0015\u0003\tY\u00042a^A\u0001\u001b\u0005A(BA={\u0003%)\u0007\u0010^3og&|gN\u0003\u0002|y\u0006\u0019\u0011\r]5\u000b\u0005ut\u0018a\u00026va&$XM\u001d\u0006\u0003\u007fv\nQA[;oSRL1!a\u0001y\u0005E\u0011VmZ5ti\u0016\u0014X\t\u001f;f]NLwN\\\u0001\u0012aJ|7\rV5nK>\u0013H-\u001a:ECR\fWCAA\u0005!\u0019\tY!!\u0007\u0002\u001e5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005j[6,H/\u00192mK*!\u00111CA\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u0003/\tQa]2bY\u0006LA!a\u0007\u0002\u000e\t!A*[:u!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012s\u0005)A/\u001f9fg&!\u0011qEA\u0011\u0005\r\u0011vn^\u0001\u0013aJ|7\rV5nK>\u0013H-\u001a:ECR\f\u0007%\u0001\u000bqe>\u001cG+[7f\u0007V\u0014(/\u001a8ds\u0012\u000bG/Y\u0001\u0016aJ|7\rV5nK\u000e+(O]3oGf$\u0015\r^1!\u0003u\u0001(o\\2US6,7)\u001e:sK:\u001c\u0017p\u00115b]\u001e,Gn\\4ECR\f\u0017A\b9s_\u000e$\u0016.\\3DkJ\u0014XM\\2z\u0007\"\fgnZ3m_\u001e$\u0015\r^1!\u0003A\u0011xn\u001e+j[\u0016|%\u000fZ3s\t\u0006$\u0018-A\ts_^$\u0016.\\3Pe\u0012,'\u000fR1uC\u0002\n\u0001E]8x)&lWmQ;se\u0016t7-\u001f#bi\u0006,6/\u001b8h\u001b\u0016$\u0018\rV5nK\u0006\t#o\\<US6,7)\u001e:sK:\u001c\u0017\u0010R1uCV\u001b\u0018N\\4NKR\fG+[7fA\u0005\u0011#o\\<US6,7)\u001e:sK:\u001c\u0017\u0010R1uCV\u001b\u0018N\\4CK\u001a|'/\u001a+j[\u0016\f1E]8x)&lWmQ;se\u0016t7-\u001f#bi\u0006,6/\u001b8h\u0005\u00164wN]3US6,\u0007%\u0001\rvaN,'\u000f^*pkJ\u001cWmQ;se\u0016t7-\u001f#bi\u0006\f\u0011$\u001e9tKJ$8k\\;sG\u0016\u001cUO\u001d:f]\u000eLH)\u0019;bA\u0005i\"o\\<US6,\u0017J\\:feR|e\u000e\\=DkJ\u0014XM\\2z\t\u0006$\u0018-\u0001\u0010s_^$\u0016.\\3J]N,'\u000f^(oYf\u001cUO\u001d:f]\u000eLH)\u0019;bA\u00059\u0001O]3qCJ,GCAA&!\u0011\ti%a\u0014\u000e\u0005\u0005U\u0011\u0002BA)\u0003+\u0011A!\u00168ji\"\u001aQ#!\u0016\u0011\t\u0005]\u0013\u0011L\u0007\u0002u&\u0019\u00111\f>\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\ruKN$\bK]8d)&lW\rV3na>\u0014\u0018\r\u001c&pS:D3AFA1!\u0011\t9&a\u0019\n\u0007\u0005\u0015$P\u0001\u0007UKN$H+Z7qY\u0006$X-\u0001\u000fuKN$\bK]8d)&lW\rT3giR+W\u000e]8sC2Tu.\u001b8)\u0007]\t\t'A\u0014uKN$\bK]8d)&lW\rV3na>\u0014\u0018\r\u001c&pS:\u001c\u0005.\u00198hK2|wmU8ve\u000e,\u0007f\u0001\r\u0002b\u0005\u0001C/Z:u!J|7\rV5nKR+W\u000e]8sC2Tu.\u001b8XSRDg+[3xQ\rI\u0012\u0011M\u0001%i\u0016\u001cH\u000f\u0015:pGRKW.\u001a'fMR$V-\u001c9pe\u0006d'j\\5o/&$\bNV5fo\"\u001a!$!\u0019\u0002OQ,7\u000f\u001e)s_\u000e$\u0016.\\3UK6\u0004xN]1m\u0015>LgnV5uQZKWm\u001e(p]\u0016\u000bX/\u001b\u0015\u00047\u0005\u0005\u0014A\r;fgR\u0004&o\\2US6,G*\u001a4u)\u0016l\u0007o\u001c:bY*{\u0017N\\,ji\"4\u0016.Z<XSRD\u0007K]3eS\u000e\fG/Z:)\u0007q\t\t'A\u000fuKN$\bK]8d)&lW-T;mi&$V-\u001c9pe\u0006d'j\\5oQ\ri\u0012\u0011M\u0001\u001ai\u0016\u001cH/\u0012<f]R$\u0016.\\3UK6\u0004xN]1m\u0015>Lg\u000eK\u0002\u001f\u0003C\na\u0006^3ti\u00163XM\u001c;US6,G+Z7q_J\fGNS8j]RC\u0017\r\u001e&pS:\\W-_\"p]R\f\u0017N\\:QW\"\u001aq$!\u0019\u0002GQ,7\u000f^#wK:$H+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\,ji\"4\u0015\u000e\u001c;fe\"\u001a\u0001%!\u0019\u0002;Q,7\u000f^#wK:$H+[7f\u0019\u00164G\u000fV3na>\u0014\u0018\r\u001c&pS:D3!IA1\u0003E\"Xm\u001d;Fm\u0016tG\u000fV5nKR+W\u000e]8sC2Tu.\u001b8DQ\u0006tw-\u001a7pOV\u001b\u0018N\\4CK\u001a|'/\u001a+j[\u0016D3AIA1\u0003%\"Xm\u001d;Fm\u0016tG\u000fV5nK2+g\r\u001e+f[B|'/\u00197K_&tW\u000b]:feR\u001cv.\u001e:dK\"\u001a1%!\u0019\u0002MQ,7\u000f^#wK:$H+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\,ji\"lU\u000f\u001c;j\u0017\u0016L8\u000fK\u0002%\u0003C\na\u0006^3ti\u00163XM\u001c;US6,G+Z7q_J\fGNS8j]^KG\u000f\u001b(p]\u0016\u000bX/\u00197D_:$\u0017\u000e^5p]\"\u001aQ%!\u0019\u0002YQ,7\u000f^#wK:$H+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\#rk\u0006d7i\u001c8eSRLwN\\(o\u0017\u0016L\bf\u0001\u0014\u0002b\u0005qB/Z:u\u000bZ,g\u000e\u001e+j[\u0016lU\u000f\u001c;j)\u0016l\u0007o\u001c:bY*{\u0017N\u001c\u0015\u0004O\u0005\u0005\u0014!\r;fgR,e/\u001a8u)&lW\rV3na>\u0014\u0018\r\u001c&pS:<\u0016\u000e\u001e5EK\u0012,\b\u000f\\5dCR,g)\u001b:tiZKWm\u001e\u0015\u0004Q\u0005\u0005\u0014\u0001\r;fgR,e/\u001a8u)&lW\rV3na>\u0014\u0018\r\u001c&pS:<\u0016\u000e\u001e5EK\u0012,\b\u000f\\5dCR,G*Y:u-&,w\u000fK\u0002*\u0003C\nQ\u0005^3ti\u00163XM\u001c;US6,G*\u001a4u)\u0016l\u0007o\u001c:bY*{\u0017N\\,ji\"4\u0016.Z<)\u0007)\n\t'\u0001\u0014uKN$X*\u001b8j\u0005\u0006$8\r[#wK:$H+[7f-&,w\u000fV3na>\u0014\u0018\r\u001c&pS:D3aKA1\u0003=\u0019'/Z1uKNKgn\u001b+bE2,GCBA&\u0003\u007f\u000b\u0019\u000eC\u0004\u0002B2\u0002\r!a1\u0002\u0013Q\f'\r\\3OC6,\u0007\u0003BAc\u0003\u001btA!a2\u0002JB\u0019\u0011+!\u0006\n\t\u0005-\u0017QC\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0017\u0011\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005-\u0017Q\u0003\u0005\b\u0003+d\u0003\u0019AAl\u0003\u001d\u0019w\u000e\\;n]N\u0004b!!\u0014\u0002Z\u0006\r\u0017\u0002BAn\u0003+\u0011aa\u00149uS>t\u0017\u0001D2iC:<W\r\\8h%><HCBA\u000f\u0003C\f)\u000fC\u0004\u0002d6\u0002\r!a1\u0002\t-Lg\u000e\u001a\u0005\b\u0003Ol\u0003\u0019AAu\u0003\u00191\u0018\r\\;fgB1\u0011QJAv\u0003_LA!!<\u0002\u0016\tQAH]3qK\u0006$X\r\u001a \u0011\t\u00055\u0013\u0011_\u0005\u0005\u0003g\f)BA\u0002B]fDs\u0001AA|\u0003{\fy\u0010E\u0002x\u0003sL1!a?y\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0005\u0003\u0019#Aa\u0001\u0011\t\t\u0015!1C\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TAA!\u0004\u0003\u0010\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007}\u0014\tB\u0003\u0002ks%!!Q\u0003B\u0004\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0001")
public class TemporalJoinITCase
extends StreamingWithStateTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    private final List<Row> procTimeOrderData = new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "Euro", "no1", BoxesRunTime.boxToLong((long)12L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "US Dollar", "no1", BoxesRunTime.boxToLong((long)14L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "US Dollar", "no2", BoxesRunTime.boxToLong((long)18L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), "RMB", "no1", BoxesRunTime.boxToLong((long)40L)})), (List)Nil$.MODULE$))));
    private final List<Row> procTimeCurrencyData = new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Yen", "no1", BoxesRunTime.boxToLong((long)1L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)118L)})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no2", BoxesRunTime.boxToLong((long)106L)})), (List)Nil$.MODULE$))))));
    private final List<Row> procTimeCurrencyChangelogData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L)})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L)})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Yen", "no1", BoxesRunTime.boxToLong((long)1L)})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L)})), this.changelogRow("-U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L)})), this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)802L)})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)118L)})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no2", BoxesRunTime.boxToLong((long)106L)}))}));
    private final List<Row> rowTimeOrderData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "Euro", "no1", BoxesRunTime.boxToLong((long)12L), "2020-08-15T00:01:00"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "US Dollar", "no1", BoxesRunTime.boxToLong((long)1L), "2020-08-15T00:02:00"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "RMB", "no1", BoxesRunTime.boxToLong((long)40L), "2020-08-15T00:03:00"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), "Euro", "no1", BoxesRunTime.boxToLong((long)14L), "2020-08-16T00:04:00"})), this.changelogRow("-U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "US Dollar", "no1", BoxesRunTime.boxToLong((long)1L), "2020-08-16T00:03:00"})), this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "US Dollar", "no1", BoxesRunTime.boxToLong((long)18L), "2020-08-16T00:03:00"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), "RMB", "no1", BoxesRunTime.boxToLong((long)40L), "2020-08-16T00:03:00"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), "RMB", "no1", BoxesRunTime.boxToLong((long)40L), "2020-08-16T00:04:00"})), this.changelogRow("-D", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), "RMB", "no1", BoxesRunTime.boxToLong((long)40L), "2020-08-16T00:04:00"}))}));
    private final List<Row> rowTimeCurrencyDataUsingMetaTime = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L), "2020-08-15T00:00:01"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-15T00:00:02"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Yen", "no1", BoxesRunTime.boxToLong((long)1L), "2020-08-15T00:00:03"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-15T00:00:04"})), this.changelogRow("-U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L), "2020-08-16T00:01:00"})), this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)118L), "2020-08-16T00:01:00"})), this.changelogRow("-U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-16T00:02:00"})), this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)106L), "2020-08-16T00:02:00"})), this.changelogRow("-D", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-16T00:02:00"}))}));
    private final List<Row> rowTimeCurrencyDataUsingBeforeTime = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L), "2020-08-15T00:00:01"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-15T00:00:02"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Yen", "no1", BoxesRunTime.boxToLong((long)1L), "2020-08-15T00:00:03"})), this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-15T00:00:04"})), this.changelogRow("-U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L), "2020-08-15T00:00:01"})), this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)118L), "2020-08-16T00:01:00"})), this.changelogRow("-U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-15T00:00:02"})), this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)106L), "2020-08-16T00:02:00"})), this.changelogRow("-D", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-15T00:00:04"}))}));
    private final List<Row> upsertSourceCurrencyData = new .colon.colon((Object)this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L), "2020-08-15T00:00:01"})), (List)new .colon.colon((Object)this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-15T00:00:02"})), (List)new .colon.colon((Object)this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Yen", "no1", BoxesRunTime.boxToLong((long)1L), "2020-08-15T00:00:03"})), (List)new .colon.colon((Object)this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-15T00:00:04"})), (List)new .colon.colon((Object)this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)118L), "2020-08-16T00:01:00"})), (List)new .colon.colon((Object)this.changelogRow("+U", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)104L), "2020-08-16T00:02:00"})), (List)new .colon.colon((Object)this.changelogRow("-D", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-15T00:00:04"})), (List)Nil$.MODULE$)))))));
    private final List<Row> rowTimeInsertOnlyCurrencyData = new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)114L), "2020-08-15T00:00:01"})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-15T00:00:02"})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Yen", "no1", BoxesRunTime.boxToLong((long)1L), "2020-08-15T00:00:03"})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"RMB", "no1", BoxesRunTime.boxToLong((long)702L), "2020-08-15T00:00:04"})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Euro", "no1", BoxesRunTime.boxToLong((long)118L), "2020-08-16T00:01:00"})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)102L), "2020-08-16T00:02:00"})), (List)new .colon.colon((Object)this.changelogRow("+I", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US Dollar", "no1", BoxesRunTime.boxToLong((long)106L), "2020-08-16T00:02:00"})), (List)Nil$.MODULE$)))))));

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    public List<Row> procTimeOrderData() {
        return this.procTimeOrderData;
    }

    public List<Row> procTimeCurrencyData() {
        return this.procTimeCurrencyData;
    }

    public List<Row> procTimeCurrencyChangelogData() {
        return this.procTimeCurrencyChangelogData;
    }

    public List<Row> rowTimeOrderData() {
        return this.rowTimeOrderData;
    }

    public List<Row> rowTimeCurrencyDataUsingMetaTime() {
        return this.rowTimeCurrencyDataUsingMetaTime;
    }

    public List<Row> rowTimeCurrencyDataUsingBeforeTime() {
        return this.rowTimeCurrencyDataUsingBeforeTime;
    }

    public List<Row> upsertSourceCurrencyData() {
        return this.upsertSourceCurrencyData;
    }

    public List<Row> rowTimeInsertOnlyCurrencyData() {
        return this.rowTimeInsertOnlyCurrencyData;
    }

    @BeforeEach
    public void prepare() {
        String procTimeOrderDataId = TestValuesTableFactory.registerData(this.procTimeOrderData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(499).append("\n                       |CREATE TABLE orders_proctime (\n                       |  order_id BIGINT,\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  amount BIGINT,\n                       |  proctime as PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'false',\n                       |  'data-id' = '").append(procTimeOrderDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String procTimeCurrencyDataId = TestValuesTableFactory.registerData(this.procTimeCurrencyData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(584).append("\n                       |CREATE TABLE currency_proctime (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate BIGINT,\n                       |  proctime as PROCTIME(),\n                       |  PRIMARY KEY(currency, currency_no) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'false',\n                       |  'disable-lookup' = 'true',\n                       |  'data-id' = '").append(procTimeCurrencyDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String procTimeCurrencyChangelogDataId = TestValuesTableFactory.registerData(this.procTimeCurrencyChangelogData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(652).append("\n                       |CREATE TABLE changelog_currency_proctime (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate BIGINT,\n                       |  proctime as PROCTIME(),\n                       |  PRIMARY KEY(currency, currency_no) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'false',\n                       |  'disable-lookup' = 'true',\n                       |  'changelog-mode' = 'I,UA,UB,D',\n                       |  'data-id' = '").append(procTimeCurrencyChangelogDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                       |CREATE VIEW latest_rates AS\n                       |SELECT\n                       |  currency,\n                       |  currency_no,\n                       |  rate,\n                       |  proctime FROM\n                       |      ( SELECT *, ROW_NUMBER() OVER (PARTITION BY currency, currency_no\n                       |        ORDER BY proctime DESC) AS rowNum\n                       |        FROM currency_proctime) T\n                       | WHERE rowNum = 1")).stripMargin());
        this.createSinkTable("proctime_default_sink", (Option<String>)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("\n              |  order_id BIGINT,\n              |  currency STRING,\n              |  amount BIGINT,\n              |  l_time TIMESTAMP_LTZ(3),\n              |  rate BIGINT,\n              |  r_time TIMESTAMP_LTZ(3),\n              |  PRIMARY KEY(order_id) NOT ENFORCED\n              |")).stripMargin()));
        String rowTimeOrderDataId = TestValuesTableFactory.registerData(this.rowTimeOrderData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(639).append("\n                       |CREATE TABLE orders_rowtime (\n                       |  order_id BIGINT,\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  amount BIGINT,\n                       |  order_time TIMESTAMP(3),\n                       |  WATERMARK FOR order_time AS order_time,\n                       |  PRIMARY KEY (order_id) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'I,UA,UB,D',\n                       |  'data-id' = '").append(rowTimeOrderDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String rowTimeCurrencyDataId = TestValuesTableFactory.registerData(this.rowTimeCurrencyDataUsingMetaTime());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(646).append("\n                       |CREATE TABLE versioned_currency_with_single_key (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '10' SECOND,\n                       |  PRIMARY KEY(currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'I,UA,UB,D',\n                       |  'data-id' = '").append(rowTimeCurrencyDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(658).append("\n                       |CREATE TABLE versioned_currency_with_multi_key (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '10' SECOND,\n                       |  PRIMARY KEY(currency, currency_no) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'I,UA,UB,D',\n                       |  'data-id' = '").append(rowTimeCurrencyDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String currencyDataUsingBeforeTimeId = TestValuesTableFactory.registerData(this.rowTimeCurrencyDataUsingBeforeTime());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(641).append("\n                       |CREATE TABLE currency_using_update_before_time (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '2' DAY,\n                       |  PRIMARY KEY(currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'I,UA,UB,D',\n                       |  'data-id' = '").append(currencyDataUsingBeforeTimeId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String upsertSourceDataId = TestValuesTableFactory.registerData(this.upsertSourceCurrencyData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(618).append("\n                       |CREATE TABLE upsert_currency (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '2' DAY,\n                       |  PRIMARY KEY(currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'data-id' = '").append(upsertSourceDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        this.createSinkTable("rowtime_default_sink", (Option<String>)None$.MODULE$);
        String rowTimeInsertOnlyCurrencyDataId = TestValuesTableFactory.registerData(this.rowTimeInsertOnlyCurrencyData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(538).append("\n                       |CREATE TABLE currency_history (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '0.001' SECOND\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(rowTimeInsertOnlyCurrencyDataId).append("',\n                       |  'changelog-mode' = 'I')\n                       |  ").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE VIEW currency_deduplicated_first_row AS\n         |SELECT\n         |  currency,\n         |  currency_no,\n         |  rate,\n         |  currency_time FROM\n         |      (SELECT *, ROW_NUMBER() OVER (PARTITION BY currency ORDER BY currency_time)\n         |       AS rowNum FROM currency_history) T\n         | WHERE rowNum = 1")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE VIEW currency_deduplicated_last_row AS\n         |SELECT\n         |  currency,\n         |  currency_no,\n         |  rate,\n         |  currency_time FROM\n         |      (SELECT *, ROW_NUMBER() OVER (PARTITION BY currency ORDER BY currency_time DESC)\n         |       AS rowNum FROM currency_history) T\n         | WHERE rowNum = 1")).stripMargin());
    }

    @TestTemplate
    public void testProcTimeTemporalJoin() {
        String sql = "INSERT INTO proctime_default_sink  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r.proctime  FROM orders_proctime AS o  JOIN currency_proctime FOR SYSTEM_TIME AS OF o.proctime as r  ON o.currency = r.currency and o.currency_no = r.currency_no";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeLeftTemporalJoin() {
        String sql = "INSERT INTO proctime_default_sink  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r.proctime  FROM orders_proctime AS o  LEFT JOIN currency_proctime FOR SYSTEM_TIME AS OF o.proctime as r  ON o.currency = r.currency and o.currency_no = r.currency_no";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeTemporalJoinChangelogSource() {
        this.createSinkTable("proctime_sink1", (Option<String>)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("\n              | currency STRING,\n              | currency_no STRING,\n              | rate BIGINT,\n              | proctime TIMESTAMP_LTZ(3)\n              | ")).stripMargin()));
        String sql = "INSERT INTO proctime_sink1  SELECT r.* FROM orders_proctime AS o  JOIN changelog_currency_proctime FOR SYSTEM_TIME AS OF o.proctime as r  ON o.currency = r.currency and o.currency_no = r.currency_no";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeTemporalJoinWithView() {
        String sql = "INSERT INTO proctime_default_sink  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r.proctime  FROM orders_proctime AS o  JOIN latest_rates FOR SYSTEM_TIME AS OF o.proctime as r  ON o.currency = r.currency and o.currency_no = r.currency_no";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeLeftTemporalJoinWithView() {
        String sql = "INSERT INTO proctime_default_sink  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r.proctime  FROM orders_proctime AS o  LEFT JOIN latest_rates FOR SYSTEM_TIME AS OF o.proctime as r  ON o.currency = r.currency and o.currency_no = r.currency_no";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeTemporalJoinWithViewNonEqui() {
        String sql = "INSERT INTO proctime_default_sink  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r.proctime  FROM orders_proctime AS o  JOIN latest_rates FOR SYSTEM_TIME AS OF o.proctime AS r  ON o.currency = r.currency and o.currency_no = r.currency_no  AND o.amount > r.rate";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeLeftTemporalJoinWithViewWithPredicates() {
        String sql = "INSERT INTO proctime_default_sink  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r.proctime  FROM orders_proctime AS o  LEFT JOIN latest_rates FOR SYSTEM_TIME AS OF o.proctime AS r  ON o.currency = r.currency and o.currency_no = r.currency_no AND o.amount > r.rate";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testProcTimeMultiTemporalJoin() {
        this.createSinkTable("proctime_sink2", (Option<String>)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("\n              |  order_id BIGINT,\n              |  currency STRING,\n              |  amount BIGINT,\n              |  l_time TIMESTAMP_LTZ(3),\n              |  rate BIGINT,\n              |  r_time TIMESTAMP_LTZ(3),\n              |  PRIMARY KEY(order_id) NOT ENFORCED\n              |")).stripMargin()));
        String sql = "INSERT INTO proctime_sink2  SELECT o.order_id, o.currency, o.amount, o.proctime, r.rate, r1.proctime  FROM orders_proctime AS o  JOIN latest_rates FOR SYSTEM_TIME AS OF o.proctime as r  ON o.currency = r.currency and o.currency_no = r.currency_no  JOIN currency_proctime FOR SYSTEM_TIME AS OF o.proctime as r1 ON o.currency = r1.currency and o.currency_no = r1.currency_no";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql).await()).hasMessage("Processing-time temporal join is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testEventTimeTemporalJoin() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o JOIN versioned_currency_with_single_key  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinThatJoinkeyContainsPk() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o JOIN versioned_currency_with_single_key  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency AND o.currency_no = r.currency_no";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinWithFilter() {
        this.tEnv().executeSql("CREATE VIEW v1 AS SELECT * FROM versioned_currency_with_single_key");
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o  JOIN v1 FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency WHERE rate < 115";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeLeftTemporalJoin() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o LEFT JOIN versioned_currency_with_single_key  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinChangelogUsingBeforeTime() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o LEFT JOIN currency_using_update_before_time  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,null,null", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeLeftTemporalJoinUpsertSource() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o LEFT JOIN upsert_currency  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency ";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,104,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,null,null", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinWithMultiKeys() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o JOIN versioned_currency_with_multi_key  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency_no = r.currency_no AND o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinWithNonEqualCondition() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o JOIN currency_using_update_before_time  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency and o.currency_no = r.currency_no  and o.order_id < 5 and r.rate > 102";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinEqualConditionOnKey() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o JOIN currency_using_update_before_time  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency and o.currency_no = r.currency_no  and o.currency = 'Euro' and r.rate > 102";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeMultiTemporalJoin() {
        this.createSinkTable("rowtime_sink1", (Option<String>)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |  order_id BIGINT,\n           |  currency STRING,\n           |  amount BIGINT,\n           |  l_time TIMESTAMP(3),\n           |  rate BIGINT,\n           |  r_time TIMESTAMP(3),\n           |  r1_rate BIGINT,\n           |  r1_time TIMESTAMP(3),\n           |  PRIMARY KEY(order_id) NOT ENFORCED\n           |")).stripMargin()));
        String sql = "INSERT INTO rowtime_sink1  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time, r1.rate, r1.currency_time FROM orders_rowtime AS o  LEFT JOIN versioned_currency_with_multi_key  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency and o.currency_no = r.currency_no  LEFT JOIN versioned_currency_with_single_key  FOR SYSTEM_TIME AS OF o.order_time as r1  ON o.currency = r1.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01,118,2020-08-16T00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,null,null,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_sink1")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinWithDeduplicateFirstView() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o  LEFT JOIN currency_deduplicated_first_row  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,102,2020-08-15T00:00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,702,2020-08-15T00:00:04", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTemporalJoinWithDeduplicateLastView() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o  JOIN currency_deduplicated_last_row  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,702,2020-08-15T00:00:04", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeLeftTemporalJoinWithView() {
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o  LEFT JOIN currency_deduplicated_last_row  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency AND substr(o.currency, 1, 2) = 'US' ";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,null,null", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,null,null", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,null,null", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMiniBatchEventTimeViewTemporalJoin() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY.key(), "10 s");
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)4L));
        String sql = "INSERT INTO rowtime_default_sink  SELECT o.order_id, o.currency, o.amount, o.order_time, r.rate, r.currency_time  FROM orders_rowtime AS o JOIN  currency_deduplicated_last_row  FOR SYSTEM_TIME AS OF o.order_time as r  ON o.currency = r.currency";
        this.tEnv().executeSql(sql).await();
        .colon.colon expected = new .colon.colon((Object)"1,Euro,12,2020-08-15T00:01,114,2020-08-15T00:00:01", (List)new .colon.colon((Object)"2,US Dollar,18,2020-08-16T00:03,106,2020-08-16T00:02", (List)new .colon.colon((Object)"3,RMB,40,2020-08-15T00:03,702,2020-08-15T00:00:04", (List)new .colon.colon((Object)"4,Euro,14,2020-08-16T00:04,118,2020-08-16T00:01", (List)new .colon.colon((Object)"5,RMB,40,2020-08-16T00:03,702,2020-08-15T00:00:04", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("rowtime_default_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void createSinkTable(String tableName, Option<String> columns) {
        String string;
        Option<String> option = columns;
        if (option instanceof Some) {
            String cols;
            Some some = (Some)option;
            string = cols = (String)some.value();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString("\n           |  order_id BIGINT,\n           |  currency STRING,\n           |  amount BIGINT,\n           |  l_time TIMESTAMP(3),\n           |  rate BIGINT,\n           |  r_time TIMESTAMP(3),\n           |  PRIMARY KEY(order_id) NOT ENFORCED\n           |")).stripMargin();
        }
        String columnsDDL = string;
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(313).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       | ").append(columnsDDL).append("\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'sink-insert-only' = 'false',\n                       |  'changelog-mode' = 'I,UA,UB,D'\n                       |)\n                       |").toString())).stripMargin());
    }

    private Row changelogRow(String kind, Seq<Object> values) {
        Seq objects = (Seq)values.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return BoxesRunTime.boxToLong((long)l);
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return BoxesRunTime.boxToInteger((int)n);
            }
            if (object instanceof String) {
                Object object2;
                String string = (String)object;
                try {
                    object2 = LocalDateTime.parse(string);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    object2 = string;
                }
                return object2;
            }
            if (object instanceof Object) {
                Object object3 = object;
                return object3;
            }
            throw new MatchError(object);
        }, Seq$.MODULE$.canBuildFrom());
        return TestValuesTableFactory.changelogRow(kind, (Object[])objects.toArray(ClassTag$.MODULE$.Object()));
    }

    public TemporalJoinITCase(StreamingWithStateTestBase.StateBackendMode state) {
        super(state);
    }
}

