/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.TableScanITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TimeTestUtil;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001q2AAB\u0004\u00011!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)a\u0007\u0001C\u0001I!)\u0001\b\u0001C\u0001I!)!\b\u0001C\u0001I\tyA+\u00192mKN\u001b\u0017M\\%U\u0007\u0006\u001cXM\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011AB:ue\u0016\fWN\u0003\u0002\r\u001b\u00059!/\u001e8uS6,'B\u0001\b\u0010\u0003\u001d\u0001H.\u00198oKJT!\u0001E\t\u0002\u000bQ\f'\r\\3\u000b\u0005I\u0019\u0012!\u00024mS:\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\u0011AdC\u0001\u0006kRLGn]\u0005\u0003=m\u0011\u0011c\u0015;sK\u0006l\u0017N\\4UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\tq!A\u0012uKN$H+\u00192mKN{WO]2f/&$\bn\\;u)&lW-\u0011;ue&\u0014W\u000f^3\u0015\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012A!\u00168ji\"\u0012!\u0001\f\t\u0003[Qj\u0011A\f\u0006\u0003_A\n1!\u00199j\u0015\t\t$'A\u0004kkBLG/\u001a:\u000b\u0005M*\u0012!\u00026v]&$\u0018BA\u001b/\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e)s_\u000e$\u0018.\\3UC\ndWmU8ve\u000e,\u0007FA\u0002-\u0003Y!Xm\u001d;S_^$\u0018.\\3UC\ndWmU8ve\u000e,\u0007F\u0001\u0003-\u0003!\"Xm\u001d;S_^$\u0018.\\3UC\ndWmU8ve\u000e,\u0007K]3tKJ4XmV1uKJl\u0017M]6tQ\t)A\u0006")
public class TableScanITCase
extends StreamingTestBase {
    @Test
    public void testTableSourceWithoutTimeAttribute() {
        String tableName = "MyTable";
        TestTableSourceSinks$.MODULE$.createWithoutTimeAttributesTableSource((TableEnvironment)this.tEnv(), tableName);
        String sqlQuery = new StringBuilder(14).append("SELECT * from ").append(tableName).toString();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Mary,1,1", (List)new .colon.colon((Object)"Bob,2,3", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProctimeTableSource() {
        String tableName = "MyTable";
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Peter"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz"})), (List)Nil$.MODULE$))))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n                       |create table ").append(tableName).append(" (\n                       |  name string,\n                       |  ptime as proctime()\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sqlQuery = new StringBuilder(17).append("SELECT name FROM ").append(tableName).toString();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Mary", (List)new .colon.colon((Object)"Peter", (List)new .colon.colon((Object)"Bob", (List)new .colon.colon((Object)"Liz", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeTableSource() {
        String tableName = "MyTable";
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), DateTimeUtils.toLocalDateTime((long)11L), "Mary"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), DateTimeUtils.toLocalDateTime((long)12L), "Peter"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), DateTimeUtils.toLocalDateTime((long)13L), "Bob"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), DateTimeUtils.toLocalDateTime((long)14L), "Liz"})), (List)Nil$.MODULE$))))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(445).append("\n                       |create table ").append(tableName).append(" (\n                       |  key int,\n                       |  rowtime timestamp(3),\n                       |  payload string,\n                       |  watermark for rowtime as rowtime\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n         |SELECT\n         |  CAST(TUMBLE_START(rowtime, INTERVAL '0.005' SECOND) AS VARCHAR),\n         |  COUNT(payload)\n         |FROM ").append(tableName).append("\n         |GROUP BY TUMBLE(rowtime, INTERVAL '0.005' SECOND)\n       ").toString())).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01 00:00:00.010,4", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeTableSourcePreserveWatermarks() {
        String tableName = "MyTable";
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)1L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"A"))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"B"))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)10L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)8L), (Object)"C"))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)20L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)21L), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)21L), (Object)"D"))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)30L))}));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)this.env().addSource(new TimeTestUtil.EventTimeSourceFunction(data)).returns((TypeInformation)Predef$.MODULE$.implicitly((Object)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.TableScanITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).setMaxParallelism(1).setMaxParallelism(1)).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")).rowtime(), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}));
        this.tEnv().createTemporaryView(tableName, t);
        String sqlQuery = new StringBuilder(21).append("SELECT id, name FROM ").append(tableName).toString();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream().process((ProcessFunction)new ProcessFunction<Row, Row>(null){

            public void processElement(Row value, ProcessFunction.Context ctx, Collector<Row> out) {
                Row res = new Row(3);
                res.setField(0, value.getField(0));
                res.setField(1, value.getField(1));
                res.setField(2, (Object)BoxesRunTime.boxToLong((long)ctx.timerService().currentWatermark()));
                out.collect((Object)res);
            }
        }).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,A,1", (List)new .colon.colon((Object)"2,B,1", (List)new .colon.colon((Object)"6,C,10", (List)new .colon.colon((Object)"6,D,20", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

