/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collections;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.JavaPojos;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.StringSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001}2Aa\u0002\u0005\u00013!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C\u0001K!)q\u0007\u0001C\u0001K!)\u0011\b\u0001C\u0001K!)1\b\u0001C\u0001K!)Q\b\u0001C\u0001K\ta2\u000b\u001e:fC6$\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/\u0013+DCN,'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\taa\u001d;sK\u0006l'BA\u0007\u000f\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0004\t\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011CE\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003'Q\tQA\u001a7j].T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\tiB\"A\u0003vi&d7/\u0003\u0002 9\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005A\u0011A\b;fgR$v.\u00119qK:$7\u000b\u001e:fC6<\u0016\u000e\u001e5Q_*|G+\u001f9f)\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRD#AA\u0017\u0011\u00059*T\"A\u0018\u000b\u0005A\n\u0014aA1qS*\u0011!gM\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!d#A\u0003kk:LG/\u0003\u00027_\t!A+Z:u\u0003u!Xm\u001d;U_\u0006\u0003\b/\u001a8e'R\u0014X-Y7XSRD'+Y<UsB,\u0007FA\u0002.\u0003}!Xm\u001d;U_J+GO]1diN#(/Z1n/&$\b\u000eU8k_RK\b/\u001a\u0015\u0003\t5\n!\u0004^3tiJ+GO]1di6\u001bxmV5uQB{'n\u001c+za\u0016D#!B\u0017\u0002UQ,7\u000f\u001e+bE2,7i\u001c8gS\u001eLe\u000e[3sSR\u001cXI\u001c<je>tW.\u001a8u'\u0016$H/\u001b8hg\"\u0012a!\f")
public class StreamTableEnvironmentITCase
extends StreamingTestBase {
    @Test
    public void testToAppendStreamWithPojoType() {
        Schema schema = Schema.newBuilder().column("user", (AbstractDataType)DataTypes.BIGINT()).column("product", (AbstractDataType)DataTypes.STRUCTURED(JavaPojos.ProductItem.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).column("amount", (AbstractDataType)DataTypes.INT()).build();
        DataStreamSource orderA = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 3), (List)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("diaper", Predef$.MODULE$.long2Long(11L)), 4), (List)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(3L), new JavaPojos.ProductItem("rubber", Predef$.MODULE$.long2Long(12L)), 2), (List)Nil$.MODULE$))), TypeExtractor.createTypeInfo(JavaPojos.Order.class));
        DataStreamSource orderB = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(2L), new JavaPojos.ProductItem("pen", Predef$.MODULE$.long2Long(13L)), 3), (List)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(2L), new JavaPojos.ProductItem("rubber", Predef$.MODULE$.long2Long(12L)), 3), (List)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(4L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 1), (List)Nil$.MODULE$))), TypeExtractor.createTypeInfo(JavaPojos.Order.class));
        Table tableA = this.tEnv().fromDataStream(orderA, schema);
        this.tEnv().createTemporaryView("OrderB", orderB, schema);
        Table result = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n                                  |SELECT * FROM ").append(tableA).append(" WHERE amount > 2\n                                  |UNION ALL\n                                  |SELECT * FROM OrderB WHERE amount < 2\n        ").toString())).stripMargin());
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(result).toDataStream((AbstractDataType)DataTypes.STRUCTURED(JavaPojos.Order.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"user", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"product", (DataType)DataTypes.STRUCTURED(JavaPojos.ProductItem.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})), DataTypes.FIELD((String)"amount", (DataType)DataTypes.INT())})).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Order{user=1, product='Product{name='beer', id=10}', amount=3}", (List)new .colon.colon((Object)"Order{user=1, product='Product{name='diaper', id=11}', amount=4}", (List)new .colon.colon((Object)"Order{user=4, product='Product{name='beer', id=10}', amount=1}", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToAppendStreamWithRawType() {
        DataStreamSource devices = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)new .colon.colon((Object)new JavaPojos.Device(Predef$.MODULE$.long2Long(1L), "device1", Collections.singletonMap("A", Predef$.MODULE$.long2Long(10L))), (List)new .colon.colon((Object)new JavaPojos.Device(Predef$.MODULE$.long2Long(2L), "device2", Collections.emptyMap()), (List)new .colon.colon((Object)new JavaPojos.Device(Predef$.MODULE$.long2Long(3L), "device3", Collections.singletonMap("B", Predef$.MODULE$.long2Long(20L))), (List)Nil$.MODULE$))), TypeExtractor.createTypeInfo(JavaPojos.Device.class));
        this.tEnv().createTemporaryView("devices", devices, Schema.newBuilder().column("deviceId", (AbstractDataType)DataTypes.BIGINT()).column("deviceName", (AbstractDataType)DataTypes.STRING()).column("metrics", (AbstractDataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT())).build());
        Table result = this.tEnv().sqlQuery("SELECT * FROM devices WHERE deviceId >= 2");
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(result).toDataStream((AbstractDataType)DataTypes.STRUCTURED(JavaPojos.Device.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"deviceId", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"deviceName", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"metrics", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT()))})).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Device{deviceId=2, deviceName='device2', metrics={}}", (List)new .colon.colon((Object)"Device{deviceId=3, deviceName='device3', metrics={B=20}}", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToRetractStreamWithPojoType() {
        DataStreamSource persons = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)new .colon.colon((Object)new JavaPojos.Person("bob", 1), (List)new .colon.colon((Object)new JavaPojos.Person("Liz", 2), (List)new .colon.colon((Object)new JavaPojos.Person("Jack", 3), (List)Nil$.MODULE$))), TypeExtractor.createTypeInfo(JavaPojos.Person.class));
        this.tEnv().createTemporaryView("person", persons);
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select name, age from person")).toRetractStream(TypeExtractor.createTypeInfo(JavaPojos.Person.class)).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"(true,Person{name='bob', age=1})", (List)new .colon.colon((Object)"(true,Person{name='Liz', age=2})", (List)new .colon.colon((Object)"(true,Person{name='Jack', age=3})", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRetractMsgWithPojoType() {
        DataStreamSource orders = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 1), (List)new .colon.colon((Object)new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 2), (List)Nil$.MODULE$)), TypeExtractor.createTypeInfo(JavaPojos.Order.class));
        Table table = this.tEnv().fromDataStream(orders, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "user")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "product")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}));
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("|SELECT user, product, sum(amount) as amount\n                    |FROM ").append(table).append("\n                    |GROUP BY user, product\n                    |").toString())).stripMargin())).toRetractStream(TypeExtractor.createTypeInfo(JavaPojos.Order.class)).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"(true,Order{user=1, product='Product{name='beer', id=10}', amount=1})", (List)new .colon.colon((Object)"(false,Order{user=1, product='Product{name='beer', id=10}', amount=1})", (List)new .colon.colon((Object)"(true,Order{user=1, product='Product{name='beer', id=10}', amount=3})", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableConfigInheritsEnvironmentSettings() {
        Configuration config = new Configuration();
        config.set(TableConfigOptions.TABLE_CATALOG_NAME, (Object)"myCatalog");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)config);
        org.apache.flink.table.api.bridge.java.StreamTableEnvironment tEnv = org.apache.flink.table.api.bridge.java.StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        Assertions.assertThat((String)((String)tEnv.getConfig().get(TableConfigOptions.TABLE_CATALOG_NAME))).isEqualTo("myCatalog");
        StreamExecutionEnvironment env2 = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment scalaTEnv = StreamTableEnvironment$.MODULE$.create(env2, EnvironmentSettings.newInstance().withConfiguration(config).build());
        Assertions.assertThat((String)((String)scalaTEnv.getConfig().get(TableConfigOptions.TABLE_CATALOG_NAME))).isEqualTo("myCatalog");
    }
}

