/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.planner.factories.TestProcedureCatalogFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ProcedureITCase
extends StreamingTestBase {
    ProcedureITCase() {
    }

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        TestProcedureCatalogFactory.CatalogWithBuiltInProcedure procedureCatalog = new TestProcedureCatalogFactory.CatalogWithBuiltInProcedure("procedure_catalog");
        procedureCatalog.createDatabase("system", (CatalogDatabase)new CatalogDatabaseImpl(Collections.emptyMap(), null), true);
        this.tEnv().registerCatalog("test_p", (Catalog)procedureCatalog);
        this.tEnv().useCatalog("test_p");
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"argsForShowProcedures"})
    void testShowProcedures(String sql, String expected) {
        List rows = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql(sql).collect());
        if (expected.isEmpty()) {
            Assertions.assertThat((List)rows).isEmpty();
        } else {
            Assertions.assertThat((String)rows.toString()).isEqualTo(expected);
        }
    }

    private static Stream<Arguments> argsForShowProcedures() {
        return Stream.of(Arguments.of((Object[])new Object[]{"show procedures", ""}), Arguments.of((Object[])new Object[]{"show procedures in `system`", "[+I[generate_n], +I[generate_user], +I[get_env_conf], +I[get_year], +I[named_args], +I[named_args_optional], +I[named_args_overload], +I[sum_n]]"}), Arguments.of((Object[])new Object[]{"show procedures in `system` like 'generate%'", "[+I[generate_n], +I[generate_user]]"}), Arguments.of((Object[])new Object[]{"show procedures in `system` like 'gEnerate%'", ""}), Arguments.of((Object[])new Object[]{"show procedures in `system` ilike 'gEnerate%'", "[+I[generate_n], +I[generate_user]]"}), Arguments.of((Object[])new Object[]{"show procedures in `system` not like 'generate%'", "[+I[get_env_conf], +I[get_year], +I[named_args], +I[named_args_optional], +I[named_args_overload], +I[sum_n]]"}), Arguments.of((Object[])new Object[]{"show procedures in `system` not ilike 'generaTe%'", "[+I[get_env_conf], +I[get_year], +I[named_args], +I[named_args_optional], +I[named_args_overload], +I[sum_n]]"}));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"argsForShowProceduresForFailedCases"})
    void testShowProceduresForFailedCase(String sql, Class<?> expectedExceptionClass, String expectedErrorMsg) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(sql)).isInstanceOf(expectedExceptionClass)).hasMessage(expectedErrorMsg);
    }

    private static Stream<Arguments> argsForShowProceduresForFailedCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"show procedures in `db1`", TableException.class, "Fail to show procedures because the Database `db1` to show from/in does not exist in Catalog `test_p`."}), Arguments.of((Object[])new Object[]{"show procedures in default_catalog.default_catalog", UnsupportedOperationException.class, "listProcedures is not implemented for class org.apache.flink.table.catalog.GenericInMemoryCatalog."}));
    }

    @Test
    void testCallProcedure() {
        TableResult tableResult = this.tEnv().executeSql("call `system`.generate_n(4)");
        this.verifyTableResult(tableResult, Arrays.asList(Row.of((Object[])new Object[]{0}), Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2}), Row.of((Object[])new Object[]{3})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"result", (DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))}));
        tableResult = this.tEnv().executeSql("call `system`.generate_n(4, 'BATCH')");
        this.verifyTableResult(tableResult, Arrays.asList(Row.of((Object[])new Object[]{0}), Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2}), Row.of((Object[])new Object[]{3})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"result", (DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))}));
        Assertions.assertThat((Comparable)((RuntimeExecutionMode)this.tEnv().getConfig().get(ExecutionOptions.RUNTIME_MODE))).isEqualTo((Object)RuntimeExecutionMode.STREAMING);
        tableResult = this.tEnv().executeSql("call `system`.sum_n(5.5, 1.2, 3.3)");
        this.verifyTableResult(tableResult, Collections.singletonList(Row.of((Object[])new Object[]{"10.00", 3})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"sum_value", (DataType)DataTypes.DECIMAL((int)10, (int)2)), Column.physical((String)"count", (DataType)DataTypes.INT())}));
        tableResult = this.tEnv().executeSql("call `system`.get_year(timestamp '2023-04-22 00:00:00', timestamp '2024-04-22 00:00:00.300')");
        this.verifyTableResult(tableResult, Arrays.asList(Row.of((Object[])new Object[]{2023}), Row.of((Object[])new Object[]{2024})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"result", (DataType)DataTypes.STRING())}));
        tableResult = this.tEnv().executeSql("call `system`.generate_user('yuxia', 18)");
        this.verifyTableResult(tableResult, Collections.singletonList(Row.of((Object[])new Object[]{"yuxia", 18})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"age", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}));
    }

    @Test
    void testNamedArguments() {
        TableResult tableResult = this.tEnv().executeSql("call `system`.named_args(d => 19, c => 'yuxia')");
        this.verifyTableResult(tableResult, Collections.singletonList(Row.of((Object[])new Object[]{"yuxia, 19"})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"result", (DataType)DataTypes.STRING())}));
    }

    @Test
    void testNamedArgumentsWithMethodOverload() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("call `system`.named_args_overload(d => 19, c => 'yuxia')")).isInstanceOf(ValidationException.class)).hasMessageContaining("Unsupported function signature. Function must not be overloaded or use varargs.");
    }

    @Test
    void testNamedArgumentsWithOptionalArguments() {
        TableResult tableResult = this.tEnv().executeSql("call `system`.named_args_optional(d => 19)");
        this.verifyTableResult(tableResult, Collections.singletonList(Row.of((Object[])new Object[]{"null, 19"})), ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"result", (DataType)DataTypes.STRING())}));
    }

    @Test
    void testEnvironmentConf() throws DatabaseAlreadyExistException {
        Configuration configuration = new Configuration();
        configuration.setString("key1", "value1");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        tableEnv.getConfig().set("key2", "value2");
        TestProcedureCatalogFactory.CatalogWithBuiltInProcedure procedureCatalog = new TestProcedureCatalogFactory.CatalogWithBuiltInProcedure("procedure_catalog");
        procedureCatalog.createDatabase("system", (CatalogDatabase)new CatalogDatabaseImpl(Collections.emptyMap(), null), true);
        tableEnv.registerCatalog("test_p", (Catalog)procedureCatalog);
        tableEnv.useCatalog("test_p");
        TableResult tableResult = tableEnv.executeSql("call `system`.get_env_conf()");
        List environmentConf = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assertions.assertThat((boolean)environmentConf.contains(Row.of((Object[])new Object[]{"key1", "value1"}))).isTrue();
        Assertions.assertThat((boolean)environmentConf.contains(Row.of((Object[])new Object[]{"key2", "value2"}))).isTrue();
        tableEnv.getConfig().set("key1", "value11");
        tableResult = tableEnv.executeSql("call `system`.get_env_conf()");
        environmentConf = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assertions.assertThat((boolean)environmentConf.contains(Row.of((Object[])new Object[]{"key1", "value11"}))).isTrue();
    }

    private void verifyTableResult(TableResult tableResult, List<Row> expectedResult, ResolvedSchema expectedSchema) {
        Assertions.assertThat((String)CollectionUtil.iteratorToList((Iterator)tableResult.collect()).toString()).isEqualTo(expectedResult.toString());
        Assertions.assertThat((Object)tableResult.getResolvedSchema()).isEqualTo((Object)expectedSchema);
    }
}

