/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.ChangelogSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u001b7\u0001\u001dC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u000b\u0003w\u0004!\u0011!Q\u0001\n\u0005u\bB\u0003B\b\u0001\t\u0005\t\u0015!\u0003\u0003\u0012!1a\u000e\u0001C\u0001\u0005?A\u0011B!\u000b\u0001\u0005\u0004%IAa\u000b\t\u0011\t\u0015\u0003\u0001)A\u0005\u0005[AqAa\u0018\u0001\t\u0003\u0012\t\u0007C\u0004\u0003t\u0001!\tA!\u0019\t\u000f\tu\u0004\u0001\"\u0001\u0003b!9!\u0011\u0011\u0001\u0005\u0002\t\u0005\u0004b\u0002BC\u0001\u0011\u0005!\u0011\r\u0005\b\u0005\u0013\u0003A\u0011\u0001B1\u0011\u001d\u0011i\t\u0001C\u0001\u0005CBqA!%\u0001\t\u0003\u0011\t\u0007C\u0004\u0003\u0016\u0002!IA!\u0019\t\u000f\t]\u0005\u0001\"\u0003\u0003b!9!\u0011\u0014\u0001\u0005\n\t\u0005\u0004b\u0002BN\u0001\u0011%!\u0011\r\u0005\b\u0005;\u0003A\u0011\u0002BP\u000f\u0015!g\u0007#\u0001f\r\u0015)d\u0007#\u0001h\u0011\u0015qW\u0003\"\u0001p\r\u0011\u0001X\u0003Q9\t\u0011a<\"Q3A\u0005\u0002eD\u0011\"!\u0002\u0018\u0005#\u0005\u000b\u0011\u0002>\t\r9<B\u0011AA\u0004\u0011\u001d\tya\u0006C!\u0003#A\u0011\"a\u0005\u0018\u0003\u0003%\t!!\u0006\t\u0013\u0005eq#%A\u0005\u0002\u0005m\u0001\"CA\u0019/\u0005\u0005I\u0011IA\u001a\u0011%\t\u0019eFA\u0001\n\u0003\t)\u0005C\u0005\u0002N]\t\t\u0011\"\u0001\u0002P!I\u00111L\f\u0002\u0002\u0013\u0005\u0013Q\f\u0005\n\u0003W:\u0012\u0011!C\u0001\u0003[B\u0011\"a\u001e\u0018\u0003\u0003%\t%!\u001f\t\u0013\u0005mt#!A\u0005B\u0005ut!CAA+\u0005\u0005\t\u0012AAB\r!\u0001X#!A\t\u0002\u0005\u0015\u0005B\u00028'\t\u0003\t\t\nC\u0005\u0002\u0010\u0019\n\t\u0011\"\u0012\u0002\u0014\"I\u0011Q\u0013\u0014\u0002\u0002\u0013\u0005\u0015q\u0013\u0005\n\u000373\u0013\u0011!CA\u0003;C\u0011\"!+'\u0003\u0003%I!a+\t\u0013\u0005MVC1A\u0005\u0002\u0005U\u0006\u0002CA\\+\u0001\u0006I!!\u0003\t\u0013\u0005eVC1A\u0005\u0002\u0005U\u0006\u0002CA^+\u0001\u0006I!!\u0003\t\u0013\u0005uVC1A\u0005\u0002\u0005U\u0006\u0002CA`+\u0001\u0006I!!\u0003\t\u0013\u0005\u0005WC1A\u0005\u0002\u0005U\u0006\u0002CAb+\u0001\u0006I!!\u0003\t\u000f\u0005\u0015W\u0003\"\u0001\u0002H\n)2\t[1oO\u0016dwnZ*pkJ\u001cW-\u0013+DCN,'BA\u001c9\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003si\naa\u001d;sK\u0006l'BA\u001e=\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0010 \u0002\u000fAd\u0017M\u001c8fe*\u0011q\bQ\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0003\n\u000bQA\u001a7j].T!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO\u000e\u00011C\u0001\u0001I!\tIE*D\u0001K\u0015\tY%(A\u0003vi&d7/\u0003\u0002N\u0015\nq2\u000b\u001e:fC6LgnZ,ji\"l\u0015N\\5CCR\u001c\u0007\u000eV3ti\n\u000b7/Z\u0001\u000bg>,(oY3N_\u0012,\u0007C\u0001)\u0018\u001d\t\tFC\u0004\u0002SG:\u00111K\u0019\b\u0003)\u0006t!!\u00161\u000f\u0005Y{fBA,_\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\\r\u00061AH]8pizJ\u0011!R\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0005}\u0002\u0015BA\u001f?\u0013\tYD(\u0003\u0002:u%\u0011q\u0007O\u0001\u0016\u0007\"\fgnZ3m_\u001e\u001cv.\u001e:dK&#6)Y:f!\t1W#D\u00017'\t)\u0002\u000e\u0005\u0002jY6\t!NC\u0001l\u0003\u0015\u00198-\u00197b\u0013\ti'N\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0014!bU8ve\u000e,Wj\u001c3f'\u00119\u0002N];\u0011\u0005%\u001c\u0018B\u0001;k\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u001b<\n\u0005]T'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B7pI\u0016,\u0012A\u001f\t\u0003w~t!\u0001`?\u0011\u0005eS\u0017B\u0001@k\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011aP[\u0001\u0006[>$W\r\t\u000b\u0005\u0003\u0013\ti\u0001E\u0002\u0002\f]i\u0011!\u0006\u0005\u0006qj\u0001\rA_\u0001\ti>\u001cFO]5oOR\t!0\u0001\u0003d_BLH\u0003BA\u0005\u0003/Aq\u0001\u001f\u000f\u0011\u0002\u0003\u0007!0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u!f\u0001>\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,)\f!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003mC:<'BAA \u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0011\u0011H\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000f\u00022![A%\u0013\r\tYE\u001b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003#\n9\u0006E\u0002j\u0003'J1!!\u0016k\u0005\r\te.\u001f\u0005\n\u00033\u0002\u0013\u0011!a\u0001\u0003\u000f\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA0!\u0019\t\t'a\u001a\u0002R5\u0011\u00111\r\u0006\u0004\u0003KR\u0017AC2pY2,7\r^5p]&!\u0011\u0011NA2\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0014Q\u000f\t\u0004S\u0006E\u0014bAA:U\n9!i\\8mK\u0006t\u0007\"CA-E\u0005\u0005\t\u0019AA)\u0003!A\u0017m\u001d5D_\u0012,GCAA$\u0003\u0019)\u0017/^1mgR!\u0011qNA@\u0011%\tI\u0006JA\u0001\u0002\u0004\t\t&\u0001\u0006T_V\u00148-Z'pI\u0016\u00042!a\u0003''\u00111\u0013qQ;\u0011\u000f\u0005%\u0015Q\u0012>\u0002\n5\u0011\u00111\u0012\u0006\u0003w)LA!a$\u0002\f\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005\rECAA\u001b\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tI!!'\t\u000baL\u0003\u0019\u0001>\u0002\u000fUt\u0017\r\u001d9msR!\u0011qTAS!\u0011I\u0017\u0011\u0015>\n\u0007\u0005\r&N\u0001\u0004PaRLwN\u001c\u0005\n\u0003OS\u0013\u0011!a\u0001\u0003\u0013\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0006\u0003BA\u001c\u0003_KA!!-\u0002:\t1qJ\u00196fGR\f\u0001c\u0011%B\u001d\u001e+EjT$`'>+&kQ#\u0016\u0005\u0005%\u0011!E\"I\u0003:;U\tT(H?N{UKU\"FA\u000513\tS!O\u000f\u0016cujR0T\u001fV\u00136)R0X\u0013RCu,\u0012,F\u001dR\u001bv\fR+Q\u0019&\u001b\u0015\tV#\u0002O\rC\u0015IT$F\u0019>;ulU(V%\u000e+ulV%U\u0011~+e+\u0012(U'~#U\u000b\u0015'J\u0007\u0006#V\tI\u0001\u000e+B\u001bVI\u0015+`'>+&kQ#\u0002\u001dU\u00036+\u0012*U?N{UKU\"FA\u0005\u0001bjT0V!\u0012\u000bE+R0T\u001fV\u00136)R\u0001\u0012\u001d>{V\u000b\u0015#B)\u0016{6kT+S\u0007\u0016\u0003\u0013A\u00039be\u0006lW\r^3sgR\u0011\u0011\u0011\u001a\t\u0007\u0003\u0017\f\t.!6\u000e\u0005\u00055'\u0002BAh\u0003{\tA!\u001e;jY&!\u00111[Ag\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006S\u0006]\u0017QV\u0005\u0004\u00033T'!B!se\u0006L\bf\u0002\u001b\u0002^\u0006U\u0018q\u001f\t\u0005\u0003?\f\t0\u0004\u0002\u0002b*!\u00111]As\u00035\u0001\u0018M]1nKR,'/\u001b>fI*!\u0011q]Au\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0005\u0003W\fi/A\u0003kk:LGOC\u0002\u0002p\u0002\u000b\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005M\u0018\u0011\u001d\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!!?\u0002WM{WO]2f{m\u0004T\u0010\f\u0011NS:L')\u0019;dQvZ\u0018' \u0017!'R\fG/\u001a\"bG.,g\u000eZ\u001f|eu\f\u0011\"\\5oS\n\u000bGo\u00195\u0011\t\u0005}(\u0011\u0002\b\u0005\u0005\u0003\u0011)AD\u0002T\u0005\u0007I!a\u0013\u001e\n\u0007\t\u001d!*\u0001\u0010TiJ,\u0017-\\5oO^KG\u000f['j]&\u0014\u0015\r^2i)\u0016\u001cHOQ1tK&!!1\u0002B\u0007\u00055i\u0015N\\5CCR\u001c\u0007.T8eK*\u0019!q\u0001&\u0002\u000bM$\u0018\r^3\u0011\t\tM!\u0011\u0004\b\u0005\u0005\u0003\u0011)\"C\u0002\u0003\u0018)\u000b!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016LAAa\u0007\u0003\u001e\t\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u0004\u0005/QE\u0003\u0003B\u0011\u0005G\u0011)Ca\n\u0011\u0005\u0019\u0004\u0001\"\u0002(\u0005\u0001\u0004y\u0005bBA~\t\u0001\u0007\u0011Q \u0005\b\u0005\u001f!\u0001\u0019\u0001B\t\u0003\u0005yVC\u0001B\u0017!\u0019\u0011yCa\u000e\u0003<5\u0011!\u0011\u0007\u0006\u0005\u0003_\u0014\u0019DC\u0002\u00036\u0001\u000bAaY8sK&!!\u0011\bB\u0019\u0005M)\u0015m\u00195DC2d'-Y2l/J\f\u0007\u000f]3s!\u0011\u0011iD!\u0011\u000e\u0005\t}\"BA&?\u0013\u0011\u0011\u0019Ea\u0010\u0003%1+w-Y2z%><X\t\u001f;f]NLwN\\\u0001\u0003?\u0002B3A\u0002B%!\u0011\u0011YEa\u0017\u000e\u0005\t5#\u0002\u0002B(\u0005#\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\t\tM#QK\u0001\u0004CBL'\u0002\u0002B,\u00053\nqA[;qSR,'OC\u0002\u0002l\u0012KAA!\u0018\u0003N\t\t\"+Z4jgR,'/\u0012=uK:\u001c\u0018n\u001c8\u0002\r\t,gm\u001c:f)\t\u0011\u0019\u0007E\u0002j\u0005KJ1Aa\u001ak\u0005\u0011)f.\u001b;)\u0007\u001d\u0011Y\u0007\u0005\u0003\u0003n\t=TB\u0001B)\u0013\u0011\u0011\tH!\u0015\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\nuKN$Hk\u001c*fiJ\f7\r^*ue\u0016\fW\u000eK\u0002\t\u0005o\u0002BA!\u001c\u0003z%!!1\u0010B)\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003A!Xm\u001d;U_V\u00038/\u001a:u'&t7\u000eK\u0002\n\u0005o\nQ\u0002^3ti\u0006;wM]3hCR,\u0007f\u0001\u0006\u0003x\u0005IB/Z:u\u0003\u001e<'/Z4bi\u0016$v.\u00169tKJ$8+\u001b8lQ\rY!qO\u0001\u0019i\u0016\u001cHo\u0012:pkB\u0014\u0015PT8o!JLW.\u0019:z\u0017\u0016L\bf\u0001\u0007\u0003x\u0005QA/Z:u\r&dG/\u001a:)\u00075\u00119(A\buKN$(+Z4vY\u0006\u0014(j\\5oQ\rq!qO\u0001\u0018e\u0016<\u0017n\u001d;fe\u000eC\u0017M\\4fY><7k\\;sG\u0016\f!F]3hSN$XM]\"iC:<W\r\\8h'>,(oY3XSRDWI^3oiN$U\u000f\u001d7jG\u0006$X-\u0001\u000bsK\u001eL7\u000f^3s+B\u001cXM\u001d;T_V\u00148-Z\u0001\u0017e\u0016<\u0017n\u001d;fe:{W\u000b\u001d3bi\u0016\u001cv.\u001e:dK\u0006)2m\u001c8wKJ$Hk\u001c(p+B$\u0017\r^3ECR\fG\u0003\u0002BQ\u0005\u007f\u0003bAa)\u0003.\nMf\u0002\u0002BS\u0005Ss1!\u0017BT\u0013\u0005Y\u0017b\u0001BVU\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BX\u0005c\u00131aU3r\u0015\r\u0011YK\u001b\t\u0005\u0005k\u0013Y,\u0004\u0002\u00038*\u0019!\u0011\u0018!\u0002\u000bQL\b/Z:\n\t\tu&q\u0017\u0002\u0004%><\bb\u0002Ba'\u0001\u0007!\u0011U\u0001\u0005I\u0006$\u0018\rK\u0004\u0001\u0005\u000b\u0014YM!4\u0011\t\t-#qY\u0005\u0005\u0005\u0013\u0014iE\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#Aa4$\u0005\tE\u0007\u0003BAp\u0005'LAA!6\u0002b\nQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u0002")
public class ChangelogSourceITCase
extends StreamingWithMiniBatchTestBase {
    private final SourceMode sourceMode;
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _;

    @Parameters(name="Source={0}, MiniBatch={1}, StateBackend={2}")
    public static Collection<Object[]> parameters() {
        return ChangelogSourceITCase$.MODULE$.parameters();
    }

    public static SourceMode NO_UPDATE_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.NO_UPDATE_SOURCE();
    }

    public static SourceMode UPSERT_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.UPSERT_SOURCE();
    }

    public static SourceMode CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE() {
        return ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
    }

    public static SourceMode CHANGELOG_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
    }

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String orderDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ordersData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n                       |CREATE TABLE orders (\n                       |  amount BIGINT,\n                       |  currency STRING\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(orderDataId).append("',\n                       | 'changelog-mode' = 'I'\n                       |)\n                       |").toString())).stripMargin());
        SourceMode sourceMode = this.sourceMode;
        SourceMode sourceMode2 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
        SourceMode sourceMode3 = sourceMode;
        if (!(sourceMode2 != null ? !((Object)sourceMode2).equals(sourceMode3) : sourceMode3 != null)) {
            this.registerChangelogSource();
            return;
        }
        SourceMode sourceMode4 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
        SourceMode sourceMode5 = sourceMode;
        if (!(sourceMode4 != null ? !((Object)sourceMode4).equals(sourceMode5) : sourceMode5 != null)) {
            this.registerChangelogSourceWithEventsDuplicate();
            return;
        }
        SourceMode sourceMode6 = ChangelogSourceITCase$.MODULE$.UPSERT_SOURCE();
        SourceMode sourceMode7 = sourceMode;
        if (!(sourceMode6 != null ? !((Object)sourceMode6).equals(sourceMode7) : sourceMode7 != null)) {
            this.registerUpsertSource();
            return;
        }
        SourceMode sourceMode8 = ChangelogSourceITCase$.MODULE$.NO_UPDATE_SOURCE();
        SourceMode sourceMode9 = sourceMode;
        if (!(sourceMode8 != null ? !((Object)sourceMode8).equals(sourceMode9) : sourceMode9 != null)) {
            this.registerNoUpdateSource();
            return;
        }
        throw new MatchError((Object)sourceMode);
    }

    @TestTemplate
    public void testToRetractStream() {
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT * FROM users")).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        TestingRetractSink sink = new TestingRetractSink();
        result.addSink((SinkFunction)sink).setParallelism(result.getParallelism());
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"user1,Tom,tom123@gmail.com,8.10,16.20", (List)new .colon.colon((Object)"user3,Bailey,bailey@qq.com,9.99,19.98", (List)new .colon.colon((Object)"user4,Tina,tina@gmail.com,11.30,22.60", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testToUpsertSink() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  user_id STRING PRIMARY KEY NOT ENFORCED,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 DECIMAL(18,2)\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT * FROM users\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)new .colon.colon((Object)"user1,Tom,tom123@gmail.com,8.10,16.20", (List)new .colon.colon((Object)"user3,Bailey,bailey@qq.com,9.99,19.98", (List)new .colon.colon((Object)"user4,Tina,tina@gmail.com,11.30,22.60", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        SourceMode sourceMode = this.sourceMode;
        SourceMode sourceMode2 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
        SourceMode sourceMode3 = sourceMode;
        if (!(sourceMode2 != null ? !((Object)sourceMode2).equals(sourceMode3) : sourceMode3 != null)) {
            java.util.List<String> rawResult = TestValuesTableFactory.getRawResultsAsStrings("user_sink");
            boolean hasUB = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rawResult).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.startsWith("-U")));
            Assertions.assertThat((boolean)hasUB).isFalse();
            return;
        }
    }

    @TestTemplate
    public void testAggregate() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT count(*), sum(balance), max(email)\n         |FROM users\n         |")).stripMargin();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        TestingRetractSink sink = new TestingRetractSink();
        result.addSink((SinkFunction)sink).setParallelism(result.getParallelism());
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,29.39,tom123@gmail.com", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggregateToUpsertSink() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  `scope` STRING,\n         |  cnt BIGINT,\n         |  sum_balance DECIMAL(18,2),\n         |  max_email STRING,\n         |  PRIMARY KEY (`scope`) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT 'ALL', count(*), sum(balance), max(email)\n         |FROM users\n         |GROUP BY 'ALL'\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)new .colon.colon((Object)"ALL,3,29.39,tom123@gmail.com", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testGroupByNonPrimaryKey() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  balance DECIMAL(18,2),\n         |  cnt BIGINT,\n         |  max_email STRING,\n         |  PRIMARY KEY (balance) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT balance2, count(*), max(email)\n         |FROM users\n         |GROUP BY balance2\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)new .colon.colon((Object)"16.20,1,tom123@gmail.com", (List)new .colon.colon((Object)"19.98,1,bailey@qq.com", (List)new .colon.colon((Object)"22.60,1,tina@gmail.com", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testFilter() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  user_id STRING PRIMARY KEY NOT ENFORCED,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 DECIMAL(18,2)\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT * FROM users WHERE balance > 9\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)new .colon.colon((Object)"user3,Bailey,bailey@qq.com,9.99,19.98", (List)new .colon.colon((Object)"user4,Tina,tina@gmail.com,11.30,22.60", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testRegularJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT o.currency, o.amount, r.rate, o.amount * r.rate\n         |FROM orders AS o JOIN rates AS r\n         |ON o.currency = r.currency\n         |")).stripMargin();
        TestingRetractSink sink = new TestingRetractSink();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink).setParallelism(result.getParallelism());
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Euro,2,119,238", (List)new .colon.colon((Object)"Euro,3,119,357", (List)new .colon.colon((Object)"US Dollar,1,102,102", (List)new .colon.colon((Object)"US Dollar,5,102,510", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void registerChangelogSource() {
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userChangelog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(552).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'I,UA,UB,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String ratesDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ratesHistoryData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(394).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'I,UB,UA,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private void registerChangelogSourceWithEventsDuplicate() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SOURCE_CDC_EVENTS_DUPLICATE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq userChangelog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+I", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("+I", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("-U", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+U", "user1", "Tom", "tom123@gmail.com", new BigDecimal("8.1")), TestValuesTableFactory.changelogRow("-U", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+U", "user1", "Tom", "tom123@gmail.com", new BigDecimal("8.1")), TestValuesTableFactory.changelogRow("+I", "user3", "Bailey", "bailey@gmail.com", new BigDecimal("9.99")), TestValuesTableFactory.changelogRow("-D", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("-D", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("+I", "user4", "Tina", "tina@gmail.com", new BigDecimal("11.3")), TestValuesTableFactory.changelogRow("-U", "user3", "Bailey", "bailey@gmail.com", new BigDecimal("9.99")), TestValuesTableFactory.changelogRow("+U", "user3", "Bailey", "bailey@qq.com", new BigDecimal("9.99"))}));
        String userDataId = TestValuesTableFactory.registerData((Seq<Row>)userChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(620).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2,\n                       |  PRIMARY KEY (user_name, user_id) NOT ENFORCED\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'UA,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        Seq ratesChangelog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "US Dollar", 102L), TestValuesTableFactory.changelogRow("+I", "Euro", 114L), TestValuesTableFactory.changelogRow("+I", "Euro", 114L), TestValuesTableFactory.changelogRow("+I", "Yen", 1L), TestValuesTableFactory.changelogRow("-U", "Euro", 114L), TestValuesTableFactory.changelogRow("+U", "Euro", 116L), TestValuesTableFactory.changelogRow("-U", "Euro", 116L), TestValuesTableFactory.changelogRow("+U", "Euro", 119L), TestValuesTableFactory.changelogRow("-U", "Euro", 116L), TestValuesTableFactory.changelogRow("+U", "Euro", 119L), TestValuesTableFactory.changelogRow("-D", "Yen", 1L), TestValuesTableFactory.changelogRow("-D", "Yen", 1L)}));
        String ratesDataId = TestValuesTableFactory.registerData((Seq<Row>)ratesChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(452).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT,\n                       |  PRIMARY KEY (currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private void registerUpsertSource() {
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userUpsertlog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(620).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2,\n                       |  PRIMARY KEY (user_name, user_id) NOT ENFORCED\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'UA,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String ratesDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ratesUpsertData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(452).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT,\n                       |  PRIMARY KEY (currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private void registerNoUpdateSource() {
        Seq<Row> userChangelog = this.convertToNoUpdateData(TestData$.MODULE$.userChangelog());
        String userDataId = TestValuesTableFactory.registerData(userChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(546).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'I,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        Seq<Row> ratesChangelog = this.convertToNoUpdateData(TestData$.MODULE$.ratesHistoryData());
        String ratesDataId = TestValuesTableFactory.registerData(ratesChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'I,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private Seq<Row> convertToNoUpdateData(Seq<Row> data) {
        return (Seq)data.map((Function1 & Serializable & scala.Serializable)row -> {
            RowKind rowKind = row.getKind();
            if (RowKind.INSERT.equals(rowKind) ? true : RowKind.DELETE.equals(rowKind)) {
                return row;
            }
            if (RowKind.UPDATE_BEFORE.equals(rowKind)) {
                Row ret = Row.copy((Row)row);
                ret.setKind(RowKind.DELETE);
                return ret;
            }
            if (RowKind.UPDATE_AFTER.equals(rowKind)) {
                Row ret = Row.copy((Row)row);
                ret.setKind(RowKind.INSERT);
                return ret;
            }
            throw new MatchError((Object)rowKind);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ChangelogSourceITCase(SourceMode sourceMode, StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch, StreamingWithStateTestBase.StateBackendMode state) {
        this.sourceMode = sourceMode;
        super(miniBatch, state);
        this._ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    }

    public static class SourceMode
    implements Product,
    scala.Serializable {
        private final String mode;

        public String mode() {
            return this.mode;
        }

        public String toString() {
            return this.mode();
        }

        public SourceMode copy(String mode) {
            return new SourceMode(mode);
        }

        public String copy$default$1() {
            return this.mode();
        }

        public String productPrefix() {
            return "SourceMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mode();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SourceMode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SourceMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            SourceMode sourceMode = (SourceMode)x$1;
            String string = this.mode();
            String string2 = sourceMode.mode();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!sourceMode.canEqual(this)) return false;
            return true;
        }

        public SourceMode(String mode) {
            this.mode = mode;
            Product.$init$((Product)this);
        }
    }
}

