/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.core.execution.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.runtime.stream.FiniteTestSource;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=240L, unit=TimeUnit.SECONDS)
@ScalaSignature(bytes="\u0006\u0001\u0005\rg!\u0002\f\u0018\u0003\u00031\u0003\"B\u0017\u0001\t\u0003q\u0003\"C\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00053\u0011%\u0001\u0005\u00011AA\u0002\u0013E\u0011\tC\u0005I\u0001\u0001\u0007\t\u0011)Q\u0005g!)\u0011\n\u0001C\u0001\u0015\")!\f\u0001C\u00017\")\u0011\r\u0001C!E\")a\u000e\u0001C\u0001_\")1\u000f\u0001C\u0001E\")\u0001\u0010\u0001C\u0001E\")!\u0010\u0001C\u0001E\")A\u0010\u0001C\u0001{\"1\u0011q\u0004\u0001\u0005\u0002\tDq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u0013\u0005m\u0002!%A\u0005\u0002\u0005u\u0002bBA*\u0001\u0011%\u0011Q\u000b\u0005\n\u0003w\u0002\u0011\u0013!C\u0005\u0003{A\u0011\"! \u0001#\u0003%I!!\u0010\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u00111\u0013\u0001\u0005\u0002\u0005U%!\u0007$t'R\u0014X-Y7j]\u001e\u001c\u0016N\\6J)\u000e\u000b7/\u001a\"bg\u0016T!\u0001G\r\u0002\rM$(/Z1n\u0015\tQ2$A\u0004sk:$\u0018.\\3\u000b\u0005qi\u0012a\u00029mC:tWM\u001d\u0006\u0003=}\tQ\u0001^1cY\u0016T!\u0001I\u0011\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+3\u0005)Q\u000f^5mg&\u0011A&\u000b\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\u0018\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002gA\u0011A'\u0010\b\u0003km\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u0013\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qJ\u0014A\u0004:fgVdG\u000fU1uQ~#S-\u001d\u000b\u0003\u0005\u001a\u0003\"a\u0011#\u000e\u0003eJ!!R\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u000e\t\t\u00111\u00014\u0003\rAH%M\u0001\fe\u0016\u001cX\u000f\u001c;QCRD\u0007%A\u0004hKR$\u0015\r^1\u0016\u0003-\u00032\u0001T)U\u001d\tiuJ\u0004\u00027\u001d&\t!(\u0003\u0002Qs\u00059\u0001/Y2lC\u001e,\u0017B\u0001*T\u0005\r\u0019V-\u001d\u0006\u0003!f\u0002\"!\u0016-\u000e\u0003YS!aV\u0010\u0002\u000bQL\b/Z:\n\u0005e3&a\u0001*po\u0006Aq-\u001a;ECR\f''F\u0001]!\ri\u0006\rV\u0007\u0002=*\u0011q,O\u0001\u000bG>dG.Z2uS>t\u0017B\u0001*_\u0003\u0019\u0011WMZ8sKR\t!\t\u000b\u0002\bIB\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\u0004CBL'BA5k\u0003\u001dQW\u000f]5uKJT!a[\u0012\u0002\u000b),h.\u001b;\n\u000554'A\u0003\"fM>\u0014X-R1dQ\u0006!\u0012\r\u001a3ji&|g.\u00197Qe>\u0004XM\u001d;jKN$\u0012\u0001\u001d\t\u0004\u0007F\u001c\u0014B\u0001::\u0005\u0015\t%O]1z\u0003-!Xm\u001d;O_:\u0004\u0016M\u001d;)\u0005%)\bCA3w\u0013\t9hM\u0001\u0003UKN$\u0018\u0001\u0003;fgR\u0004\u0016M\u001d;)\u0005))\u0018a\u0005;fgRlU\r^1ti>\u0014X\rU8mS\u000eL\bFA\u0006v\u000399W\r\u001e#bi\u0006\u001cFO]3b[J\"2A`A\b!\u0011y\u00181\u0002+\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t!\u0002Z1uCN$(/Z1n\u0015\r9\u0017q\u0001\u0006\u0004\u0003\u0013y\u0012!C:ue\u0016\fW.\u001b8h\u0013\u0011\ti!!\u0001\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000eC\u0004\u0002\u00121\u0001\r!a\u0005\u0002\u0007\u0019,h\u000e\u0005\u0004D\u0003+!\u0016\u0011D\u0005\u0004\u0003/I$!\u0003$v]\u000e$\u0018n\u001c82!\r\u0019\u00151D\u0005\u0004\u0003;I$\u0001\u0002'p]\u001e\f!\u0004^3tiB\u000b'\u000f^5uS>tw+\u001b;i\u0005\u0006\u001c\u0018n\u0019#bi\u0016D#!D;\u0002\u001b\u001d,G\u000fR1uCN#(/Z1n)\rq\u0018q\u0005\u0005\b\u0003#q\u0001\u0019AA\n\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]\u000e+8\u000f^8n\r>\u0014X.\u0019;ECR,G#\u0002\"\u0002.\u0005]\u0002bBA\u0018\u001f\u0001\u0007\u0011\u0011G\u0001\na\u0006\u0014H/\u001b;j_:\u00042aQA\u001a\u0013\r\t)$\u000f\u0002\b\u0005>|G.Z1o\u0011!\tId\u0004I\u0001\u0002\u0004\u0019\u0014A\u00029pY&\u001c\u00170A\u0014uKN$\b+\u0019:uSRLwN\\\"vgR|WNR8s[\u0006$H)\u0019;fI\u0011,g-Y;mi\u0012\u0012TCAA U\r\u0019\u0014\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011QJ\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!A/Z:u)U\u0011\u0015qKA.\u0003?\n\u0019'a\u001a\u0002j\u00055\u0014\u0011OA;\u0003oBa!!\u0017\u0012\u0001\u0004q\u0018A\u00033bi\u0006\u001cFO]3b[\"1\u0011QL\tA\u0002M\n\u0011\u0003^5nK\u0016CHO]1di>\u00148*\u001b8e\u0011\u0019\t\t'\u0005a\u0001g\u0005iB/[7f\u000bb$(/Y2u_J4uN]7biR,'\u000fU1ui\u0016\u0014h\u000e\u0003\u0004\u0002fE\u0001\raM\u0001\u0015i&lW-\u0012=ue\u0006\u001cGo\u001c:QCR$XM\u001d8\t\r\u0005=\u0012\u00031\u00014\u0011\u0019\tY'\u0005a\u0001g\u0005i1m\\7nSR$&/[4hKJDa!a\u001c\u0012\u0001\u0004\u0019\u0014aC2p[6LG\u000fR3mCfDa!a\u001d\u0012\u0001\u0004Y\u0015\u0001\u00033bi\u0006$Vm\u001d;\t\u0011\u0005e\u0012\u0003%AA\u0002MB\u0001\"!\u001f\u0012!\u0003\u0005\raM\u0001\u0010gV\u001c7-Z:t\r&dWMT1nK\u0006qA/Z:uI\u0011,g-Y;mi\u0012J\u0014a\u0004;fgR$C-\u001a4bk2$H%\r\u0019\u0002\r\u001d,G\u000f\u0012#M)E\u0019\u00141QAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\u0007\u0003;\"\u0002\u0019A\u001a\t\r\u0005\u0005D\u00031\u00014\u0011\u0019\t)\u0007\u0006a\u0001g!1\u0011q\u0006\u000bA\u0002MBa!a\u001b\u0015\u0001\u0004\u0019\u0004BBA8)\u0001\u00071\u0007\u0003\u0004\u0002:Q\u0001\ra\r\u0005\u0007\u0003s\"\u0002\u0019A\u001a\u0002\u000b\rDWmY6\u0015\u000b\t\u000b9*a'\t\r\u0005eU\u00031\u00014\u0003!\u0019\u0018\u000f\\)vKJL\bBBAO+\u0001\u00071*\u0001\bfqB,7\r^3e%\u0016\u001cX\u000f\u001c;)\u0017\u0001\t\t+a*\u0002*\u0006-\u0016Q\u0016\t\u0004K\u0006\r\u0016bAASM\n9A+[7f_V$\u0018!\u0002<bYV,gD\u0001\u0001q\u0004\u0011)h.\u001b;%\u0005\u0005=\u0016\u0002BAY\u0003g\u000bqaU#D\u001f:#5K\u0003\u0003\u00026\u0006]\u0016\u0001\u0003+j[\u0016,f.\u001b;\u000b\t\u0005e\u00161X\u0001\u000bG>t7-\u001e:sK:$(\u0002BA_\u0003\u007f\u000bA!\u001e;jY*\u0011\u0011\u0011Y\u0001\u0005U\u00064\u0018\r")
public abstract class FsStreamingSinkITCaseBase
extends StreamingTestBase {
    private String resultPath;

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    public Seq<Row> getData() {
        return (Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{1, "a", "b", "05-03-2020", "07"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{2, "p", "q", "05-03-2020", "08"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{3, "x", "y", "05-03-2020", "09"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{4, "x", "y", "05-03-2020", "10"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{5, "x", "y", "05-03-2020", "11"}), (List)Nil$.MODULE$)))));
    }

    public Seq<Row> getData2() {
        return (Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{1, "a", "b", "20200503", "07"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{2, "p", "q", "20200503", "08"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{3, "x", "y", "20200503", "09"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{4, "x", "y", "20200504", "10"}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{5, "x", "y", "20200504", "11"}), (List)Nil$.MODULE$)))));
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        this.env().enableCheckpointing(100L);
        this.env().getCheckpointConfig().setCheckpointingConsistencyMode(CheckpointingMode.EXACTLY_ONCE);
    }

    public String[] additionalProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    @Test
    public void testNonPart() {
        this.testPartitionCustomFormatDate(false, this.testPartitionCustomFormatDate$default$2());
    }

    @Test
    public void testPart() {
        this.testPartitionCustomFormatDate(true, this.testPartitionCustomFormatDate$default$2());
        File basePath = new File(new URI(this.resultPath()).getPath(), "d=05-03-2020");
        Assertions.assertThat((Object[])basePath.list()).hasSize(5);
        Assertions.assertThat((File)new File(new File(basePath, "e=07"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=08"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=09"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=10"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=11"), "_MY_SUCCESS")).exists();
    }

    @Test
    public void testMetastorePolicy() {
        Assertions.assertThatThrownBy(() -> this.testPartitionCustomFormatDate(true, "metastore")).hasMessage("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
    }

    public DataStream<Row> getDataStream2(Function1<Row, Object> fun) {
        return this.env().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.getData2(), fun), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING}));
    }

    @Test
    public void testPartitionWithBasicDate() {
        Function1 & Serializable & scala.Serializable fun = (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)FsStreamingSinkITCaseBase.$anonfun$testPartitionWithBasicDate$1(t));
        this.test(this.getDataStream2((Function1<Row, Object>)fun), "default", "yyyyMMdd", "$d", "d", "partition-time", "1d", this.getData2(), this.test$default$9(), this.test$default$10());
        File basePath = new File(new URI(this.resultPath()).getPath());
        Assertions.assertThat((Object[])basePath.list()).hasSize(2);
        Assertions.assertThat((File)new File(new File(basePath, "d=20200503"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "d=20200504"), "_MY_SUCCESS")).exists();
    }

    public DataStream<Row> getDataStream(Function1<Row, Object> fun) {
        return this.env().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.getData(), fun), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING}));
    }

    public void testPartitionCustomFormatDate(boolean partition, String policy) {
        Function1 & Serializable & scala.Serializable fun = (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)FsStreamingSinkITCaseBase.$anonfun$testPartitionCustomFormatDate$1(t));
        this.test(this.getDataStream((Function1<Row, Object>)fun), "default", "MM-dd-yyyy HH:mm:ss", "$d $e:00:00", partition ? "d,e" : "", "process-time", "1h", this.getData(), policy, this.test$default$10());
    }

    private void test(DataStream<Row> dataStream, String timeExtractorKind, String timeExtractorFormatterPattern, String timeExtractorPattern, String partition, String commitTrigger, String commitDelay, Seq<Row> dataTest, String policy, String successFileName) {
        this.resultPath_$eq(TempDirUtils.newFolder((Path)this.tempFolder()).toURI().toString());
        this.tEnv().createTemporaryView("my_table", dataStream);
        String ddl = this.getDDL(timeExtractorKind, timeExtractorFormatterPattern, timeExtractorPattern, partition, commitTrigger, commitDelay, policy, successFileName);
        this.tEnv().executeSql(ddl);
        this.tEnv().sqlQuery("select * from my_table").executeInsert("sink_table").await();
        this.check("select * from sink_table", dataTest);
    }

    public String testPartitionCustomFormatDate$default$2() {
        return "success-file";
    }

    private String test$default$9() {
        return "success-file";
    }

    private String test$default$10() {
        return "_MY_SUCCESS";
    }

    public String getDDL(String timeExtractorKind, String timeExtractorFormatterPattern, String timeExtractorPattern, String partition, String commitTrigger, String commitDelay, String policy, String successFileName) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(444).append("\n         |create table sink_table (\n         |  a int,\n         |  b string,\n         |  c string,\n         |  d string,\n         |  e string\n         |)\n         |").append((Object)(new StringOps(Predef$.MODULE$.augmentString(partition)).nonEmpty() ? new StringBuilder(18).append("partitioned by (").append(partition).append(") ").toString() : " ")).append("\n         |with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.resultPath()).append("',\n         |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_KIND.key()).append("' = '").append(timeExtractorKind).append("',\n         |").append((Object)(new StringOps(Predef$.MODULE$.augmentString(timeExtractorFormatterPattern)).nonEmpty() ? new StringBuilder(9).append(" '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_FORMATTER.key()).append("' = ").append("'").append(timeExtractorFormatterPattern).append("',").toString() : "")).append("\n         |\n         |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN.key()).append("' =\n         |      '").append(timeExtractorPattern).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER.key()).append("' = '").append(commitTrigger).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY.key()).append("' = '").append(commitDelay).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND.key()).append("' = '").append(policy).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME.key()).append("' = '").append(successFileName).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.additionalProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin();
        return ddl;
    }

    public void check(String sqlQuery, Seq<Row> expectedResult) {
        CloseableIterator iter = this.tEnv().sqlQuery(sqlQuery).execute().collect();
        java.util.List result = CollectionUtil.iteratorToList((Iterator)iter);
        iter.close();
        Assertions.assertThat((Object)((SeqLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).map((Function1 & Serializable & scala.Serializable)x$1 -> TestSinkUtil$.MODULE$.rowToString((Row)x$1, TestSinkUtil$.MODULE$.rowToString$default$2()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(((SeqLike)expectedResult.map((Function1 & Serializable & scala.Serializable)x$2 -> TestSinkUtil$.MODULE$.rowToString((Row)x$2, TestSinkUtil$.MODULE$.rowToString$default$2()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$testPartitionWithBasicDate$1(Row t) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.parse((CharSequence)t.getFieldAs(3), DateTimeFormatter.BASIC_ISO_DATE), LocalTime.MIDNIGHT);
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime).getMillisecond();
    }

    public static final /* synthetic */ long $anonfun$testPartitionCustomFormatDate$1(Row t) {
        LocalDateTime localDateTime = LocalDateTime.parse(new StringBuilder(7).append(t.getField(3)).append(" ").append(t.getField(4)).append(":00:00").toString(), DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm:ss"));
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime).getMillisecond();
    }
}

