/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowTableFunctionHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\u000b\u0016\u0001\u0011B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\")Q\n\u0001C\u0001\u001d\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006B\u0002+\u0001A\u0003%Q\tC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ry\u0003\u0001\u0015!\u0003X\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015\u0011\b\u0001\"\u0001a\u0011\u00159\b\u0001\"\u0001a\u0011\u0015I\b\u0001\"\u0001a\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002Z\u0001!I!a\u0017\b\u000f\u0005%U\u0003#\u0001\u0002\f\u001a1A#\u0006E\u0001\u0003\u001bCa!T\t\u0005\u0002\u0005U\u0005bBAL#\u0011\u0005\u0011\u0011\u0014\u0002\u001f/&tGm\\<UC\ndWMR;oGRLwN\u001c%be:,7o\u001d+fgRT!AF\f\u0002\u000f!\f'O\\3tg*\u0011\u0001$G\u0001\beVtG/[7f\u0015\tQ2$A\u0004qY\u0006tg.\u001a:\u000b\u0005qi\u0012!\u0002;bE2,'B\u0001\u0010 \u0003\u00151G.\u001b8l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\n\t\u0003M\u001dj\u0011!F\u0005\u0003QU\u0011q\u0002S1s]\u0016\u001c8\u000fV3ti\n\u000b7/Z\u0001\bE\u0006\u001c7.\u001a8e!\tY\u0013I\u0004\u0002-}9\u0011Q\u0006\u0010\b\u0003]mr!a\f\u001e\u000f\u0005AJdBA\u00199\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026G\u00051AH]8pizJ\u0011AI\u0005\u0003A\u0005J!AH\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002>/\u0005)Q\u000f^5mg&\u0011q\bQ\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\u0006\u0003{]I!AQ\"\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'BA A\u00035\u0019\b.\u001b4u)&lWMW8oKB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005i&lWMC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%A\u0002.p]\u0016LE-\u0001\u0004=S:LGO\u0010\u000b\u0004\u001fB\u000b\u0006C\u0001\u0014\u0001\u0011\u0015I3\u00011\u0001+\u0011\u0015!5\u00011\u0001F\u0003-)FkQ0[\u001f:+u,\u0013#\u0016\u0003\u0015\u000bA\"\u0016+D?j{e*R0J\t\u0002\n\u0001\"Y:tKJ$xN]\u000b\u0002/B\u0011\u0001\fX\u0007\u00023*\u0011!lW\u0001\u0005kRLGN\u0003\u0002\u00197%\u0011Q,\u0017\u0002\u0017%><H)\u0019;b\u0011\u0006\u0014h.Z:t\u0003N\u001cXM\u001d;pe\u0006I\u0011m]:feR|'\u000fI\u0001\u0007E\u00164wN]3\u0015\u0003\u0005\u0004\"AY3\u000e\u0003\rT\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\u0014A!\u00168ji\"\u0012\u0001\u0002\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f1!\u00199j\u0015\tig.A\u0004kkBLG/\u001a:\u000b\u0005=\f\u0013!\u00026v]&$\u0018BA9k\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001fi\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001b8h)&lW\rV;nE2,w+\u001b8e_^D#!\u0003;\u0011\u0005%,\u0018B\u0001<k\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003m!Xm\u001d;Qe>\u001cWm]:j]\u001e$\u0016.\\3I_B<\u0016N\u001c3po\"\u0012!\u0002^\u0001!i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001b8h)&lWmQ;nk2\fG/Z,j]\u0012|w\u000f\u000b\u0002\fi\u0006Q\u0011N\\4fgR$\u0015\r^1\u0015\u0005\u0005l\b\"\u0002@\r\u0001\u0004y\u0018a\u0003;fgRD\u0015M\u001d8fgN\u0004\u0002\"!\u0001\u0002\n\u00055\u0011QB\u0007\u0003\u0003\u0007Q1AWA\u0003\u0015\r\t9!H\u0001\ngR\u0014X-Y7j]\u001eLA!a\u0003\u0002\u0004\t\tsJ\\3J]B,Ho\u0015;sK\u0006lw\n]3sCR|'\u000fV3ti\"\u000b'O\\3tgB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014m\tA\u0001Z1uC&!\u0011qCA\t\u0005\u001d\u0011vn\u001e#bi\u0006\faA]3d_J$G\u0003BA\u000f\u0003W\u0001b!a\b\u0002(\u00055QBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u0019M$(/Z1ne\u0016\u001cwN\u001d3\u000b\u0007a\t)!\u0003\u0003\u0002*\u0005\u0005\"\u0001D*ue\u0016\fWNU3d_J$\u0007bBA\u0017\u001b\u0001\u0007\u0011qF\u0001\u0005CJ<7\u000fE\u0003c\u0003c\t)$C\u0002\u00024\r\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?!\r\u0011\u0017qG\u0005\u0004\u0003s\u0019'aA!os\u0006QAn\\2bY6KG\u000e\\:\u0015\t\u0005}\u0012Q\t\t\u0005\u0003\u001f\t\t%\u0003\u0003\u0002D\u0005E!!\u0004+j[\u0016\u001cH/Y7q\t\u0006$\u0018\rC\u0004\u0002H9\u0001\r!!\u0013\u0002\u0011\u0011\fG/\u001a+j[\u0016\u0004B!a\u0013\u0002T9!\u0011QJA(!\t\u00194-C\u0002\u0002R\r\fa\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)G\u0006)Q.\u001b7mgR!\u0011qHA/\u0011\u001d\t9e\u0004a\u0001\u0003\u0013Bs\u0001AA1\u0003[\ny\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9G[\u0001\nKb$XM\\:j_:LA!a\u001b\u0002f\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005E4EAA:!\u0011\t)(!\"\u000e\u0005\u0005]$\u0002BA=\u0003w\nQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA?\u0003\u007f\n!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\ry\u0017\u0011\u0011\u0006\u0004\u0003\u0007k\u0012!\u0003;fgR,H/\u001b7t\u0013\u0011\t9)a\u001e\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\u0002=]Kg\u000eZ8x)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8ICJtWm]:UKN$\bC\u0001\u0014\u0012'\r\t\u0012q\u0012\t\u0004E\u0006E\u0015bAAJG\n1\u0011I\\=SK\u001a$\"!a#\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\u001cB1\u0011QTAQ\u0003Kk!!a(\u000b\u0005iK\u0015\u0002BAR\u0003?\u0013!bQ8mY\u0016\u001cG/[8o!\u0015\u0011\u0017qUAV\u0013\r\tIk\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011W%\u0002\t1\fgnZ\u0005\u0005\u0003k\u000byK\u0001\u0004PE*,7\r\u001e\u0015\b'\u0005e\u0016qXAa!\u0011\t)(a/\n\t\u0005u\u0016q\u000f\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!a1\u0002=M#\u0018\r^3CC\u000e\\WM\u001c3>wBjH\u0006\t+j[\u0016TvN\\3>wFj\b")
public class WindowTableFunctionHarnessTest
extends HarnessTestBase {
    private final ZoneId shiftTimeZone;
    private final ZoneId UTC_ZONE_ID;
    private final RowDataHarnessAssertor assertor;

    @Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowTableFunctionHarnessTest$.MODULE$.parameters();
    }

    private ZoneId UTC_ZONE_ID() {
        return this.UTC_ZONE_ID;
    }

    private RowDataHarnessAssertor assertor() {
        return this.assertor;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.shiftTimeZone);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(551).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testProcessingTimeTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @TestTemplate
    public void testProcessingTimeHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TABLE(\n        |  HOP(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:10"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25"), this.mills("1970-01-01T00:00:24.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @TestTemplate
    public void testProcessingTimeCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TABLE(\n        |  CUMULATE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '15' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25"), this.mills("1970-01-01T00:00:24.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:30"), this.mills("1970-01-01T00:00:29.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45"), this.mills("1970-01-01T00:00:44.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45"), this.mills("1970-01-01T00:00:44.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(OneInputStreamOperatorTestHarness<RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(2000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(3000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(4000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null})));
        testHarness.setProcessingTime(6000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null})));
        testHarness.setProcessingTime(7000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null})));
        testHarness.setProcessingTime(8000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null})));
        testHarness.setProcessingTime(16000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null})));
        testHarness.setProcessingTime(32000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null})));
        testHarness.setProcessingTime(34000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(50000L);
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return BoxesRunTime.boxToLong((long)l);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return BoxesRunTime.boxToDouble((double)d);
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    private TimestampData localMills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)TimeWindowUtil.toUtcTimestampMills((long)windowDateTime.toInstant().toEpochMilli(), (ZoneId)this.shiftTimeZone));
    }

    private TimestampData mills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)windowDateTime.toInstant().toEpochMilli());
    }

    public WindowTableFunctionHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        super(backend);
        this.UTC_ZONE_ID = ZoneId.of("UTC");
        this.assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
    }
}

