/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\n\u0015\u0001\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A1\n\u0001B\u0001B\u0003%A\nC\u0003S\u0001\u0011\u00051\u000bC\u0003Y\u0001\u0011\u0005\u0013\fC\u0003i\u0001\u0011\u0005\u0011\fC\u0003n\u0001\u0011\u0005\u0011\fC\u0003p\u0001\u0011\u0005\u0011\fC\u0003r\u0001\u0011\u0005\u0011\fC\u0003t\u0001\u0011\u0005\u0011\fC\u0003v\u0001\u0011%a\u000fC\u0004\u0002(\u0001!I!!\u000b\t\r\u0005]\u0002\u0001\"\u0003w\u0011\u0019\tI\u0004\u0001C\u00013\u001e9\u0011q\r\u000b\t\u0002\u0005%dAB\n\u0015\u0011\u0003\tY\u0007\u0003\u0004S!\u0011\u0005\u00111\u000f\u0005\b\u0003k\u0002B\u0011AA<\u0005e9%o\\;q\u0003\u001e<'/Z4bi\u0016D\u0015M\u001d8fgN$Vm\u001d;\u000b\u0005U1\u0012a\u00025be:,7o\u001d\u0006\u0003/a\tqA];oi&lWM\u0003\u0002\u001a5\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u000e\u001d\u0003\u0015!\u0018M\u00197f\u0015\tib$A\u0003gY&t7N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0014\u000e\u0003QI!a\n\u000b\u0003\u001f!\u000b'O\\3tgR+7\u000f\u001e\"bg\u0016\fA!\\8eKB\u0011!\u0006\u0011\b\u0003Wur!\u0001L\u001e\u000f\u00055RdB\u0001\u0018:\u001d\ty\u0003H\u0004\u00021o9\u0011\u0011G\u000e\b\u0003eUj\u0011a\r\u0006\u0003i\t\na\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\tYB$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003yY\tQ!\u001e;jYNL!AP \u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\u000b\u0005q2\u0012BA!C\u0005A\u0019F/\u0019;f\u0005\u0006\u001c7.\u001a8e\u001b>$WM\u0003\u0002?\u007f\u0005IQ.\u001b8j\u0005\u0006$8\r\u001b\t\u0003\u000b\"s!a\u000b$\n\u0005\u001d{\u0014AH*ue\u0016\fW.\u001b8h/&$\b.T5oS\n\u000bGo\u00195UKN$()Y:f\u0013\tI%JA\u0007NS:L')\u0019;dQ6{G-\u001a\u0006\u0003\u000f~\n\u0001#\u001a8bE2,\u0017i]=oGN#\u0018\r^3\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"B\u0001V+W/B\u0011Q\u0005\u0001\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\u0006\u0007\u0012\u0001\r\u0001\u0012\u0005\u0006\u0017\u0012\u0001\r\u0001T\u0001\u0007E\u00164wN]3\u0015\u0003i\u0003\"!T.\n\u0005qs%\u0001B+oSRD#!\u00020\u0011\u0005}3W\"\u00011\u000b\u0005\u0005\u0014\u0017aA1qS*\u00111\rZ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)\u0007%A\u0003kk:LG/\u0003\u0002hA\nQ!)\u001a4pe\u0016,\u0015m\u00195\u00027Q,7\u000f^!hOJ,w-\u0019;f/&$\bNU3ue\u0006\u001cG/[8oQ\t1!\u000e\u0005\u0002`W&\u0011A\u000e\u0019\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001#i\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRDgj\\*uCR,W\t\u001f9je\u0006$\u0018n\u001c8)\u0005\u001dQ\u0017a\u0007;fgR\fum\u001a:fO\u0006$\u0018n\u001c8XSRDG)[:uS:\u001cG\u000f\u000b\u0002\tU\u0006\tC/Z:u\u000f2|'-\u00197BO\u001e\u0014XmZ1uK^KG\u000f\u001b*fiJ\f7\r^5p]\"\u0012\u0011B[\u0001)i\u0016\u001cHo\u00127pE\u0006d\u0017iZ4sK\u001e\fG/Z,ji\"tun\u0015;bi\u0016,\u0005\u0010]5sCRLwN\u001c\u0015\u0003\u0015)\f\u0011c\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o)\u00059\b#B'yu\u0006E\u0011BA=O\u0005\u0019!V\u000f\u001d7feAI10!\u0001\u0002\u0006\u0005\u0015\u0011QA\u0007\u0002y*\u0011QP`\u0001\u0005kRLGN\u0003\u0002\u00009\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0004\u0003\u0007a(AJ&fs\u0016$wJ\\3J]B,Ho\u0015;sK\u0006lw\n]3sCR|'\u000fV3ti\"\u000b'O\\3tgB!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fi\tA\u0001Z1uC&!\u0011qBA\u0005\u0005\u001d\u0011vn\u001e#bi\u0006\u0004R!TA\n\u0003/I1!!\u0006O\u0005\u0015\t%O]1z!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tq\u0001\\8hS\u000e\fGNC\u0002\u0002\"i\tQ\u0001^=qKNLA!!\n\u0002\u001c\tYAj\\4jG\u0006dG+\u001f9f\u0003]\u0019'/Z1uK\u001ecwNY1m\u0003\u001e<'/Z4bi&|g\u000e\u0006\u0002\u0002,AAQ*!\f\u00022i\f\t\"C\u0002\u000209\u0013a\u0001V;qY\u0016\u001c\u0004cB>\u00024\u0005\u0015\u0011QA\u0005\u0004\u0003ka(!I(oK&s\u0007/\u001e;TiJ,\u0017-\\(qKJ\fGo\u001c:UKN$\b*\u0019:oKN\u001c\u0018!H2sK\u0006$X-Q4he\u0016<\u0017\r^5p]^KG\u000f\u001b#jgRLgn\u0019;\u0002)Q,7\u000f^\"m_N,w+\u001b;i_V$x\n]3oQ\tq!\u000eK\u0004\u0001\u0003\u007f\tY%!\u0014\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012a\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002J\u0005\r#AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\u0012\u0011qJ\u0012\u0003\u0003#\u0002B!a\u0015\u0002d5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u00037\ni&\u0001\u0006fqR,gn]5p]NT1!ZA0\u0015\r\t\t\u0007H\u0001\ni\u0016\u001cH/\u001e;jYNLA!!\u001a\u0002V\tQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u0006IrI]8va\u0006;wM]3hCR,\u0007*\u0019:oKN\u001cH+Z:u!\t)\u0003cE\u0002\u0011\u0003[\u00022!TA8\u0013\r\t\tH\u0014\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005%\u0014A\u00039be\u0006lW\r^3sgR\u0011\u0011\u0011\u0010\t\u0007\u0003w\n\u0019)a\"\u000e\u0005\u0005u$bA?\u0002\u0000)\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006u$AC\"pY2,7\r^5p]B)Q*a\u0005\u0002\nB!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006}\u0014\u0001\u00027b]\u001eLA!a%\u0002\u000e\n1qJ\u00196fGRDsAEAL\u0003;\u000by\n\u0005\u0003\u0002T\u0005e\u0015\u0002BAN\u0003+\u0012!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005\u0005\u0016AN*uCR,')Y2lK:$Wh\u001f\u0019~Y\u0001j\u0015N\\5CCR\u001c\u0007.P>2{2\u0002\u0003%\u00128bE2,\u0017i]=oGN#\u0018\r^3>wJj\b")
public class GroupAggregateHarnessTest
extends HarnessTestBase {
    private final StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch;
    private final boolean enableAsyncState;

    @Parameters(name="StateBackend={0}, MiniBatch={1},  EnableAsyncState={2}")
    public static Collection<Object[]> parameters() {
        return GroupAggregateHarnessTest$.MODULE$.parameters();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
        TableConfig tableConfig = this.tEnv().getConfig();
        StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode = this.miniBatch;
        StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode2 = StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOn();
        StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode3 = miniBatchMode;
        if (!(miniBatchMode2 != null ? !((Object)miniBatchMode2).equals(miniBatchMode3) : miniBatchMode3 != null)) {
            tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
            tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)1L));
            tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.ONE_PHASE);
        } else {
            StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode4 = StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOff();
            StreamingWithMiniBatchTestBase.MiniBatchMode miniBatchMode5 = miniBatchMode;
            if (!(miniBatchMode4 != null ? !((Object)miniBatchMode4).equals(miniBatchMode5) : miniBatchMode5 != null)) {
                BoxesRunTime.boxToBoolean((boolean)tableConfig.getConfiguration().removeConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY));
            } else {
                throw new MatchError((Object)miniBatchMode);
            }
        }
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_STATE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.enableAsyncState));
    }

    @TestTemplate
    public void testAggregateWithRetraction() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createAggregation();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        LogicalType[] outputType2 = (LogicalType[])tuple22._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputType2);
        testHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness2.setStateTtlProcessingTime(1L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(3L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}));
        testHarness2.setStateTtlProcessingTime(3002L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}));
        Object object = this.enableAsyncState ? BoxesRunTime.boxToBoolean((boolean)expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"ccc", Predef$.MODULE$.long2Long(3L)}))) : BoxedUnit.UNIT;
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(4L)}));
        if (this.enableAsyncState) {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
            bl6 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(5L)}));
        } else {
            bl6 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(4L)}));
        }
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(2L)}));
        if (this.enableAsyncState) {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
            bl5 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(3L)}));
        } else {
            bl5 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(2L)}));
        }
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(5L)}));
        if (this.enableAsyncState) {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(5L)}));
            bl4 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(10L)}));
        } else {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(4L)}));
            bl4 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(9L)}));
        }
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"eee", Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"eee", Predef$.MODULE$.long2Long(6L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(7L)}));
        if (this.enableAsyncState) {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(10L)}));
            bl3 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(17L)}));
        } else {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(9L)}));
            bl3 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(16L)}));
        }
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(3L)}));
        if (this.enableAsyncState) {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(3L)}));
            bl2 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(6L)}));
        } else {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(2L)}));
            bl2 = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(5L)}));
        }
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L)}));
        if (this.enableAsyncState) {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(17L)}));
            bl = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(17L)}));
        } else {
            expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(16L)}));
            bl = expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(16L)}));
        }
        ConcurrentLinkedQueue result = testHarness2.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness2.close();
    }

    @TestTemplate
    public void testAggregateWithNoStateExpiration() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createAggregation();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        LogicalType[] outputType2 = (LogicalType[])tuple22._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputType2);
        testHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L)}));
        ConcurrentLinkedQueue result = testHarness2.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness2.close();
    }

    @TestTemplate
    public void testAggregationWithDistinct() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createAggregationWithDistinct();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputTypes = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputTypes);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        LogicalType[] outputTypes2 = (LogicalType[])tuple22._2();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        testHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        testHarness2.setStateTtlProcessingTime(1L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", "b1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)}));
        testHarness2.setStateTtlProcessingTime(1000L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a2", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)}));
        testHarness2.setStateTtlProcessingTime(2001L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", "b3", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(3L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a2", Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", null, Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|0", Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(2L), "2|1", Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(10L)}));
        testHarness2.setStateTtlProcessingTime(5001L);
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", null, Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L), "0|1", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", "a2", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L), "0|1", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L), "1|1", Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(6L)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", "b4", Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L), "1|0", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(4L)}));
        ConcurrentLinkedQueue result = testHarness2.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)result);
        testHarness2.close();
    }

    @TestTemplate
    public void testGlobalAggregateWithRetraction() {
        if (!this.miniBatch.on()) {
            return;
        }
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        Tuple3<OneInputStreamOperatorTestHarness<RowData, RowData>, KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple3 = this.createGlobalAggregation();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        OneInputStreamOperatorTestHarness localTestHarness = (OneInputStreamOperatorTestHarness)tuple3._1();
        KeyedOneInputStreamOperatorTestHarness globalTestHarness = (KeyedOneInputStreamOperatorTestHarness)tuple3._2();
        LogicalType[] outputTypes = (LogicalType[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)localTestHarness, (Object)globalTestHarness, (Object)outputTypes);
        OneInputStreamOperatorTestHarness localTestHarness2 = (OneInputStreamOperatorTestHarness)tuple32._1();
        KeyedOneInputStreamOperatorTestHarness globalTestHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple32._2();
        LogicalType[] outputTypes2 = (LogicalType[])tuple32._3();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        localTestHarness2.open();
        globalTestHarness2.open();
        localTestHarness2.open();
        globalTestHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        localTestHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        localTestHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        localTestHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        ConcurrentLinkedQueue localResult = localTestHarness2.getOutput();
        globalTestHarness2.processElements((Collection)localResult);
        ConcurrentLinkedQueue globalResult = globalTestHarness2.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)globalResult);
        localTestHarness2.close();
        globalTestHarness2.close();
    }

    @TestTemplate
    public void testGlobalAggregateWithNoStateExpiration() {
        if (!this.miniBatch.on()) {
            return;
        }
        Tuple3<OneInputStreamOperatorTestHarness<RowData, RowData>, KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple3 = this.createGlobalAggregation();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        OneInputStreamOperatorTestHarness localTestHarness = (OneInputStreamOperatorTestHarness)tuple3._1();
        KeyedOneInputStreamOperatorTestHarness globalTestHarness = (KeyedOneInputStreamOperatorTestHarness)tuple3._2();
        LogicalType[] outputTypes = (LogicalType[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)localTestHarness, (Object)globalTestHarness, (Object)outputTypes);
        OneInputStreamOperatorTestHarness localTestHarness2 = (OneInputStreamOperatorTestHarness)tuple32._1();
        KeyedOneInputStreamOperatorTestHarness globalTestHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple32._2();
        LogicalType[] outputTypes2 = (LogicalType[])tuple32._3();
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(outputTypes2);
        localTestHarness2.open();
        globalTestHarness2.open();
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        localTestHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(1L)}));
        localTestHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"bbb", Predef$.MODULE$.long2Long(1L)}));
        localTestHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"aaa", Predef$.MODULE$.long2Long(0L)}));
        ConcurrentLinkedQueue localResult = localTestHarness2.getOutput();
        globalTestHarness2.processElements((Collection)localResult);
        ConcurrentLinkedQueue globalResult = globalTestHarness2.getOutput();
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, (Collection)globalResult);
        localTestHarness2.close();
        globalTestHarness2.close();
    }

    private Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createAggregation() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(c)\n        |FROM (\n        |  SELECT a, b, SUM(c) as c\n        |  FROM T GROUP BY a, b\n        |)GROUP BY a\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "GroupAggregate");
        LogicalType[] outputTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
        AbstractBooleanAssert abstractBooleanAssert = this.enableAsyncState ? Assertions.assertThat((boolean)this.isAsyncStateOperator(testHarness)).isTrue() : Assertions.assertThat((boolean)this.isAsyncStateOperator(testHarness)).isFalse();
        return new Tuple2(testHarness, (Object)outputTypes);
    }

    private Tuple3<OneInputStreamOperatorTestHarness<RowData, RowData>, KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createGlobalAggregation() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE);
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(c)\n        |FROM (\n        |  SELECT a, b, SUM(c) as c\n        |  FROM T GROUP BY a, b\n        |)GROUP BY a\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> localTestHarness = this.createHarnessTesterForNoState(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "LocalGroupAggregate");
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> globalTestHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "GlobalGroupAggregate");
        LogicalType[] outputTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
        return new Tuple3(localTestHarness, globalTestHarness, (Object)outputTypes);
    }

    private Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> createAggregationWithDistinct() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.harness.GroupAggregateHarnessTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("CntNullNonNull", (UserDefinedFunction)new UserDefinedFunctionTestUtils.CountNullNonNull());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), CntNullNonNull(DISTINCT b), COUNT(*), SUM(c)\n        |FROM T\n        |GROUP BY a\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(2L));
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "GroupAggregate");
        LogicalType[] outputTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
        Assertions.assertThat((boolean)this.isAsyncStateOperator(testHarness)).isFalse();
        return new Tuple2(testHarness, (Object)outputTypes);
    }

    @TestTemplate
    public void testCloseWithoutOpen() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, LogicalType[]> tuple2 = this.createAggregationWithDistinct();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        LogicalType[] outputType = (LogicalType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)outputType);
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple22._1();
        LogicalType[] outputType2 = (LogicalType[])tuple22._2();
        testHarness2.setup((TypeSerializer)new RowDataSerializer(outputType2));
        testHarness2.close();
    }

    public GroupAggregateHarnessTest(StreamingWithStateTestBase.StateBackendMode mode, StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch, boolean enableAsyncState) {
        this.miniBatch = miniBatch;
        this.enableAsyncState = enableAsyncState;
        super(mode);
    }
}

