/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.SingleSubTaskBoundTableFunction;
import org.apache.flink.table.planner.runtime.batch.sql.join.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.runtime.functions.table.fullcache.inputformat.FullCacheTestInputFormat;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t}g\u0001B\u001d;\u00015CQ\u0001\u0016\u0001\u0005\u0002UC\u0011\u0002\u0017\u0001A\u0002\u0003\u0007I\u0011A-\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0003\t\u0007\"C4\u0001\u0001\u0004\u0005\t\u0015)\u0003[\u0011%9\b\u00011AA\u0002\u0013\u0005\u0001\u0010C\u0006\u00020\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0002BCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005s\"I\u00111\b\u0001C\u0002\u0013\u0005\u0011Q\b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002@!I\u0011Q\f\u0001C\u0002\u0013\u0005\u0011Q\b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002@!I\u0011\u0011\r\u0001C\u0002\u0013\u0005\u0011Q\b\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002@!I\u0011Q\r\u0001C\u0002\u0013\u0005\u0011Q\b\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002@!9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0004bBAA\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011%\t)\rAI\u0001\n\u0013\t9\rC\u0005\u0002^\u0002\t\n\u0011\"\u0003\u0002H\"I\u0011q\u001c\u0001\u0012\u0002\u0013%\u0011q\u0019\u0005\n\u0003C\u0004\u0011\u0013!C\u0005\u0003\u000fDq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002l\u0002!I!!<\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9\u0011q\u001f\u0001\u0005\u0002\u0005-\u0004b\u0002B\u0001\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005\u000b\u0001A\u0011AA6\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003WBqA!\u0004\u0001\t\u0003\tY\u0007C\u0004\u0003\u0012\u0001!\t!a\u001b\t\u000f\tU\u0001\u0001\"\u0001\u0002l!9!\u0011\u0004\u0001\u0005\u0002\u0005-\u0004b\u0002B\u000f\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005C\u0001A\u0011AA6\u0011\u001d\u0011)\u0003\u0001C\u0001\u0003WBqA!\u000b\u0001\t\u0003\tY\u0007C\u0004\u0003.\u0001!\t!a\u001b\t\u000f\tE\u0002\u0001\"\u0001\u0002l!9!Q\u0007\u0001\u0005\u0002\u0005-\u0004b\u0002B\u001d\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005{\u0001A\u0011AA6\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0003WBqA!\u0012\u0001\t\u0003\tY\u0007C\u0004\u0003J\u0001!\t!a\u001b\t\u000f\t5\u0003\u0001\"\u0001\u0002l!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B8\u0001\u0011\u0005!\u0011O\u0004\b\u00053S\u0004\u0012\u0001BN\r\u0019I$\b#\u0001\u0003\u001e\"1AK\rC\u0001\u0005KC\u0011Ba*3\u0005\u0004%\tA!+\t\u0011\t=&\u0007)A\u0005\u0005WC\u0011B!-3\u0005\u0004%\tA!+\t\u0011\tM&\u0007)A\u0005\u0005WCqA!.3\t\u0003\u00119L\u0001\tM_>\\W\u000f\u001d&pS:LEkQ1tK*\u00111\bP\u0001\u0005U>LgN\u0003\u0002>}\u0005\u00191/\u001d7\u000b\u0005}\u0002\u0015!\u00022bi\u000eD'BA!C\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0011#\u0002\u000fAd\u0017M\u001c8fe*\u0011QIR\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f\"\u000bQA\u001a7j].T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011C\u0001\u0001O!\ty%+D\u0001Q\u0015\t\t\u0006)A\u0003vi&d7/\u0003\u0002T!\ni!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001,\u0011\u0005]\u0003Q\"\u0001\u001e\u0002\u0017%\u001c\u0018i]=oG6{G-Z\u000b\u00025B\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n9!i\\8mK\u0006t\u0017aD5t\u0003NLhnY'pI\u0016|F%Z9\u0015\u0005\t,\u0007CA.d\u0013\t!GL\u0001\u0003V]&$\bb\u00024\u0004\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\n\u0014\u0001D5t\u0003NLhnY'pI\u0016\u0004\u0003\u0006\u0002\u0003jkZ\u0004\"A[:\u000e\u0003-T!\u0001\\7\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\tqw.\u0001\u0006fqR,gn]5p]NT!\u0001]9\u0002\u000b),h.\u001b;\u000b\u0005I4\u0015!\u0003;fgR,H/\u001b7t\u0013\t!8NA\u0005QCJ\fW.\u001a;fe\u0006)a/\u00197vKv\t\u0001!A\u0005dC\u000eDW\rV=qKV\t\u0011\u0010E\u0002{\u0003Sq1a_A\u0012\u001d\ra\u0018Q\u0004\b\u0004{\u0006]ab\u0001@\u0002\u00149\u0019q0!\u0005\u000f\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tiA\u0004\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001T\u0001\u0007yI|w\u000e\u001e \n\u0003-K!!\u0013&\n\u0005\u001dC\u0015BA#G\u0013\r\t)\u0002R\u0001\nG>tg.Z2u_JLA!!\u0007\u0002\u001c\u000511o\\;sG\u0016T1!!\u0006E\u0013\u0011\ty\"!\t\u0002\r1|wn[;q\u0015\u0011\tI\"a\u0007\n\t\u0005\u0015\u0012qE\u0001\u000e\u0019>|7.\u001e9PaRLwN\\:\u000b\t\u0005}\u0011\u0011E\u0005\u0005\u0003W\tiCA\bM_>\\W\u000f]\"bG\",G+\u001f9f\u0015\u0011\t)#a\n\u0002\u001b\r\f7\r[3UsB,w\fJ3r)\r\u0011\u00171\u0007\u0005\bM\u001a\t\t\u00111\u0001z\u0003)\u0019\u0017m\u00195f)f\u0004X\r\t\u0015\u0006\u000f%,\u0018\u0011H\u000f\u0002\u0003\u0005!A-\u0019;b+\t\ty\u0004\u0005\u0004\u0002B\u0005-\u0013qJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013b\u0016AC2pY2,7\r^5p]&!\u0011QJA\"\u0005\u0011a\u0015n\u001d;\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016G\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI&a\u0015\u0003\u0007I{w/A\u0003eCR\f\u0007%\u0001\u0007eCR\fw+\u001b;i\u001dVdG.A\u0007eCR\fw+\u001b;i\u001dVdG\u000eI\u0001\tkN,'\u000fR1uC\u0006IQo]3s\t\u0006$\u0018\rI\u0001\u0011kN,'\u000fR1uC^KG\u000f\u001b(vY2\f\u0011#^:fe\u0012\u000bG/Y,ji\"tU\u000f\u001c7!\u0003\u0019\u0011WMZ8sKR\t!\rK\u0002\u0011\u0003_\u0002B!!\u001d\u0002~5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0002ba&TA!!\u001f\u0002|\u00059!.\u001e9ji\u0016\u0014(B\u00019K\u0013\u0011\ty(a\u001d\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0003bMR,'\u000fK\u0002\u0012\u0003\u000b\u0003B!!\u001d\u0002\b&!\u0011\u0011RA:\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\tde\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016$RBYAH\u0003G\u000b),!/\u0002>\u0006\u0005\u0007bBAI%\u0001\u0007\u00111S\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B!!&\u0002\u001e:!\u0011qSAM!\r\t)\u0001X\u0005\u0004\u00037c\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0006\u0005&AB*ue&twMC\u0002\u0002\u001crCq!a\u000f\u0013\u0001\u0004\t)\u000b\u0005\u0004\u0002(\u0006E\u0016q\n\b\u0005\u0003S\u000biK\u0004\u0003\u0002\u0006\u0005-\u0016\"A/\n\u0007\u0005=F,A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u00131\u0017\u0006\u0004\u0003_c\u0006\u0002CA\\%A\u0005\t\u0019\u0001.\u0002'\u0015t\u0017M\u00197f\u0007V\u001cHo\\7TQV4g\r\\3\t\u0011\u0005m&\u0003%AA\u0002i\u000b!dY;ti>l7\u000b[;gM2,G)\u001a;fe6Lg.[:uS\u000eD\u0001\"a0\u0013!\u0003\u0005\rAW\u0001\u001eGV\u001cHo\\7TQV4g\r\\3F[B$\u0018\u0010U1si&$\u0018n\u001c8fe\"A\u00111\u0019\n\u0011\u0002\u0003\u0007!,\u0001\u000bdkN$x.\\*ik\u001a4G.Z,ji\",FIR\u0001\u001cGJ,\u0017\r^3M_>\\W\u000f\u001d+bE2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%'f\u0001.\u0002L.\u0012\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003%)hn\u00195fG.,GMC\u0002\u0002Xr\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY.!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ede\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016$C-\u001a4bk2$H\u0005N\u0001\u001cGJ,\u0017\r^3M_>\\W\u000f\u001d+bE2,G\u0005Z3gCVdG\u000fJ\u001b\u00027\r\u0014X-\u0019;f\u0019>|7.\u001e9UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00137\u0003\r\u001a'/Z1uK2{wn[;q)\u0006\u0014G.Z,ji\"\u001cu.\u001c9vi\u0016$7i\u001c7v[:$RAYAt\u0003SDq!!%\u0018\u0001\u0004\t\u0019\nC\u0004\u0002<]\u0001\r!!*\u0002\u001f\u001d,GoQ1dQ\u0016|\u0005\u000f^5p]N$\"!a%\u0002\u001f\r\u0014X-\u0019;f'\u000e\fg\u000eV1cY\u0016$RAYAz\u0003kDq!!%\u001a\u0001\u0004\t\u0019\nC\u0004\u0002<e\u0001\r!!*\u0002WQ,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dunY1m!J,G-[2bi\u0016D3AGA~!\u0011\t\t(!@\n\t\u0005}\u00181\u000f\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001\u0016i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\rY\u00121`\u0001\"i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eU;tQ\u0012{wO\u001c\u0015\u00049\u0005m\u0018a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tuN\\#rk\u0006dg)\u001b7uKJD3!HA~\u0003\t\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&4\u0015.\u001a7eg\"\u001aa$a?\u0002SQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS\u001aKW\r\u001c3t/&$\b.\u00163gQ\ry\u00121`\u0001&i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mIND3\u0001IA~\u0003e!Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0007\u0005\nY0A\u0019uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2$\u0015\r^1)\u0007\t\nY0A\u001buKN$H*\u001a4u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"tU\u000f\u001c7ECR\f\u0007fA\u0012\u0002|\u00061C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\u001c(vY2\u001cuN\\:uC:$8*Z=)\u0007\u0011\nY0\u0001\u001duKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2\u001cuN\\:uC:$8*Z=)\u0007\u0015\nY0A\u0014uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0007f\u0001\u0014\u0002|\u0006\u0011D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7o\u0003:$\u0007+^:i\t><h\u000eK\u0002(\u0003w\fA\u0005^3ti2{wn[;q\u0007\u0006\u001c\u0007.Z*iCJLgnZ!de>\u001c8oU;ci\u0006\u001c8n\u001d\u0015\u0004Q\u0005m\u0018\u0001\r;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dun\\6va\"Kg\u000e^#oC\ndWm\u00155vM\u001adW\rK\u0002*\u0003w\fa\b^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{wn[;q\u0011&tG/\u00128bE2,7\u000b[;gM2,wJ\u001c(pe6\fGnU8ve\u000e,\u0007f\u0001\u0016\u0002|\u0006\u0001E/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0019>|7.\u001e9IS:$XI\\1cY\u0016tuN\u001c#fi\u0016\u0014X.\u001b8jgRL7m\u00155vM\u001adW\rK\u0002,\u0003w\fq\t^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{wn[;q\u0011&tG/\u00128bE2,7\u000b[;gM2,wJ\\!mY\u000e{gn\u001d;b]Rdun\\6va.+\u0017p\u001d\u0015\u0004Y\u0005m\u0018\u0001\u0011;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dun\\6va\"Kg\u000e^#oC\ndWm\u00155vM\u001adW-R7qif\u0004\u0016M\u001d;ji&|g.\u001a:)\u00075\nY0\u0001\u001euKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\8lkBD\u0015N\u001c;F]\u0006\u0014G.Z*ik\u001a4G.Z,ji\"|W\u000f^+E\r\"\u001aa&a?\u0002\u0005)LG\u0003\u0002B+\u0005K\u0002BAa\u0016\u0003b5\u0011!\u0011\f\u0006\u0005\u00057\u0012i&\u0001\u0003mC:<'B\u0001B0\u0003\u0011Q\u0017M^1\n\t\t\r$\u0011\f\u0002\b\u0013:$XmZ3s\u0011\u001d\u00119g\fa\u0001\u0005S\n\u0011!\u001b\t\u00047\n-\u0014b\u0001B79\n\u0019\u0011J\u001c;\u0002\u0005)dG\u0003\u0002B:\u0005s\u0002BAa\u0016\u0003v%!!q\u000fB-\u0005\u0011auN\\4\t\u000f\tm\u0004\u00071\u0001\u0003~\u0005\tA\u000eE\u0002\\\u0005\u007fJ1Aa\u001e]Q\u0019\u0001!1Q;\u0003\u0010B!!Q\u0011BF\u001b\t\u00119I\u0003\u0003\u0003\n\u0006M\u0014!C3yi\u0016t7/[8o\u0013\u0011\u0011iIa\"\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0003\u0012\u000e\u0012!1\u0013\t\u0004U\nU\u0015b\u0001BLW\nQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u0006\u0001Bj\\8lkBTu.\u001b8J)\u000e\u000b7/\u001a\t\u0003/J\u001a2A\rBP!\rY&\u0011U\u0005\u0004\u0005Gc&AB!osJ+g\r\u0006\u0002\u0003\u001c\u0006Q\u0011iU-O\u0007~ku\nR#\u0016\u0005\t-\u0006\u0003\u0002B,\u0005[K1a\u0018B-\u0003-\t5+\u0017(D?6{E)\u0012\u0011\u0002\u0013MKfjQ0N\u001f\u0012+\u0015AC*Z\u001d\u000e{Vj\u0014#FA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\te\u0006C\u0002B^\u0005\u0003\u0014)-\u0004\u0002\u0003>*!!q\u0018B/\u0003\u0011)H/\u001b7\n\t\t\r'Q\u0018\u0002\u000b\u0007>dG.Z2uS>t\u0007#B.\u0003H\n-\u0017b\u0001Be9\n)\u0011I\u001d:bsB!!q\u000bBg\u0013\u0011\u0011yM!\u0017\u0003\r=\u0013'.Z2uQ\u001dA$1\u001bBm\u00057\u00042A\u001bBk\u0013\r\u00119n\u001b\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#A!8\u0002E%\u001b\u0018i]=oG6{G-\u001a\u0011>Am\u0004T\u0010\f\u0011dC\u000eDW\rV=qK\u0002j\u0004e_\u0019~\u0001")
public class LookupJoinITCase
extends BatchTestBase {
    @Parameter(value=0)
    private boolean isAsyncMode;
    @Parameter(value=1)
    private LookupOptions.LookupCacheType cacheType;
    private final List<Row> data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)12L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$)))));
    private final List<Row> dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$))));
    private final List<Row> userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
    private final List<Row> userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));

    @Parameters(name="IsAsyncMode = {0}, cacheType = {1}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean SYNC_MODE() {
        return LookupJoinITCase$.MODULE$.SYNC_MODE();
    }

    public static Boolean ASYNC_MODE() {
        return LookupJoinITCase$.MODULE$.ASYNC_MODE();
    }

    public boolean isAsyncMode() {
        return this.isAsyncMode;
    }

    public void isAsyncMode_$eq(boolean x$1) {
        this.isAsyncMode = x$1;
    }

    public LookupOptions.LookupCacheType cacheType() {
        return this.cacheType;
    }

    public void cacheType_$eq(LookupOptions.LookupCacheType x$1) {
        this.cacheType = x$1;
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        TestValuesTableFactory.RESOURCE_COUNTER.set(0);
        FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.set(0);
        this.createScanTable("T", this.data());
        this.createScanTable("nullableT", this.dataWithNull());
        this.createLookupTable("user_table_custom_shuffle", this.userData(), true, this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6());
        this.createLookupTable("user_table_custom_shuffle_non_deterministic", this.userData(), true, false, this.createLookupTable$default$5(), this.createLookupTable$default$6());
        String x$1 = "user_table_custom_shuffle_empty_partitioner";
        List<Row> x$2 = this.userData();
        boolean x$3 = true;
        boolean x$4 = true;
        boolean x$5 = this.createLookupTable$default$4();
        boolean x$6 = this.createLookupTable$default$6();
        this.createLookupTable(x$1, x$2, x$3, x$5, x$4, x$6);
        String x$7 = "user_table_custom_shuffle_without_udf";
        List<Row> x$8 = this.userData();
        boolean x$9 = true;
        boolean x$10 = false;
        boolean x$11 = this.createLookupTable$default$4();
        boolean x$12 = this.createLookupTable$default$5();
        this.createLookupTable(x$7, x$8, x$9, x$11, x$12, x$10);
        this.createLookupTable("userTable", this.userData(), this.createLookupTable$default$3(), this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6());
        this.createLookupTable("userTableWithNull", this.userDataWithNull(), this.createLookupTable$default$3(), this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
        this.env().getConfig().disableObjectReuse();
    }

    @Override
    @AfterEach
    public void after() {
        Assertions.assertThat((int)TestValuesTableFactory.RESOURCE_COUNTER.get()).isEqualTo(0);
        Assertions.assertThat((int)FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.get()).isEqualTo(0);
    }

    private void createLookupTable(String tableName, List<Row> data, boolean enableCustomShuffle, boolean customShuffleDeterministic, boolean customShuffleEmptyPartitioner, boolean customShuffleWithUDF) {
        String dataId = TestValuesTableFactory.registerData(data);
        String cacheOptions = this.getCacheOptions();
        if (!enableCustomShuffle) {
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode()).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            return;
        }
        if (customShuffleEmptyPartitioner || !customShuffleWithUDF) {
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(627).append("\n                           |CREATE TABLE ").append(tableName).append(" (\n                           |  `age` INT,\n                           |  `id` BIGINT,\n                           |  `name` STRING\n                           |) WITH (\n                           |  ").append(cacheOptions).append("\n                           |  'connector' = 'values',\n                           |  'data-id' = '").append(dataId).append("',\n                           |  'async' = '").append(this.isAsyncMode()).append("',\n                           |  'bounded' = 'true',\n                           |  'enable-custom-shuffle' = 'true',\n                           |  'custom-shuffle-empty-partitioner' = '").append(customShuffleEmptyPartitioner).append("'\n                           |)\n                           |").toString())).stripMargin());
            return;
        }
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(473).append("\n             |CREATE TABLE ").append(tableName).append(" (\n             |  `age` INT,\n             |  `id` BIGINT,\n             |  `name` STRING\n             |) WITH (\n             |  ").append(cacheOptions).append("\n             |  'connector' = 'values',\n             |  'data-id' = '").append(dataId).append("',\n             |  'async' = '").append(this.isAsyncMode()).append("',\n             |  'bounded' = 'true',\n             |  'enable-custom-shuffle' = 'true',\n             |  'lookup-function-class' = '").append(new SingleSubTaskBoundTableFunction().getClass().getName()).append("',\n             |  'custom-shuffle-deterministic' = '").append(customShuffleDeterministic).append("'\n             |)\n             |").toString())).stripMargin());
    }

    private boolean createLookupTable$default$3() {
        return false;
    }

    private boolean createLookupTable$default$4() {
        return true;
    }

    private boolean createLookupTable$default$5() {
        return false;
    }

    private boolean createLookupTable$default$6() {
        return true;
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        String cacheOptions = this.getCacheOptions();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(496).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `age` INT,\n                       |  `id` BIGINT,\n                       |  `name` STRING,\n                       |  `nominal_age` as age + 1\n                       |) WITH (\n                       |  ").append(cacheOptions).append("\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'async' = '").append(this.isAsyncMode()).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
    }

    private String getCacheOptions() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType();
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(53).append("\n         |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n         |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n         |").toString())).stripMargin();
        }
        LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType();
        LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
        if (!(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n         |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n         |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n         |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n         |").toString())).stripMargin();
        }
        return "";
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(492).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` BIGINT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'runtime-source' ='NewSource',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testLeftJoinTemporalTableWithLocalPredicate() {
        String sql = new StringBuilder(190).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id ").append("AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' ").append("WHERE T.id > 1").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), "Hello world", null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), "Hello world!", null, null})), (List)Nil$.MODULE$))));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTable() {
        String sql = new StringBuilder(112).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"})), (List)Nil$.MODULE$)));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithPushDown() {
        String sql = new StringBuilder(127).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"})), (List)Nil$.MODULE$));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = new StringBuilder(140).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)})), (List)Nil$.MODULE$));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)Nil$.MODULE$));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiFieldsWithUdf() {
        String sql = new StringBuilder(132).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON mod(T.id, 4) = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)Nil$.MODULE$));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)Nil$.MODULE$));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinTemporalTable() {
        String sql = new StringBuilder(113).append("SELECT T.id, T.len, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", BoxesRunTime.boxToInteger((int)11)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Jark", BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", BoxesRunTime.boxToInteger((int)33)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), null, null})), (List)Nil$.MODULE$)))));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(142).append("SELECT T.id, T.len, D.name FROM nullableT T JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(147).append("SELECT D.id, T.len, D.name FROM nullableT T LEFT JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)12), null})), (List)Nil$.MODULE$))));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = new StringBuilder(104).append("SELECT T.id, T.len, T.content FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON D.id = null").toString();
        Seq expected = (Seq)Nil$.MODULE$;
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id").toString();
        Seq expected = (Seq)Nil$.MODULE$;
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumn() {
        String sql = new StringBuilder(152).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)12)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)})), (List)Nil$.MODULE$)));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        String sql = new StringBuilder(175).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)})), (List)Nil$.MODULE$));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testLookupCacheSharingAcrossSubtasks() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType();
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.NONE;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE datagen_source (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6',\n           |  'number-of-rows' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM datagen_source as T \n          |LEFT JOIN userTable FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            this.executeQuery(this.parseQuery(sql));
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType();
            LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.PARTIAL;
            int numEntries = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? 6 : this.userData().size();
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo((long)numEntries);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffle() {
        String sql = new StringBuilder(192).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM ").append("T JOIN user_table_custom_shuffle ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Fabian' AND D.age = 33").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "Fabian"})), (List)Nil$.MODULE$)))));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleOnNormalSource() {
        String sql = new StringBuilder(139).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM ").append("T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Julian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Jark"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Fabian"})), (List)Nil$.MODULE$)));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableNonDeterministicShuffle() {
        String sql = new StringBuilder(210).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM ").append("T JOIN user_table_custom_shuffle_non_deterministic ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Fabian' AND D.age = 33").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "Fabian"})), (List)Nil$.MODULE$)))));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleOnAllConstantLookupKeys() {
        String sql = new StringBuilder(189).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM ").append("T JOIN user_table_custom_shuffle ").append("for system_time as of T.proctime AS D ON D.id = 1 AND D.name = 'Fabian' AND D.age = 33").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "Fabian"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "Fabian"})), (List)Nil$.MODULE$)))));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleEmptyPartitioner() {
        String sql = new StringBuilder(210).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM ").append("T JOIN user_table_custom_shuffle_empty_partitioner ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Fabian' AND D.age = 33").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Fabian"})), (List)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleWithoutUDF() {
        String sql = new StringBuilder(204).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM ").append("T JOIN user_table_custom_shuffle_without_udf ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Fabian' AND D.age = 33").toString();
        Seq expected = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Fabian"})), (List)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }
}

