/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u001e=\u0001=CQA\u0016\u0001\u0005\u0002]C\u0011B\u0017\u0001A\u0002\u0003\u0007I\u0011A.\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0003I\bBCA\u0003\u0001\u0001\u0007\t\u0011)Q\u00059\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA\u001d\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u0007\u0002A\u0011AA\u0012\u0011\u001d\t9\u0005\u0001C\u0001\u0003GAq!a\u0013\u0001\t\u0003\t\u0019\u0003C\u0004\u0002P\u0001!\t!a\t\t\u000f\u0005M\u0003\u0001\"\u0001\u0002$!9\u0011q\u000b\u0001\u0005\u0002\u0005\r\u0002bBA.\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003?\u0002A\u0011AA\u0012\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003GAq!a\u001a\u0001\t\u0003\t\u0019\u0003C\u0004\u0002l\u0001!\t!a\t\t\u000f\u0005=\u0004\u0001\"\u0001\u0002$!9\u00111\u000f\u0001\u0005\u0002\u0005\r\u0002bBA<\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003w\u0002A\u0011AA\u0012\u0011\u001d\ty\b\u0001C\u0001\u0003GAq!a!\u0001\t\u0003\t\u0019\u0003C\u0004\u0002\b\u0002!\t!a\t\t\u000f\u0005-\u0005\u0001\"\u0001\u0002$!9\u0011q\u0012\u0001\u0005\u0002\u0005\r\u0002bBAJ\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003/\u0003A\u0011AA\u0012\u0011\u001d\tY\n\u0001C\u0001\u0003GAq!a(\u0001\t\u0003\t\u0019\u0003C\u0004\u0002$\u0002!\t!a\t\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002$!9\u00111\u0016\u0001\u0005\u0002\u0005\r\u0002bBAX\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003g\u0003A\u0011AA\u0012\u0011\u001d\t9\f\u0001C\u0001\u0003GAq!a/\u0001\t\u0003\t\u0019\u0003C\u0004\u0002@\u0002!\t!a\t\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002$!9\u0011q\u0019\u0001\u0005\u0002\u0005\r\u0002bBAf\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u001f\u0004A\u0011AA\u0012\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003GAq!a6\u0001\t\u0003\t\u0019\u0003C\u0004\u0002\\\u0002!\t!a\t\t\u000f\u0005}\u0007\u0001\"\u0001\u0002$!9\u00111\u001d\u0001\u0005\u0002\u0005\r\u0002bBAt\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003W\u0004A\u0011AA\u0012\u0011\u001d\ty\u000f\u0001C\u0001\u0003GAq!a=\u0001\t\u0003\t\u0019\u0003C\u0004\u0002x\u0002!\t!a\t\t\u000f\u0005m\b\u0001\"\u0001\u0002$!9\u0011q \u0001\u0005\u0002\u0005\rra\u0002B\u000fy!\u0005!q\u0004\u0004\u0007wqB\tA!\t\t\rYCD\u0011\u0001B\u0015\u0011\u001d\u0011Y\u0003\u000fC\u0001\u0005[\u0011!BS8j]&#6)Y:f\u0015\tid(\u0001\u0003k_&t'BA A\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0003\n\u000bQAY1uG\"T!a\u0011#\u0002\u000fI,h\u000e^5nK*\u0011QIR\u0001\ba2\fgN\\3s\u0015\t9\u0005*A\u0003uC\ndWM\u0003\u0002J\u0015\u0006)a\r\\5oW*\u00111\nT\u0001\u0007CB\f7\r[3\u000b\u00035\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005M\u0013\u0015!B;uS2\u001c\u0018BA+S\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\u0017\t\u00033\u0002i\u0011\u0001P\u0001\u0011Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016,\u0012\u0001\u0018\t\u0003;Vt!AX:\u000f\u0005}\u0013hB\u00011r\u001d\t\t\u0007O\u0004\u0002c_:\u00111M\u001c\b\u0003I6t!!\u001a7\u000f\u0005\u0019\\gBA4k\u001b\u0005A'BA5O\u0003\u0019a$o\\8u}%\tQ*\u0003\u0002L\u0019&\u0011\u0011JS\u0005\u0003\u000f\"K!!\u0012$\n\u0005\r#\u0015BA!C\u0013\ty\u0004)\u0003\u0002>}%\u0011A\u000fP\u0001\t\u0015>Lg\u000eV=qK&\u0011ao\u001e\u0002\t\u0015>Lg\u000eV=qK*\u0011A\u000fP\u0001\u0015Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016|F%Z9\u0015\u0007i\f\t\u0001\u0005\u0002|}6\tAPC\u0001~\u0003\u0015\u00198-\u00197b\u0013\tyHP\u0001\u0003V]&$\b\u0002CA\u0002\u0007\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'A\tfqB,7\r^3e\u0015>Lg\u000eV=qK\u0002B3\u0001BA\u0005!\u0011\tY!!\b\u000e\u0005\u00055!\u0002BA\b\u0003#\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA\n\u0003+\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\u0011\t9\"!\u0007\u0002\u000b),h.\u001b;\u000b\u0007\u0005m\u0001*A\u0005uKN$X\u000f^5mg&!\u0011qDA\u0007\u0005%\u0001\u0016M]1nKR,'/\u0001\u0004cK\u001a|'/\u001a\u000b\u0002u\"\u001aQ!a\n\u0011\t\u0005%\u0012QG\u0007\u0003\u0003WQA!!\f\u00020\u0005\u0019\u0011\r]5\u000b\t\u0005E\u00121G\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9\u0002T\u0005\u0005\u0003o\tYC\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3ti*{\u0017N\u001c\u0015\u0004\r\u0005u\u0002\u0003BA\u0015\u0003\u007fIA!!\u0011\u0002,\taA+Z:u)\u0016l\u0007\u000f\\1uK\u0006AB/Z:u\u0019>twMS8j]^KG\u000f\u001b\"jOJ\u000bgnZ3)\u0007\u001d\ti$A\ruKN$Hj\u001c8h\u0011\u0006\u001c\bNS8j]\u001e+g.\u001a:bi>\u0014\bf\u0001\u0005\u0002>\u0005AB/Z:u\u001f:,7+\u001b3f'6Tg)[3mI\u0016\u0013(o\u001c:)\u0007%\ti$\u0001\fuKN$(j\\5o'\u0006lWMR5fY\u0012,\u0015/^1mQ\rQ\u0011QH\u0001\u000bi\u0016\u001cHOS8j]>s\u0007fA\u0006\u0002>\u0005\tB/Z:u\u0015>LgNT8NCR\u001c\u0007.Z:)\u00071\ti$A\u000fuKN$(j\\5o\u001d>l\u0015\r^2iKN<\u0016\u000e\u001e5Tk\n\fX/\u001a:zQ\ri\u0011QH\u0001\u0013i\u0016\u001cHOS8j]^KG\u000f\u001b$jYR,'\u000fK\u0002\u000f\u0003{\ta\u0003^3ti*{\u0017N\\,ji\"Tu.\u001b8GS2$XM\u001d\u0015\u0004\u001f\u0005u\u0012a\n;fgRLeN\\3s\u0015>LgnV5uQ\n{w\u000e\\3b]\u001aKG\u000e^3s\u0007>tG-\u001b;j_:D3\u0001EA\u001f\u0003\u0015\"Xm\u001d;J]:,'OS8j]^KG\u000f\u001b(p]\u0016\u000bX/\u001b&pS:\u0004&/\u001a3jG\u0006$X\rK\u0002\u0012\u0003{\t\u0001\u0004^3ti*{\u0017N\\,ji\"lU\u000f\u001c;ja2,7*Z=tQ\r\u0011\u0012QH\u0001\u0012i\u0016\u001cHOS8j]^KG\u000f[!mS\u0006\u001c\bfA\n\u0002>\u0005aB/Z:u\u0019\u00164GOS8j]^KG\u000f['vYRL\u0007\u000f\\3LKf\u001c\bf\u0001\u000b\u0002>\u0005yB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b(p]\u0016\u000bX/\u001b&pS:\u0004&/\u001a3)\u0007U\ti$A\u000fuKN$H*\u001a4u\u0015>LgnV5uQ2+g\r\u001e'pG\u0006d\u0007K]3eQ\r1\u0012QH\u0001\u001ei\u0016\u001cHOU5hQRTu.\u001b8XSRDW*\u001e7uSBdWmS3zg\"\u001aq#!\u0010\u0002AQ,7\u000f\u001e*jO\"$(j\\5o/&$\bNT8o\u000bF,\u0018NS8j]B\u0013X\r\u001a\u0015\u00041\u0005u\u0012A\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ2+g\r\u001e'pG\u0006d\u0007K]3eQ\rI\u0012QH\u0001\"i\u0016\u001cHOR;mY>+H/\u001a:K_&tw+\u001b;i\u001bVdG/\u001b9mK.+\u0017p\u001d\u0015\u00045\u0005u\u0012a\b;fgR4U\u000f\u001c7K_&tw+\u001b;i\u001d>tW)];j\u0015>Lg\u000e\u0015:fI\"\u001a1$!\u0010\u0002;Q,7\u000f\u001e$vY2Tu.\u001b8XSRDG*\u001a4u\u0019>\u001c\u0017\r\u001c)sK\u0012D3\u0001HA\u001f\u0003E!Xm\u001d;Gk2dw*\u001e;fe*{\u0017N\u001c\u0015\u0004;\u0005u\u0012!\t;fgR4U\u000f\u001c7PkR,'OS8j]^KG\u000f[8vi\u0016\u000bX/\u00197D_:$\u0007f\u0001\u0010\u0002>\u0005QC/Z:u'&tw\r\\3S_^4U\u000f\u001c7PkR,'OS8j]^KG\u000f[8vi\u0016\u000bX/\u00197D_:$\u0007fA\u0010\u0002>\u0005\tD/Z:u'&tw\r\\3S_^4U\u000f\u001c7PkR,'OS8j]^KG\u000f[8vi\u0016\u000bX/\u00197D_:$gj\\'bi\u000eD\u0007f\u0001\u0011\u0002>\u0005\tB/Z:u\u0019\u00164GoT;uKJTu.\u001b8)\u0007\u0005\ni$\u0001\nuKN$(+[4ii>+H/\u001a:K_&t\u0007f\u0001\u0012\u0002>\u00059B/Z:u\u0015>LgnV5uQ\u0006;wM]3hCRLwN\u001c\u0015\u0004G\u0005u\u0012!\b;fgRTu.\u001b8D_:$\u0017\u000e^5p]:+W\rZ*j[Bd\u0017NZ=)\u0007\u0011\ni$\u0001\u001euKN$(j\\5o\u0007>tG-\u001b;j_:$UM]5wK\u00124%o\\7D_J\u0014X\r\\1uK\u0012\u001cVOY)vKJLh*Z3e'&l\u0007\u000f\\5gs\"\u001aQ%!\u0010\u0002\u0015Q,7\u000f^*j[BdW\rK\u0002'\u0003{\t!\u0002^3tiN+G.Z2uQ\r9\u0013QH\u0001\u000fi\u0016\u001cHoQ8se\u0016d\u0017\r^3eQ\rA\u0013QH\u0001\u0014i\u0016\u001cHoQ8se\u0016d\u0017\r^3e\u000bbL7\u000f\u001e\u0015\u0004S\u0005u\u0012\u0001\u0006;fgR\u001cuN\u001d:fY\u0006$X\rZ#ySN$(\u0007K\u0002+\u0003{\ta\u0003^3ti\u000e{'O]3mCR,GMT8u\u000bbL7\u000f\u001e\u0015\u0004W\u0005u\u0012A\u0006;fgR,fnY8se\u0016d\u0017\r^3e'\u000e\fG.\u0019:)\u00071\ni$\u0001\fuKN$X)];bY^KG\u000f[!hON\u001b\u0017\r\\1sQ\ri\u0013QH\u0001\u0016i\u0016\u001cHoQ8na\u0006\u0014\u0018n]8ogN\u001b\u0017\r\\1sQ\rq\u0013QH\u0001\u0011i\u0016\u001cHOS8j]^KG\u000f\u001b(vY2D3aLA\u001f\u0003E!Xm\u001d;TS:<G.\u001a*po*{\u0017N\u001c\u0015\u0004a\u0005u\u0012a\b;fgRtuN\\#naRLH+\u00192mK*{\u0017N\\#naRLH+\u00192mK\"\u001a\u0011'!\u0010\u00029Q,7\u000f^#naRLH+\u00192mK*{\u0017N\\#naRLH+\u00192mK\"\u001a!'!\u0010\u0002#Q,7\u000f\u001e&pS:\u001cu\u000e\u001c7bi&|g\u000eK\u00024\u0003{\tQ\u0003^3ti*{\u0017N\\,ji\",FI\u0012$jYR,'\u000fK\u00025\u0003{\t!\u0004^3ti*{\u0017N\\,ji\"4\u0015\u000e\u001c;feB+8\u000f\u001b#po:D3!NA\u001f\u0003\u0005\"Xm\u001d;K_&tw+\u001b;i\u0015>LgnQ8oI&$\u0018n\u001c8QkNDGi\\<oQ\r1\u0014Q\b\u0015\b\u0001\t\u0015!\u0011\u0003B\n!\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003W\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\t=!\u0011\u0002\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GF\u0001B\u000bG\t\u00119\u0002\u0005\u0003\u0002\f\te\u0011\u0002\u0002B\u000e\u0003\u001b\u0011!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\f!BS8j]&#6)Y:f!\tI\u0006hE\u00029\u0005G\u00012a\u001fB\u0013\u0013\r\u00119\u0003 \u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t}\u0011A\u00039be\u0006lW\r^3sgR\u0011!q\u0006\t\u0007\u0005c\u0011YDa\u0010\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\tA!\u001e;jY*\u0011!\u0011H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003>\tM\"AC\"pY2,7\r^5p]B\u00191P!\u0011\n\u0007\t\rCPA\u0002B]fDsA\u000fB$\u0005\u001b\u0012y\u0005\u0005\u0003\u0002\f\t%\u0013\u0002\u0002B&\u0003\u001b\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\tE\u0013\u0001F3ya\u0016\u001cG/\u001a3K_&tG+\u001f9f{m\u0004T\u0010")
public class JoinITCase
extends BatchTestBase {
    @Parameter
    private Enumeration.Value expectedJoinType;

    @Parameters(name="expectedJoinType={0}")
    public static Collection<Object> parameters() {
        return JoinITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String smallData3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String data3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data3());
        String nullData3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.nullData3());
        String data5Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data5());
        String nullData5Id = TestValuesTableFactory.registerData(TestData$.MODULE$.nullData5());
        String data21Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data2_1());
        String data22Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data2_2());
        String data23Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data2_3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("CREATE TEMPORARY TABLE SmallTable3 (\n                       | a int,\n                       | b bigint,\n                       | c string\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(smallData3Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("CREATE TEMPORARY TABLE Table3 (\n                       | a int,\n                       | b bigint,\n                       | c string\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data3Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(355).append("CREATE TEMPORARY TABLE NullTable3 (\n                       | a int,\n                       | b bigint,\n                       | c string\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(nullData3Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(417).append("CREATE TEMPORARY TABLE Table5(\n                       | d int,\n                       | e bigint,\n                       | f int,\n                       | g string,\n                       | h bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data5Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(421).append("CREATE TEMPORARY TABLE NullTable5(\n                       | d int,\n                       | e bigint,\n                       | f int,\n                       | g string,\n                       | h bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(nullData5Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("CREATE TEMPORARY TABLE l(\n                       | a int,\n                       | b double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data21Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("CREATE TEMPORARY TABLE r(\n                       | c int,\n                       | d double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data22Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("CREATE TEMPORARY TABLE t(\n                       | c int,\n                       | d double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data23Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLongJoinWithBigRange() {
        Seq data1 = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$));
        Seq data2 = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$));
        String inputDataId1 = TestValuesTableFactory.registerData((Seq<Row>)data1);
        String inputDataId2 = TestValuesTableFactory.registerData((Seq<Row>)data2);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("CREATE TEMPORARY TABLE inputT1(\n                       | a bigint,\n                       | b double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(inputDataId1).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("CREATE TEMPORARY TABLE inputT2(\n                       | c bigint,\n                       | d double\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(inputDataId2).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("SELECT a, b, c, d FROM inputT1, inputT2 WHERE a = c", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLongHashJoinGenerator() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.HashJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.NONE);
            this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.NONE);
            TestSinkUtil$.MODULE$.addValuesSink(this.tEnv(), "outputTable", (List<String>)new .colon.colon((Object)"c", (List)Nil$.MODULE$), (List<DataType>)new .colon.colon((Object)DataTypes.STRING(), (List)Nil$.MODULE$), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
            StatementSet stmtSet = this.tEnv().createStatementSet();
            Table table = this.tEnv().sqlQuery("SELECT c FROM SmallTable3, Table5 WHERE b = e");
            stmtSet.addInsert("outputTable", table);
            TestingTableEnvironment testingTEnv = (TestingTableEnvironment)this.tEnv();
            StatementSetImpl testingStmtSet = (StatementSetImpl)stmtSet;
            java.util.List transforms = ((PlannerBase)testingTEnv.getPlanner()).translate(testingStmtSet.getOperations());
            BooleanRef haveTwoOp = BooleanRef.create((boolean)false);
            ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(transforms).map((Function1 & Serializable & scala.Serializable)t -> this.findTwoInputTransform$1((Transformation)t), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)transform -> {
                JoinITCase.$anonfun$testLongHashJoinGenerator$2(haveTwoOp, transform);
                return BoxedUnit.UNIT;
            });
            Assertions.assertThat((boolean)haveTwoOp.elem).isTrue();
            return;
        }
    }

    @TestTemplate
    public void testOneSideSmjFieldError() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            String smallData3Id = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(377).append("CREATE TEMPORARY TABLE PojoSmallTable3(\n                         | a int,\n                         | b bigint,\n                         | c string\n                         |)WITH(\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(smallData3Id).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            String data5Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data5());
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(443).append("CREATE TEMPORARY TABLE PojoTable5(\n                         | d int,\n                         | e bigint,\n                         | f int,\n                         | g string,\n                         | h bigint\n                         |)WITH(\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(data5Id).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            this.checkResult("SELECT c, g FROM (SELECT h, g, f, e, d FROM PojoSmallTable3, PojoTable5 WHERE b = e), PojoSmallTable3 WHERE b = e", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testJoinSameFieldEqual() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e and b = h", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinOn() {
        this.checkResult("SELECT c, g FROM SmallTable3 JOIN Table5 ON b = e", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinNoMatches() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 where c = g", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinNoMatchesWithSubquery() {
        this.checkResult("SELECT c, g FROM (SELECT * FROM SmallTable3 WHERE b>2), (SELECT * FROM Table5 WHERE e>2) WHERE b = e", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithFilter() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e AND b < 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithJoinFilter() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInnerJoinWithBooleanFilterCondition() {
        Seq data1 = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi", BoxesRunTime.boxToBoolean((boolean)true)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello", BoxesRunTime.boxToBoolean((boolean)false)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world", BoxesRunTime.boxToBoolean((boolean)true)})), (List)Nil$.MODULE$)));
        String data1Id = TestValuesTableFactory.registerData((Seq<Row>)data1);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(390).append("CREATE TEMPORARY TABLE table5(\n                       | a1 int,\n                       | b1 bigint,\n                       | c1 string,\n                       | d1 boolean\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data1Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(390).append("CREATE TEMPORARY TABLE table6(\n                       | a2 int,\n                       | b2 bigint,\n                       | c2 string,\n                       | d2 boolean\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data1Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("SELECT a1, a1, c2 FROM table5 INNER JOIN table6 ON d1 = d2 where d1 is true", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, 1, Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, 1, Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, 3, Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, 3, Hi"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInnerJoinWithNonEquiJoinPredicate() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6 AND h < b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE a = d AND b = h", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithAlias() {
        String data1Id = TestValuesTableFactory.registerData(TestData$.MODULE$.data5());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(422).append("CREATE TEMPORARY TABLE AliasTable5(\n                       | d int,\n                       | e bigint,\n                       | f int,\n                       | g string,\n                       | c bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(data1Id).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("SELECT AliasTable5.c, T.`1-_./\u00dc` FROM (SELECT a, b, c AS `1-_./\u00dc` FROM Table3) AS T, AliasTable5 WHERE a = d AND a < 4", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "Hello world"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testLeftJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 RIGHT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFullOuterJoinWithMultipleKeys() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
                return;
            }
        }
    }

    @TestTemplate
    public void testFullJoinWithNonEquiJoinPred() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
                return;
            }
        }
    }

    @TestTemplate
    public void testFullJoinWithLeftLocalPred() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b >= 2 and h = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
                return;
            }
        }
    }

    @TestTemplate
    public void testFullOuterJoin() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType();
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM SmallTable3 FULL OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
                return;
            }
        }
    }

    @TestTemplate
    public void testFullOuterJoinWithoutEqualCond() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT t1.c, t2.c FROM SmallTable3 t1 FULL OUTER JOIN SmallTable3 t2 ON t1.b > t2.b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello world"})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testSingleRowFullOuterJoinWithoutEqualCond() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT min(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testSingleRowFullOuterJoinWithoutEqualCondNoMatch() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT max(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hi"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testLeftOuterJoin() {
        this.checkResult("SELECT c, g FROM Table5 LEFT OUTER JOIN SmallTable3 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testRightOuterJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3 RIGHT OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithAggregation() {
        this.checkResult("SELECT COUNT(g), COUNT(b) FROM SmallTable3, Table5 WHERE a = d", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), BoxesRunTime.boxToLong((long)6L)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionNeedSimplify() {
        this.checkResult("SELECT A.d FROM Table5 A JOIN SmallTable3 B ON (A.d=B.a and B.a>2) or (A.d=B.a and B.b=1)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionDerivedFromCorrelatedSubQueryNeedSimplify() {
        this.checkResult("SELECT B.a FROM SmallTable3 B WHERE b = (select count(*) from Table5 A where (A.d=B.a and A.d<3) or (A.d=B.a and B.b=5))", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSimple() {
        this.checkResult("select a, b from l where a in (select c from r where c > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSelect() {
        this.checkResult("select t.a from (select 1 as a)t", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testCorrelated() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("select t.a from (select l.a from l, r where l.a = r.c and l.a = 6)t", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testCorrelatedExist() {
        this.checkResult("select * from l where exists (select * from r where l.a = r.c)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult("select * from l where exists (select * from r where l.a = r.c) and l.a <= 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testCorrelatedExist2() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123456L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-123456L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Integer.MAX_VALUE)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-2147483647L)})), (List)Nil$.MODULE$)))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(280).append("CREATE TEMPORARY TABLE t1(\n                       | f1 bigint\n                       |)WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult("select * from t1 o where exists (select 1 from t1 i where i.f1=o.f1 limit 0)", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @TestTemplate
    public void testCorrelatedNotExist() {
        this.checkResult("select * from l where not exists (select * from r where l.a = r.c and l.b <> r.d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testUncorrelatedScalar() {
        this.checkResult("select (select 1) as b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("select (select 1 as b)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("select (select 1 as a) as b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testEqualWithAggScalar() {
        this.checkResult("select a, b from l where a = (select distinct (c) from r where c = 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComparisonsScalar() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkEmptyResult("select a, b from l where a = (select c from r where 1 = 2)");
            Row row = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row2 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row3 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}));
            Row row4 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}));
            this.checkResult("select a, b from l where a >= 1.0 * (select avg(d) from r where c > 2)", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row), this.checkResult$default$3());
        }
        Row row = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        Row row5 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        this.checkResult("select a, b from l where a * b < 2.0 * (select avg(d) from r where l.a = r.c and c < 6 )", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithNull() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) and c = 'NullTuple'", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "c"})), (List)Nil$.MODULE$)));
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(367).append("CREATE TEMPORARY TABLE NullT(\n                         | a int,\n                         | b bigint,\n                         | c string\n                         |)WITH(\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
            this.checkResult("SELECT T1.a, T1.b, T1.c FROM NullT T1, NullT T2 WHERE (T1.a = T2.a OR (T1.a IS NULL AND T2.a IS NULL)) AND (T1.b = T2.b OR (T1.b IS NULL AND T2.b IS NULL)) AND T1.c = T2.c", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"null", "null", "c"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testSingleRowJoin() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON true", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON s <> b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON s <> b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testNonEmptyTableJoinEmptyTable() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 FULL JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN SmallTable3 ON true", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testEmptyTableJoinEmptyTable() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testJoinCollation() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.a AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.b AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.b = t2.b\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithUDFFilter() {
        this.tEnv().createTemporarySystemFunction("funcWithOpen", (UserDefinedFunction)new FuncWithOpen());
        this.checkResult("SELECT c, g FROM SmallTable3 join Table5 on funcWithOpen(a + d) where b = e", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithFilterPushDown() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 where c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l inner join r on a = c where c IS NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l inner join r on a = c where c = NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n          |select * from\n          | l inner join r on a = c where c = 3\n          |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n          |select * from\n          | l left join r on a = c where c = 3\n          |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        }
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c IS NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c IS NULL AND a <= 1\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), null, null})), (List)Nil$.MODULE$))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c = NULL\n        |")).stripMargin(), (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c < 3 AND a <= 3\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        | l left join r on a = c where c <> 3 AND a <= 3\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinWithJoinConditionPushDown() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  left join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2), null, null, null})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and a >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |  (select a, max(b) b, count(*) c1 from l group by a)\n        |  right join\n        |  (select c, max(d) d, count(*) c2 from r group by c)\n        |  on a = c and c1 = c2 and c >= 2\n        |")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    private final TwoInputTransformation findTwoInputTransform$1(Transformation t) {
        Transformation transformation;
        while (true) {
            if ((transformation = t) instanceof LegacySinkTransformation) {
                LegacySinkTransformation legacySinkTransformation = (LegacySinkTransformation)transformation;
                t = (Transformation)legacySinkTransformation.getInputs().get(0);
                continue;
            }
            if (!(transformation instanceof OneInputTransformation)) break;
            OneInputTransformation oneInputTransformation = (OneInputTransformation)transformation;
            t = (Transformation)oneInputTransformation.getInputs().get(0);
        }
        if (transformation instanceof TwoInputTransformation) {
            TwoInputTransformation twoInputTransformation = (TwoInputTransformation)transformation;
            return twoInputTransformation;
        }
        throw new MatchError((Object)transformation);
    }

    public static final /* synthetic */ void $anonfun$testLongHashJoinGenerator$2(BooleanRef haveTwoOp$1, TwoInputTransformation transform) {
        StreamOperatorFactory streamOperatorFactory = transform.getOperatorFactory();
        if (streamOperatorFactory instanceof CodeGenOperatorFactory) {
            CodeGenOperatorFactory codeGenOperatorFactory = (CodeGenOperatorFactory)streamOperatorFactory;
            if (codeGenOperatorFactory.getGeneratedClass().getCode().contains("LongHashJoinOperator")) {
                haveTwoOp$1.elem = true;
                return;
            }
            return;
        }
    }
}

