/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.adaptive;

import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.adaptive.AdaptiveJoinITCase;
import org.apache.flink.table.planner.runtime.batch.sql.adaptive.AdaptiveJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.AdaptiveBatchTestBase;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3Aa\u0002\u0005\u00017!)a\u0005\u0001C\u0001O!)\u0011\u0006\u0001C!U!)A\b\u0001C\u0001U!)\u0011\t\u0001C\u0001U!)1\t\u0001C\u0001U!)Q\t\u0001C!\r\nA\u0012\tZ1qi&4XmU6fo\u0016$'j\\5o\u0013R\u001b\u0015m]3\u000b\u0005%Q\u0011\u0001C1eCB$\u0018N^3\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u001fA\tqA];oi&lWM\u0003\u0002\u0012%\u00059\u0001\u000f\\1o]\u0016\u0014(BA\n\u0015\u0003\u0015!\u0018M\u00197f\u0015\t)b#A\u0003gY&t7N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"BA\u0010\u000f\u0003\u0015)H/\u001b7t\u0013\t\tcDA\u000bBI\u0006\u0004H/\u001b<f\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\u0011\u0005\r\"S\"\u0001\u0005\n\u0005\u0015B!AE!eCB$\u0018N^3K_&t\u0017\nV\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005\r\u0002\u0011A\u00022fM>\u0014X\rF\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0011)f.\u001b;)\u0005\t\u0011\u0004CA\u001a;\u001b\u0005!$BA\u001b7\u0003\r\t\u0007/\u001b\u0006\u0003oa\nqA[;qSR,'O\u0003\u0002:1\u0005)!.\u001e8ji&\u00111\b\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\b;fgRTu.\u001b8XSRD7k[3xK\u0012,f.[8o\u0013:\u0004X\u000f\u001e\u0015\u0003\u0007y\u0002\"aM \n\u0005\u0001#$\u0001\u0002+fgR\fA\u0005^3ti*{\u0017N\\,ji\",fn\u001d9fG&4\u0017.\u001a3G_J<\u0018M\u001d3PkR\u0004X\u000f\u001e\u0015\u0003\ty\na\u0003^3ti*{\u0017N\\,ji\"D\u0015m\u001d5PkR\u0004X\u000f\u001e\u0015\u0003\u000by\n1b\u00195fG.\u0014Vm];miR\u00111f\u0012\u0005\u0006\u0017\u0019\u0001\r\u0001\u0013\t\u0003\u0013Bs!A\u0013(\u0011\u0005-kS\"\u0001'\u000b\u00055S\u0012A\u0002\u001fs_>$h(\u0003\u0002P[\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyU\u0006")
public class AdaptiveSkewedJoinITCase
extends AdaptiveBatchTestBase
implements AdaptiveJoinITCase {
    @Override
    public /* synthetic */ void org$apache$flink$table$planner$runtime$batch$sql$adaptive$AdaptiveJoinITCase$$super$before() {
        super.before();
    }

    @Override
    public /* synthetic */ TableEnvironment org$apache$flink$table$planner$runtime$batch$sql$adaptive$AdaptiveJoinITCase$$super$tEnv() {
        return super.tEnv();
    }

    @Override
    @Test
    public void testWithShuffleHashJoin() {
        AdaptiveJoinITCase.testWithShuffleHashJoin$(this);
    }

    @Override
    @Test
    public void testWithShuffleMergeJoin() {
        AdaptiveJoinITCase.testWithShuffleMergeJoin$(this);
    }

    @Override
    @Test
    public void testWithBroadcastJoin() {
        AdaptiveJoinITCase.testWithBroadcastJoin$(this);
    }

    @Override
    @Test
    public void testShuffleJoinWithForwardForConsecutiveHash() {
        AdaptiveJoinITCase.testShuffleJoinWithForwardForConsecutiveHash$(this);
    }

    @Override
    @Test
    public void testJoinWithUnionInput() {
        AdaptiveJoinITCase.testJoinWithUnionInput$(this);
    }

    @Override
    @Test
    public void testJoinWithMultipleInput() {
        AdaptiveJoinITCase.testJoinWithMultipleInput$(this);
    }

    @Override
    @Test
    public void testSimpleJoin() {
        AdaptiveJoinITCase.testSimpleJoin$(this);
    }

    @Override
    @BeforeEach
    public void before() {
        AdaptiveJoinITCase.before$(this);
        this.tEnv().getConfig().set(BatchExecutionOptions.ADAPTIVE_AUTO_PARALLELISM_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.NONE);
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_SKEWED_THRESHOLD, (Object)MemorySize.parse((String)"100k"));
        this.registerCollection("T", AdaptiveJoinITCase$.MODULE$.generateRandomData(30, 0.0), AdaptiveJoinITCase$.MODULE$.rowType(), "a, b, c, d", AdaptiveJoinITCase$.MODULE$.nullables(), false);
        this.registerCollection("T1", AdaptiveJoinITCase$.MODULE$.generateRandomData(3000, 0.99), AdaptiveJoinITCase$.MODULE$.rowType(), "a1, b1, c1, d1", AdaptiveJoinITCase$.MODULE$.nullables(), false);
        this.registerCollection("T2", AdaptiveJoinITCase$.MODULE$.generateRandomData(30, 0.0), AdaptiveJoinITCase$.MODULE$.rowType(), "a2, b2, c2, d2", AdaptiveJoinITCase$.MODULE$.nullables(), false);
        this.registerCollection("T3", AdaptiveJoinITCase$.MODULE$.generateRandomData(30, 0.0), AdaptiveJoinITCase$.MODULE$.rowType(), "a3, b3, c3, d3", AdaptiveJoinITCase$.MODULE$.nullables(), false);
    }

    @Test
    public void testJoinWithSkewedUnionInput() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT * FROM (SELECT a1 as a, b1 as b, c1 as c, d1 as d FROM T1) UNION ALL (SELECT a2 as a, b2 as b, c2 as c, d2 as d FROM T2)) Y\n        |  LEFT JOIN T ON T.a = Y.a\n        |")).stripMargin();
        this.checkResult(sql);
    }

    @Test
    public void testJoinWithUnspecifiedForwardOutput() {
        String sql = "SELECT a1 as a, b1 as b, c1 as c, d1 as d FROM T1, T2 WHERE a1 = a2";
        this.checkResult(sql);
    }

    @Test
    public void testJoinWithHashOutput() {
        String sql = "SELECT * FROM (SELECT * FROM T1, T2 WHERE T1.a1 = T2.a2) as T4 LEFT JOIN T3 ON T3.b3 = T4.b1";
        this.checkResult(sql);
    }

    @Override
    public void checkResult(String sql) {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.NONE);
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.AUTO);
        this.checkResult(sql, expected, this.checkResult$default$3());
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.FORCED);
        this.tEnv().getConfig().set(PipelineOptions.OPERATOR_CHAINING, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.checkResult(sql, expected, this.checkResult$default$3());
        this.tEnv().getConfig().set(PipelineOptions.OPERATOR_CHAINING, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public AdaptiveSkewedJoinITCase() {
        AdaptiveJoinITCase.$init$(this);
    }
}

