/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003B\u0002\u001e\u0001A\u0003%Q\u0006C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\t\r-\u0003\u0001\u0015!\u0003>\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015i\u0006\u0001\"\u0001N\u0011\u0015\u0011\u0007\u0001\"\u0001N\u0011\u0015!\u0007\u0001\"\u0001N\u0011\u00151\u0007\u0001\"\u0001N\u0011\u0015A\u0007\u0001\"\u0001N\u0011\u0015Q\u0007\u0001\"\u0001N\u0011\u0015a\u0007\u0001\"\u0001N\u0005-)f.[8o\u0013R\u001b\u0015m]3\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006E\u0006$8\r\u001b\u0006\u0003)U\tqA];oi&lWM\u0003\u0002\u0017/\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\r\u001a\u0003\u0015!\u0018M\u00197f\u0015\tQ2$A\u0003gY&t7N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR!\u0001J\n\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001a#!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u001f\u0005)A/\u001f9fmU\tQ\u0006E\u0002/eQj\u0011a\f\u0006\u0003aE\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005Q9\u0012BA\u001a0\u0005AIe\u000e^3s]\u0006dG+\u001f9f\u0013:4w\u000e\u0005\u00026q5\taG\u0003\u00028/\u0005!A-\u0019;b\u0013\tIdGA\u0004S_^$\u0015\r^1\u0002\rQL\b/\u001a\u001c!\u0003\u0015!\u0017\r^17+\u0005i\u0004c\u0001 D\u000b6\tqH\u0003\u0002A\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R \u0003\u0007M+\u0017\u000f\u0005\u0002G\u00136\tqI\u0003\u0002Im\u00051!-\u001b8befL!AS$\u0003\u001b\tKg.\u0019:z%><H)\u0019;b\u0003\u0019!\u0017\r^17A\u00051!-\u001a4pe\u0016$\u0012A\u0014\t\u0003\u001fBk\u0011!Q\u0005\u0003#\u0006\u0013A!\u00168ji\"\u0012aa\u0015\t\u0003)nk\u0011!\u0016\u0006\u0003-^\u000b1!\u00199j\u0015\tA\u0016,A\u0004kkBLG/\u001a:\u000b\u0005ik\u0012!\u00026v]&$\u0018B\u0001/V\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001ei\u0016\u001cH/\u00168j_:<\u0016\u000e\u001e5ES\u001a4WM]3oiJ{w\u000f^=qK\"\u0012qa\u0018\t\u0003)\u0002L!!Y+\u0003\tQ+7\u000f^\u0001\ri\u0016\u001cH/\u00168j_:\fE\u000e\u001c\u0015\u0003\u0011}\u000b\u0011\u0002^3tiVs\u0017n\u001c8)\u0005%y\u0016a\u0005;fgR,f.[8o/&$\bNR5mi\u0016\u0014\bF\u0001\u0006`\u0003a!Xm\u001d;V]&|gnV5uQ\u0006;wM]3hCRLwN\u001c\u0015\u0003\u0017}\u000b!\u0005^3ti*{\u0017N\\!gi\u0016\u0014H)\u001b4gKJ,g\u000e\u001e+za\u0016,f.[8o\u00032d\u0007F\u0001\u0007`\u0003Y!Xm\u001d;V]&|gn\u00144Nk2$\u0018.\u00138qkR\u001c\bFA\u0007`\u0001")
public class UnionITCase
extends BatchTestBase {
    private final InternalTypeInfo<RowData> type6 = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BigIntType(), VarCharType.STRING_TYPE});
    private final Seq<BinaryRowData> data6 = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), StringData.fromString((String)"Hi")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), StringData.fromString((String)"Hello")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), StringData.fromString((String)"Hello world")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.binaryRow(this.type6().toRowFieldTypes(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)3L), StringData.fromString((String)"Hello world, how are you?")})), (List)Nil$.MODULE$))));

    public InternalTypeInfo<RowData> type6() {
        return this.type6;
    }

    public Seq<BinaryRowData> data6() {
        return this.data6;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("Table3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
        this.registerCollection("Table5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
        this.registerCollection("Table6", this.data6(), this.type6(), "a, b, c", new boolean[]{false, false, false});
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
    }

    @Test
    public void testUnionWithDifferentRowtype() {
        this.checkResult("SELECT a FROM (SELECT * FROM Table3 t1 UNION ALL (SELECT * FROM Table6 t2))", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"})), (List)Nil$.MODULE$)))))))), this.checkResult$default$3());
    }

    @Test
    public void testUnionAll() {
        this.checkResult("SELECT t1.c FROM Table3 t1 UNION ALL (SELECT t2.c FROM Table3 t2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testUnion() {
        this.checkResult("SELECT t1.c FROM Table3 t1 UNION (SELECT t2.c FROM Table3 t2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testUnionWithFilter() {
        this.checkResult("SELECT c FROM (SELECT * FROM Table3 UNION ALL (SELECT d, e, g FROM Table5))WHERE b < 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hallo"})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testUnionWithAggregation() {
        this.checkResult("SELECT count(c) FROM (SELECT * FROM Table3 UNION ALL (SELECT d, e, g FROM Table5))", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testJoinAfterDifferentTypeUnionAll() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L)).set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, NestedLoopJoin");
        this.checkResult("SELECT a, c, g FROM (SELECT t1.a, t1.b, t1.c FROM Table3 t1 UNION ALL(SELECT a, b, c FROM Table3 ORDER BY a, b, c)), Table5 WHERE b = e", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi", "Hallo"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world", "Hallo Welt"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world", "Hallo Welt"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testUnionOfMultiInputs() {
        this.checkResult("select max(v) as x, min(v) as n from \n(values cast(-86.4 as double), cast(-100 as double), cast(2 as double)) as t(v)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToDouble((double)-100.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }
}

