/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0003\u0006\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C!O!)\u0011\b\u0001C\u0001O!)a\b\u0001C\u0001O!)\u0001\t\u0001C\u0001O!)!\t\u0001C\u0001O!)A\t\u0001C\u0001O!)a\t\u0001C\u0001O\tyA+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\f\u0019\u0005\u00191/\u001d7\u000b\u00055q\u0011!\u00022bi\u000eD'BA\b\u0011\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0005\n\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0003F\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003+Y\tQA\u001a7j].T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\tyb\"A\u0003vi&d7/\u0003\u0002\"=\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0006\u0002\r\t,gm\u001c:f)\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#\u0001B+oSRD#AA\u0018\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014aA1qS*\u0011A'N\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1\u0004$A\u0003kk:LG/\u0003\u00029c\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001dQ,7\u000f\u001e+bE2,\u0007*\u001b8ug\"\u00121a\u000f\t\u0003aqJ!!P\u0019\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cHoQ8mY\u0016\u001cGoU5oW\u000e{gNZ5hkJ\fG/[8oQ\t!1(A\fuKN$8I]3bi\u0016$\u0016M\u00197f\u0003N\u001cV\r\\3di\"\u0012QaO\u0001%i\u0016\u001cHo\u0011:fCR,G+\u00192mK\u0006\u001b8+\u001a7fGR<\u0016\u000e\u001e5T_J$H*[7ji\"\u0012aaO\u0001&i\u0016\u001cHo\u0011:fCR,G+\u00192mK\u0006\u001b8+\u001a7fGR<\u0016\u000e\u001e5pkR|\u0005\u000f^5p]ND#aB\u001e\u0002_Q,7\u000f^\"sK\u0006$X\rV1cY\u0016\f5oU3mK\u000e$x+\u001b;i\u001fJ$WM]&fs:{G\u000f\u0015:pU\u0016\u001cG/\u001a3)\u0005!Y\u0004")
public class TableSinkITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(361).append("\n                       |CREATE TABLE MyTable (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n       ").toString())).stripMargin());
    }

    @Test
    public void testTableHints() {
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n                       |CREATE TABLE MySink (\n                       |  `a` INT,\n                       |  `b` BIGINT,\n                       |  `c` STRING\n                       |) WITH (\n                       |  'connector' = 'filesystem',\n                       |  'format' = 'testcsv',\n                       |  'path' = '").append(resultPath).append("'\n                       |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        String newPath1 = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        stmtSet.addInsertSql(new StringBuilder(68).append("insert into MySink /*+ OPTIONS('path' = '").append(newPath1).append("') */ select * from MyTable").toString());
        String newPath2 = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        stmtSet.addInsertSql(new StringBuilder(68).append("insert into MySink /*+ OPTIONS('path' = '").append(newPath2).append("') */ select * from MyTable").toString());
        stmtSet.execute().await();
        Assertions.assertThat((boolean)TableTestUtil$.MODULE$.readFromFile(resultPath).isEmpty()).isTrue();
        Seq expected = (Seq)new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$)));
        Seq<String> result1 = TableTestUtil$.MODULE$.readFromFile(newPath1);
        Assertions.assertThat((Object)expected.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(result1.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<String> result2 = TableTestUtil$.MODULE$.readFromFile(newPath2);
        Assertions.assertThat((Object)expected.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(result2.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCollectSinkConfiguration() {
        this.tEnv().getConfig().set(CollectSinkOperatorFactory.MAX_BATCH_SIZE, (Object)MemorySize.parse((String)"1b"));
        Assertions.assertThatThrownBy(() -> this.checkResult("SELECT 1", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches((String)"Please consider increasing max bytes per batch value by setting collect-sink.batch-size.max")});
        this.tEnv().getConfig().set(CollectSinkOperatorFactory.MAX_BATCH_SIZE, (Object)MemorySize.parse((String)"1kb"));
        this.checkResult("SELECT 1", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testCreateTableAsSelect() {
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                     |CREATE TABLE MyCtasTable\n                     | WITH (\n                     |  'connector' = 'filesystem',\n                     |  'format' = 'testcsv',\n                     |  'path' = '").append(resultPath).append("'\n                     |) AS\n                     | SELECT * FROM MyTable\n       ").toString())).stripMargin()).await();
        Seq expected = (Seq)new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$)));
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Assertions.assertThat((Object)result.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        StatementSet statementSet = this.tEnv().createStatementSet();
        String useStatementResultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n                                 |CREATE TABLE MyCtasTableUseStatement\n                                 | WITH (\n                                 |  'connector' = 'filesystem',\n                                 |  'format' = 'testcsv',\n                                 |  'path' = '").append(useStatementResultPath).append("'\n                                 |) AS\n                                 | SELECT * FROM MyTable\n                                 |").toString())).stripMargin());
        statementSet.execute().await();
        Seq<String> useStatementResult = TableTestUtil$.MODULE$.readFromFile(useStatementResultPath);
        Assertions.assertThat((Object)useStatementResult.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCreateTableAsSelectWithSortLimit() {
        String resultPath = BatchAbstractTestBase.createTempFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n                     |CREATE TABLE MyCtasTable\n                     | WITH (\n                     |  'connector' = 'filesystem',\n                     |  'format' = 'testcsv',\n                     |  'path' = '").append(resultPath).append("'\n                     |) AS\n                     | (SELECT * FROM MyTable order by `a` LIMIT 2)\n       ").toString())).stripMargin()).await();
        Seq expected = (Seq)new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)Nil$.MODULE$));
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Assertions.assertThat((Object)result.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCreateTableAsSelectWithoutOptions() {
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE MyCtasTable\n                        | AS\n                        | SELECT * FROM MyTable\n                        |")).stripMargin()).await()).hasRootCauseMessage("Table options do not contain an option key 'connector' for discovering a connector.");
    }

    @Test
    public void testCreateTableAsSelectWithOrderKeyNotProjected() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyCtasTable\n                     |WITH (\n                     |   'connector' = 'values'\n                     |) as select b, c, d from\n                     |  (values\n                     |    (1, 1, 2, 'd1'),\n                     |    (2, 2, 4, 'd2')\n                     |  ) as V(a, b, c, d)\n                     |  order by a\n                     |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"+I[1, 2, d1]", (List)new .colon.colon((Object)"+I[2, 4, d2]", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("MyCtasTable")).toSeq()).isEqualTo((Object)expected);
    }
}

