/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0002\u0004\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)Q\u0007\u0001C\u0001G!)q\u0007\u0001C\u0001G\tyA+\u00192mKN\u001b\u0017M\\%U\u0007\u0006\u001cXM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!\u00022bi\u000eD'BA\u0006\r\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0004\b\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0002E\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003#I\tQA\u001a7j].T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\tY\"\"A\u0003vi&d7/\u0003\u0002\u001e5\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0004\u0002GQ,7\u000f\u001e+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5pkR$\u0016.\\3BiR\u0014\u0018NY;uKR\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0003V]&$\bF\u0001\u0002,!\ta3'D\u0001.\u0015\tqs&A\u0002ba&T!\u0001M\u0019\u0002\u000f),\b/\u001b;fe*\u0011!\u0007F\u0001\u0006UVt\u0017\u000e^\u0005\u0003i5\u0012A\u0001V3ti\u00069B/Z:u!J|7\r^5nKR\u000b'\r\\3T_V\u00148-\u001a\u0015\u0003\u0007-\na\u0003^3tiJ{w\u000f^5nKR\u000b'\r\\3T_V\u00148-\u001a\u0015\u0003\t-\u0002")
public class TableScanITCase
extends BatchTestBase {
    @Test
    public void testTableSourceWithoutTimeAttribute() {
        String tableName = "MyTable";
        TestTableSourceSinks$.MODULE$.createWithoutTimeAttributesTableSource(this.tEnv(), tableName);
        this.checkResult(new StringBuilder(14).append("SELECT * from ").append(tableName).toString(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testProctimeTableSource() {
        String tableName = "MyTable";
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Peter"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz"})), (List)Nil$.MODULE$))))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(346).append("\n                       |create table ").append(tableName).append(" (\n                       |  name string,\n                       |  ptime as proctime()\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult(new StringBuilder(70).append("SELECT name, CHAR_LENGTH(DATE_FORMAT(ptime, 'yyyy-MM-dd HH:mm')) FROM ").append(tableName).toString(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", BoxesRunTime.boxToInteger((int)16)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Peter", BoxesRunTime.boxToInteger((int)16)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", BoxesRunTime.boxToInteger((int)16)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz", BoxesRunTime.boxToInteger((int)16)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testRowtimeTableSource() {
        String tableName = "MyTable";
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)1L), new Integer(10)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", DateTimeUtils.toLocalDateTime((long)2L), new Integer(20)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)2L), new Integer(30)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz", DateTimeUtils.toLocalDateTime((long)2001L), new Integer(40)})), (List)Nil$.MODULE$))))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(439).append("\n                       |create table ").append(tableName).append(" (\n                       |  name string,\n                       |  rtime timestamp(3),\n                       |  amount int,\n                       |  watermark for rtime as rtime\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        this.checkResult(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)1L), new Integer(10)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)2L), new Integer(30)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", DateTimeUtils.toLocalDateTime((long)2L), new Integer(20)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz", DateTimeUtils.toLocalDateTime((long)2001L), new Integer(40)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }
}

