/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Aa\u0003\u0007\u0001;!)A\u0005\u0001C\u0001K!)\u0001\u0006\u0001C!S!)1\b\u0001C\u0001S!)1\b\u0001C\u0005\u0001\")a\t\u0001C\u0001S!)a\t\u0001C\u0005\u0011\")Q\n\u0001C\u0001S!)q\n\u0001C\u0001S!)\u0011\u000b\u0001C\u0001S!)1\u000b\u0001C\u0001S\ty1k\u001c:u\u0019&l\u0017\u000e^%U\u0007\u0006\u001cXM\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012!\u00022bi\u000eD'BA\t\u0013\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0005\u000b\u0002\u000fAd\u0017M\u001c8fe*\u0011QCF\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003/a\tQA\u001a7j].T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\t\t\u0003#A\u0003vi&d7/\u0003\u0002$A\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\u0007\u0002\r\t,gm\u001c:f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#AA\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA$$A\u0003kk:LG/\u0003\u0002;g\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002;Q,7\u000f^(sI\u0016\u0014()_,ji\"|eMZ:fi\u0006sGMR3uG\"D#aA\u001f\u0011\u0005Ir\u0014BA 4\u0005\u0011!Vm\u001d;\u0015\u0005)\n\u0005\"\u0002\"\u0005\u0001\u0004\u0019\u0015!B8sI\u0016\u0014\bCA\u0016E\u0013\t)EFA\u0004C_>dW-\u00198\u0002!Q,7\u000f^(sI\u0016\u0014()\u001f'j[&$\bFA\u0003>)\rQ\u0013j\u0013\u0005\u0006\u0015\u001a\u0001\raQ\u0001\u0007_J$WM]\u0019\t\u000b13\u0001\u0019A\"\u0002\r=\u0014H-\u001a:3\u0003e!Xm\u001d;Pe\u0012,'OQ=MKN\u001cH\u000b[1o\u001f\u001a47/\u001a;)\u0005\u001di\u0014a\u0007;fgR|%\u000fZ3s\u0005fd\u0015.\\5u\u0005\u0016D\u0017N\u001c3GS\u0016dG\r\u000b\u0002\t{\u0005!B/Z:u\u001fJ$WM\u001d\"fQ&tGMR5fY\u0012D#!C\u001f\u00023Q,7\u000f^(sI\u0016\u0014()\u001f*fa\u0016\fG/\u001a3GS\u0016dGm\u001d\u0015\u0003\u0015u\u0002")
public class SortLimitITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        this.registerCollection("Table3", (Iterable<Row>)TestData$.MODULE$.data3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
    }

    @Test
    public void testOrderByWithOffsetAndFetch() {
        this.testOrderByWithOffsetAndFetch(true);
        this.testOrderByWithOffsetAndFetch(false);
    }

    private void testOrderByWithOffsetAndFetch(boolean order) {
        String sqlOrder = order ? "ASC" : "DESC";
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortLimitITCase.$anonfun$testOrderByWithOffsetAndFetch$1(order, x)), (Ordering)Ordering.Int$.MODULE$)).slice(2, 7);
        this.checkResult(new StringBuilder(69).append("SELECT * FROM Table3 ORDER BY a ").append(sqlOrder).append(" OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY").toString(), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLimit() {
        this.testOrderByLimit(true, false);
        this.testOrderByLimit(false, false);
        this.testOrderByLimit(true, true);
        this.testOrderByLimit(false, true);
    }

    private void testOrderByLimit(boolean order1, boolean order2) {
        String sqlOrder1 = order1 ? "ASC" : "DESC";
        String sqlOrder2 = order2 ? "ASC" : "DESC";
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJI.sp(order2 ? BoxesRunTime.unboxToLong((Object)x.getField(1)) : -BoxesRunTime.unboxToLong((Object)x.getField(1)), order1 ? BoxesRunTime.unboxToInt((Object)x.getField(0)) : -BoxesRunTime.unboxToInt((Object)x.getField(0))), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$))).slice(0, 5);
        this.checkResult(new StringBuilder(44).append("SELECT * FROM Table3 ORDER BY b ").append(sqlOrder2).append(", a ").append(sqlOrder1).append(" LIMIT 5").toString(), (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLessThanOffset() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortLimitITCase.$anonfun$testOrderByLessThanOffset$1(x)), (Ordering)Ordering.Int$.MODULE$)).slice(2, TestData$.MODULE$.data3().size());
        this.checkResult("SELECT * FROM Table3 ORDER BY a ASC OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByLimitBehindField() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> (String)x.getField(2), (Ordering)Ordering.String$.MODULE$)).slice(0, 5);
        this.checkResult("SELECT * FROM Table3 ORDER BY c LIMIT 5", (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderBehindField() {
        this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        Seq expected = (Seq)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> (String)x.getField(2), (Ordering)Ordering.String$.MODULE$);
        this.checkResult("SELECT * FROM Table3 ORDER BY c", (Seq<Row>)expected, true);
    }

    @Test
    public void testOrderByRepeatedFields() {
        Seq expected = (Seq)((IterableLike)TestData$.MODULE$.data3().sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortLimitITCase.$anonfun$testOrderByRepeatedFields$1(x)), (Ordering)Ordering.Int$.MODULE$)).slice(0, 5);
        this.checkResult("SELECT * FROM Table3 ORDER BY a, a, a LIMIT 5", (Seq<Row>)expected, true);
    }

    public static final /* synthetic */ int $anonfun$testOrderByWithOffsetAndFetch$1(boolean order$1, Row x) {
        if (order$1) {
            return BoxesRunTime.unboxToInt((Object)x.getField(0));
        }
        return -BoxesRunTime.unboxToInt((Object)x.getField(0));
    }

    public static final /* synthetic */ int $anonfun$testOrderByLessThanOffset$1(Row x) {
        return BoxesRunTime.unboxToInt((Object)x.getField(0));
    }

    public static final /* synthetic */ int $anonfun$testOrderByRepeatedFields$1(Row x) {
        return BoxesRunTime.unboxToInt((Object)x.getField(0));
    }
}

