/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.Collection;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.OperatorFusionCodegenITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001\u0002\u0012$\u0001QBQa\u000f\u0001\u0005\u0002qB\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001!\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0007\"C5\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011\u00159\b\u0001\"\u0011y\u0011\u0019\t9\u0001\u0001C\u0001q\"1\u0011\u0011\u0003\u0001\u0005\u0002aDa!!\u0006\u0001\t\u0003A\bBBA\r\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0002\u001e\u0001!\t\u0001\u001f\u0005\u0007\u0003C\u0001A\u0011\u0001=\t\r\u0005\u0015\u0002\u0001\"\u0001y\u0011\u0019\tI\u0003\u0001C\u0001q\"1\u0011Q\u0006\u0001\u0005\u0002aDa!!\r\u0001\t\u0003A\bBBA\u001b\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0002:\u0001!\t\u0001\u001f\u0005\u0007\u0003{\u0001A\u0011\u0001=\t\r\u0005\u0005\u0003\u0001\"\u0001y\u0011\u0019\t)\u0005\u0001C\u0001q\"1\u0011\u0011\n\u0001\u0005\u0002aDa!!\u0014\u0001\t\u0003A\bBBA)\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0002V\u0001!\t\u0001\u001f\u0005\u0007\u00033\u0002A\u0011\u0001=\t\r\u0005u\u0003\u0001\"\u0001y\u0011\u0019\t\t\u0007\u0001C\u0001q\"1\u0011Q\r\u0001\u0005\u0002aDq!!\u001b\u0001\t\u0003\tYgB\u0004\u0002\u001a\u000eB\t!a'\u0007\r\t\u001a\u0003\u0012AAO\u0011\u0019Yt\u0004\"\u0001\u0002&\"9\u0011qU\u0010\u0005\u0002\u0005%&aG(qKJ\fGo\u001c:GkNLwN\\\"pI\u0016<WM\\%U\u0007\u0006\u001cXM\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!\u00022bi\u000eD'B\u0001\u0015*\u0003\u001d\u0011XO\u001c;j[\u0016T!AK\u0016\u0002\u000fAd\u0017M\u001c8fe*\u0011A&L\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003]=\nQA\u001a7j].T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011C\u0001\u00016!\t1\u0014(D\u00018\u0015\tAt%A\u0003vi&d7/\u0003\u0002;o\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u001f\u0011\u0005y\u0002Q\"A\u0012\u0002!\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,W#A!\u0011\u0005\tcfBA\"Z\u001d\t!uK\u0004\u0002F-:\u0011a)\u0016\b\u0003\u000fRs!\u0001S*\u000f\u0005%\u0013fB\u0001&R\u001d\tY\u0005K\u0004\u0002M\u001f6\tQJ\u0003\u0002Og\u00051AH]8pizJ\u0011AM\u0005\u0003aEJ!AL\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\tA\u0013&\u0003\u0002'O%\u0011A%J\u0005\u00031\u000e\nAA[8j]&\u0011!lW\u0001\t\u0015>Lg\u000eV=qK*\u0011\u0001lI\u0005\u0003;z\u0013\u0001BS8j]RK\b/\u001a\u0006\u00035n\u000bA#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3`I\u0015\fHCA1h!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u0011)f.\u001b;\t\u000f!\u001c\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002#\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,\u0007\u0005\u000b\u0002\u0005WB\u0011A.^\u0007\u0002[*\u0011an\\\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\u0005A\f\u0018AC3yi\u0016t7/[8og*\u0011!o]\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003i6\n\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005Yl'!\u0003)be\u0006lW\r^3s\u0003\u0019\u0011WMZ8sKR\t\u0011\r\u000b\u0002\u0006uB\u001910a\u0001\u000e\u0003qT!! @\u0002\u0007\u0005\u0004\u0018NC\u0002\u0000\u0003\u0003\tqA[;qSR,'O\u0003\u0002sc%\u0019\u0011Q\u0001?\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\fuKN$()Y:jG&sg.\u001a:ICND'j\\5oQ\r1\u00111\u0002\t\u0004w\u00065\u0011bAA\by\naA+Z:u)\u0016l\u0007\u000f\\1uK\u0006\u0019C/Z:u\u0005\u0006\u001c\u0018nY%o]\u0016\u0014\b*Y:i\u0015>LgnV5uQ\u000e{g\u000eZ5uS>t\u0007fA\u0004\u0002\f\u0005!C/Z:u\u0005\u0006\u001c\u0018nY%o]\u0016\u0014\b*Y:i\u0015>LgnV5uQ\u000e{g\u000eZ5uS>t'\u0007K\u0002\t\u0003\u0017\t!\u0004^3ti6\u000bg.\u001f)s_\n,w*\u001e;fe\"\u000b7\u000f\u001b&pS:D3!CA\u0006\u0003\u0015\"Xm\u001d;Qe>\u0014WmT;uKJD\u0015m\u001d5K_&tw+\u001b;i\u001f:\u001cuN\u001c3ji&|g\u000eK\u0002\u000b\u0003\u0017\t\u0001\u0006^3tiB\u0013xNY3PkR,'\u000fS1tQ*{\u0017N\\,ji\"<\u0006.\u001a:f\u0007>tG-\u001b;j_:D3aCA\u0006\u0003\u0011\"Xm\u001d;ICND'j\\5o/&$\bNT8Qe&|'/\u001b;z\u0007>t7\u000f\u001e:bS:$\bf\u0001\u0007\u0002\f\u0005qB/Z:u\u0011\u0006\u001c\bNS8j]^KG\u000f[(oYf\u0004&o\u001c6fGRLwN\u001c\u0015\u0004\u001b\u0005-\u0011A\r;fgRD\u0015m\u001d5K_&tw+\u001b;i\t\u0016\fG\r\\8dW\u000e\u000bWo]3e\u0005f,\u0005p\u00195b]\u001e,\u0017J\\!oG\u0016\u001cHo\u001c:)\u00079\tY!\u0001\u000buKN$H*\u001a4u'\u0016l\u0017\u000eS1tQ*{\u0017N\u001c\u0015\u0004\u001f\u0005-\u0011!\t;fgRdUM\u001a;TK6L\u0007*Y:i\u0015>LgnV5uQ\u000e{g\u000eZ5uS>t\u0007f\u0001\t\u0002\f\u0005!B/Z:u\u0019\u00164G/\u00118uS\"\u000b7\u000f\u001b&pS:D3!EA\u0006\u0003i!Xm\u001d;M_\u000e\fG\u000eS1tQ\u0006;wmV5uQ>,HoS3zQ\r\u0011\u00121B\u0001,i\u0016\u001cH\u000fT8dC2D\u0015m\u001d5BO\u001e<\u0016\u000e\u001e5pkR\\U-_!oI\"\u000b7\u000f[!hO^KG\u000f[&fs\"\u001a1#a\u0003\u0002%Q,7\u000f\u001e%bg\"\fumZ,ji\"\\U-\u001f\u0015\u0004)\u0005-\u0011a\u0005;fgRD\u0015m\u001d5BO\u001e<\u0016\u000e\u001e5LKf\u0014\u0004fA\u000b\u0002\f\u00059B/Z:u\u0019>\u001c\u0017\r\u001c%bg\"\fumZ,ji\"\\U-\u001f\u0015\u0004-\u0005-\u0011\u0001\u0007;fgR<En\u001c2bY\"\u000b7\u000f[!hO^KG\u000f[&fs\"\u001aq#a\u0003\u0002'Q,7\u000f^'vYRL\u0007\u000f\\3ICND\u0017iZ4)\u0007a\tY!A\ruKN$x\t\\8cC2D\u0015m\u001d5BO\u001e<\u0016\u000e\u001e5LKf\u0014\u0004fA\r\u0002\f\u0005)D/Z:u\u0019>\u001c\u0017\r\\!oI\u001ecwNY1m\u0011\u0006\u001c\b.Q4h\u0013:$vo\\*fa\u0016\u0014\u0018\r^3e\rV\u001c\u0018n\u001c8Pa\u0016\u0014\u0018\r^8sQ\rQ\u00121B\u0001\u0019i\u0016\u001cH/\u00113baRLg/\u001a'pG\u0006d\u0007*Y:i\u0003\u001e<\u0007fA\u000e\u0002\f\u0005yB/Z:u\u0011\u0006\u001c\b.Q4h/&$\bnS3z\u0003:$g)\u001b7uKJ\f%oZ:)\u0007q\tY!\u0001\u000edQ\u0016\u001c7n\u00149GkNLwN\\\"pI\u0016<WM\u001c*fgVdG\u000fF\u0002b\u0003[Ba\u0001J\u000fA\u0002\u0005=\u0004\u0003BA9\u0003srA!a\u001d\u0002vA\u0011AjY\u0005\u0004\u0003o\u001a\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002|\u0005u$AB*ue&twMC\u0002\u0002x\rDs\u0001AAA\u0003\u001b\u000by\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9\t`\u0001\nKb$XM\\:j_:LA!a#\u0002\u0006\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005E5EAAJ!\ra\u0017QS\u0005\u0004\u0003/k'A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017aG(qKJ\fGo\u001c:GkNLwN\\\"pI\u0016<WM\\%U\u0007\u0006\u001cX\r\u0005\u0002??M\u0019q$a(\u0011\u0007\t\f\t+C\u0002\u0002$\u000e\u0014a!\u00118z%\u00164GCAAN\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003W\u0003b!!,\u00028\u0006mVBAAX\u0015\u0011\t\t,a-\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003k\u000bAA[1wC&!\u0011\u0011XAX\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004E\u0006u\u0016bAA`G\n\u0019\u0011I\\=)\u000f\u0005\n\u0019-!3\u0002LB\u0019A.!2\n\u0007\u0005\u001dWN\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012\u0011QZ\u0001\u0015Kb\u0004Xm\u0019;fI*{\u0017N\u001c+za\u0016l4\u0010M?")
public class OperatorFusionCodegenITCase
extends BatchTestBase {
    @Parameter
    private Enumeration.Value expectedJoinType;

    @Parameters(name="expectedJoinType={0}")
    public static Collection<Object> parameters() {
        return OperatorFusionCodegenITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testBasicInnerHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT * FROM\n                                 |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testBasicInnerHashJoinWithCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT * FROM\n                                 |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d, e FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d WHERE T1.b > T2.e\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testBasicInnerHashJoinWithCondition2() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d WHERE CHAR_LENGTH(x.c) > CHAR_LENGTH(y.f)) T1\n        |  INNER JOIN\n        |  (SELECT d, e FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d WHERE T1.b > T2.e\n        |")).stripMargin());
    }

    @TestTemplate
    public void testManyProbeOuterHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProbeOuterHashJoinWithOnCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, ny, nz FROM x\n        |  LEFT JOIN y ON x.a = y.ny\n        |  LEFT JOIN z ON x.a = z.nz AND CHAR_LENGTH(x.c) > CHAR_LENGTH(z.i)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testProbeOuterHashJoinWithWhereCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, ny, nz FROM x\n        |  LEFT JOIN y ON x.a = y.ny\n        |  LEFT JOIN z ON x.a = z.nz WHERE CHAR_LENGTH(x.c) > CHAR_LENGTH(y.f)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashJoinWithNoPriorityConstraint() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashJoinWithOnlyProjection() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT * FROM (SELECT a, nx + ny AS nt FROM x\n                                 |  JOIN y ON x.a = y.ny) t\n                                 |JOIN z ON t.a = z.nz WHERE t.nt -10 > z.nz\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testHashJoinWithDeadlockCausedByExchangeInAncestor() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLeftSemiHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM t WHERE t.a IN\n        |(SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLeftSemiHashJoinWithCondition() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM t WHERE t.a IN\n        |(SELECT * FROM (SELECT a FROM x INNER JOIN y ON x.a = y.d) t2 WHERE t.b > t2.a )\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLeftAntiHashJoin() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x, y WHERE x.a = y.d\n        |AND NOT EXISTS (SELECT * FROM z t1 WHERE x.b = t1.h AND t1.g >= 0)\n        |AND NOT EXISTS (SELECT * FROM z t2 WHERE x.b = t2.h AND t2.h < 100)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLocalHashAggWithoutKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT count(a) as cnt FROM\n                                 |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testLocalHashAggWithoutKeyAndHashAggWithKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT count(distinct d) as cnt FROM\n                                 |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testHashAggWithKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashAggWithKey2() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT a, count(b) as cnt FROM\n                                 |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |  GROUP BY a\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testLocalHashAggWithKey() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE);
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT a, count(b) as cnt, avg(b) as pj FROM\n                                 |  (SELECT a, b FROM x INNER JOIN y ON x.a = y.d) T1\n                                 |  INNER JOIN\n                                 |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                                 |  ON T1.a = T2.d\n                                 |  GROUP BY a\n                                 |")).stripMargin());
    }

    @TestTemplate
    public void testGlobalHashAggWithKey() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT a, SUM(b) AS cnt, AVG(b) AS pj FROM t GROUP BY a) T2\n        |  ON T1.a = T2.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testMultipleHashAgg() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a, SUM(b) as b FROM x group by a) T1\n        |  INNER JOIN\n        |  (SELECT d, SUM(e) as e FROM y group by d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testGlobalHashAggWithKey2() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH agg AS (SELECT a, SUM(b) AS cnt FROM t GROUP BY a)\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN agg ON y.d = agg.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testLocalAndGlobalHashAggInTwoSeperatedFusionOperator() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE);
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testAdaptiveLocalHashAgg() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE);
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)1L));
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testHashAggWithKeyAndFilterArgs() {
        this.checkOpFusionCodegenResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, b, c, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(DISTINCT b) AS cnt1, COUNT(DISTINCT c) as cnt2 FROM T GROUP BY a) T1\n        |  RIGHT JOIN\n        |  (SELECT d FROM y) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    public void checkOpFusionCodegenResult(String sql) {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.checkResult(sql, expected, this.checkResult$default$3());
    }
}

