/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!)1\u0006\u0001C!Y!)a\b\u0001C\u0001Y!)1\t\u0001C\u0001Y!)Q\t\u0001C\u0001Y!)q\t\u0001C\u0001Y!)\u0011\n\u0001C\u0001Y!)1\n\u0001C\u0001Y!)Q\n\u0001C\u0001Y!)q\n\u0001C\u0001Y!)\u0011\u000b\u0001C\u0001Y!)1\u000b\u0001C\u0001Y!)Q\u000b\u0001C\u0001Y\tYA*[7ji&#6)Y:f\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000b\t\fGo\u00195\u000b\u0005Q)\u0012a\u0002:v]RLW.\u001a\u0006\u0003-]\tq\u0001\u001d7b]:,'O\u0003\u0002\u00193\u0005)A/\u00192mK*\u0011!dG\u0001\u0006M2Lgn\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0014\u0003\u0015)H/\u001b7t\u0013\t13EA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003=\taAY3g_J,G#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005Q\u0002\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0007\u0005\u0004\u0018N\u0003\u0002:u\u00059!.\u001e9ji\u0016\u0014(BA\u001e\u001e\u0003\u0015QWO\\5u\u0013\tidG\u0001\u0006CK\u001a|'/Z#bG\"\f!\u0003^3ti>3gm]3u\u0003:$g)\u001a;dQ\"\u00121\u0001\u0011\t\u0003k\u0005K!A\u0011\u001c\u0003\tQ+7\u000f^\u0001\u0013i\u0016\u001cHo\u00144gg\u0016$\u0018I\u001c3MS6LG\u000f\u000b\u0002\u0005\u0001\u0006IA/Z:u\r\u0016$8\r\u001b\u0015\u0003\u000b\u0001\u000bq\u0003^3ti\u001a+Go\u00195XSRDG*[7jiR\u000b'\r\\3)\u0005\u0019\u0001\u0015A\u0004;fgR4U\r^2i\r&\u00148\u000f\u001e\u0015\u0003\u000f\u0001\u000bA\u0004^3ti\u001a+Go\u00195GSJ\u001cHoV5uQ2KW.\u001b;UC\ndW\r\u000b\u0002\t\u0001\u0006IA/Z:u\u0019&l\u0017\u000e\u001e\u0015\u0003\u0013\u0001\u000b\u0001\u0004^3ti2KW.\u001b;1/&$\b\u000eT5nSR$\u0016M\u00197fQ\tQ\u0001)A\fuKN$H*[7ji^KG\u000f\u001b'j[&$H+\u00192mK\"\u00121\u0002Q\u0001\u0013i\u0016\u001cH\u000fT3tgRC\u0017M\\(gMN,G\u000f\u000b\u0002\r\u0001\u0006\tC/Z:u\u0019\u0016\u001c8\u000f\u00165b]>3gm]3u/&$\b\u000eT5nSR\u001cv.\u001e:dK\"\u0012Q\u0002\u0011")
public class LimitITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        BatchTestBase$.MODULE$.configForMiniCluster(this.tableConfig());
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.data3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(232).append("\n         |CREATE TABLE LimitTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
    }

    @Test
    public void testOffsetAndFetch() {
        this.checkSize("SELECT * FROM Table3 OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", 5);
    }

    @Test
    public void testOffsetAndLimit() {
        this.checkSize("SELECT * FROM Table3 LIMIT 10 OFFSET 2", 10);
    }

    @Test
    public void testFetch() {
        this.checkSize("SELECT * FROM Table3 FETCH NEXT 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable FETCH NEXT 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchFirst() {
        this.checkSize("SELECT * FROM Table3 FETCH FIRST 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchFirstWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable FETCH FIRST 10 ROWS ONLY", 10);
    }

    @Test
    public void testLimit() {
        this.checkSize("SELECT * FROM Table3 LIMIT 5", 5);
    }

    @Test
    public void testLimit0WithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable LIMIT 0", 0);
    }

    @Test
    public void testLimitWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable LIMIT 5", 5);
    }

    @Test
    public void testLessThanOffset() {
        this.checkSize("SELECT * FROM Table3 OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", 19);
    }

    @Test
    public void testLessThanOffsetWithLimitSource() {
        this.checkSize("SELECT * FROM LimitTable OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", 19);
    }
}

