/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.Arrays;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;

class ForwardHashExchangeITCase
extends BatchTestBase {
    ForwardHashExchangeITCase() {
    }

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        this.env().disableOperatorChaining();
        this.tEnv().getConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_BLOCKING);
        String testDataId = TestValuesTableFactory.registerData(TestData.data3());
        String ddl = "CREATE TABLE MyTable (\n  a int,\n  b bigint,\n  c string\n) WITH (\n  'connector' = 'values',\n  'data-id' = '" + testDataId + "',\n  'bounded' = 'true'\n)";
        this.tEnv().executeSql(ddl);
    }

    @Test
    void testOverAggWithHashAgg() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        this.checkResult("SELECT\n   b,\n   SUM(a) sum_a,\n   AVG(SUM(a)) OVER (PARTITION BY b) avg_a,\n   RANK() OVER (PARTITION BY b ORDER BY b) rn\n FROM MyTable\n GROUP BY b", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{1, 1, 1, 1}), Row.of((Object[])new Object[]{2, 5, 5, 1}), Row.of((Object[])new Object[]{3, 15, 15, 1}), Row.of((Object[])new Object[]{4, 34, 34, 1}), Row.of((Object[])new Object[]{5, 65, 65, 1}), Row.of((Object[])new Object[]{6, 111, 111, 1}))), false);
    }

    @Test
    void testOverAggWithSortAgg() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.checkResult("SELECT\n   b,\n   SUM(a) sum_a,\n   AVG(SUM(a)) OVER (PARTITION BY b) avg_a,\n   RANK() OVER (PARTITION BY b ORDER BY b) rn\n FROM MyTable\n GROUP BY b", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{1, 1, 1, 1}), Row.of((Object[])new Object[]{2, 5, 5, 1}), Row.of((Object[])new Object[]{3, 15, 15, 1}), Row.of((Object[])new Object[]{4, 34, 34, 1}), Row.of((Object[])new Object[]{5, 65, 65, 1}), Row.of((Object[])new Object[]{6, 111, 111, 1}))), false);
    }
}

