/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4AAC\u0006\u00019!)1\u0005\u0001C\u0001I!)q\u0005\u0001C!Q!)!\b\u0001C\u0001Q!)q\b\u0001C\u0001Q!)\u0011\t\u0001C\u0001Q!)1\t\u0001C\u0001Q!)Q\t\u0001C\u0001Q!)q\t\u0001C\u0001Q!1\u0011\n\u0001C\u0001+)\u0013qbQ8eKN\u0003H.\u001b;J)\u000e\u000b7/\u001a\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003cCR\u001c\u0007N\u0003\u0002\u0011#\u00059!/\u001e8uS6,'B\u0001\n\u0014\u0003\u001d\u0001H.\u00198oKJT!\u0001F\u000b\u0002\u000bQ\f'\r\\3\u000b\u0005Y9\u0012!\u00024mS:\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\u0011\u0001eD\u0001\u0006kRLGn]\u0005\u0003E}\u0011QBQ1uG\"$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\f\u0003\u0019\u0011WMZ8sKR\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0003V]&$\bF\u0001\u00021!\t\t\u0004(D\u00013\u0015\t\u0019D'A\u0002ba&T!!\u000e\u001c\u0002\u000f),\b/\u001b;fe*\u0011q'G\u0001\u0006UVt\u0017\u000e^\u0005\u0003sI\u0012!BQ3g_J,W)Y2i\u0003U!Xm\u001d;TK2,7\r^'b]f\u001cu\u000e\\;n]ND#a\u0001\u001f\u0011\u0005Ej\u0014B\u0001 3\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f^'b]f|%o]%o\u0007>tG-\u001b;j_:D#\u0001\u0002\u001f\u0002)Q,7\u000f^'b]f\fum\u001a:fO\u0006$\u0018n\u001c8tQ\t)A(\u0001\buKN$X*\u00198z-\u0006dW/Z:)\u0005\u0019a\u0014a\b;fgRl\u0015M\\=BO\u001e\u0014XmZ1uS>t7oV5uQ\u001e\u0013x.\u001e9Cs\"\u0012q\u0001P\u0001\fi\u0016\u001cH/T1os&s7\u000f\u000b\u0002\ty\u00059!/\u001e8UKN$HcA\u0015L/\")A\"\u0003a\u0001\u0019B\u0011Q\n\u0016\b\u0003\u001dJ\u0003\"aT\u0016\u000e\u0003AS!!U\u000e\u0002\rq\u0012xn\u001c;?\u0013\t\u00196&\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*,\u0011\u0015A\u0016\u00021\u0001Z\u0003\u001d\u0011Xm];miN\u00042AW0c\u001d\tYVL\u0004\u0002P9&\tA&\u0003\u0002_W\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\r\u0019V-\u001d\u0006\u0003=.\u0002\"a\u00194\u000e\u0003\u0011T!!Z\u000b\u0002\u000bQL\b/Z:\n\u0005\u001d$'a\u0001*po\u0002")
public class CodeSplitITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("SmallTable3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
    }

    @Test
    public void testSelectManyColumns() {
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT ");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(10).append("a + ").append(BoxesRunTime.unboxToInt((Object)i)).append(" * b, ").toString()));
        sql.append("a, b FROM SmallTable3");
        ArrayBuffer results = new ArrayBuffer();
        ((TraversableLike)new .colon.colon((Object)new Tuple2.mcII.sp(1, 1), (List)new .colon.colon((Object)new Tuple2.mcII.sp(2, 2), (List)new .colon.colon((Object)new Tuple2.mcII.sp(3, 2), (List)Nil$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CodeSplitITCase.$anonfun$testSelectManyColumns$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CodeSplitITCase.$anonfun$testSelectManyColumns$3(results, x$1);
            return BoxedUnit.UNIT;
        });
        this.runTest(sql.mkString(), (Seq<Row>)results);
    }

    @Test
    public void testManyOrsInCondition() {
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT a, b FROM SmallTable3 WHERE ");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 300).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(27).append("(a + b > ").append(BoxesRunTime.unboxToInt((Object)i)).append(" AND a * b > ").append(BoxesRunTime.unboxToInt((Object)i)).append(") OR ").toString()));
        sql.append("CAST((a + b > 1 AND a * b > 1) AS VARCHAR) = 'true'");
        this.runTest(sql.mkString(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
    }

    @Test
    public void testManyAggregations() {
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT ");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 300).foreach((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyAggregations$1(sql, BoxesRunTime.unboxToInt((Object)i)));
        sql.append(" FROM SmallTable3");
        Row result = new Row(300);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 300).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> result.setField(i - 1, (Object)BoxesRunTime.boxToInteger((int)(6 + 5 * i))));
        this.runTest(sql.mkString(), (Seq<Row>)((Seq)new .colon.colon((Object)result, (List)Nil$.MODULE$)));
    }

    @Test
    public void testManyValues() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("\n           |CREATE TABLE test_many_values (\n           |").append(((TraversableOnce)package$.MODULE$.Range().apply(0, 100).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyValues$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",\n")).append("\n           |) WITH (\n           |  'connector' = 'values'\n           |)\n           |").toString())).stripMargin()).await();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n           |INSERT INTO test_many_values VALUES\n           |").append(((TraversableOnce)package$.MODULE$.Range().apply(0, 100).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyValues$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ")).append("\n           |").toString())).stripMargin()).await();
        ArrayList expected = new ArrayList();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> expected.add(new StringBuilder(4).append("+I[").append(((TraversableOnce)package$.MODULE$.Range().apply(0, 100).map((Function1 & Serializable & scala.Serializable)x$3 -> CodeSplitITCase.$anonfun$testManyValues$5(i, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString()));
        IterableAssert.assertThatIterable(TestValuesTableFactory.getResultsAsStrings("test_many_values")).containsExactlyElementsOf(expected);
    }

    @Test
    public void testManyAggregationsWithGroupBy() {
        this.tEnv().getConfig().set(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, (Object)BoxesRunTime.boxToInteger((int)4000));
        this.tEnv().getConfig().set(TableConfigOptions.MAX_MEMBERS_GENERATED_CODE, (Object)BoxesRunTime.boxToInteger((int)10000));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(368).append("\n           |CREATE TABLE test_many_values (\n           |`ID` INT,\n           |").append(((TraversableOnce)package$.MODULE$.Range().inclusive(1, 250).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyAggregationsWithGroupBy$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",\n")).append("\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'number-of-rows' = '10',\n           |  'fields.ID.kind' = 'sequence',\n           |  'fields.ID.start' = '1',\n           |  'fields.ID.end' = '10',\n           |").append(((TraversableOnce)package$.MODULE$.Range().inclusive(1, 250).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyAggregationsWithGroupBy$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",\n")).append(",\n           |").append(((TraversableOnce)package$.MODULE$.Range().inclusive(1, 250).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyAggregationsWithGroupBy$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",\n")).append(",\n           |").append(((TraversableOnce)package$.MODULE$.Range().inclusive(1, 250).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyAggregationsWithGroupBy$4(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",\n")).append("\n           |)\n           |").toString())).stripMargin()).await();
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(120).append("\n         |SELECT\n         |").append(((TraversableOnce)package$.MODULE$.Range().inclusive(1, 250).map((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyAggregationsWithGroupBy$5(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",\n")).append("\n         |    FROM `test_many_values` T1\n         |    GROUP BY ID ORDER BY a_1;\n         |").toString())).stripMargin();
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        Assertions.assertThat((int)result.size()).isEqualTo(10);
        result.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rowNumber -> {
            Row row = (Row)result.apply(rowNumber);
            Assertions.assertThat((int)row.getArity()).isEqualTo(250);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 250).foreach((Function1 & Serializable & scala.Serializable)j -> CodeSplitITCase.$anonfun$testManyAggregationsWithGroupBy$7(rowNumber, row, BoxesRunTime.unboxToInt((Object)j)));
        });
    }

    @Test
    public void testManyIns() {
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT a FROM SmallTable3 WHERE a IN (");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1 & Serializable & scala.Serializable)i -> CodeSplitITCase.$anonfun$testManyIns$1(sql, BoxesRunTime.unboxToInt((Object)i)));
        sql.append(")");
        Seq result = (Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{1}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{2}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{3}), (List)Nil$.MODULE$)));
        this.runTest(sql.mkString(), (Seq<Row>)result);
    }

    public void runTest(String sql, Seq<Row> results) {
        this.tEnv().getConfig().set(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, (Object)BoxesRunTime.boxToInteger((int)4000));
        this.tEnv().getConfig().set(TableConfigOptions.MAX_MEMBERS_GENERATED_CODE, (Object)BoxesRunTime.boxToInteger((int)10000));
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString(sql)).mkString(), results, this.checkResult$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testSelectManyColumns$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testSelectManyColumns$3(ArrayBuffer results$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int a = tuple2._1$mcI$sp();
            int b = tuple2._2$mcI$sp();
            Row r = new Row(1002);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> r.setField(i - 1, (Object)BoxesRunTime.boxToInteger((int)(a + i * b))));
            r.setField(1000, (Object)BoxesRunTime.boxToInteger((int)a));
            r.setField(1001, (Object)BoxesRunTime.boxToInteger((int)b));
            results$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{r}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Object $anonfun$testManyAggregations$1(scala.collection.mutable.StringBuilder sql$3, int i) {
        sql$3.append(new StringBuilder(13).append("SUM(a + ").append(i).append(" * b)").toString());
        if (i != 300) {
            return sql$3.append(", ");
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$testManyValues$1(int i) {
        return new StringBuilder(7).append("  f").append(i).append(" INT").toString();
    }

    public static final /* synthetic */ String $anonfun$testManyValues$3(int i$1, int x$2) {
        return String.valueOf(BoxesRunTime.boxToInteger((int)i$1));
    }

    public static final /* synthetic */ String $anonfun$testManyValues$2(int i) {
        return new StringBuilder(2).append("(").append(((TraversableOnce)package$.MODULE$.Range().apply(0, 100).map((Function1 & Serializable & scala.Serializable)x$2 -> CodeSplitITCase.$anonfun$testManyValues$3(i, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$testManyValues$5(int i$2, int x$3) {
        return String.valueOf(BoxesRunTime.boxToInteger((int)i$2));
    }

    public static final /* synthetic */ String $anonfun$testManyAggregationsWithGroupBy$1(int i) {
        return new StringBuilder(8).append("  a_").append(i).append(" INT").toString();
    }

    public static final /* synthetic */ String $anonfun$testManyAggregationsWithGroupBy$2(int i) {
        return new StringBuilder(31).append("  'fields.a_").append(i).append(".kind' = 'sequence'").toString();
    }

    public static final /* synthetic */ String $anonfun$testManyAggregationsWithGroupBy$3(int i) {
        return new StringBuilder(25).append("  'fields.a_").append(i).append(".start' = '1'").toString();
    }

    public static final /* synthetic */ String $anonfun$testManyAggregationsWithGroupBy$4(int i) {
        return new StringBuilder(24).append("  'fields.a_").append(i).append(".end' = '10'").toString();
    }

    public static final /* synthetic */ String $anonfun$testManyAggregationsWithGroupBy$5(int i) {
        return new StringBuilder(15).append("  SUM(a_").append(i).append(") as a_").append(i).toString();
    }

    public static final /* synthetic */ ObjectAssert $anonfun$testManyAggregationsWithGroupBy$7(int rowNumber$1, Row row$1, int j) {
        int expectedRowValue = rowNumber$1 + 1;
        return (ObjectAssert)Assertions.assertThat((Object)row$1.getField(new StringBuilder(2).append("a_").append(j).toString())).withFailMessage(new StringOps(Predef$.MODULE$.augmentString("Invalid value for row %d and column a_%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rowNumber$1), BoxesRunTime.boxToInteger((int)j)})), new Object[0]).isEqualTo((Object)BoxesRunTime.boxToInteger((int)expectedRowValue));
    }

    public static final /* synthetic */ Object $anonfun$testManyIns$1(scala.collection.mutable.StringBuilder sql$4, int i) {
        sql$4.append(i);
        if (i != 10000) {
            return sql$4.append(", ");
        }
        return BoxedUnit.UNIT;
    }
}

