/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Instant;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.FileSystemITCaseBase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005daB\u001b7!\u0003\r\ta\u0011\u0005\u0006\u0015\u0002!\ta\u0013\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\u0012AC\u0011\u0002\u0018\u0001A\u0002\u0003\u0007I\u0011C/\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n#\t\u0007\"C=\u0001\u0001\u0004\u0005\r\u0011\"\u0005{\u0011\u0015a\b\u0001\"\u0001~\u0011\u0019\t\u0019\u0001\u0001C\u0001!\"9\u0011Q\u0001\u0001\u0007\u0002\u0005\u001d\u0001bBA\n\u0001\u0019\u0005\u0011Q\u0003\u0005\b\u0003c\u0001a\u0011AA\u001a\u0011\u001d\t\t\u0004\u0001C\u0001\u0003\u000fBq!!\u0017\u0001\t\u0003\tY\u0006\u0003\u0004\u0002d\u0001!\ta\u0013\u0005\u0007\u0003K\u0002A\u0011A&\t\r\u0005E\u0004\u0001\"\u0001L\u0011\u0019\t)\b\u0001C\u0001\u0017\"1\u0011\u0011\u0010\u0001\u0005\u0002-Ca!! \u0001\t\u0003Y\u0005BBAA\u0001\u0011\u00051\n\u0003\u0004\u0002\u0006\u0002!\ta\u0013\u0005\u0007\u0003\u0013\u0003A\u0011A&\t\r\u00055\u0005\u0001\"\u0001L\u0011\u0019\t\t\n\u0001C\u0001\u0017\"1\u0011Q\u0013\u0001\u0005\u0002-Ca!!'\u0001\t\u0003Y\u0005BBAO\u0001\u0011\u00051\n\u0003\u0004\u0002\"\u0002!\ta\u0013\u0005\u0007\u0003K\u0003A\u0011A&\t\r\u0005%\u0006\u0001\"\u0001L\u0011\u0019\ti\u000b\u0001C\u0001\u0017\u001e9\u0011\u0011\u0017\u001c\t\u0002\u0005MfAB\u001b7\u0011\u0003\t9\fC\u0004\u0002:\u0002\"\t!a/\t\u0013\u0005u\u0006E1A\u0005\u0002\u0005}\u0006\u0002CAgA\u0001\u0006I!!1\t\u0013\u0005=\u0007E1A\u0005\u0002\u0005E\u0007\u0002CAyA\u0001\u0006I!a5\t\u0013\t\u0005\u0001E1A\u0005\u0002\t\r\u0001\u0002\u0003B\nA\u0001\u0006IA!\u0002\t\u0013\tU\u0001E1A\u0005\u0002\t]\u0001\u0002\u0003B\rA\u0001\u0006I!a\u000f\t\u0013\tm\u0001E1A\u0005\u0002\t]\u0001\u0002\u0003B\u000fA\u0001\u0006I!a\u000f\t\u0013\t}\u0001E1A\u0005\u0002\t]\u0001\u0002\u0003B\u0011A\u0001\u0006I!a\u000f\t\u0013\t\r\u0002E1A\u0005\u0002\t]\u0001\u0002\u0003B\u0013A\u0001\u0006I!a\u000f\t\u0013\t\u001d\u0002E1A\u0005\u0002\t]\u0001\u0002\u0003B\u0015A\u0001\u0006I!a\u000f\u0007\r\t-\u0002\u0005\u0001B\u0017\u0011\u001d\tIL\rC\u0001\u0005\u000bBqAa\u00133\t\u0003\u0012iE\u0001\u000bGS2,7+_:uK6LEkQ1tK\n\u000b7/\u001a\u0006\u0003oa\nqA];oi&lWM\u0003\u0002:u\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u001e=\u0003\u0015!\u0018M\u00197f\u0015\tid(A\u0003gY&t7N\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0011\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001M!\t)U*\u0003\u0002O\r\n!QK\\5u\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002#B\u0011!+\u0017\b\u0003'^\u0003\"\u0001\u0016$\u000e\u0003US!A\u0016\"\u0002\rq\u0012xn\u001c;?\u0013\tAf)\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-G\u00039\u0011Xm];miB\u000bG\u000f[0%KF$\"\u0001\u00140\t\u000f}\u001b\u0011\u0011!a\u0001#\u0006\u0019\u0001\u0010J\u0019\u0002\u001d\u0019LG.\u001a+f[B4u\u000e\u001c3feV\t!\r\u0005\u0002dU6\tAM\u0003\u0002fM\u0006!a-\u001b7f\u0015\t9\u0007.A\u0002oS>T\u0011![\u0001\u0005U\u00064\u0018-\u0003\u0002lI\n!\u0001+\u0019;iQ\t!Q\u000e\u0005\u0002oo6\tqN\u0003\u0002qc\u0006\u0011\u0011n\u001c\u0006\u0003eN\f1!\u00199j\u0015\t!X/A\u0004kkBLG/\u001a:\u000b\u0005Y\u0004\u0015!\u00026v]&$\u0018B\u0001=p\u0005\u001d!V-\u001c9ESJ\f!CZ5mKR+W\u000e\u001d$pY\u0012,'o\u0018\u0013fcR\u0011Aj\u001f\u0005\b?\u0016\t\t\u00111\u0001c\u0003A1wN]7biB\u0013x\u000e]3si&,7\u000fF\u0001\u007f!\r)u0U\u0005\u0004\u0003\u00031%!B!se\u0006L\u0018!C4fiN\u001b\u0007.Z7f\u0003!!\u0018M\u00197f\u000b:4XCAA\u0005!\u0011\tY!a\u0004\u000e\u0005\u00055!B\u0001:;\u0013\u0011\t\t\"!\u0004\u0003!Q\u000b'\r\\3F]ZL'o\u001c8nK:$\u0018AD2iK\u000e\\\u0007K]3eS\u000e\fG/\u001a\u000b\u0006\u0019\u0006]\u00111\u0004\u0005\u0007\u00033I\u0001\u0019A)\u0002\u0011M\fH.U;fefDq!!\b\n\u0001\u0004\ty\"A\u0005dQ\u0016\u001c7NR;oGB1Q)!\t\u0002&1K1!a\tG\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY\u0003P\u0001\u0006if\u0004Xm]\u0005\u0005\u0003_\tICA\u0002S_^\fQa\u00195fG.$R\u0001TA\u001b\u0003oAa!!\u0007\u000b\u0001\u0004\t\u0006bBA\u001d\u0015\u0001\u0007\u00111H\u0001\u000fKb\u0004Xm\u0019;fIJ+7/\u001e7u!\u0019\ti$a\u0011\u0002&5\u0011\u0011q\b\u0006\u0004\u0003\u00032\u0015AC2pY2,7\r^5p]&!\u0011QIA \u0005\r\u0019V-\u001d\u000b\u0006\u0019\u0006%\u00131\n\u0005\u0007\u00033Y\u0001\u0019A)\t\u000f\u0005e2\u00021\u0001\u0002NA1\u0011qJA+\u0003Ki!!!\u0015\u000b\u0007\u0005M\u0003.\u0001\u0003vi&d\u0017\u0002BA,\u0003#\u0012A\u0001T5ti\u000692/\u001e9q_J$8OU3bI&tw-T3uC\u0012\fG/Y\u000b\u0003\u0003;\u00022!RA0\u0013\r\t\tG\u0012\u0002\b\u0005>|G.Z1o\u0003\u0011y\u0007/\u001a8\u0002mQ,7\u000f^*fY\u0016\u001cG\u000fR3dS6\fGnV5uQB\u0013XmY5tS>tG+\u001a8B]\u0012TVM]8Ge>lg)\u001b7f'f\u001cH/Z7)\u00079\tI\u0007\u0005\u0003\u0002l\u00055T\"A9\n\u0007\u0005=\u0014O\u0001\u0007UKN$H+Z7qY\u0006$X-A\u001cuKN$8+\u001a7fGR$UmY5nC2<\u0016\u000e\u001e5Qe\u0016\u001c\u0017n]5p]RC'/Z3B]\u0012$vo\u001c$s_64\u0015\u000e\\3TsN$X-\u001c\u0015\u0004\u001f\u0005%\u0014\u0001\u0007;fgR\fE\u000e\\*uCRL7\rU1si&$\u0018n\u001c8tc!\u001a\u0001#!\u001b\u00021Q,7\u000f^!mYN#\u0018\r^5d!\u0006\u0014H/\u001b;j_:\u001c(\u0007K\u0002\u0012\u0003S\n1\u0005^3ti\u0006cGn\u0015;bi&\u001c\u0007+\u0019:uSRLwN\\:XSRDW*\u001a;bI\u0006$\u0018\rK\u0002\u0013\u0003S\n1\u0004^3tiB\u000b'\u000f^5bY\u0012Kh.Y7jGB\u000b'\u000f^5uS>t\u0007fA\n\u0002j\u0005!B/Z:u\tft\u0017-\\5d!\u0006\u0014H/\u001b;j_:D3\u0001FA5\u0003m!Xm\u001d;QCJ$\u0018\u000e^5p]^KG\u000f\u001b%jI\u0012,gNR5mK\"\u001aQ#!\u001b\u0002!Q,7\u000f\u001e(p]B\u000b'\u000f^5uS>t\u0007f\u0001\f\u0002j\u0005aB/Z:u\u001d>t\u0007+\u0019:uSRLwN\\,ji\"lU\r^1eCR\f\u0007fA\f\u0002j\u0005\u0019B/Z:u%\u0016\fG-\u00117m\u001b\u0016$\u0018\rZ1uC\"\u001a\u0001$!\u001b\u0002#Q,7\u000f\u001e'j[&$\b+^:i\t><h\u000eK\u0002\u001a\u0003S\n!\u0003^3ti\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u001a!$!\u001b\u0002'Q,7\u000f\u001e)s_*,7\r\u001e)vg\"$un\u001e8)\u0007m\tI'\u0001\tuKN$\u0018J\\:feR\f\u0005\u000f]3oI\"\u001aA$!\u001b\u0002'Q,7\u000f^%og\u0016\u0014Ho\u0014<fe^\u0014\u0018\u000e^3)\u0007u\tI'A\u0010uKN$8)^:u_6\u0004\u0016M\u001d;ji&|gnQ8n[&$\bk\u001c7jGfD3AHA5\u0003Q1\u0015\u000e\\3TsN$X-\\%U\u0007\u0006\u001cXMQ1tKB\u0019\u0011Q\u0017\u0011\u000e\u0003Y\u001a\"\u0001\t#\u0002\rqJg.\u001b;?)\t\t\u0019,\u0001\u0006gS\u0016dGMT1nKN,\"!!1\u0011\t\u0015{\u00181\u0019\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a5\u0002\t1\fgnZ\u0005\u00045\u0006\u001d\u0017a\u00034jK2$g*Y7fg\u0002\n!BZ5fY\u0012$\u0016\u0010]3t+\t\t\u0019\u000e\u0005\u0003F\u007f\u0006U\u0007\u0007BAl\u0003[\u0004b!!7\u0002f\u0006%XBAAn\u0015\u0011\ti.a8\u0002\u0011QL\b/Z5oM>TA!!9\u0002d\u000611m\\7n_:T!A\u001d\u001f\n\t\u0005\u001d\u00181\u001c\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]B!\u00111^Aw\u0019\u0001!1\"a<&\u0003\u0003\u0005\tQ!\u0001\u0002t\n\u0019q\fJ\u0019\u0002\u0017\u0019LW\r\u001c3UsB,7\u000fI\t\u0005\u0003k\fY\u0010E\u0002F\u0003oL1!!?G\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!RA\u007f\u0013\r\tyP\u0012\u0002\u0004\u0003:L\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005\u001fi!A!\u0003\u000b\t\t-!QB\u0001\nif\u0004X-\u001e;jYNT1![Ar\u0013\u0011\u0011\tB!\u0003\u0003\u0017I{w\u000fV=qK&sgm\\\u0001\nI\u0006$\u0018\rV=qK\u0002\nA\u0003Z1uC~;\u0018\u000e\u001e5`a\u0006\u0014H/\u001b;j_:\u001cXCAA\u001e\u0003U!\u0017\r^1`o&$\bn\u00189beRLG/[8og\u0002\nA\u0001Z1uC\u0006)A-\u0019;bA\u0005\u0011B-\u0019;b?B\f'\u000f^5uS>tw,M02\u0003M!\u0017\r^1`a\u0006\u0014H/\u001b;j_:|\u0016gX\u0019!\u0003I!\u0017\r^1`a\u0006\u0014H/\u001b;j_:|&gX\u0019\u0002'\u0011\fG/Y0qCJ$\u0018\u000e^5p]~\u0013t,\r\u0011\u0002%\u0011\fG/Y0qCJ$\u0018\u000e^5p]~\u000btLM\u0001\u0014I\u0006$\u0018m\u00189beRLG/[8o?Fz&\u0007\t\u0002\u000b)\u0016\u001cH\u000fU8mS\u000eL8#\u0002\u001a\u00030\tU\u0002\u0003BAc\u0005cIAAa\r\u0002H\n1qJ\u00196fGR\u0004BAa\u000e\u0003B5\u0011!\u0011\b\u0006\u0004w\tm\"bA3\u0003>)\u0019!q\b\u001f\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B\"\u0005s\u0011Q\u0003U1si&$\u0018n\u001c8D_6l\u0017\u000e\u001e)pY&\u001c\u0017\u0010\u0006\u0002\u0003HA\u0019!\u0011\n\u001a\u000e\u0003\u0001\naaY8n[&$Hc\u0001'\u0003P!9!\u0011\u000b\u001bA\u0002\tM\u0013aB2p]R,\u0007\u0010\u001e\t\u0005\u0005+\u0012YF\u0004\u0003\u00038\t]\u0013\u0002\u0002B-\u0005s\tQ\u0003U1si&$\u0018n\u001c8D_6l\u0017\u000e\u001e)pY&\u001c\u00170\u0003\u0003\u0003^\t}#aB\"p]R,\u0007\u0010\u001e\u0006\u0005\u00053\u0012I\u0004")
public interface FileSystemITCaseBase {
    public static Seq<Row> data_partition_1_2() {
        return FileSystemITCaseBase$.MODULE$.data_partition_1_2();
    }

    public static Seq<Row> data_partition_2_1() {
        return FileSystemITCaseBase$.MODULE$.data_partition_2_1();
    }

    public static Seq<Row> data_partition_1_1() {
        return FileSystemITCaseBase$.MODULE$.data_partition_1_1();
    }

    public static Seq<Row> data() {
        return FileSystemITCaseBase$.MODULE$.data();
    }

    public static Seq<Row> data_with_partitions() {
        return FileSystemITCaseBase$.MODULE$.data_with_partitions();
    }

    public static RowTypeInfo dataType() {
        return FileSystemITCaseBase$.MODULE$.dataType();
    }

    public static TypeInformation<?>[] fieldTypes() {
        return FileSystemITCaseBase$.MODULE$.fieldTypes();
    }

    public static String[] fieldNames() {
        return FileSystemITCaseBase$.MODULE$.fieldNames();
    }

    public String resultPath();

    public void resultPath_$eq(String var1);

    public java.nio.file.Path fileTempFolder();

    public void fileTempFolder_$eq(java.nio.file.Path var1);

    public static /* synthetic */ String[] formatProperties$(FileSystemITCaseBase $this) {
        return $this.formatProperties();
    }

    default public String[] formatProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public static /* synthetic */ String getScheme$(FileSystemITCaseBase $this) {
        return $this.getScheme();
    }

    default public String getScheme() {
        return "file";
    }

    public TableEnvironment tableEnv();

    public void checkPredicate(String var1, Function1<Row, BoxedUnit> var2);

    public void check(String var1, Seq<Row> var2);

    public static /* synthetic */ void check$(FileSystemITCaseBase $this, String sqlQuery, java.util.List expectedResult) {
        $this.check(sqlQuery, expectedResult);
    }

    default public void check(String sqlQuery, java.util.List<Row> expectedResult) {
        this.check(sqlQuery, (Seq<Row>)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(expectedResult.iterator()).asScala()).toSeq());
    }

    public static /* synthetic */ boolean supportsReadingMetadata$(FileSystemITCaseBase $this) {
        return $this.supportsReadingMetadata();
    }

    default public boolean supportsReadingMetadata() {
        return true;
    }

    public static /* synthetic */ void open$(FileSystemITCaseBase $this) {
        $this.open();
    }

    default public void open() {
        this.resultPath_$eq(TempDirUtils.newFolder((java.nio.file.Path)this.fileTempFolder()).toURI().getPath());
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tableEnv(), "originalT", FileSystemITCaseBase$.MODULE$.data_with_partitions(), FileSystemITCaseBase$.MODULE$.dataType(), "x, y, a, b");
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(289).append("\n         |create table partitionedTable (\n         |  x string,\n         |  y int,\n         |  a int,\n         |  b bigint,\n         |  c as b + 1\n         |) partitioned by (a, b) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        Object object = this.supportsReadingMetadata() ? this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(374).append("\n           |create table partitionedTableWithMetadata (\n           |  x string,\n           |  y int,\n           |  a int,\n           |  b bigint,\n           |  c as b + 1,\n           |  f string metadata from 'file.path'\n           |) partitioned by (a, b) with (\n           |  'connector' = 'filesystem',\n           |  'path' = '").append(this.resultPath()).append("',\n           |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n           |)\n           ").toString())).stripMargin()) : BoxedUnit.UNIT;
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         |create table nonPartitionedTable (\n         |  x string,\n         |  y int,\n         |  a int,\n         |  b bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        Object object2 = this.supportsReadingMetadata() ? this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           |create table nonPartitionedTableWithMetadata (\n           |  x string,\n           |  y int,\n           |  a int,\n           |  f string metadata from 'file.path',\n           |  b bigint\n           |) with (\n           |  'connector' = 'filesystem',\n           |  'path' = '").append(this.resultPath()).append("',\n           |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n           |)\n         ").toString())).stripMargin()) : BoxedUnit.UNIT;
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(225).append("\n         |create table hasDecimalFieldWithPrecisionTenAndZeroTable (\n         |  x decimal(10, 0), y int\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(225).append("\n         |create table hasDecimalFieldWithPrecisionThreeAndTwoTable (\n         |  x decimal(3, 2), y int\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin());
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("\n         |create table table_custom_partition_commit_policy (\n         |  x varchar, y int\n         |) PARTITIONED BY (x) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.getScheme()).append("://").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append(",\n         |  'sink.partition-commit.policy.kind' = 'custom',\n         |  'sink.partition-commit.policy.class' = '").append(TestPolicy.class.getName()).append("'\n         |)\n ").toString())).stripMargin());
    }

    public static /* synthetic */ void testSelectDecimalWithPrecisionTenAndZeroFromFileSystem$(FileSystemITCaseBase $this) {
        $this.testSelectDecimalWithPrecisionTenAndZeroFromFileSystem();
    }

    @TestTemplate
    default public void testSelectDecimalWithPrecisionTenAndZeroFromFileSystem() {
        this.tableEnv().executeSql("insert into hasDecimalFieldWithPrecisionTenAndZeroTable(x, y) values(cast(2113554011 as decimal(10, 0)), 1), (cast(2113554022 as decimal(10,0)), 2)").await();
        this.check("select x, y from hasDecimalFieldWithPrecisionTenAndZeroTable", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2113554011), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2113554022), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
    }

    public static /* synthetic */ void testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem$(FileSystemITCaseBase $this) {
        $this.testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem();
    }

    @TestTemplate
    default public void testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem() {
        this.tableEnv().executeSql("insert into hasDecimalFieldWithPrecisionThreeAndTwoTable(x,y) values(cast(1.32 as decimal(3, 2)), 1), (cast(2.64 as decimal(3, 2)), 2)").await();
        this.check("select x, y from hasDecimalFieldWithPrecisionThreeAndTwoTable", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.32), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.64), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
    }

    public static /* synthetic */ void testAllStaticPartitions1$(FileSystemITCaseBase $this) {
        $this.testAllStaticPartitions1();
    }

    @TestTemplate
    default public void testAllStaticPartitions1() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        this.check("select x, y from partitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    public static /* synthetic */ void testAllStaticPartitions2$(FileSystemITCaseBase $this) {
        $this.testAllStaticPartitions2();
    }

    @TestTemplate
    default public void testAllStaticPartitions2() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a='2', b='1') select x, y from originalT where a=2 and b=1").await();
        this.check("select x, y from partitionedTable where a=2 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
    }

    public static /* synthetic */ void testAllStaticPartitionsWithMetadata$(FileSystemITCaseBase $this) {
        $this.testAllStaticPartitionsWithMetadata();
    }

    @TestTemplate
    default public void testAllStaticPartitionsWithMetadata() {
        if (!this.supportsReadingMetadata()) {
            return;
        }
        this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        this.checkPredicate("select x, f, y from partitionedTableWithMetadata where a=1 and b=1", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testAllStaticPartitionsWithMetadata$1(this, row);
            return BoxedUnit.UNIT;
        });
        this.checkPredicate("select x, f, y from partitionedTableWithMetadata", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testAllStaticPartitionsWithMetadata$2(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testPartialDynamicPartition$(FileSystemITCaseBase $this) {
        $this.testPartialDynamicPartition();
    }

    @TestTemplate
    default public void testPartialDynamicPartition() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a=3) select x, y, b from originalT where a=3").await();
        this.check("select x, y from partitionedTable where a=2 and b=1", (Seq<Row>)((Seq)Nil$.MODULE$));
        this.check("select x, y from partitionedTable where a=3 and b=1", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x17", BoxesRunTime.boxToInteger((int)17)})), (List)Nil$.MODULE$)));
        this.check("select x, y from partitionedTable where a=3 and b=2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x18", BoxesRunTime.boxToInteger((int)18)})), (List)Nil$.MODULE$)));
        this.check("select x, y from partitionedTable where a=3 and b=3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x19", BoxesRunTime.boxToInteger((int)19)})), (List)Nil$.MODULE$)));
        this.check("select x, y from partitionedTable where a=3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x17", BoxesRunTime.boxToInteger((int)17)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x18", BoxesRunTime.boxToInteger((int)18)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x19", BoxesRunTime.boxToInteger((int)19)})), (List)Nil$.MODULE$)))));
    }

    public static /* synthetic */ void testDynamicPartition$(FileSystemITCaseBase $this) {
        $this.testDynamicPartition();
    }

    @TestTemplate
    default public void testDynamicPartition() {
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.check("select x, y from partitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
        this.check("select x, y from partitionedTable where a=2 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
        this.check("select x, y, a, b, c from partitionedTable where a=1 and c=2", FileSystemITCaseBase$.MODULE$.data_partition_1_2());
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data());
    }

    public static /* synthetic */ void testPartitionWithHiddenFile$(FileSystemITCaseBase $this) {
        $this.testPartitionWithHiddenFile();
    }

    @TestTemplate
    default public void testPartitionWithHiddenFile() {
        this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        Assertions.assertThat((boolean)new File(new Path(new StringBuilder(14).append("file:").append(this.resultPath()).append("/a=1/.b=2").toString()).toUri()).mkdir()).isTrue();
        this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    public static /* synthetic */ void testNonPartition$(FileSystemITCaseBase $this) {
        $this.testNonPartition();
    }

    @TestTemplate
    default public void testNonPartition() {
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT where a=1 and b=1").await();
        this.check("select x, y from nonPartitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    public static /* synthetic */ void testNonPartitionWithMetadata$(FileSystemITCaseBase $this) {
        $this.testNonPartitionWithMetadata();
    }

    @TestTemplate
    default public void testNonPartitionWithMetadata() {
        if (!this.supportsReadingMetadata()) {
            return;
        }
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT where a=1 and b=1").await();
        this.checkPredicate("select x, f, y from nonPartitionedTableWithMetadata where a=1 and b=1", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testNonPartitionWithMetadata$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testReadAllMetadata$(FileSystemITCaseBase $this) {
        $this.testReadAllMetadata();
    }

    @TestTemplate
    default public void testReadAllMetadata() {
        if (!this.supportsReadingMetadata()) {
            return;
        }
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(366).append("\n         |CREATE TABLE metadataTable (\n         |  x STRING,\n         |  `file.path` STRING METADATA,\n         |  `file.name` STRING METADATA,\n         |  `file.size` BIGINT METADATA,\n         |  `file.modification-time` TIMESTAMP_LTZ(3) METADATA\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.resultPath()).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.formatProperties())).mkString(",\n")).append("\n         |)\n         ").toString())).stripMargin());
        this.tableEnv().executeSql("INSERT INTO nonPartitionedTable (x) SELECT x FROM originalT LIMIT 1").await();
        this.checkPredicate("SELECT * FROM metadataTable", (Function1<Row, BoxedUnit>)(Function1 & Serializable & scala.Serializable)row -> {
            FileSystemITCaseBase.$anonfun$testReadAllMetadata$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testLimitPushDown$(FileSystemITCaseBase $this) {
        $this.testLimitPushDown();
    }

    @TestTemplate
    default public void testLimitPushDown() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT").await();
        this.check("select x, y from nonPartitionedTable limit 3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x1", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x3", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
    }

    public static /* synthetic */ void testFilterPushDown$(FileSystemITCaseBase $this) {
        $this.testFilterPushDown();
    }

    @TestTemplate
    default public void testFilterPushDown() {
        this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT").await();
        this.check("select x, y from nonPartitionedTable where a=10086", (Seq<Row>)((Seq)Nil$.MODULE$));
    }

    public static /* synthetic */ void testProjectPushDown$(FileSystemITCaseBase $this) {
        $this.testProjectPushDown();
    }

    @TestTemplate
    default public void testProjectPushDown() {
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"})), (List)Nil$.MODULE$)))));
    }

    public static /* synthetic */ void testInsertAppend$(FileSystemITCaseBase $this) {
        $this.testInsertAppend();
    }

    @TestTemplate
    default public void testInsertAppend() {
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"})), (List)Nil$.MODULE$))))))));
    }

    public static /* synthetic */ void testInsertOverwrite$(FileSystemITCaseBase $this) {
        $this.testInsertOverwrite();
    }

    @TestTemplate
    default public void testInsertOverwrite() {
        this.tableEnv().executeSql("insert overwrite partitionedTable select x, y, a, b from originalT").await();
        this.tableEnv().executeSql("insert overwrite partitionedTable select x, y, a, b from originalT").await();
        this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"})), (List)Nil$.MODULE$)))));
    }

    public static /* synthetic */ void testCustomPartitionCommitPolicy$(FileSystemITCaseBase $this) {
        $this.testCustomPartitionCommitPolicy();
    }

    @TestTemplate
    default public void testCustomPartitionCommitPolicy() {
        this.tableEnv().executeSql("insert into table_custom_partition_commit_policy values ('p1', 1), ('p1', 2)").await();
        File file = new File(new StringBuilder(20).append(this.resultPath()).append("/x=p1/_custom_commit").toString());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.exists());
    }

    public static /* synthetic */ void $anonfun$testAllStaticPartitionsWithMetadata$1(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)row.getField("f")).isNotNull();
        Assertions.assertThat((Object)row.getField(1)).isNotNull();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(((Object)$this.fileTempFolder().getParent()).toString())).isTrue();
    }

    public static /* synthetic */ void $anonfun$testAllStaticPartitionsWithMetadata$2(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)row.getField("f")).isNotNull();
        Assertions.assertThat((Object)row.getField(1)).isNotNull();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(((Object)$this.fileTempFolder().getRoot()).toString())).isTrue();
    }

    public static /* synthetic */ void $anonfun$testNonPartitionWithMetadata$1(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)row.getField("f")).isNotNull();
        Assertions.assertThat((Object)row.getField(1)).isNotNull();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(((Object)$this.fileTempFolder().getRoot()).toString())).isTrue();
    }

    public static /* synthetic */ void $anonfun$testReadAllMetadata$1(FileSystemITCaseBase $this, Row row) {
        Assertions.assertThat((int)row.getArity()).isEqualTo(5);
        File file = new File(URI.create($this.resultPath()).getPath()).listFiles()[0];
        String filename = ((Object)Paths.get(file.toURI()).getFileName()).toString();
        Assertions.assertThat((boolean)((String)row.getFieldAs(1)).contains(filename)).isTrue();
        Assertions.assertThat((String)((String)row.getFieldAs(2))).isEqualTo(filename);
        Assertions.assertThat((long)BoxesRunTime.unboxToLong((Object)row.getFieldAs(3))).isEqualTo(file.length());
        Assertions.assertThat((Instant)((Instant)row.getFieldAs(4))).isEqualTo((Object)Instant.ofEpochMilli(file.lastModified()));
    }

    public static void $init$(FileSystemITCaseBase $this) {
    }

    public static class TestPolicy
    implements PartitionCommitPolicy {
        public void commit(PartitionCommitPolicy.Context context) {
            FileSystem fs = context.partitionPath().getFileSystem();
            fs.create(new Path(context.partitionPath(), "_custom_commit"), FileSystem.WriteMode.OVERWRITE).close();
        }
    }
}

