/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.planner.plan.utils.RexNodeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.IntSumAggFunction;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0012%\u0001MBQ\u0001\u000f\u0001\u0005\u0002eBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019a\u0005\u0001)A\u0005\r\"9Q\n\u0001b\u0001\n\u0003q\u0005BB+\u0001A\u0003%q\nC\u0004W\u0001\t\u0007I\u0011A,\t\ry\u0003\u0001\u0015!\u0003Y\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007\"B3\u0001\t\u00031\u0007\"B<\u0001\t\u00031\u0007\"B=\u0001\t\u00031\u0007\"B>\u0001\t\u00031\u0007\"B?\u0001\t\u00031\u0007\"B@\u0001\t\u00031\u0007BBA\u0002\u0001\u0011\u0005a\r\u0003\u0004\u0002\b\u0001!\tA\u001a\u0005\u0007\u0003\u0017\u0001A\u0011\u00014\t\r\u0005=\u0001\u0001\"\u0001g\u0011\u0019\t\u0019\u0002\u0001C\u0001M\"1\u0011q\u0003\u0001\u0005\u0002\u0019Da!a\u0007\u0001\t\u00031\u0007BBA\u0010\u0001\u0011\u0005a\r\u0003\u0004\u0002$\u0001!\tA\u001a\u0005\u0007\u0003O\u0001A\u0011\u00014\t\r\u0005-\u0002\u0001\"\u0001g\u0011\u0019\ty\u0003\u0001C\u0001M\"1\u00111\u0007\u0001\u0005\u0002\u0019Da!a\u000e\u0001\t\u00031\u0007bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\ty\n\u0001C\u0005\u0003C\u0013ACU3y\u001d>$W-\u0012=ue\u0006\u001cGo\u001c:UKN$(BA\u0013'\u0003\u0015)H/\u001b7t\u0015\t9\u0003&\u0001\u0003qY\u0006t'BA\u0015+\u0003\u001d\u0001H.\u00198oKJT!a\u000b\u0017\u0002\u000bQ\f'\r\\3\u000b\u00055r\u0013!\u00024mS:\\'BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001iA\u0011QGN\u0007\u0002I%\u0011q\u0007\n\u0002\u0010%\u0016Dhj\u001c3f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012A\u000f\t\u0003k\u0001\t1\u0002^1cY\u0016\u001cuN\u001c4jOV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002AU\u0005\u0019\u0011\r]5\n\u0005\t{$a\u0003+bE2,7i\u001c8gS\u001e\fA\u0002^1cY\u0016\u001cuN\u001c4jO\u0002\nqB]3t_V\u00148-Z'b]\u0006<WM]\u000b\u0002\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011JK\u0001\te\u0016\u001cx.\u001e:dK&\u00111\n\u0013\u0002\u0010%\u0016\u001cx.\u001e:dK6\u000bg.Y4fe\u0006\u0001\"/Z:pkJ\u001cW-T1oC\u001e,'\u000fI\u0001\u000fG\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*+\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001V)\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe\u0006y1-\u0019;bY><W*\u00198bO\u0016\u0014\b%A\u0007n_\u0012,H.Z'b]\u0006<WM]\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111LK\u0001\u0007[>$W\u000f\\3\n\u0005uS&!D'pIVdW-T1oC\u001e,'/\u0001\bn_\u0012,H.Z'b]\u0006<WM\u001d\u0011\u0002\u001f\u0019,hn\u0019;j_:\u001c\u0015\r^1m_\u001e,\u0012!\u0019\t\u0003!\nL!aY)\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001e\f\u0001CZ;oGRLwN\\\"bi\u0006dwn\u001a\u0011\u00023Q,7\u000f^#yiJ\f7\r\u001e*fM&s\u0007/\u001e;GS\u0016dGm\u001d\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\n!QK\\5uQ\taa\u000e\u0005\u0002pk6\t\u0001O\u0003\u0002Ac*\u0011!o]\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!\b'A\u0003kk:LG/\u0003\u0002wa\n!A+Z:u\u0003}!Xm\u001d;FqR\u0014\u0018m\u0019;SK\u001atUm\u001d;fI&s\u0007/\u001e;GS\u0016dGm\u001d\u0015\u0003\u001b9\fA\u0006^3ti\u0016CHO]1diJ+gMT3ti\u0016$\u0017J\u001c9vi\u001aKW\r\u001c3t/&$\bNT8OKN$\u0018N\\4)\u00059q\u0017a\t;fgR,\u0005\u0010\u001e:bGR$U-\u001a9SK\u001atUm\u001d;fI&s\u0007/\u001e;GS\u0016dGm\u001d\u0015\u0003\u001f9\f!\u0004^3ti\u0016CHO]1diNKW\u000e\u001d7f\u0007>tG-\u001b;j_:D#\u0001\u00058\u00025Q,7\u000f^#yiJ\f7\r^*j]\u001edWmQ8oI&$\u0018n\u001c8)\u0005Eq\u0017!\n;fgR,\u0005\u0010\u001e:bGR\u001cuN\u001c3ji&|gnV5uQ\nKg.\u0019:z\u0019&$XM]1mQ\t\u0011b.A\fuKN$X\t\u001f;sC\u000e$8I\u001c4D_:$\u0017\u000e^5p]\"\u00121C\\\u0001\u001ai\u0016\u001cH/\u0012=ue\u0006\u001cG/\u0011(E\u000bb\u0004(/Z:tS>t7\u000f\u000b\u0002\u0015]\u0006iB/Z:u\u001dVlWM]5d\u0019&$XM]1m\u0007>tg/\u001a:tS>t7\u000f\u000b\u0002\u0016]\u0006QB/Z:u)&lW\rT5uKJ\fGnQ8om\u0016\u00148/[8og\"\u0012aC\\\u0001 i\u0016\u001cH/\u0012=ue\u0006\u001cG/\u0011:ji\"lW\r^5d\u0007>tG-\u001b;j_:\u001c\bFA\fo\u0003q!Xm\u001d;FqR\u0014\u0018m\u0019;Q_N$h-\u001b=D_:$\u0017\u000e^5p]ND#\u0001\u00078\u0002KQ,7\u000f^#yiJ\f7\r^\"p]\u0012LG/[8o/&$\bNR;oGRLwN\\\"bY2\u001c\bFA\ro\u0003M!Xm\u001d;FqR\u0014\u0018m\u0019;XSRD7)Y:uQ\tQb.A\nuKN$X\t\u001f;sC\u000e$x+\u001b;i)JLW\u000e\u000b\u0002\u001c]\u0006\u0011B/Z:u\u000bb$(/Y2u/&$\b.\u00163gQ\tab.\u0001\u0010uKN$X\t\u001f;sC\u000e$\b+\u0019:uSRLwN\u001c)sK\u0012L7-\u0019;fg\"\u0012QD\\\u0001#i\u0016\u001cH/\u0012=ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8Qe\u0016$\u0017nY1uKN$\u0015\r^3)\u0005yq\u0017a\u000b;fgR$\u0016.\\3MSR,'/\u00197XSRDGj\\2bYRKW.\u001a.p]\u0016\u001cuN\u001c<feNLwN\\:)\u0005}q\u0017!\t;fgR,\u0005\u0010\u001e:bGR\u001c\u0016N\\4mKB{7\u000f\u001e4jq\u000e{g\u000eZ5uS>tGcB4\u0002@\u0005M\u0013q\r\u0005\b\u0003\u0003\u0002\u0003\u0019AA\"\u0003)1\u0017.\u001a7e\u0013:$W\r\u001f\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!!\u0015\u0002H\t9\u0011J\u001c;fO\u0016\u0014\bbBA+A\u0001\u0007\u0011qK\u0001\u0003_B\u0004B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&A\u0002tc2T1!!\u0019/\u0003\u001d\u0019\u0017\r\\2ji\u0016LA!!\u001a\u0002\\\t\u00112+\u001d7Q_N$h-\u001b=Pa\u0016\u0014\u0018\r^8s\u0011\u001d\tI\u0007\ta\u0001\u0003W\nA!\u001a=qeB!\u0011QNA>\u001d\u0011\ty'a\u001e\u0011\u0007\u0005E\u0014.\u0004\u0002\u0002t)\u0019\u0011Q\u000f\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\tI([\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0014q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e\u0014.A\u000ebgN,'\u000f^#yaJ,7o]5p]\u0006\u0013(/Y=FcV\fGn\u001d\u000b\u0006O\u0006\u0015\u00151\u0014\u0005\b\u0003\u000f\u000b\u0003\u0019AAE\u0003!)\u0007\u0010]3di\u0016$\u0007#\u00025\u0002\f\u0006=\u0015bAAGS\n)\u0011I\u001d:bsB!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016*\n1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011TAJ\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003;\u000b\u0003\u0019AAE\u0003\u0019\t7\r^;bY\u0006aR\r\u001f;sC\u000e$8i\u001c8kk:\u001cG/\u001b<f\u0007>tG-\u001b;j_:\u001cHCCAR\u0003o\u000bI,!3\u0002TB9\u0001.!*\u0002\n\u0006%\u0016bAATS\n1A+\u001e9mKJ\u0002R\u0001[AF\u0003W\u0003B!!,\u000246\u0011\u0011q\u0016\u0006\u0005\u0003c\u000by&A\u0002sKbLA!!.\u00020\n9!+\u001a=O_\u0012,\u0007bBA5E\u0001\u0007\u00111\u0016\u0005\b\u0003w\u0013\u0003\u0019AA_\u0003=Ig\u000e];u\r&,G\u000e\u001a(b[\u0016\u001c\bCBA`\u0003\u000b\fY'\u0004\u0002\u0002B*!\u00111YA&\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002L\n\u0002\r!!4\u0002\u0015I,\u0007PQ;jY\u0012,'\u000f\u0005\u0003\u0002.\u0006=\u0017\u0002BAi\u0003_\u0013!BU3y\u0005VLG\u000eZ3s\u0011\u0015\u0011&\u00051\u0001b\u0001")
public class RexNodeExtractorTest
extends RexNodeTestBase {
    private final TableConfig tableConfig = TableConfig.getDefault();
    private final ResourceManager resourceManager = ResourceManager.createResourceManager((URL[])new URL[0], (ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)this.tableConfig().getConfiguration());
    private final CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
    private final ModuleManager moduleManager = new ModuleManager();
    private final FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)this.tableConfig(), this.resourceManager(), this.catalogManager(), this.moduleManager());

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    public ResourceManager resourceManager() {
        return this.resourceManager;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public ModuleManager moduleManager() {
        return this.moduleManager;
    }

    private FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    @Test
    public void testExtractRefInputFields() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List exprs = (java.util.List)tuple2._1();
        java.util.List exprs2 = exprs;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(exprs2);
        Assertions.assertThat((int[])usedFields).isEqualTo((Object)new int[]{2, 3, 1});
    }

    @Test
    public void testExtractRefNestedInputFields() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List rexProgram = (java.util.List)tuple2._1();
        java.util.List rexProgram2 = rexProgram;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(rexProgram2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(rexProgram2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"amount"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})})});
        Assertions.assertThat((Object[][])usedNestedFields).isEqualTo((Object)expected);
    }

    @Test
    public void testExtractRefNestedInputFieldsWithNoNesting() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List exprs = (java.util.List)tuple2._1();
        java.util.List exprs2 = exprs;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(exprs2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(exprs2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})})});
        Assertions.assertThat((Object[][])usedNestedFields).isEqualTo((Object)expected);
    }

    @Test
    public void testExtractDeepRefNestedInputFields() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List rexProgram = (java.util.List)tuple2._1();
        java.util.List rexProgram2 = rexProgram;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(rexProgram2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(rexProgram2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"amount"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"with", "deeper", "entry"}), Arrays.asList((Object[])new String[]{"with", "deep", "entry"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"outer"}), Arrays.asList((Object[])new String[]{"inner", "deep_array"})})});
        Assertions.assertThat((int[])usedFields).isEqualTo((Object)new int[]{1, 0, 2, 3});
        Assertions.assertThat((Object[][])usedNestedFields).isEqualTo((Object)expected);
    }

    @Test
    public void testExtractSimpleCondition() {
        FlinkRexBuilder builder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        RexNode expr = this.buildConditionExpr();
        Expression firstExp = package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(6));
        Expression secondExp = package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$))).$less(package$.MODULE$.int2Literal(100));
        Expression[] expected = (Expression[])((Object[])new Expression[]{firstExp, secondExp});
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(expr, this.allFieldNames(), (RexBuilder)builder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testExtractSingleCondition() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(a, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$greater$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testExtractConditionWithBinaryLiteral() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(5), 5);
        RexLiteral t1 = this.rexBuilder().makeBinaryLiteral(ByteString.of((String)"616263", (int)16));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t0, t1});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(a, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blob"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.array2ArrayConstructor(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{97, 98, 99}), ClassTag$.MODULE$.Byte())))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testExtractCnfCondition() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200L));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode e = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))).asJava());
        RexNode or = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)and, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)e, (List)Nil$.MODULE$)))).asJava());
        RexNode not = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)d, (List)Nil$.MODULE$)).asJava());
        RexNode complexNode = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)or, (List)new .colon.colon((Object)not, (List)Nil$.MODULE$))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexNode, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less(package$.MODULE$.int2Literal(100))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(100)))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(200))), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(100)))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(200))), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).unary_$bang()});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testExtractANDExpressions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(100))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testNumericLiteralConversions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200.1));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t4});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToInteger((int)100))}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount"), ApiExpressionUtils.unresolvedRef((String)"id")}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"id"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToDouble((double)200.1))}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"price"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToDouble((double)200.1))})});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testTimeLiteralConversions() {
        FlinkRexBuilder relBuilder;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"date_col", (List)new .colon.colon((Object)"time_col", (List)Nil$.MODULE$)))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.DATE, SqlTypeName.TIME}));
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 3);
        RexLiteral rexDate = this.rexBuilder().makeDateLiteral(new DateString("2017-09-12"));
        RexLiteral rexTime = this.rexBuilder().makeTimeLiteral(new TimeString("14:23:01"), 0);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexDate, (List)new .colon.colon((Object)rexTime, (List)Nil$.MODULE$)));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).asJava();
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, fieldNames, (RexBuilder)(relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory())), this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] converted = (Expression[])tuple2._1();
        Expression[] converted2 = converted;
        LocalDateTime datetime = DateTimeTestUtil$.MODULE$.localDateTime("2017-09-10 14:23:01");
        LocalDate date = DateTimeTestUtil$.MODULE$.localDate("2017-09-12");
        LocalTime time = DateTimeTestUtil$.MODULE$.localTime("14:23:01");
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"timestamp_col"), ApiExpressionUtils.valueLiteral((Object)datetime)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"date_col"), ApiExpressionUtils.valueLiteral((Object)date)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"time_col"), ApiExpressionUtils.valueLiteral((Object)time)})});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    @Test
    public void testExtractArithmeticConditions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall(FlinkSqlOperatorTable.DIVIDE, new RexNode[]{t0, t1}), t2})}))).asJava();
        RexNode complexExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexExpr, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$bang$eq$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$greater$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$plus(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$minus(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$div(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testExtractPostfixConditions() {
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NULL, "isNull(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_TRUE, "isTrue(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_TRUE, "isNotTrue(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_FALSE, "isFalse(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_FALSE, "isNotFalse(flag)");
    }

    @Test
    public void testExtractConditionWithFunctionCalls() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode condition1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SUM, new RexNode[]{t0}), t2});
        RexNode condition2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.FIRST_VALUE, new RexNode[]{t1}), t2});
        RexNode complexExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexExpr, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)new AggregateFunctionDefinition("sum", (AggregateFunction)new IntSumAggFunction(), Types.INT, Types.INT), (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount")}), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToInteger((int)100))})});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assertions.assertThat((Object[])unconvertedRexNodes2).hasSize(1);
    }

    @Test
    public void testExtractWithCast() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode cast = this.rexBuilder().makeCast(this.allFieldTypes().get(1), (RexNode)t0);
        RexNode condition1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{cast, t2});
        RexNode condition2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode condition3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{condition1, condition2});
        RexNode conditionExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2, condition3});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(conditionExpr, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Assertions.assertThat((Object[])convertedExpressions2).hasSize(3);
        Assertions.assertThat((String)convertedExpressions2[0].toString()).isEqualTo("greaterThan(cast(amount, BIGINT), 100)");
        Assertions.assertThat((String)convertedExpressions2[1].toString()).isEqualTo("lessThanOrEqual(amount, id)");
        Assertions.assertThat((String)convertedExpressions2[2].toString()).isEqualTo("or(greaterThan(cast(amount, BIGINT), 100), lessThanOrEqual(amount, id))");
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
        this.assertExpressionArrayEquals((Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))}), (Expression[])((Object[])new Expression[]{convertedExpressions2[1]}));
    }

    @Test
    public void testExtractWithTrim() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 0);
        RexLiteral t1 = this.rexBuilder().makeLiteral("He");
        RexNode trimBoth = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.BOTH), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode trimLeading = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.LEADING), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode trimTrailing = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)trimBoth, (List)new .colon.colon((Object)trimLeading, (List)new .colon.colon((Object)trimTrailing, (List)Nil$.MODULE$)))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Assertions.assertThat((Object[])convertedExpressions2).isEmpty();
        Assertions.assertThat((Object[])unconvertedRexNodes2).hasSize(3);
    }

    @Test
    public void testExtractWithUdf() {
        this.functionCatalog().registerTempSystemScalarFunction("myUdf", (ScalarFunction)Func1$.MODULE$);
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexNode t1 = this.rexBuilder().makeCall((SqlOperator)new ScalarSqlFunction(FunctionIdentifier.of((String)"MyUdf"), "myUdf", (ScalarFunction)Func1$.MODULE$, this.typeFactory(), ScalarSqlFunction$.MODULE$.$lessinit$greater$default$5()), new RexNode[]{t0});
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode condition = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t2});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(condition, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Assertions.assertThat((Object[])convertedExpressions2).hasSize(1);
        Assertions.assertThat((String)convertedExpressions2[0].toString()).isEqualTo("greaterThan(MyUdf(amount), 100)");
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    @Test
    public void testExtractPartitionPredicates() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 0);
        RexLiteral t3 = this.rexBuilder().makeLiteral("test%");
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        Tuple2 tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount", "name"}));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexNode partitionPredicate1 = (RexNode)tuple2._1();
        RexNode nonPartitionPredicate1 = (RexNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicate1, (Object)nonPartitionPredicate1);
        RexNode partitionPredicate12 = (RexNode)tuple22._1();
        RexNode nonPartitionPredicate12 = (RexNode)tuple22._2();
        Assertions.assertThat((Object)partitionPredicate12).isEqualTo((Object)c3);
        Assertions.assertThat((boolean)nonPartitionPredicate12.isAlwaysTrue()).isTrue();
        Tuple2 tuple23 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount"}));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        RexNode partitionPredicate2 = (RexNode)tuple23._1();
        RexNode nonPartitionPredicate2 = (RexNode)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)partitionPredicate2, (Object)nonPartitionPredicate2);
        RexNode partitionPredicate22 = (RexNode)tuple24._1();
        RexNode nonPartitionPredicate22 = (RexNode)tuple24._2();
        Assertions.assertThat((Object)partitionPredicate22).isEqualTo((Object)c1);
        Assertions.assertThat((Object)nonPartitionPredicate22).isEqualTo((Object)c2);
        Tuple2 tuple25 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"id"}));
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        RexNode partitionPredicate3 = (RexNode)tuple25._1();
        RexNode nonPartitionPredicate3 = (RexNode)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)partitionPredicate3, (Object)nonPartitionPredicate3);
        RexNode partitionPredicate32 = (RexNode)tuple26._1();
        RexNode nonPartitionPredicate32 = (RexNode)tuple26._2();
        Assertions.assertThat((boolean)partitionPredicate32.isAlwaysTrue()).isTrue();
        Assertions.assertThat((Object)nonPartitionPredicate32).isEqualTo((Object)c3);
        RexNode c4 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{c1, c2});
        Tuple2 tuple27 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c4, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount", "name"}));
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        RexNode partitionPredicate4 = (RexNode)tuple27._1();
        RexNode nonPartitionPredicate4 = (RexNode)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)partitionPredicate4, (Object)nonPartitionPredicate4);
        RexNode partitionPredicate42 = (RexNode)tuple28._1();
        RexNode nonPartitionPredicate42 = (RexNode)tuple28._2();
        Assertions.assertThat((Object)partitionPredicate42).isEqualTo((Object)c4);
        Assertions.assertThat((boolean)nonPartitionPredicate42.isAlwaysTrue()).isTrue();
        Tuple2 tuple29 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c4, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount"}));
        if (tuple29 == null) {
            throw new MatchError((Object)tuple29);
        }
        RexNode partitionPredicate5 = (RexNode)tuple29._1();
        RexNode nonPartitionPredicate5 = (RexNode)tuple29._2();
        Tuple2 tuple210 = new Tuple2((Object)partitionPredicate5, (Object)nonPartitionPredicate5);
        RexNode partitionPredicate52 = (RexNode)tuple210._1();
        RexNode nonPartitionPredicate52 = (RexNode)tuple210._2();
        Assertions.assertThat((boolean)partitionPredicate52.isAlwaysTrue()).isTrue();
        Assertions.assertThat((Object)nonPartitionPredicate52).isEqualTo((Object)c4);
    }

    @Test
    public void testExtractPartitionPredicatesDate() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 1);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.typeFactory().createFieldTypeFromLogicalType(DataTypes.DATE().getLogicalType()), 0);
        RexLiteral t3 = this.rexBuilder().makeDateLiteral(DateString.fromDaysSinceEpoch((int)18000));
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        Tuple2 tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"date"}));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexNode partitionPredicate1 = (RexNode)tuple2._1();
        RexNode nonPartitionPredicate1 = (RexNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicate1, (Object)nonPartitionPredicate1);
        RexNode partitionPredicate12 = (RexNode)tuple22._1();
        RexNode nonPartitionPredicate12 = (RexNode)tuple22._2();
        Assertions.assertThat((Object)partitionPredicate12).isEqualTo((Object)c2);
        Assertions.assertThat((Object)nonPartitionPredicate12).isEqualTo((Object)c1);
        Tuple2 tuple23 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"date", "amount"}));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        RexNode partitionPredicate2 = (RexNode)tuple23._1();
        RexNode nonPartitionPredicate2 = (RexNode)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)partitionPredicate2, (Object)nonPartitionPredicate2);
        RexNode partitionPredicate22 = (RexNode)tuple24._1();
        RexNode nonPartitionPredicate22 = (RexNode)tuple24._2();
        Assertions.assertThat((Object)partitionPredicate22).isEqualTo((Object)c3);
        Assertions.assertThat((boolean)nonPartitionPredicate22.isAlwaysTrue()).isTrue();
        Tuple2 tuple25 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"id", "amount"}));
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        RexNode partitionPredicate3 = (RexNode)tuple25._1();
        RexNode nonPartitionPredicate3 = (RexNode)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)partitionPredicate3, (Object)nonPartitionPredicate3);
        RexNode partitionPredicate32 = (RexNode)tuple26._1();
        RexNode nonPartitionPredicate32 = (RexNode)tuple26._2();
        Assertions.assertThat((Object)partitionPredicate32).isEqualTo((Object)c1);
        Assertions.assertThat((Object)nonPartitionPredicate32).isEqualTo((Object)c2);
    }

    @Test
    public void testTimeLiteralWithLocalTimeZoneConversions() {
        FlinkRexBuilder relBuilder;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"instant_col", (List)Nil$.MODULE$))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE}));
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01.123456");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 6);
        RexLiteral rexInstant = this.rexBuilder().makeTimestampWithLocalTimeZoneLiteral(timestampString, 6);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexInstant, (List)Nil$.MODULE$));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).asJava();
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, fieldNames, (RexBuilder)(relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory())), this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] converted = (Expression[])tuple2._1();
        Expression[] converted2 = converted;
        LocalDateTime datetime = DateTimeTestUtil$.MODULE$.localDateTime("2017-09-10 14:23:01.123456");
        Instant instant = datetime.toInstant(ZoneId.of(ZoneOffset.UTC.getId()).getRules().getOffset(datetime));
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"timestamp_col"), ApiExpressionUtils.valueLiteral((Object)datetime)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"instant_col"), ApiExpressionUtils.valueLiteral((Object)instant)})});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    private void testExtractSinglePostfixCondition(Integer fieldIndex, SqlPostfixOperator op, String expr) {
        this.rexBuilder_$eq((RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(Predef$.MODULE$.Integer2int(fieldIndex)), Predef$.MODULE$.Integer2int(fieldIndex));
        RexNode conditionExpr = this.rexBuilder().makeCall((SqlOperator)op, new RexNode[]{t0});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(conditionExpr, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Expression[] convertedExpressions2 = (Expression[])tuple22._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple22._2();
        Assertions.assertThat((Object[])convertedExpressions2).hasSize(1);
        Assertions.assertThat((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])convertedExpressions2)).head().toString()).isEqualTo(expr);
        Assertions.assertThat((Object[])unconvertedRexNodes2).isEmpty();
    }

    private void assertExpressionArrayEquals(Expression[] expected, Expression[] actual) {
        Expression[] sortedExpected = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Expression[] sortedActual = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object[])sortedExpected).hasSameSizeAs((Object)sortedActual);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedExpected)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sortedActual), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression l = (Expression)tuple2._1();
                Expression r = (Expression)tuple2._2();
                return Assertions.assertThat((String)l.toString()).isEqualTo(r.toString());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexNode expr, java.util.List<String> inputFieldNames, RexBuilder rexBuilder, FunctionCatalog catalog) {
        return RexNodeExtractor$.MODULE$.extractConjunctiveConditions(expr, inputFieldNames, rexBuilder, catalog, this.catalogManager());
    }
}

