/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction$;
import org.apache.flink.table.planner.plan.utils.PartitionPruner$;
import org.apache.flink.table.planner.plan.utils.RexNodeTestBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0002\u0004\u0001+!)!\u0004\u0001C\u00017!)Q\u0004\u0001C\u0001=!)\u0001\u0007\u0001C\u0001=!)!\u0007\u0001C\u0001=\t\u0019\u0002+\u0019:uSRLwN\u001c)sk:,'\u000fV3ti*\u0011q\u0001C\u0001\u0006kRLGn\u001d\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\u0004\n\u0005e1!a\u0004*fq:{G-\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005a\u0002CA\f\u0001\u0003M!Xm\u001d;QeVtW\rU1si&$\u0018n\u001c8t)\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#\u0001B+oSRD#A\u0001\u0014\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013aA1qS*\u00111\u0006L\u0001\bUV\u0004\u0018\u000e^3s\u0015\ti##A\u0003kk:LG/\u0003\u00020Q\t!A+Z:u\u0003i!Xm\u001d;QeVtW\rU1si&$\u0018n\u001c8t/&$\b.\u00163gQ\t\u0019a%A\fuKN$H+[7f!J,h.\u001a)beRLG/[8og\"\u0012AA\n")
public class PartitionPrunerTest
extends RexNodeTestBase {
    @Test
    public void testPrunePartitions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 0);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 1);
        RexLiteral t3 = this.rexBuilder().makeLiteral("test%");
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        String[] partitionFieldNames = (String[])((Object[])new String[]{"amount", "name", "flag"});
        LogicalType[] partitionFieldTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.VARCHAR((int)100).getLogicalType(), DataTypes.BOOLEAN().getLogicalType()});
        java.util.List allPartitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"20"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"test1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"true")}))).asJava()), (List)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"150"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"test2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"false")}))).asJava()), (List)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Test3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"false")}))).asJava()), (List)Nil$.MODULE$)))).asJava();
        TableConfig tableConfig = TableConfig.getDefault();
        java.util.List prunedPartitions = PartitionPruner$.MODULE$.prunePartitions(tableConfig, Thread.currentThread().getContextClassLoader(), partitionFieldNames, partitionFieldTypes, allPartitions, c3);
        Assertions.assertEquals((int)1, (int)prunedPartitions.size());
        Assertions.assertEquals((Object)"150", ((java.util.Map)prunedPartitions.get(0)).get("amount"));
    }

    @Test
    public void testPrunePartitionsWithUdf() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 1);
        RexNode t1 = this.rexBuilder().makeCall((SqlOperator)new ScalarSqlFunction(FunctionIdentifier.of((String)"MyUdf"), "MyUdf", (ScalarFunction)Func1$.MODULE$, this.typeFactory(), ScalarSqlFunction$.MODULE$.$lessinit$greater$default$5()), new RexNode[]{t0});
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t2});
        String[] partitionFieldNames = (String[])((Object[])new String[]{"name", "amount"});
        LogicalType[] partitionFieldTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.VARCHAR((int)100).getLogicalType(), DataTypes.INT().getLogicalType()});
        java.util.List allPartitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"20"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"test1")}))).asJava()), (List)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"150"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"test2")}))).asJava()), (List)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Test3")}))).asJava()), (List)Nil$.MODULE$)))).asJava();
        TableConfig tableConfig = TableConfig.getDefault();
        java.util.List prunedPartitions = PartitionPruner$.MODULE$.prunePartitions(tableConfig, Thread.currentThread().getContextClassLoader(), partitionFieldNames, partitionFieldTypes, allPartitions, c);
        Assertions.assertEquals((int)2, (int)prunedPartitions.size());
        Assertions.assertEquals((Object)"150", ((java.util.Map)prunedPartitions.get(0)).get("amount"));
        Assertions.assertEquals((Object)"200", ((java.util.Map)prunedPartitions.get(1)).get("amount"));
    }

    @Test
    public void testTimePrunePartitions() {
        RexInputRef f0 = this.rexBuilder().makeInputRef(this.typeFactory().createSqlType(SqlTypeName.DATE), 0);
        RexInputRef f1 = this.rexBuilder().makeInputRef(this.typeFactory().createSqlType(SqlTypeName.TIME, 0), 1);
        RexInputRef f2 = this.rexBuilder().makeInputRef(this.typeFactory().createSqlType(SqlTypeName.TIMESTAMP, 3), 2);
        RexInputRef f3 = this.rexBuilder().makeInputRef(this.typeFactory().createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, 3), 3);
        RexNode c0 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{f0, this.rexBuilder().makeDateLiteral(new DateString("2018-08-06"))});
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{f1, this.rexBuilder().makeTimeLiteral(new TimeString("12:08:06"), 0)});
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{f2, this.rexBuilder().makeTimestampLiteral(new TimestampString("2018-08-06 12:08:06.123"), 3)});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{f3, this.rexBuilder().makeTimestampWithLocalTimeZoneLiteral(new TimestampString("2018-08-06 12:08:06.123"), 3)});
        RexNode condition = RexUtil.composeConjunction((RexBuilder)this.rexBuilder(), (Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)c0, (List)new .colon.colon((Object)c1, (List)new .colon.colon((Object)c2, (List)new .colon.colon((Object)c3, (List)Nil$.MODULE$))))));
        String[] partitionFieldNames = (String[])((Object[])new String[]{"f0", "f1", "f2", "f3"});
        LogicalType[] partitionFieldTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.DATE().getLogicalType(), DataTypes.TIME((int)0).getLogicalType(), DataTypes.TIMESTAMP((int)3).getLogicalType(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).getLogicalType()});
        java.util.List allPartitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f0"), (Object)"2018-08-05"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f1"), (Object)"12:08:07"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f2"), (Object)"2018-08-06 12:08:06.124"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f3"), (Object)"2018-08-06 12:08:06.124")}))).asJava()), (List)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f0"), (Object)"2018-08-07"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f1"), (Object)"12:08:05"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f2"), (Object)"2018-08-06 12:08:06.124"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f3"), (Object)"2018-08-06 12:08:06.124")}))).asJava()), (List)new .colon.colon((Object)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f0"), (Object)"2018-08-07"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f1"), (Object)"12:08:07"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f2"), (Object)"2018-08-06 12:08:06.124"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f3"), (Object)"2018-08-06 12:08:06.124")}))).asJava()), (List)Nil$.MODULE$)))).asJava();
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setLocalTimeZone((ZoneId)ZoneOffset.ofHours(0));
        java.util.List prunedPartitions = PartitionPruner$.MODULE$.prunePartitions(tableConfig, Thread.currentThread().getContextClassLoader(), partitionFieldNames, partitionFieldTypes, allPartitions, condition);
        Assertions.assertEquals((int)1, (int)prunedPartitions.size());
        Assertions.assertEquals((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allPartitions).apply(2), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(prunedPartitions).apply(0));
    }
}

