/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil$;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import org.apache.flink.table.planner.plan.utils.RexNodeTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0003\u0006\u00013!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0005E!)A\u0007\u0001C\u0001k!)\u0011\t\u0001C\u0001k!)1\t\u0001C\u0001k!)Q\t\u0001C\u0001k!)q\t\u0001C\u0001k!)\u0011\n\u0001C\u0001k\tAb*Z:uK\u0012\u0004&o\u001c6fGRLwN\\+uS2$Vm\u001d;\u000b\u0005-a\u0011!B;uS2\u001c(BA\u0007\u000f\u0003\u0011\u0001H.\u00198\u000b\u0005=\u0001\u0012a\u00029mC:tWM\u001d\u0006\u0003#I\tQ\u0001^1cY\u0016T!a\u0005\u000b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c95\t!\"\u0003\u0002\u001e\u0015\ty!+\u001a=O_\u0012,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u00111\u0004A\u0001\fCN\u001cXM\u001d;BeJ\f\u0017\u0010F\u0002$SI\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012A!\u00168ji\")!F\u0001a\u0001W\u00051\u0011m\u0019;vC2\u00042\u0001\n\u0017/\u0013\tiSEA\u0003BeJ\f\u0017\u0010E\u0002%Y=\u0002\"\u0001\n\u0019\n\u0005E*#aA%oi\")1G\u0001a\u0001W\u0005AQ\r\u001f9fGR,G-A\ruKN$X\t\u001f;sC\u000e$(+\u001a4J]B,HOR5fY\u0012\u001cH#A\u0012)\u0005\r9\u0004C\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u0003\r\t\u0007/\u001b\u0006\u0003yu\nqA[;qSR,'O\u0003\u0002?-\u0005)!.\u001e8ji&\u0011\u0001)\u000f\u0002\u0005)\u0016\u001cH/A\u0010uKN$X\t\u001f;sC\u000e$(+\u001a4OKN$X\rZ%oaV$h)[3mIND#\u0001B\u001c\u0002gQ,7\u000f^#yiJ\f7\r\u001e#fKB\u0014VM\u001a(fgR,G-\u00138qkR4\u0015.\u001a7egV\u001b\u0018N\\4OKN$X\r\u001a$jK2$\u0007FA\u00038\u0003U!Xm\u001d;SK^\u0014\u0018\u000e^3SKb\u0004&o\\4sC6D#AB\u001c\u0002MQ,7\u000f\u001e*foJLG/\u001a*FqB\u0013xn\u001a:b[^KG\u000f\u001b(fgR,G\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002\bo\u0005QC/Z:u%\u0016<(/\u001b;f%\u0016D\bK]8he\u0006lw+\u001b;i\t\u0016,\u0007OT3ti\u0016$\u0007K]8kK\u000e$\bF\u0001\u00058\u0001")
public class NestedProjectionUtilTest
extends RexNodeTestBase {
    private void assertArray(int[][] actual, int[][] expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])expected), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NestedProjectionUtilTest.$anonfun$assertArray$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testExtractRefInputFields() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List exprs = (java.util.List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exprs, (Object)rowType);
        java.util.List exprs2 = (java.util.List)tuple22._1();
        RelDataType rowType2 = (RelDataType)tuple22._2();
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(exprs2, rowType2);
        int[][] actual = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] expected = (int[][])((Object[])new int[][]{{2}, {3}, {1}});
        this.assertArray(actual, expected);
    }

    @Test
    public void testExtractRefNestedInputFields() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List rexProgram = (java.util.List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rexProgram, (Object)rowType);
        java.util.List rexProgram2 = (java.util.List)tuple22._1();
        RelDataType rowType2 = (RelDataType)tuple22._2();
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(rexProgram2, rowType2);
        int[][] actual = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] expected = (int[][])((Object[])new int[][]{{1, 1}, {0}});
        this.assertArray(actual, expected);
    }

    @Test
    public void testExtractDeepRefNestedInputFieldsUsingNestedField() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List rexProgram = (java.util.List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rexProgram, (Object)rowType);
        java.util.List rexProgram2 = (java.util.List)tuple22._1();
        RelDataType rowType2 = (RelDataType)tuple22._2();
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(rexProgram2, rowType2);
        int[][] actual = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] expected = (int[][])((Object[])new int[][]{{1, 1}, {0}, {2, 0, 0, 0}, {2, 0, 1, 0}, {3, 1, 0}, {3, 0}});
        this.assertArray(actual, expected);
    }

    @Test
    public void testRewriteRexProgram() {
        RexProgram rexProgram = this.buildSimpleRexProgram();
        java.util.List exprs = rexProgram.getExprList();
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$0", "$1", "$2", "$3", "$4", "$5", "*($t2, $t3)", "100", "<($t6, $t7)", "6", ">($t1, $t9)", "AND($t8, $t10)"});
        Assertions.assertTrue((!(object != null ? !object.equals(wrappedArray) : wrappedArray != null) ? 1 : 0) != 0);
        NestedSchema nestedField = NestedProjectionUtil$.MODULE$.build(exprs, rexProgram.getInputRowType());
        int[][] paths = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedField);
        int[][] orderedPaths = (int[][])((Object[])new int[][]{{0}, {1}, {2}, {3}, {4}, {5}});
        this.assertArray(paths, orderedPaths);
        FlinkRexBuilder builder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Buffer projectExprs = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexProgram.getProjectList()).map((Function1 & Serializable & scala.Serializable)expr -> rexProgram.expandLocalRef(expr), Buffer$.MODULE$.canBuildFrom());
        java.util.List newProjectExprs = NestedProjectionUtil$.MODULE$.rewrite(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(projectExprs), nestedField, (RexBuilder)builder);
        RexNode conditionExprs = rexProgram.expandLocalRef(rexProgram.getCondition());
        java.util.List newConditionExprs = NestedProjectionUtil$.MODULE$.rewrite(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)conditionExprs, (List)Nil$.MODULE$)), nestedField, (RexBuilder)builder);
        Object object2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newProjectExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray2 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$2", "*($2, $3)"});
        Assertions.assertTrue((!(object2 != null ? !object2.equals(wrappedArray2) : wrappedArray2 != null) ? 1 : 0) != 0);
        Object object3 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newConditionExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray3 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AND(<(*($2, $3), 100), >($1, 6))"});
        Assertions.assertTrue((!(object3 != null ? !object3.equals(wrappedArray3) : wrappedArray3 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testRewriteRExProgramWithNestedProject() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List exprs = (java.util.List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exprs, (Object)rowType);
        java.util.List exprs2 = (java.util.List)tuple22._1();
        RelDataType rowType2 = (RelDataType)tuple22._2();
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs2).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$1.amount", "$0", "100"});
        Assertions.assertTrue((!(object != null ? !object.equals(wrappedArray) : wrappedArray != null) ? 1 : 0) != 0);
        NestedSchema nestedField = NestedProjectionUtil$.MODULE$.build(exprs2, rowType2);
        int[][] paths = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedField);
        int[][] orderedPaths = (int[][])((Object[])new int[][]{{1, 1}, {0}});
        this.assertArray(paths, orderedPaths);
        java.util.List newExprs = NestedProjectionUtil$.MODULE$.rewrite(exprs2, nestedField, (RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        Object object2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray2 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$0", "$1", "100"});
        Assertions.assertTrue((!(object2 != null ? !object2.equals(wrappedArray2) : wrappedArray2 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testRewriteRexProgramWithDeepNestedProject() {
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List exprs = (java.util.List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exprs, (Object)rowType);
        java.util.List exprs2 = (java.util.List)tuple22._1();
        RelDataType rowType2 = (RelDataType)tuple22._2();
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs2).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*($1.amount, 10)", "$0.passport.status", "$2.with.deep.entry", "$2.with.deeper.entry.inside.entry", "$2.with.deeper.entry", "$0", "ITEM(ITEM($3.inner.deep_array, $3.outer).deep_map, _UTF-16LE'item')"});
        Assertions.assertTrue((!(object != null ? !object.equals(wrappedArray) : wrappedArray != null) ? 1 : 0) != 0);
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(exprs2, rowType2);
        int[][] paths = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] orderedPaths = (int[][])((Object[])new int[][]{{1, 1}, {0}, {2, 0, 0, 0}, {2, 0, 1, 0}, {3, 1, 0}, {3, 0}});
        this.assertArray(paths, orderedPaths);
        java.util.List newExprs = NestedProjectionUtil$.MODULE$.rewrite(exprs2, nestedFields, (RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        Object object2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray2 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*($0, 10)", "$1.passport.status", "$2", "$3.inside.entry", "$3", "$1", "ITEM(ITEM($4, $5).deep_map, _UTF-16LE'item')"});
        Assertions.assertTrue((!(object2 != null ? !object2.equals(wrappedArray2) : wrappedArray2 != null) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$assertArray$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int[] result = (int[])tuple2._1();
            int[] expect = (int[])tuple2._2();
            Predef$.MODULE$.assert(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(result)).sameElements((GenIterable)Predef$.MODULE$.wrapIntArray(expect)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

