/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.utils.ExpandTableScanShuttle;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtilTest$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y3A\u0001E\t\u0001A!)q\u0005\u0001C\u0001Q!I1\u0006\u0001a\u0001\u0002\u0004%\t\u0001\f\u0005\ng\u0001\u0001\r\u00111A\u0005\u0002QB\u0011B\u000f\u0001A\u0002\u0003\u0005\u000b\u0015B\u0017\t\u000bm\u0002A\u0011\u0001\u001f\t\u000b\u001d\u0003A\u0011\u0001\u001f\t\u000b1\u0003A\u0011\u0001\u001f\t\u000b9\u0003A\u0011\u0001\u001f\t\u000bA\u0003A\u0011\u0001\u001f\t\u000bI\u0003A\u0011\u0001\u001f\t\u000bQ\u0003A\u0011\u0001\u001f\t\u000bY\u0003A\u0011\u0001\u001f\t\u000ba\u0003A\u0011\u0001\u001f\t\u000bi\u0003A\u0011\u0001\u001f\t\u000bq\u0003A\u0011\u0001\u001f\u0003'\u0019c\u0017N\\6SK2|\u0005\u000f^+uS2$Vm\u001d;\u000b\u0005I\u0019\u0012!B;uS2\u001c(B\u0001\u000b\u0016\u0003\u0011\u0001H.\u00198\u000b\u0005Y9\u0012a\u00029mC:tWM\u001d\u0006\u00031e\tQ\u0001^1cY\u0016T!AG\u000e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003E\t\u0001\u0002^1cY\u0016,eN^\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001gF\u0001\u0004CBL\u0017B\u0001\u001a0\u0005A!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/\u0001\u0007uC\ndW-\u00128w?\u0012*\u0017\u000f\u0006\u00026qA\u0011!EN\u0005\u0003o\r\u0012A!\u00168ji\"9\u0011hAA\u0001\u0002\u0004i\u0013a\u0001=%c\u0005IA/\u00192mK\u0016sg\u000fI\u0001\u0007E\u00164wN]3\u0015\u0003UB#!\u0002 \u0011\u0005}*U\"\u0001!\u000b\u0005A\n%B\u0001\"D\u0003\u001dQW\u000f]5uKJT!\u0001R\u000f\u0002\u000b),h.\u001b;\n\u0005\u0019\u0003%A\u0003\"fM>\u0014X-R1dQ\u0006aA/Z:u)>\u001cFO]5oO\"\u0012a!\u0013\t\u0003\u007f)K!a\u0013!\u0003\tQ+7\u000f^\u0001\u001ai\u0016\u001cH\u000fV8TiJLgnZ,ji\",\u0006o]3si.+\u0017\u0010\u000b\u0002\b\u0013\u0006\u0001C/Z:u\u000f\u0016$H)[4fgR<\u0016\u000e\u001e5Es:\fW.[2Gk:\u001cG/[8oQ\tA\u0011*\u0001\u0013uKN$x)\u001a;ES\u001e,7\u000f^,ji\"$\u0015P\\1nS\u000e4UO\\2uS>tg+[3xQ\tI\u0011*A\fuKN$X*\u001a:hKJ{w\u000fV5nK\u0006sGMT8oK\"\u0012!\"S\u0001\u0019i\u0016\u001cH/T3sO\u0016\u0004&o\\2US6,\u0017I\u001c3O_:,\u0007FA\u0006J\u0003u!Xm\u001d;NKJ<WMU8x)&lW\rV!oIB\u0013xn\u0019+j[\u0016\f\u0004F\u0001\u0007J\u0003u!Xm\u001d;NKJ<WMU8x)&lW\rV!oIB\u0013xn\u0019+j[\u0016\u0014\u0004FA\u0007J\u0003i!Xm\u001d;NKJ<WMU8x)&lW-\u00118e%><H/[7fQ\tq\u0011*\u0001\u000euKN$X*\u001a:hK^KG\u000f\u001b(p]\u0016l\u0015N\\5CCR\u001c\u0007\u000e\u000b\u0002\u0010\u0013\u0002")
public class FlinkRelOptUtilTest {
    private TableEnvironment tableEnv;

    public TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public void tableEnv_$eq(TableEnvironment x$1) {
        this.tableEnv = x$1;
    }

    @BeforeEach
    public void before() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().build();
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)settings);
        BatchTableEnvUtil$.MODULE$.registerCollection((TableEnvironment)tEnv, "MyTable", (Iterable)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mike", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)12.3), "Smith"})), (List)Nil$.MODULE$), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), "first, id, score, last");
        this.tableEnv_$eq((TableEnvironment)tEnv);
    }

    @Test
    public void testToString() {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment();
        StreamTableEnvironment tableEnv = StreamTableEnvironment$.MODULE$.create((StreamExecutionEnvironment)env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromElements((StreamExecutionEnvironment)env, Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[0]), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.utils.FlinkRelOptUtilTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tableEnv.createTemporaryView("MyTable", table);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t1 AS (SELECT a, c FROM MyTable WHERE b > 50),\n        |     t2 AS (SELECT a * 2 AS a, c FROM MyTable WHERE b < 50)\n        |\n        |SELECT * FROM t1 JOIN t2 ON t1.a = t2.a\n      ")).stripMargin();
        Table result = tableEnv.sqlQuery(sqlQuery);
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(result);
        String expected1 = new StringOps(Predef$.MODULE$.augmentString("\n        |LogicalProject(a=[$0], c=[$1], a0=[$2], c0=[$3])\n        |+- LogicalJoin(condition=[=($0, $2)], joinType=[inner])\n        |   :- LogicalProject(a=[$0], c=[$2])\n        |   :  +- LogicalFilter(condition=[>($1, 50)])\n        |   :     +- LogicalTableScan(table=[[default_catalog, default_database, MyTable]])\n        |   +- LogicalProject(a=[*($0, 2)], c=[$2])\n        |      +- LogicalFilter(condition=[<($1, 50)])\n        |         +- LogicalTableScan(table=[[default_catalog, default_database, MyTable]])\n      ")).stripMargin();
        Assertions.assertEquals((Object)expected1.trim(), (Object)FlinkRelOptUtil$.MODULE$.toString(rel, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()).trim());
        String expected2 = new StringOps(Predef$.MODULE$.augmentString("\n        |LogicalProject\n        |+- LogicalJoin\n        |   :- LogicalProject\n        |   :  +- LogicalFilter\n        |   :     +- LogicalTableScan\n        |   +- LogicalProject\n        |      +- LogicalFilter\n        |         +- LogicalTableScan\n      ")).stripMargin();
        Assertions.assertEquals((Object)expected2.trim(), (Object)FlinkRelOptUtil$.MODULE$.toString(rel, SqlExplainLevel.NO_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()).trim());
        RelNode x$1 = rel;
        SqlExplainLevel x$2 = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        boolean x$3 = true;
        boolean x$4 = FlinkRelOptUtil$.MODULE$.toString$default$3();
        boolean x$5 = FlinkRelOptUtil$.MODULE$.toString$default$4();
        boolean x$6 = FlinkRelOptUtil$.MODULE$.toString$default$5();
        boolean x$7 = FlinkRelOptUtil$.MODULE$.toString$default$7();
        Assertions.assertEquals((Object)expected1.trim(), (Object)FlinkRelOptUtil$.MODULE$.toString(x$1, x$2, x$4, x$5, x$6, x$3, x$7).trim());
    }

    @Test
    public void testToStringWithUpsertKey() {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment();
        StreamTableEnvironment tableEnv = StreamTableEnvironment$.MODULE$.create((StreamExecutionEnvironment)env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromElements((StreamExecutionEnvironment)env, Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[0]), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.utils.FlinkRelOptUtilTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tableEnv.createTemporaryView("MyTable", table);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t1 AS (SELECT a, c, count(*) cnt FROM MyTable group by a, c),\n        |     t2 AS (SELECT a, max(b) b FROM MyTable WHERE b < 50 group by a)\n        |\n        |SELECT * FROM t1 JOIN t2 ON t1.a = t2.a\n      ")).stripMargin();
        Table result = tableEnv.sqlQuery(sqlQuery);
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(result);
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tableEnv).getPlanner();
        RelNode optimized = planner.optimize(rel);
        String expected1 = new StringOps(Predef$.MODULE$.augmentString("\n        |Join(joinType=[InnerJoin], where=[=(a, a0)], select=[a, c, cnt, a0, b], leftInputSpec=[HasUniqueKey], rightInputSpec=[JoinKeyContainsUniqueKey], upsertKeys=[[a, c, a0], [a, c]])\n        |:- Exchange(distribution=[hash[a]], upsertKeys=[[a, c]])\n        |:  +- GroupAggregate(groupBy=[a, c], select=[a, c, COUNT(*) AS cnt], upsertKeys=[[a, c]])\n        |:     +- Exchange(distribution=[hash[a, c]])\n        |:        +- Calc(select=[a, c])\n        |:           +- DataStreamScan(table=[[default_catalog, default_database, MyTable]], fields=[a, b, c])\n        |+- Exchange(distribution=[hash[a]], upsertKeys=[[a]])\n        |   +- GroupAggregate(groupBy=[a], select=[a, MAX(b) AS b], upsertKeys=[[a]])\n        |      +- Exchange(distribution=[hash[a]])\n        |         +- Calc(select=[a, b], where=[<(b, 50)])\n        |            +- DataStreamScan(table=[[default_catalog, default_database, MyTable]], fields=[a, b, c])\n      ")).stripMargin();
        RelNode x$1 = optimized;
        SqlExplainLevel x$2 = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        boolean x$3 = true;
        boolean x$4 = FlinkRelOptUtil$.MODULE$.toString$default$3();
        boolean x$5 = FlinkRelOptUtil$.MODULE$.toString$default$4();
        boolean x$6 = FlinkRelOptUtil$.MODULE$.toString$default$5();
        boolean x$7 = FlinkRelOptUtil$.MODULE$.toString$default$7();
        Assertions.assertEquals((Object)expected1.trim(), (Object)FlinkRelOptUtil$.MODULE$.toString(x$1, x$2, x$4, x$5, x$6, x$3, x$7).trim());
    }

    @Test
    public void testGetDigestWithDynamicFunction() {
        Table table = this.tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                    |(SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1)\n                                    |INTERSECT\n                                    |(SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1)\n                                    |INTERSECT\n                                    |(SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1)\n      ")).stripMargin());
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(table);
        String expected = TableTestUtil$.MODULE$.readFromResource("/digest/testGetDigestWithDynamicFunction.out");
        Assertions.assertEquals((Object)expected, (Object)FlinkRelOptUtil$.MODULE$.getDigest(rel));
    }

    @Test
    public void testGetDigestWithDynamicFunctionView() {
        Table view = this.tableEnv().sqlQuery("SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1");
        this.tableEnv().createTemporaryView("MyView", view);
        Table table = this.tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                    |(SELECT * FROM MyView)\n                                    |INTERSECT\n                                    |(SELECT * FROM MyView)\n                                    |INTERSECT\n                                    |(SELECT * FROM MyView)\n      ")).stripMargin());
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(table).accept((RelShuttle)new ExpandTableScanShuttle());
        String expected = TableTestUtil$.MODULE$.readFromResource("/digest/testGetDigestWithDynamicFunctionView.out");
        Assertions.assertEquals((Object)expected, (Object)FlinkRelOptUtil$.MODULE$.getDigest(rel));
    }

    @Test
    public void testMergeRowTimeAndNone() {
        MiniBatchInterval none = MiniBatchInterval.NONE;
        MiniBatchInterval rowtime = new MiniBatchInterval(1000L, MiniBatchMode.RowTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(none, rowtime);
        Assertions.assertEquals((Object)rowtime, (Object)mergedResult);
    }

    @Test
    public void testMergeProcTimeAndNone() {
        MiniBatchInterval none = MiniBatchInterval.NONE;
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(none, proctime);
        Assertions.assertEquals((Object)proctime, (Object)mergedResult);
    }

    @Test
    public void testMergeRowTimeTAndProcTime1() {
        MiniBatchInterval rowtime = new MiniBatchInterval(4000L, MiniBatchMode.RowTime);
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime, proctime);
        Assertions.assertEquals((Object)rowtime, (Object)mergedResult);
    }

    @Test
    public void testMergeRowTimeTAndProcTime2() {
        MiniBatchInterval rowtime = new MiniBatchInterval(0L, MiniBatchMode.RowTime);
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime, proctime);
        Assertions.assertEquals((Object)new MiniBatchInterval(1000L, MiniBatchMode.RowTime), (Object)mergedResult);
    }

    @Test
    public void testMergeRowTimeAndRowtime() {
        MiniBatchInterval rowtime1 = new MiniBatchInterval(3000L, MiniBatchMode.RowTime);
        MiniBatchInterval rowtime2 = new MiniBatchInterval(5000L, MiniBatchMode.RowTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime1, rowtime2);
        Assertions.assertEquals((Object)new MiniBatchInterval(1000L, MiniBatchMode.RowTime), (Object)mergedResult);
    }

    @Test
    public void testMergeWithNoneMiniBatch() {
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, MiniBatchInterval.NONE));
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NONE, MiniBatchInterval.NO_MINIBATCH));
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, MiniBatchInterval.NO_MINIBATCH));
        MiniBatchInterval rowtime = new MiniBatchInterval(3000L, MiniBatchMode.RowTime);
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, rowtime));
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime, MiniBatchInterval.NO_MINIBATCH));
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, proctime));
        Assertions.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(proctime, MiniBatchInterval.NO_MINIBATCH));
    }
}

