/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4Aa\u0005\u000b\u0001M!)Q\u0006\u0001C\u0001]!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004B\u0002\u001c\u0001A\u0003%1\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\r}\u0002\u0001\u0015!\u0003:\u0011\u001d\u0001\u0005A1A\u0005\u0002aBa!\u0011\u0001!\u0002\u0013I\u0004b\u0002\"\u0001\u0005\u0004%\t\u0001\u000f\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001d\t\u000f\u0011\u0003!\u0019!C\u0001q!1Q\t\u0001Q\u0001\neBqA\u0012\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004H\u0001\u0001\u0006I!\u000f\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u00065\u0002!\t!\u0013\u0005\u00069\u0002!\t!\u0013\u0005\u0006=\u0002!\t!\u0013\u0005\u0006A\u0002!\t!\u0013\u0002 )\u0016l\u0007o\u001c:bYR\u000b'\r\\3K_&tg+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u000b\u0017\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003/a\tQ\u0001^1cY\u0016T!!\u0007\u000e\u0002\rM$(/Z1n\u0015\tYB$\u0001\u0003qY\u0006t'BA\u000f\u001f\u0003\u001d\u0001H.\u00198oKJT!aF\u0010\u000b\u0005\u0001\n\u0013!\u00024mS:\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001fK\u0007\u0002S)\u0011!\u0006H\u0001\u0006kRLGn]\u0005\u0003Y%\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\u0015\u0003\u0011)H/\u001b7\u0016\u0003M\u0002\"\u0001\u000b\u001b\n\u0005UJ#!\u0004+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%\u0001\u0004pe\u0012,'o]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011AHH\u0001\u0004CBL\u0017B\u0001 <\u0005\u0015!\u0016M\u00197f\u0003\u001dy'\u000fZ3sg\u0002\nab\u001c:eKJ\u001c\bK]8di&lW-A\bpe\u0012,'o\u001d)s_\u000e$\u0018.\\3!\u0003iy'\u000fZ3sg^KG\u000f[8viRKW.Z!uiJL'-\u001e;f\u0003my'\u000fZ3sg^KG\u000f[8viRKW.Z!uiJL'-\u001e;fA\u0005a!/\u0019;fg\"K7\u000f^8ss\u0006i!/\u0019;fg\"K7\u000f^8ss\u0002\n\u0001E]1uKND\u0015n\u001d;pef<\u0016\u000e\u001e5pkR$\u0016.\\3BiR\u0014\u0018NY;uK\u0006\t#/\u0019;fg\"K7\u000f^8ss^KG\u000f[8viRKW.Z!uiJL'-\u001e;fA\u0005IB/Z:u\u0013:4\u0018\r\\5e\r&,G\u000e\u001a*fM\u0016\u0014XM\\2f)\u0005Q\u0005CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%\u0001B+oSRD#AD)\u0011\u0005ICV\"A*\u000b\u0005q\"&BA+W\u0003\u001dQW\u000f]5uKJT!aV\u0012\u0002\u000b),h.\u001b;\n\u0005e\u001b&\u0001\u0002+fgR\fq\u0004^3ti&sg/\u00197jIN#(/\u001b8h\r&,G\u000e\u001a*fM\u0016\u0014XM\\2fQ\ty\u0011+A\u0010uKN$hj\u001c8US6,\u0017J\u001c3jG\u0006$xN](o%&<\u0007\u000e^*jI\u0016D#\u0001E)\u0002=Q,7\u000f\u001e(p]RKW.Z%oI&\u001c\u0017\r^8s\u001f:dUM\u001a;TS\u0012,\u0007FA\tR\u0003]!Xm\u001d;NSb,G\rV5nK&sG-[2bi>\u00148\u000f\u000b\u0002\u0013#\u0002")
public class TemporalTableJoinValidationTest
extends TableTestBase {
    private final TableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private final Table orders = this.util().addDataStream("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });
    private final Table ordersProctime = this.util().addDataStream("OrdersProctime", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")).proctime()}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                public Tuple2<Object, String> createInstance(Object[] fields) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });
    private final Table ordersWithoutTimeAttribute = this.util().addDataStream("OrdersWithoutTimeAttribute", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });
    private final Table ratesHistory = this.util().addDataStream("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });
    private final Table ratesHistoryWithoutTimeAttribute = this.util().addDataStream("ratesHistoryWithoutTimeAttribute", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.table.validation.TemporalTableJoinValidationTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });

    public TableTestUtil util() {
        return this.util;
    }

    public Table orders() {
        return this.orders;
    }

    public Table ordersProctime() {
        return this.ordersProctime;
    }

    public Table ordersWithoutTimeAttribute() {
        return this.ordersWithoutTimeAttribute;
    }

    public Table ratesHistory() {
        return this.ratesHistory;
    }

    public Table ratesHistoryWithoutTimeAttribute() {
        return this.ratesHistoryWithoutTimeAttribute;
    }

    @Test
    public void testInvalidFieldReference() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "foobar")))).hasMessageContaining("Cannot resolve field [foobar]") instanceof ValidationException;
    }

    @Test
    public void testInvalidStringFieldReference() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.ratesHistory().createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foobar"}))).$((Seq)Nil$.MODULE$))).hasMessageContaining("Cannot resolve field [foobar]") instanceof ValidationException;
    }

    @Test
    public void testNonTimeIndicatorOnRightSide() {
        TemporalTableFunction rates = this.ratesHistoryWithoutTimeAttribute().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        Table result = this.orders().joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)rates).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")))).select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o_amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate"}))).$((Seq)Nil$.MODULE$))}).as("rate", new String[0]);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(result)).hasMessageContaining("Non rowtime timeAttribute [TIMESTAMP(3)] used to create TemporalTableFunction") instanceof ValidationException;
    }

    @Test
    public void testNonTimeIndicatorOnLeftSide() {
        TemporalTableFunction rates = this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        Table result = this.ordersWithoutTimeAttribute().joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)rates).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")))).select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o_amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate"}))).$((Seq)Nil$.MODULE$))}).as("rate", new String[0]);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(result)).hasMessageContaining("Non rowtime timeAttribute [TIMESTAMP(3)] passed as the argument to TemporalTableFunction") instanceof ValidationException;
    }

    @Test
    public void testMixedTimeIndicators() {
        TemporalTableFunction rates = this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        Table result = this.ordersProctime().joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)rates).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")))).select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o_amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate"}))).$((Seq)Nil$.MODULE$))}).as("rate", new String[0]);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(result)).hasMessageContaining("Non rowtime timeAttribute [TIMESTAMP_LTZ(3) *PROCTIME*] passed as the argument to TemporalTableFunction") instanceof ValidationException;
    }
}

